/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure;

import java.util.Map;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

class ServletEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final boolean SERVLET_AVAILABLE = ClassUtils.isPresent((String)"io.grpc.servlet.jakarta.GrpcServlet", null);

    ServletEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (SERVLET_AVAILABLE) {
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("grpc-servlet", Map.of("server.http2.enabled", "true")));
        }
    }
}

