/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure;

import io.grpc.TlsServerCredentials;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DataSizeUnit;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.grpc.internal.GrpcUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

@ConfigurationProperties(prefix="spring.grpc.server")
public class GrpcServerProperties {
    public static final String ANY_IP_ADDRESS = "*";
    private @Nullable String address;
    private String host = "*";
    private int port = GrpcUtils.DEFAULT_PORT;
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMessageSize = DataSize.ofBytes((long)0x400000L);
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMetadataSize = DataSize.ofBytes((long)8192L);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration shutdownGracePeriod = Duration.ofSeconds(30L);
    private final Health health = new Health();
    private final Inprocess inprocess = new Inprocess();
    private final KeepAlive keepAlive = new KeepAlive();
    private final Ssl ssl = new Ssl();

    public @Nullable String getAddress() {
        return this.address;
    }

    public void setAddress(@Nullable String address) {
        this.address = address;
    }

    public String determineAddress() {
        return this.address != null ? this.address : this.host + ":" + this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public DataSize getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public void setMaxInboundMessageSize(DataSize maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public DataSize getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    public void setMaxInboundMetadataSize(DataSize maxInboundMetadataSize) {
        this.maxInboundMetadataSize = maxInboundMetadataSize;
    }

    public Duration getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    public void setShutdownGracePeriod(Duration shutdownGracePeriod) {
        this.shutdownGracePeriod = shutdownGracePeriod;
    }

    public Health getHealth() {
        return this.health;
    }

    public Inprocess getInprocess() {
        return this.inprocess;
    }

    public KeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public static class Health {
        private boolean enabled = true;
        private final Actuator actuator = new Actuator();

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Actuator getActuator() {
            return this.actuator;
        }
    }

    public static class Inprocess {
        private @Nullable String name;

        public @Nullable String getName() {
            return this.name;
        }

        public void setName(@Nullable String name) {
            this.name = name;
        }
    }

    public static class KeepAlive {
        @DurationUnit(value=ChronoUnit.SECONDS)
        private @Nullable Duration time = Duration.ofHours(2L);
        @DurationUnit(value=ChronoUnit.SECONDS)
        private @Nullable Duration timeout = Duration.ofSeconds(20L);
        @DurationUnit(value=ChronoUnit.SECONDS)
        private @Nullable Duration maxIdle;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private @Nullable Duration maxAge;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private @Nullable Duration maxAgeGrace;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private @Nullable Duration permitTime = Duration.ofMinutes(5L);
        private boolean permitWithoutCalls;

        public @Nullable Duration getTime() {
            return this.time;
        }

        public void setTime(@Nullable Duration time) {
            this.time = time;
        }

        public @Nullable Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(@Nullable Duration timeout) {
            this.timeout = timeout;
        }

        public @Nullable Duration getMaxIdle() {
            return this.maxIdle;
        }

        public void setMaxIdle(@Nullable Duration maxIdle) {
            this.maxIdle = maxIdle;
        }

        public @Nullable Duration getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(@Nullable Duration maxAge) {
            this.maxAge = maxAge;
        }

        public @Nullable Duration getMaxAgeGrace() {
            return this.maxAgeGrace;
        }

        public void setMaxAgeGrace(@Nullable Duration maxAgeGrace) {
            this.maxAgeGrace = maxAgeGrace;
        }

        public @Nullable Duration getPermitTime() {
            return this.permitTime;
        }

        public void setPermitTime(@Nullable Duration permitTime) {
            this.permitTime = permitTime;
        }

        public boolean isPermitWithoutCalls() {
            return this.permitWithoutCalls;
        }

        public void setPermitWithoutCalls(boolean permitWithoutCalls) {
            this.permitWithoutCalls = permitWithoutCalls;
        }
    }

    public static class Ssl {
        private @Nullable Boolean enabled;
        private TlsServerCredentials.ClientAuth clientAuth = TlsServerCredentials.ClientAuth.NONE;
        private @Nullable String bundle;
        private boolean secure = true;

        public @Nullable Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
        }

        public boolean determineEnabled() {
            return this.enabled != null ? this.enabled : this.bundle != null;
        }

        public @Nullable String getBundle() {
            return this.bundle;
        }

        public void setBundle(@Nullable String bundle) {
            this.bundle = bundle;
        }

        public void setClientAuth(TlsServerCredentials.ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }

        public TlsServerCredentials.ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public boolean isSecure() {
            return this.secure;
        }
    }

    public static class Actuator {
        private boolean enabled = true;
        private boolean updateOverallHealth = true;
        private Duration updateRate = Duration.ofSeconds(5L);
        private Duration updateInitialDelay = Duration.ofSeconds(5L);
        private List<String> healthIndicatorPaths = new ArrayList<String>();

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean getUpdateOverallHealth() {
            return this.updateOverallHealth;
        }

        public void setUpdateOverallHealth(boolean updateOverallHealth) {
            this.updateOverallHealth = updateOverallHealth;
        }

        public Duration getUpdateRate() {
            return this.updateRate;
        }

        public void setUpdateRate(Duration updateRate) {
            this.updateRate = updateRate;
        }

        public Duration getUpdateInitialDelay() {
            return this.updateInitialDelay;
        }

        public void setUpdateInitialDelay(Duration updateInitialDelay) {
            this.updateInitialDelay = updateInitialDelay;
        }

        public List<String> getHealthIndicatorPaths() {
            return this.healthIndicatorPaths;
        }

        public void setHealthIndicatorPaths(List<String> healthIndicatorPaths) {
            this.healthIndicatorPaths = healthIndicatorPaths;
        }
    }
}

