/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure;

import io.grpc.BindableService;
import io.grpc.servlet.jakarta.GrpcServlet;
import io.grpc.servlet.jakarta.ServletServerBuilder;
import jakarta.servlet.Servlet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnGrpcNativeServer;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnGrpcServerEnabled;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnGrpcServletServer;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnSpringGrpc;
import org.springframework.boot.grpc.server.autoconfigure.GrpcServerFactoryConfigurations;
import org.springframework.boot.grpc.server.autoconfigure.GrpcServerProperties;
import org.springframework.boot.grpc.server.autoconfigure.ServerBuilderCustomizers;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.grpc.server.service.GrpcServiceConfigurer;
import org.springframework.grpc.server.service.GrpcServiceDiscoverer;
import org.springframework.util.unit.DataSize;

@AutoConfiguration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnSpringGrpc
@ConditionalOnGrpcServerEnabled
@ConditionalOnBean(value={BindableService.class})
public final class GrpcServerFactoryAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnGrpcServletServer
    public static class GrpcServletConfiguration {
        private static Log logger = LogFactory.getLog(GrpcServletConfiguration.class);

        @Bean
        ServletRegistrationBean<GrpcServlet> grpcServlet(GrpcServerProperties properties, GrpcServiceDiscoverer serviceDiscoverer, GrpcServiceConfigurer serviceConfigurer, ServerBuilderCustomizers serverBuilderCustomizers) {
            List serviceNames = serviceDiscoverer.listServiceNames();
            if (logger.isInfoEnabled()) {
                serviceNames.forEach(service -> logger.info((Object)("Registering gRPC service: " + service)));
            }
            List<String> paths = serviceNames.stream().map(service -> "/" + service + "/*").toList();
            ServletServerBuilder servletServerBuilder = new ServletServerBuilder();
            serviceDiscoverer.findServices().stream().map(serviceSpec -> serviceConfigurer.configure(serviceSpec, null)).forEach(arg_0 -> ((ServletServerBuilder)servletServerBuilder).addService(arg_0));
            PropertyMapper mapper = PropertyMapper.get();
            mapper.from((Object)properties.getMaxInboundMessageSize()).asInt(DataSize::toBytes).to(arg_0 -> ((ServletServerBuilder)servletServerBuilder).maxInboundMessageSize(arg_0));
            serverBuilderCustomizers.customize(servletServerBuilder);
            ServletRegistrationBean servlet = new ServletRegistrationBean((Servlet)servletServerBuilder.buildServlet(), new String[0]);
            servlet.setUrlMappings(paths);
            return servlet;
        }

        @Configuration(proxyBeanMethods=false)
        @Import(value={GrpcServerFactoryConfigurations.InProcessServerFactoryConfiguration.class})
        static class InProcessConfiguration {
            InProcessConfiguration() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnGrpcNativeServer
    static class GrpcServerFactoryConfiguration {
        GrpcServerFactoryConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @Import(value={GrpcServerFactoryConfigurations.ShadedNettyServerFactoryConfiguration.class, GrpcServerFactoryConfigurations.NettyServerFactoryConfiguration.class, GrpcServerFactoryConfigurations.InProcessServerFactoryConfiguration.class})
        static class NettyServerFactoryConfiguration {
            NettyServerFactoryConfiguration() {
            }
        }
    }
}

