/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.federation;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionStepInfo;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DelegatingDataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.data.federation.EntityHandlerMethod;
import org.springframework.graphql.data.federation.RepresentationException;
import org.springframework.graphql.data.federation.RepresentationNotResolvedException;
import org.springframework.graphql.data.method.annotation.support.HandlerDataFetcherExceptionResolver;
import org.springframework.graphql.execution.ErrorType;
import reactor.core.publisher.Mono;

final class EntitiesDataFetcher
implements DataFetcher<Mono<DataFetcherResult<List<Object>>>> {
    private final Map<String, EntityHandlerMethod> handlerMethods;
    private final HandlerDataFetcherExceptionResolver exceptionResolver;

    EntitiesDataFetcher(Map<String, EntityHandlerMethod> handlerMethods, HandlerDataFetcherExceptionResolver resolver) {
        this.handlerMethods = new LinkedHashMap<String, EntityHandlerMethod>(handlerMethods);
        this.exceptionResolver = resolver;
    }

    public Mono<DataFetcherResult<List<Object>>> get(DataFetchingEnvironment env) {
        List representations = (List)env.getArgument("representations");
        if (representations == null) {
            return Mono.error((Throwable)new RepresentationException(Collections.emptyMap(), "Missing \"representations\" argument"));
        }
        if (representations.isEmpty()) {
            return Mono.just((Object)DataFetcherResult.newResult().data(Collections.emptyList()).build());
        }
        HashSet<String> batchedTypes = new HashSet<String>();
        ArrayList<Object> monoList = new ArrayList<Object>();
        for (int index = 0; index < representations.size(); ++index) {
            Map map = (Map)representations.get(index);
            Object v = map.get("__typename");
            if (!(v instanceof String)) {
                RepresentationException ex = new RepresentationException(map, "Missing \"__typename\" argument");
                monoList.add(this.resolveException(ex, env, null, index));
                continue;
            }
            String type = (String)v;
            EntityHandlerMethod handlerMethod = this.handlerMethods.get(type);
            if (handlerMethod == null) {
                RepresentationException ex = new RepresentationException(map, "No entity fetcher");
                monoList.add(this.resolveException(ex, env, null, index));
                continue;
            }
            if (!handlerMethod.isBatchHandlerMethod()) {
                monoList.add(this.invokeEntityMethod(env, handlerMethod, map, index));
                continue;
            }
            if (!batchedTypes.contains(type)) {
                monoList.add(this.invokeEntitiesMethod(env, handlerMethod, representations, type));
                batchedTypes.add(type);
                continue;
            }
            monoList.add(Mono.just(Collections.emptyMap()));
        }
        return Mono.zip(monoList, Arrays::asList).map(EntitiesDataFetcher::toDataFetcherResult);
    }

    private Mono<Object> invokeEntityMethod(DataFetchingEnvironment environment, EntityHandlerMethod handlerMethod, Map<String, Object> representation, int index) {
        return handlerMethod.getEntity(environment, representation).switchIfEmpty(Mono.error((Throwable)new RepresentationNotResolvedException(representation, handlerMethod))).onErrorResume(ex -> this.resolveException((Throwable)ex, environment, handlerMethod, index));
    }

    private Mono<EntitiesResultContainer> invokeEntitiesMethod(DataFetchingEnvironment environment, EntityHandlerMethod handlerMethod, List<Map<String, Object>> representations, String type) {
        ArrayList<Map<String, Object>> typeRepresentations = new ArrayList<Map<String, Object>>();
        ArrayList<Integer> originalIndexes = new ArrayList<Integer>();
        for (int i = 0; i < representations.size(); ++i) {
            Map<String, Object> map = representations.get(i);
            if (!type.equals(map.get("__typename"))) continue;
            typeRepresentations.add(map);
            originalIndexes.add(i);
        }
        return handlerMethod.getEntities(environment, typeRepresentations).mapNotNull(result -> ((List)result).isEmpty() ? null : result).switchIfEmpty(Mono.defer(() -> {
            ArrayList<Mono<ErrorContainer>> exceptions = new ArrayList<Mono<ErrorContainer>>(originalIndexes.size());
            for (int i = 0; i < originalIndexes.size(); ++i) {
                exceptions.add(this.resolveException(new RepresentationNotResolvedException((Map<String, Object>)((Map)typeRepresentations.get(i)), handlerMethod), environment, handlerMethod, (Integer)originalIndexes.get(i)));
            }
            return Mono.zip(exceptions, Arrays::asList);
        })).onErrorResume(ex -> {
            ArrayList<Mono<ErrorContainer>> list = new ArrayList<Mono<ErrorContainer>>();
            for (Integer index : originalIndexes) {
                list.add(this.resolveException((Throwable)ex, environment, handlerMethod, index));
            }
            return Mono.zip(list, Arrays::asList);
        }).map(result -> new EntitiesResultContainer((List)result, originalIndexes));
    }

    private Mono<ErrorContainer> resolveException(Throwable ex, DataFetchingEnvironment env, @Nullable EntityHandlerMethod handlerMethod, int index) {
        Throwable theEx = this.unwrapException(ex);
        IndexedDataFetchingEnvironment theEnv = new IndexedDataFetchingEnvironment(env, index);
        Object handler = handlerMethod != null ? handlerMethod.getBean() : null;
        return this.exceptionResolver.resolveException(theEx, (DataFetchingEnvironment)theEnv, handler).map(ErrorContainer::new).switchIfEmpty(Mono.fromCallable(() -> this.lambda$resolveException$0(theEx, (DataFetchingEnvironment)theEnv)));
    }

    private Throwable unwrapException(Throwable exception) {
        if (exception instanceof CompletionException) {
            CompletionException completionException = (CompletionException)exception;
            return completionException.getCause() != null ? completionException.getCause() : exception;
        }
        return exception;
    }

    private ErrorContainer createDefaultError(Throwable ex, DataFetchingEnvironment env) {
        ErrorType errorType;
        if (ex instanceof RepresentationException) {
            RepresentationException representationEx = (RepresentationException)ex;
            errorType = representationEx.getErrorType();
        } else {
            errorType = ErrorType.INTERNAL_ERROR;
        }
        ErrorType errorType2 = errorType;
        return new ErrorContainer(GraphqlErrorBuilder.newError((DataFetchingEnvironment)env).errorType((ErrorClassification)errorType2).message(ex.getMessage(), new Object[0]).build());
    }

    private static DataFetcherResult<List<Object>> toDataFetcherResult(List<Object> entities) {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        for (int i = 0; i < entities.size(); ++i) {
            Object entity = entities.get(i);
            if (entity instanceof EntitiesResultContainer) {
                EntitiesResultContainer resultHandler = (EntitiesResultContainer)entity;
                resultHandler.applyResults(entities, errors);
            }
            if (!(entity instanceof ErrorContainer)) continue;
            ErrorContainer errorContainer = (ErrorContainer)entity;
            errors.addAll(errorContainer.errors());
            entities.set(i, null);
        }
        return DataFetcherResult.newResult().data(entities).errors(errors).build();
    }

    private /* synthetic */ ErrorContainer lambda$resolveException$0(Throwable theEx, DataFetchingEnvironment theEnv) throws Exception {
        return this.createDefaultError(theEx, theEnv);
    }

    private static class IndexedDataFetchingEnvironment
    extends DelegatingDataFetchingEnvironment {
        private final ExecutionStepInfo executionStepInfo;

        IndexedDataFetchingEnvironment(DataFetchingEnvironment env, int index) {
            super(env);
            this.executionStepInfo = ExecutionStepInfo.newExecutionStepInfo((ExecutionStepInfo)env.getExecutionStepInfo()).path(env.getExecutionStepInfo().getPath().segment(index)).build();
        }

        public ExecutionStepInfo getExecutionStepInfo() {
            return this.executionStepInfo;
        }
    }

    private record ErrorContainer(List<GraphQLError> errors) {
        ErrorContainer(GraphQLError error) {
            this(Collections.singletonList(error));
        }
    }

    private record EntitiesResultContainer(List<?> results, List<Integer> originalIndexes) {
        public void applyResults(List<Object> entities, List<GraphQLError> errors) {
            for (int i = 0; i < this.results.size(); ++i) {
                Object result = this.results.get(i);
                Integer index = this.originalIndexes.get(i);
                if (result instanceof ErrorContainer) {
                    ErrorContainer container = (ErrorContainer)result;
                    errors.addAll(container.errors());
                    entities.set(index, null);
                    continue;
                }
                entities.set(index, result);
            }
        }
    }
}

