/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import io.micrometer.context.ThreadLocalAccessor;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ClassUtils;

public class SecurityContextThreadLocalAccessor
implements ThreadLocalAccessor<Object> {
    private static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.core.context.SecurityContext", (ClassLoader)SecurityContextThreadLocalAccessor.class.getClassLoader());
    private final ThreadLocalAccessor<?> delegate = springSecurityPresent ? new DelegateAccessor() : new NoOpAccessor();

    public Object key() {
        return this.delegate.key();
    }

    public Object getValue() {
        return this.delegate.getValue();
    }

    public void setValue(Object value) {
        this.setValueInternal(value);
    }

    private <V> void setValueInternal(Object value) {
        this.delegate.setValue(value);
    }

    public void reset() {
        this.delegate.reset();
    }

    private static final class DelegateAccessor
    implements ThreadLocalAccessor<Object> {
        private DelegateAccessor() {
        }

        public Object key() {
            return SecurityContext.class.getName();
        }

        public Object getValue() {
            return SecurityContextHolder.getContext();
        }

        public void setValue(Object value) {
            SecurityContextHolder.setContext((SecurityContext)((SecurityContext)value));
        }

        public void reset() {
            SecurityContextHolder.clearContext();
        }
    }

    private static final class NoOpAccessor
    implements ThreadLocalAccessor<Object> {
        private NoOpAccessor() {
        }

        public Object key() {
            return this.getClass().getName();
        }

        public Object getValue() {
            return null;
        }

        public void setValue(Object value) {
        }

        public void reset() {
        }
    }
}

