/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationState;
import io.micrometer.context.ContextSnapshot;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.dataloader.DataLoaderRegistry;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.ExecutionGraphQlResponse;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.execution.DataLoaderRegistrar;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.support.DefaultExecutionGraphQlResponse;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public class DefaultExecutionGraphQlService
implements ExecutionGraphQlService {
    private static final BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput> RESET_EXECUTION_ID_CONFIGURER = (executionInput, builder) -> builder.executionId(null).build();
    private final GraphQlSource graphQlSource;
    private final List<DataLoaderRegistrar> dataLoaderRegistrars = new ArrayList<DataLoaderRegistrar>();
    @Nullable
    private Boolean hasDataLoaderRegistrations;
    private final boolean isDefaultExecutionIdProvider;

    public DefaultExecutionGraphQlService(GraphQlSource graphQlSource) {
        this.graphQlSource = graphQlSource;
        this.isDefaultExecutionIdProvider = graphQlSource.graphQl().getIdProvider() == ExecutionIdProvider.DEFAULT_EXECUTION_ID_PROVIDER;
    }

    public void addDataLoaderRegistrar(DataLoaderRegistrar registrar) {
        this.dataLoaderRegistrars.add(registrar);
    }

    @Override
    public final Mono<ExecutionGraphQlResponse> execute(ExecutionGraphQlRequest request) {
        return Mono.deferContextual(contextView -> {
            if (!this.isDefaultExecutionIdProvider && request.getExecutionId() == null) {
                request.configureExecutionInput(RESET_EXECUTION_ID_CONFIGURER);
            }
            ExecutionInput executionInput = request.toExecutionInput();
            GraphQLContext graphQLContext = executionInput.getGraphQLContext();
            ContextSnapshot.captureFrom((Object)contextView).updateContext((Object)graphQLContext);
            ExecutionInput executionInputToUse = this.registerDataLoaders(executionInput);
            return Mono.fromFuture((CompletableFuture)this.graphQlSource.graphQl().executeAsync(executionInputToUse)).map(result -> new DefaultExecutionGraphQlResponse(executionInputToUse, (ExecutionResult)result));
        });
    }

    private ExecutionInput registerDataLoaders(ExecutionInput executionInput) {
        if (this.hasDataLoaderRegistrations == null) {
            this.hasDataLoaderRegistrations = this.initHasDataLoaderRegistrations();
        }
        if (this.hasDataLoaderRegistrations.booleanValue()) {
            GraphQLContext graphQLContext = executionInput.getGraphQLContext();
            DataLoaderRegistry existingRegistry = executionInput.getDataLoaderRegistry();
            if (existingRegistry == DataLoaderDispatcherInstrumentationState.EMPTY_DATALOADER_REGISTRY) {
                DataLoaderRegistry newRegistry = DataLoaderRegistry.newRegistry().build();
                this.applyDataLoaderRegistrars(newRegistry, graphQLContext);
                executionInput = executionInput.transform(builder -> builder.dataLoaderRegistry(newRegistry));
            } else {
                this.applyDataLoaderRegistrars(existingRegistry, graphQLContext);
            }
        }
        return executionInput;
    }

    private boolean initHasDataLoaderRegistrations() {
        for (DataLoaderRegistrar registrar : this.dataLoaderRegistrars) {
            if (!registrar.hasRegistrations()) continue;
            return true;
        }
        return false;
    }

    private void applyDataLoaderRegistrars(DataLoaderRegistry registry, GraphQLContext graphQLContext) {
        this.dataLoaderRegistrars.forEach(registrar -> registrar.registerDataLoaders(registry, graphQLContext));
    }
}

