/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLTypeVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.querydsl.binding.QuerydslBinderCustomizer;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.util.TypeInformation;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.graphql.data.query.AutoRegistrationRuntimeWiringConfigurer;
import org.springframework.graphql.data.query.AutoRegistrationTypeVisitor;
import org.springframework.graphql.data.query.PropertySelection;
import org.springframework.graphql.data.query.QueryByExampleDataFetcher;
import org.springframework.graphql.data.query.RepositoryUtils;
import org.springframework.graphql.data.query.ScrollSubrange;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class QuerydslDataFetcher<T> {
    private static final Log logger = LogFactory.getLog(QueryByExampleDataFetcher.class);
    private static final QuerydslPredicateBuilder BUILDER = new QuerydslPredicateBuilder(DefaultConversionService.getSharedInstance(), (EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
    private static final QuerydslBinderCustomizer NO_OP_BINDER_CUSTOMIZER = (bindings, root) -> {};
    private final TypeInformation<T> domainType;
    private final QuerydslBinderCustomizer<EntityPath<?>> customizer;

    QuerydslDataFetcher(TypeInformation<T> domainType, QuerydslBinderCustomizer<EntityPath<?>> customizer) {
        this.domainType = domainType;
        this.customizer = customizer;
    }

    public String getDescription() {
        return "QuerydslDataFetcher<" + this.domainType.getType().getName() + ">";
    }

    protected Predicate buildPredicate(DataFetchingEnvironment environment) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        QuerydslBindings bindings = new QuerydslBindings();
        EntityPath path = SimpleEntityPathResolver.INSTANCE.createPath(this.domainType.getType());
        this.customizer.customize(bindings, path);
        for (Map.Entry<String, Object> entry : QuerydslDataFetcher.getArgumentValues(environment).entrySet()) {
            Object value = entry.getValue();
            List<Object> values = value instanceof List ? (List<Object>)value : Collections.singletonList(value);
            parameters.put((Object)entry.getKey(), values);
        }
        return BUILDER.getPredicate(this.domainType, (MultiValueMap)parameters, bindings);
    }

    private static Map<String, Object> getArgumentValues(DataFetchingEnvironment environment) {
        String name;
        Object value;
        Map arguments = environment.getArguments();
        if (environment.getFieldDefinition().getArguments().size() == 1 && (value = arguments.get(name = ((GraphQLArgument)environment.getFieldDefinition().getArguments().get(0)).getName())) instanceof Map) {
            return (Map)value;
        }
        return arguments;
    }

    protected boolean requiresProjection(Class<?> resultType) {
        return !resultType.equals(this.domainType.getType());
    }

    protected Collection<String> buildPropertyPaths(DataFetchingFieldSelectionSet selection, Class<?> resultType) {
        if (this.domainType.getType().equals(resultType) || this.domainType.getType().isAssignableFrom(resultType) || this.domainType.isSubTypeOf(resultType)) {
            return PropertySelection.create(this.domainType, selection).toList();
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.getDescription();
    }

    public static <T> Builder<T, T> builder(QuerydslPredicateExecutor<T> executor) {
        return new Builder(executor, RepositoryUtils.getDomainType(executor));
    }

    public static <T> ReactiveBuilder<T, T> builder(ReactiveQuerydslPredicateExecutor<T> executor) {
        return new ReactiveBuilder(executor, RepositoryUtils.getDomainType(executor));
    }

    public static RuntimeWiringConfigurer autoRegistrationConfigurer(List<QuerydslPredicateExecutor<?>> executors, List<ReactiveQuerydslPredicateExecutor<?>> reactiveExecutors) {
        return QuerydslDataFetcher.autoRegistrationConfigurer(executors, reactiveExecutors, null, null);
    }

    public static RuntimeWiringConfigurer autoRegistrationConfigurer(List<QuerydslPredicateExecutor<?>> executors, List<ReactiveQuerydslPredicateExecutor<?>> reactiveExecutors, @Nullable CursorStrategy<ScrollPosition> cursorStrategy, @Nullable ScrollSubrange defaultScrollSubrange) {
        Object builder;
        String typeName;
        HashMap<String, AutoRegistrationRuntimeWiringConfigurer.DataFetcherFactory> factories = new HashMap<String, AutoRegistrationRuntimeWiringConfigurer.DataFetcherFactory>();
        for (QuerydslPredicateExecutor<?> querydslPredicateExecutor : executors) {
            typeName = RepositoryUtils.getGraphQlTypeName(querydslPredicateExecutor);
            if (typeName == null) continue;
            builder = QuerydslDataFetcher.customize(querydslPredicateExecutor, QuerydslDataFetcher.builder(querydslPredicateExecutor).cursorStrategy(cursorStrategy).defaultScrollSubrange(defaultScrollSubrange).customizer(QuerydslDataFetcher.customizer(querydslPredicateExecutor)));
            factories.put(typeName, new AutoRegistrationRuntimeWiringConfigurer.DataFetcherFactory((Builder)builder){
                final /* synthetic */ Builder val$builder;
                {
                    this.val$builder = builder;
                }

                @Override
                public DataFetcher<?> single() {
                    return this.val$builder.single();
                }

                @Override
                public DataFetcher<?> many() {
                    return this.val$builder.many();
                }

                @Override
                public DataFetcher<?> scrollable() {
                    return this.val$builder.scrollable();
                }
            });
        }
        for (ReactiveQuerydslPredicateExecutor reactiveQuerydslPredicateExecutor : reactiveExecutors) {
            typeName = RepositoryUtils.getGraphQlTypeName(reactiveQuerydslPredicateExecutor);
            if (typeName == null) continue;
            builder = QuerydslDataFetcher.customize(reactiveQuerydslPredicateExecutor, QuerydslDataFetcher.builder(reactiveQuerydslPredicateExecutor).cursorStrategy(cursorStrategy).defaultScrollSubrange(defaultScrollSubrange).customizer(QuerydslDataFetcher.customizer(reactiveQuerydslPredicateExecutor)));
            factories.put(typeName, new AutoRegistrationRuntimeWiringConfigurer.DataFetcherFactory((ReactiveBuilder)builder){
                final /* synthetic */ ReactiveBuilder val$builder;
                {
                    this.val$builder = reactiveBuilder;
                }

                @Override
                public DataFetcher<?> single() {
                    return this.val$builder.single();
                }

                @Override
                public DataFetcher<?> many() {
                    return this.val$builder.many();
                }

                @Override
                public DataFetcher<?> scrollable() {
                    return this.val$builder.scrollable();
                }
            });
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Auto-registration candidate typeNames " + factories.keySet()));
        }
        return new AutoRegistrationRuntimeWiringConfigurer(factories);
    }

    @Deprecated(since="1.0.0", forRemoval=true)
    public static GraphQLTypeVisitor autoRegistrationTypeVisitor(List<QuerydslPredicateExecutor<?>> executors, List<ReactiveQuerydslPredicateExecutor<?>> reactiveExecutors) {
        Object builder;
        String typeName;
        HashMap factories = new HashMap();
        for (QuerydslPredicateExecutor<?> querydslPredicateExecutor : executors) {
            typeName = RepositoryUtils.getGraphQlTypeName(querydslPredicateExecutor);
            if (typeName == null) continue;
            builder = QuerydslDataFetcher.customize(querydslPredicateExecutor, QuerydslDataFetcher.builder(querydslPredicateExecutor).customizer(QuerydslDataFetcher.customizer(querydslPredicateExecutor)));
            factories.put(typeName, arg_0 -> QuerydslDataFetcher.lambda$autoRegistrationTypeVisitor$1((Builder)builder, arg_0));
        }
        for (ReactiveQuerydslPredicateExecutor reactiveQuerydslPredicateExecutor : reactiveExecutors) {
            typeName = RepositoryUtils.getGraphQlTypeName(reactiveQuerydslPredicateExecutor);
            if (typeName == null) continue;
            builder = QuerydslDataFetcher.customize(reactiveQuerydslPredicateExecutor, QuerydslDataFetcher.builder(reactiveQuerydslPredicateExecutor).customizer(QuerydslDataFetcher.customizer(reactiveQuerydslPredicateExecutor)));
            factories.put(typeName, arg_0 -> QuerydslDataFetcher.lambda$autoRegistrationTypeVisitor$2((ReactiveBuilder)builder, arg_0));
        }
        return new AutoRegistrationTypeVisitor(factories);
    }

    private static Builder customize(QuerydslPredicateExecutor<?> executor, Builder builder) {
        if (executor instanceof QuerydslBuilderCustomizer) {
            QuerydslBuilderCustomizer customizer = (QuerydslBuilderCustomizer)executor;
            return customizer.customize(builder);
        }
        return builder;
    }

    private static ReactiveBuilder customize(ReactiveQuerydslPredicateExecutor<?> executor, ReactiveBuilder builder) {
        if (executor instanceof ReactiveQuerydslBuilderCustomizer) {
            ReactiveQuerydslBuilderCustomizer customizer = (ReactiveQuerydslBuilderCustomizer)executor;
            return customizer.customize(builder);
        }
        return builder;
    }

    private static QuerydslBinderCustomizer customizer(Object executor) {
        return executor instanceof QuerydslBinderCustomizer ? (QuerydslBinderCustomizer)executor : NO_OP_BINDER_CUSTOMIZER;
    }

    private static /* synthetic */ DataFetcher lambda$autoRegistrationTypeVisitor$2(ReactiveBuilder builder, Boolean single) {
        return single != false ? builder.single() : builder.many();
    }

    private static /* synthetic */ DataFetcher lambda$autoRegistrationTypeVisitor$1(Builder builder, Boolean single) {
        return single != false ? builder.single() : builder.many();
    }

    public static class Builder<T, R> {
        private final QuerydslPredicateExecutor<T> executor;
        private final TypeInformation<T> domainType;
        private final Class<R> resultType;
        @Nullable
        private final CursorStrategy<ScrollPosition> cursorStrategy;
        @Nullable
        private final Integer defaultScrollCount;
        @Nullable
        private final Function<Boolean, ScrollPosition> defaultScrollPosition;
        private final Sort sort;
        private final QuerydslBinderCustomizer<? extends EntityPath<T>> customizer;

        Builder(QuerydslPredicateExecutor<T> executor, Class<R> domainType) {
            this(executor, TypeInformation.of(domainType), domainType, null, null, null, Sort.unsorted(), NO_OP_BINDER_CUSTOMIZER);
        }

        Builder(QuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, @Nullable CursorStrategy<ScrollPosition> cursorStrategy, @Nullable Integer defaultScrollCount, @Nullable Function<Boolean, ScrollPosition> defaultScrollPosition, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            this.executor = executor;
            this.domainType = domainType;
            this.resultType = resultType;
            this.cursorStrategy = cursorStrategy;
            this.defaultScrollCount = defaultScrollCount;
            this.defaultScrollPosition = defaultScrollPosition;
            this.sort = sort;
            this.customizer = customizer;
        }

        public <P> Builder<T, P> projectAs(Class<P> projectionType) {
            Assert.notNull(projectionType, (String)"Projection type must not be null");
            return new Builder<T, P>(this.executor, this.domainType, projectionType, this.cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, this.sort, this.customizer);
        }

        public Builder<T, R> cursorStrategy(@Nullable CursorStrategy<ScrollPosition> cursorStrategy) {
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, this.sort, this.customizer);
        }

        public Builder<T, R> defaultScrollSubrange(int defaultCount, Function<Boolean, ScrollPosition> defaultPosition) {
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, defaultCount, defaultPosition, this.sort, this.customizer);
        }

        @Deprecated(since="1.2.5", forRemoval=true)
        public Builder<T, R> defaultScrollSubrange(@Nullable ScrollSubrange defaultSubrange) {
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, defaultSubrange != null ? Integer.valueOf(defaultSubrange.count().getAsInt()) : null, defaultSubrange != null ? forward -> (ScrollPosition)defaultSubrange.position().get() : null, this.sort, this.customizer);
        }

        public Builder<T, R> sortBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, sort, this.customizer);
        }

        public Builder<T, R> customizer(QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            Assert.notNull(customizer, (String)"QuerydslBinderCustomizer must not be null");
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, this.sort, customizer);
        }

        public DataFetcher<R> single() {
            return new SingleEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort, this.customizer);
        }

        public DataFetcher<Iterable<R>> many() {
            return new ManyEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort, this.customizer);
        }

        public DataFetcher<Iterable<R>> scrollable() {
            return new ScrollableEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy != null ? this.cursorStrategy : RepositoryUtils.defaultCursorStrategy(), this.defaultScrollCount != null ? this.defaultScrollCount : RepositoryUtils.defaultScrollCount(), this.defaultScrollPosition != null ? this.defaultScrollPosition : RepositoryUtils.defaultScrollPosition(), this.sort, this.customizer);
        }
    }

    public static class ReactiveBuilder<T, R> {
        private final ReactiveQuerydslPredicateExecutor<T> executor;
        private final TypeInformation<T> domainType;
        private final Class<R> resultType;
        @Nullable
        private final CursorStrategy<ScrollPosition> cursorStrategy;
        @Nullable
        private final Integer defaultScrollCount;
        @Nullable
        private final Function<Boolean, ScrollPosition> defaultScrollPosition;
        private final Sort sort;
        private final QuerydslBinderCustomizer<? extends EntityPath<T>> customizer;

        ReactiveBuilder(ReactiveQuerydslPredicateExecutor<T> executor, Class<R> domainType) {
            this(executor, TypeInformation.of(domainType), domainType, null, null, null, Sort.unsorted(), NO_OP_BINDER_CUSTOMIZER);
        }

        ReactiveBuilder(ReactiveQuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, @Nullable CursorStrategy<ScrollPosition> cursorStrategy, @Nullable Integer defaultScrollCount, @Nullable Function<Boolean, ScrollPosition> defaultScrollPosition, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            this.executor = executor;
            this.domainType = domainType;
            this.resultType = resultType;
            this.cursorStrategy = cursorStrategy;
            this.defaultScrollCount = defaultScrollCount;
            this.defaultScrollPosition = defaultScrollPosition;
            this.sort = sort;
            this.customizer = customizer;
        }

        public <P> ReactiveBuilder<T, P> projectAs(Class<P> projectionType) {
            Assert.notNull(projectionType, (String)"Projection type must not be null");
            return new ReactiveBuilder<T, P>(this.executor, this.domainType, projectionType, this.cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, this.sort, this.customizer);
        }

        public ReactiveBuilder<T, R> cursorStrategy(@Nullable CursorStrategy<ScrollPosition> cursorStrategy) {
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, this.sort, this.customizer);
        }

        public ReactiveBuilder<T, R> defaultScrollSubrange(int defaultCount, Function<Boolean, ScrollPosition> defaultPosition) {
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, defaultCount, defaultPosition, this.sort, this.customizer);
        }

        @Deprecated(since="1.2.5", forRemoval=true)
        public ReactiveBuilder<T, R> defaultScrollSubrange(@Nullable ScrollSubrange defaultSubrange) {
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, defaultSubrange != null ? Integer.valueOf(defaultSubrange.count().getAsInt()) : null, defaultSubrange != null ? forward -> (ScrollPosition)defaultSubrange.position().get() : null, this.sort, this.customizer);
        }

        public ReactiveBuilder<T, R> sortBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, sort, this.customizer);
        }

        public ReactiveBuilder<T, R> customizer(QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            Assert.notNull(customizer, (String)"QuerydslBinderCustomizer must not be null");
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, this.sort, customizer);
        }

        public DataFetcher<Mono<R>> single() {
            return new ReactiveSingleEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort, this.customizer);
        }

        public DataFetcher<Flux<R>> many() {
            return new ReactiveManyEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort, this.customizer);
        }

        public DataFetcher<Mono<Iterable<R>>> scrollable() {
            return new ReactiveScrollableEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy != null ? this.cursorStrategy : RepositoryUtils.defaultCursorStrategy(), this.defaultScrollCount != null ? this.defaultScrollCount : RepositoryUtils.defaultScrollCount(), this.defaultScrollPosition != null ? this.defaultScrollPosition : RepositoryUtils.defaultScrollPosition(), this.sort, this.customizer);
        }
    }

    public static interface QuerydslBuilderCustomizer<T> {
        public Builder<T, ?> customize(Builder<T, ?> var1);
    }

    public static interface ReactiveQuerydslBuilderCustomizer<T> {
        public ReactiveBuilder<T, ?> customize(ReactiveBuilder<T, ?> var1);
    }

    private static class ReactiveScrollableEntityFetcher<T, R>
    extends QuerydslDataFetcher<T>
    implements SelfDescribingDataFetcher<Mono<Iterable<R>>> {
        private final ReactiveQuerydslPredicateExecutor<T> executor;
        private final Class<R> resultType;
        private final ResolvableType scrollableResultType;
        private final CursorStrategy<ScrollPosition> cursorStrategy;
        private final int defaultCount;
        private final Function<Boolean, ScrollPosition> defaultPosition;
        private final Sort sort;

        ReactiveScrollableEntityFetcher(ReactiveQuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, CursorStrategy<ScrollPosition> cursorStrategy, int defaultCount, Function<Boolean, ScrollPosition> defaultPosition, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            super(domainType, customizer);
            Assert.notNull(cursorStrategy, (String)"CursorStrategy is required");
            Assert.notNull(defaultPosition, (String)"'defaultPosition' is required");
            this.executor = executor;
            this.resultType = resultType;
            this.scrollableResultType = ResolvableType.forClassWithGenerics(Iterable.class, (Class[])new Class[]{resultType});
            this.cursorStrategy = cursorStrategy;
            this.defaultCount = defaultCount;
            this.defaultPosition = defaultPosition;
            this.sort = sort;
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClassWithGenerics(Mono.class, (ResolvableType[])new ResolvableType[]{this.scrollableResultType});
        }

        public Mono<Iterable<R>> get(DataFetchingEnvironment env) {
            return (Mono)this.executor.findBy(this.buildPredicate(env), query -> {
                FluentQuery.ReactiveFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                ScrollSubrange range = RepositoryUtils.getScrollSubrange(env, this.cursorStrategy);
                int count = range.count().orElse(this.defaultCount);
                ScrollPosition position = range.position().isPresent() ? (ScrollPosition)range.position().get() : this.defaultPosition.apply(range.forward());
                return queryToUse.limit(count).scroll(position).map(Function.identity());
            });
        }
    }

    private static class ReactiveManyEntityFetcher<T, R>
    extends QuerydslDataFetcher<T>
    implements SelfDescribingDataFetcher<Flux<R>> {
        private final ReactiveQuerydslPredicateExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ReactiveManyEntityFetcher(ReactiveQuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            super(domainType, customizer);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClassWithGenerics(Flux.class, (Class[])new Class[]{this.resultType});
        }

        public Flux<R> get(DataFetchingEnvironment env) {
            return (Flux)this.executor.findBy(this.buildPredicate(env), query -> {
                FluentQuery.ReactiveFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return queryToUse.all();
            });
        }
    }

    private static class ReactiveSingleEntityFetcher<T, R>
    extends QuerydslDataFetcher<T>
    implements SelfDescribingDataFetcher<Mono<R>> {
        private final ReactiveQuerydslPredicateExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ReactiveSingleEntityFetcher(ReactiveQuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            super(domainType, customizer);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClassWithGenerics(Mono.class, (Class[])new Class[]{this.resultType});
        }

        public Mono<R> get(DataFetchingEnvironment env) {
            return (Mono)this.executor.findBy(this.buildPredicate(env), query -> {
                FluentQuery.ReactiveFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return queryToUse.first();
            });
        }
    }

    private static class ScrollableEntityFetcher<T, R>
    extends ManyEntityFetcher<T, R> {
        private final CursorStrategy<ScrollPosition> cursorStrategy;
        private final int defaultCount;
        private final Function<Boolean, ScrollPosition> defaultPosition;

        ScrollableEntityFetcher(QuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, CursorStrategy<ScrollPosition> cursorStrategy, int defaultCount, Function<Boolean, ScrollPosition> defaultPosition, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            super(executor, domainType, resultType, sort, customizer);
            Assert.notNull(cursorStrategy, (String)"CursorStrategy is required");
            Assert.notNull(defaultPosition, (String)"'defaultPosition' is required");
            this.cursorStrategy = cursorStrategy;
            this.defaultCount = defaultCount;
            this.defaultPosition = defaultPosition;
        }

        @Override
        protected Iterable<R> getResult(FluentQuery.FetchableFluentQuery<R> queryToUse, DataFetchingEnvironment env) {
            ScrollSubrange range = RepositoryUtils.getScrollSubrange(env, this.cursorStrategy);
            int count = range.count().orElse(this.defaultCount);
            ScrollPosition position = range.position().isPresent() ? (ScrollPosition)range.position().get() : this.defaultPosition.apply(range.forward());
            return queryToUse.limit(count).scroll(position);
        }
    }

    private static class ManyEntityFetcher<T, R>
    extends QuerydslDataFetcher<T>
    implements SelfDescribingDataFetcher<Iterable<R>> {
        private final QuerydslPredicateExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ManyEntityFetcher(QuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            super(domainType, customizer);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClassWithGenerics(Iterable.class, (Class[])new Class[]{this.resultType});
        }

        public Iterable<R> get(DataFetchingEnvironment env) {
            return (Iterable)this.executor.findBy(this.buildPredicate(env), query -> {
                FluentQuery.FetchableFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return this.getResult(queryToUse, env);
            });
        }

        protected Iterable<R> getResult(FluentQuery.FetchableFluentQuery<R> queryToUse, DataFetchingEnvironment env) {
            return queryToUse.all();
        }
    }

    private static class SingleEntityFetcher<T, R>
    extends QuerydslDataFetcher<T>
    implements SelfDescribingDataFetcher<R> {
        private final QuerydslPredicateExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        SingleEntityFetcher(QuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            super(domainType, customizer);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClass(this.resultType);
        }

        public R get(DataFetchingEnvironment env) {
            return ((Optional)this.executor.findBy(this.buildPredicate(env), query -> {
                Class<R> resultType;
                FluentQuery.FetchableFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(resultType = this.resultType) ? queryToUse.as(resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), resultType));
                return queryToUse.first();
            })).orElse(null);
        }
    }
}

