/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

final class EncoderDecoderMappingProvider
implements MappingProvider {
    private static final ResolvableType MAP_TYPE = ResolvableType.forClass(Map.class);
    private final Encoder<?> encoder;
    private final Decoder<?> decoder;

    EncoderDecoderMappingProvider(CodecConfigurer configurer) {
        this.encoder = EncoderDecoderMappingProvider.findJsonEncoder(configurer);
        this.decoder = EncoderDecoderMappingProvider.findJsonDecoder(configurer);
    }

    EncoderDecoderMappingProvider(List<Encoder<?>> encoders, List<Decoder<?>> decoders) {
        this.encoder = EncoderDecoderMappingProvider.findJsonEncoder(encoders);
        this.decoder = EncoderDecoderMappingProvider.findJsonDecoder(decoders);
    }

    private static Encoder<?> findJsonEncoder(CodecConfigurer configurer) {
        return EncoderDecoderMappingProvider.findJsonEncoder(configurer.getWriters().stream().filter(writer -> writer instanceof EncoderHttpMessageWriter).map(writer -> ((EncoderHttpMessageWriter)writer).getEncoder()));
    }

    private static Decoder<?> findJsonDecoder(CodecConfigurer configurer) {
        return EncoderDecoderMappingProvider.findJsonDecoder(configurer.getReaders().stream().filter(reader -> reader instanceof DecoderHttpMessageReader).map(reader -> ((DecoderHttpMessageReader)reader).getDecoder()));
    }

    private static Encoder<?> findJsonEncoder(List<Encoder<?>> encoders) {
        return EncoderDecoderMappingProvider.findJsonEncoder(encoders.stream());
    }

    private static Decoder<?> findJsonDecoder(List<Decoder<?>> decoders) {
        return EncoderDecoderMappingProvider.findJsonDecoder(decoders.stream());
    }

    private static Encoder<?> findJsonEncoder(Stream<Encoder<?>> stream) {
        return stream.filter(encoder -> encoder.canEncode(MAP_TYPE, (MimeType)MediaType.APPLICATION_JSON)).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Encoder"));
    }

    private static Decoder<?> findJsonDecoder(Stream<Decoder<?>> decoderStream) {
        return decoderStream.filter(decoder -> decoder.canDecode(MAP_TYPE, (MimeType)MediaType.APPLICATION_JSON)).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Decoder"));
    }

    public <T> @Nullable T map(Object source, Class<T> targetType, Configuration configuration) {
        return this.mapToTargetType(source, ResolvableType.forClass(targetType));
    }

    public <T> @Nullable T map(Object source, TypeRef<T> targetType, Configuration configuration) {
        return this.mapToTargetType(source, ResolvableType.forType((Type)targetType.getType()));
    }

    private <T> @Nullable T mapToTargetType(Object source, ResolvableType targetType) {
        DefaultDataBufferFactory bufferFactory = DefaultDataBufferFactory.sharedInstance;
        MimeType mimeType = MimeTypeUtils.APPLICATION_JSON;
        Map hints = Collections.emptyMap();
        DataBuffer buffer = this.encoder.encodeValue(source, (DataBufferFactory)bufferFactory, ResolvableType.forInstance((Object)source), mimeType, hints);
        return (T)this.decoder.decode(buffer, targetType, mimeType, hints);
    }
}

