/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.test.context;

import java.util.Optional;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.geode.context.annotation.RefreshableAnnotationConfigApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;

public class TestRefreshableApplicationContextLoader
extends AbstractContextLoader {
    protected static final String DEFAULT_RESOURCE_SUFFIX = "-context";
    private Class<?> testClass;

    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        super.processContextConfiguration(configAttributes);
        this.testClass = configAttributes.getDeclaringClass();
    }

    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) {
        ConfigurableApplicationContext applicationContext = this.configure(this.newApplicationContext(mergedConfig), mergedConfig);
        applicationContext.registerShutdownHook();
        applicationContext.refresh();
        return applicationContext;
    }

    protected ConfigurableApplicationContext newApplicationContext(MergedContextConfiguration contextConfiguration) {
        RefreshableAnnotationConfigApplicationContext applicationContext = new RefreshableAnnotationConfigApplicationContext(contextConfiguration.getParentApplicationContext());
        this.prepareContext((ConfigurableApplicationContext)applicationContext, contextConfiguration);
        return applicationContext;
    }

    private ConfigurableApplicationContext configure(ConfigurableApplicationContext applicationContext, MergedContextConfiguration contextConfiguration) {
        applicationContext = this.configureComponentClasses(applicationContext, contextConfiguration);
        applicationContext = this.configureScan(applicationContext, contextConfiguration);
        this.customizeContext(applicationContext, contextConfiguration);
        return applicationContext;
    }

    private ConfigurableApplicationContext configureComponentClasses(ConfigurableApplicationContext applicationContext, MergedContextConfiguration contextConfiguration) {
        Optional.ofNullable(applicationContext).filter(it -> ArrayUtils.isNotEmpty((Object[])contextConfiguration.getClasses())).filter(AnnotationConfigRegistry.class::isInstance).map(AnnotationConfigRegistry.class::cast).ifPresent(registry -> registry.register(contextConfiguration.getClasses()));
        return applicationContext;
    }

    private ConfigurableApplicationContext configureScan(ConfigurableApplicationContext applicationContext, MergedContextConfiguration contextConfiguration) {
        Optional.ofNullable(applicationContext).filter(it -> ArrayUtils.isNotEmpty((Object[])contextConfiguration.getLocations())).filter(AnnotationConfigRegistry.class::isInstance).map(AnnotationConfigRegistry.class::cast).ifPresent(registry -> registry.scan(contextConfiguration.getLocations()));
        return applicationContext;
    }

    public ApplicationContext loadContext(String ... locations) {
        return this.loadContext(new MergedContextConfiguration(this.testClass, locations, new Class[0], new String[0], (ContextLoader)this));
    }

    protected String getResourceSuffix() {
        return DEFAULT_RESOURCE_SUFFIX;
    }
}

