/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.io.support;

import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class ResourceUtils {
    @NonNull
    public static WritableResource asStrictlyWritableResource(@Nullable Resource resource) {
        return Optional.ofNullable(resource).filter(WritableResource.class::isInstance).map(WritableResource.class::cast).filter(WritableResource::isWritable).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"Resource [%s] is not writable", (Object[])new Object[]{ResourceUtils.nullSafeGetDescription(resource)}));
    }

    public static Optional<WritableResource> asWritableResource(@Nullable Resource resource) {
        return Optional.ofNullable(resource).filter(WritableResource.class::isInstance).map(WritableResource.class::cast);
    }

    public static boolean isNotEmpty(@Nullable byte[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isReadable(@Nullable Resource resource) {
        return resource != null && resource.isReadable();
    }

    public static boolean isWritable(@Nullable Resource resource) {
        return resource instanceof WritableResource && ((WritableResource)resource).isWritable();
    }

    @Nullable
    public static String nullSafeGetDescription(@Nullable Resource resource) {
        return resource != null ? resource.getDescription() : null;
    }
}

