/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.io;

import java.nio.ByteBuffer;
import org.springframework.core.io.Resource;
import org.springframework.geode.core.io.UnhandledResourceException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@FunctionalInterface
public interface ResourceReader {
    @NonNull
    public byte[] read(@NonNull Resource var1);

    @NonNull
    default public ByteBuffer readIntoByteBuffer(@NonNull Resource resource) {
        return ByteBuffer.wrap(this.read(resource));
    }

    @NonNull
    default public ResourceReader thenReadFrom(@Nullable ResourceReader reader) {
        return reader == null ? this : resource -> {
            try {
                return this.read(resource);
            }
            catch (UnhandledResourceException ignore) {
                return reader.read(resource);
            }
        };
    }
}

