/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.config.annotation;

import java.util.Set;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.config.annotation.EnableClusterConfiguration;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.geode.config.annotation.ClusterAwareConfiguration;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={AnyClusterAvailableCondition.class})
@EnableClusterConfiguration(requireHttps=false, useHttp=true)
public class ClusterAvailableConfiguration {
    private static final Set<CloudPlatform> SUPPORTED_CLOUD_PLATFORMS = CollectionUtils.asSet((Object[])new CloudPlatform[]{CloudPlatform.CLOUD_FOUNDRY, CloudPlatform.KUBERNETES});

    public static class StandaloneClusterAvailableCondition
    extends ClusterAwareConfiguration.ClusterAwareCondition {
        @Override
        public synchronized boolean matches(@NonNull ConditionContext conditionContext, @NonNull AnnotatedTypeMetadata typeMetadata) {
            return this.isNotSupportedCloudPlatform(conditionContext) && super.matches(conditionContext, typeMetadata);
        }

        private boolean isNotSupportedCloudPlatform(@NonNull ConditionContext conditionContext) {
            return conditionContext != null && this.isNotSupportedCloudPlatform(conditionContext.getEnvironment());
        }

        private boolean isNotSupportedCloudPlatform(@NonNull Environment environment) {
            CloudPlatform activeCloudPlatform = environment != null ? CloudPlatform.getActive((Environment)environment) : null;
            return !this.isSupportedCloudPlatform(activeCloudPlatform);
        }

        private boolean isSupportedCloudPlatform(@NonNull CloudPlatform cloudPlatform) {
            return cloudPlatform != null && SUPPORTED_CLOUD_PLATFORMS.contains(cloudPlatform);
        }
    }

    public static class KubernetesClusterAvailableCondition
    extends AbstractCloudPlatformAvailableCondition {
        protected static final String KUBERNETES_NAME = "Kubernetes";
        protected static final String RUNTIME_ENVIRONMENT_NAME = "VMware Tanzu GemFire for K8S";

        @Override
        protected String getCloudPlatformName() {
            return KUBERNETES_NAME;
        }

        @Override
        protected String getRuntimeEnvironmentName() {
            return RUNTIME_ENVIRONMENT_NAME;
        }

        @Override
        protected boolean isCloudPlatformActive(@NonNull Environment environment) {
            return environment != null && CloudPlatform.KUBERNETES.isActive(environment);
        }
    }

    public static class CloudFoundryClusterAvailableCondition
    extends AbstractCloudPlatformAvailableCondition {
        protected static final String CLOUD_FOUNDRY_NAME = "CloudFoundry";
        protected static final String RUNTIME_ENVIRONMENT_NAME = "VMware Tanzu GemFire for VMs";

        @Override
        protected String getCloudPlatformName() {
            return CLOUD_FOUNDRY_NAME;
        }

        @Override
        protected String getRuntimeEnvironmentName() {
            return RUNTIME_ENVIRONMENT_NAME;
        }

        @Override
        protected boolean isCloudPlatformActive(@NonNull Environment environment) {
            return environment != null && CloudPlatform.CLOUD_FOUNDRY.isActive(environment);
        }
    }

    protected static abstract class AbstractCloudPlatformAvailableCondition
    extends ClusterAwareConfiguration.ClusterAwareCondition {
        protected AbstractCloudPlatformAvailableCondition() {
        }

        protected abstract String getCloudPlatformName();

        @Override
        protected String getRuntimeEnvironmentName() {
            return this.getCloudPlatformName();
        }

        protected abstract boolean isCloudPlatformActive(@NonNull Environment var1);

        protected boolean isInfoLoggingEnabled() {
            return this.getLogger().isInfoEnabled();
        }

        protected boolean isMatchingStrictOrLoggable(boolean match, boolean strictMatch) {
            return match && (strictMatch || this.isInfoLoggingEnabled());
        }

        @Override
        public final synchronized boolean matches(@NonNull ConditionContext conditionContext, @NonNull AnnotatedTypeMetadata typeMetadata) {
            boolean strictMatch;
            boolean match = this.isCloudPlatformActive(conditionContext.getEnvironment());
            if (this.isMatchingStrictOrLoggable(match, strictMatch = this.isStrictMatch(conditionContext, typeMetadata))) {
                match |= super.matches(conditionContext, typeMetadata);
            }
            if (match && !AbstractCloudPlatformAvailableCondition.wasClusterAvailabilityEvaluated()) {
                AbstractCloudPlatformAvailableCondition.set(true);
            }
            return match;
        }

        @Override
        protected void logConnectedRuntimeEnvironment(@NonNull Logger logger) {
            if (logger.isInfoEnabled()) {
                logger.info("Spring Boot application is running in a client/server topology, inside a [{}] Cloud-managed Environment", (Object)this.getRuntimeEnvironmentName());
            }
        }

        @Override
        protected void logUnconnectedRuntimeEnvironment(@NonNull Logger logger) {
            if (logger.isInfoEnabled()) {
                logger.info("No cluster was found; Spring Boot application is running in a [{}] Cloud-managed Environment", (Object)this.getRuntimeEnvironmentName());
            }
        }

        @Override
        protected void configureTopology(@NonNull Environment environment, @NonNull ConnectionEndpointList connectionEndpoints, int connectionCount) {
        }
    }

    public static final class AnyClusterAvailableCondition
    extends AnyNestedCondition {
        public AnyClusterAvailableCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @Conditional(value={StandaloneClusterAvailableCondition.class})
        static class IsStandaloneClusterAvailableCondition {
            IsStandaloneClusterAvailableCondition() {
            }
        }

        @Conditional(value={KubernetesClusterAvailableCondition.class})
        static class IsKubernetesClusterAvailableCondition {
            IsKubernetesClusterAvailableCondition() {
            }
        }

        @Conditional(value={CloudFoundryClusterAvailableCondition.class})
        static class IsCloudFoundryClusterAvailableCondition {
            IsCloudFoundryClusterAvailableCondition() {
            }
        }
    }
}

