/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.data.rest.core.config.JsonSchemaFormat;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class JsonSchema {
    private static List<Class<?>> INTEGER_TYPES = Arrays.asList(Long.class, Long.TYPE, Integer.class, Integer.TYPE, Short.class, Short.TYPE);
    private final String title;
    private final String description;
    private final PropertiesContainer container;
    private final Definitions definitions;

    public JsonSchema(String title, String description, Collection<AbstractJsonSchemaProperty<?>> properties, Definitions definitions) {
        Assert.hasText((String)title, (String)"Title must not be null or empty");
        Assert.notNull(properties, (String)"JsonSchemaProperties must not be null");
        Assert.notNull((Object)definitions, (String)"Definitions must not be null");
        this.title = title;
        this.description = description;
        this.container = new PropertiesContainer(properties);
        this.definitions = definitions;
    }

    @JsonProperty(value="$schema")
    public String getSchema() {
        return "http://json-schema.org/draft-04/schema#";
    }

    public String getType() {
        return "object";
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonUnwrapped
    public PropertiesContainer getContainer() {
        return this.container;
    }

    @JsonUnwrapped
    public Definitions getDefinitions() {
        return this.definitions;
    }

    private static String toJsonSchemaType(TypeInformation<?> typeInformation) {
        Class type = typeInformation.getType();
        if (type == null) {
            return null;
        }
        if (typeInformation.isCollectionLike()) {
            return "array";
        }
        if (Boolean.class.equals((Object)type) || Boolean.TYPE.equals(type)) {
            return "boolean";
        }
        if (String.class.equals((Object)type) || JsonSchema.isDate(typeInformation) || type.isEnum()) {
            return "string";
        }
        if (INTEGER_TYPES.contains(type)) {
            return "integer";
        }
        if (ClassUtils.isAssignable(Number.class, (Class)type)) {
            return "number";
        }
        return "object";
    }

    private static boolean isDate(TypeInformation<?> type) {
        Class rawType = type.getType();
        if (Date.class.equals((Object)rawType)) {
            return true;
        }
        for (String datePackage : Arrays.asList("java.time", "org.threeten.bp", "org.joda.time")) {
            if (!rawType.getName().startsWith(datePackage)) continue;
            return true;
        }
        return false;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    static class PropertiesContainer {
        public final Map<String, AbstractJsonSchemaProperty<?>> properties;
        public final Collection<String> requiredProperties;

        public PropertiesContainer(Collection<AbstractJsonSchemaProperty<?>> properties) {
            Assert.notNull(properties, (String)"JsonSchemaPropertys must not be null");
            this.properties = new HashMap();
            this.requiredProperties = new ArrayList<String>();
            for (AbstractJsonSchemaProperty<?> property : properties) {
                this.properties.put(property.getName(), property);
                if (!property.isRequired()) continue;
                this.requiredProperties.add(property.name);
            }
        }
    }

    public static class Definitions {
        private final Map<String, Item> definitions = new HashMap<String, Item>();

        public Map<String, Item> getDefinitions() {
            return this.definitions;
        }

        boolean hasDefinitionFor(TypeInformation<?> type) {
            return this.definitions.containsKey(Definitions.typeKey(type));
        }

        String addDefinition(TypeInformation<?> type, Item item) {
            String reference = Definitions.typeKey(type);
            this.definitions.put(reference, item);
            return reference;
        }

        static String getReference(TypeInformation<?> type) {
            return String.format("#/definitions/%s", Definitions.typeKey(type));
        }

        static String typeKey(TypeInformation<?> type) {
            return StringUtils.uncapitalize((String)type.getActualType().getType().getSimpleName());
        }
    }

    public static class EnumProperty
    extends JsonSchemaProperty {
        private List<String> values;

        public EnumProperty(String name, String title, Class<?> type, String description, boolean required) {
            this(name, title, EnumProperty.toValues(type), description, required);
        }

        public EnumProperty(String name, String title, List<String> values, String description, boolean required) {
            super(name, title, description, required);
            this.values = Collections.unmodifiableList(values);
        }

        @JsonProperty(value="enum")
        public List<String> getValues() {
            return this.values;
        }

        public EnumProperty withValues(List<String> values) {
            Assert.notNull(values, (String)"Values must not be null");
            this.values = Collections.unmodifiableList(values);
            return this;
        }

        private static List<String> toValues(Class<?> type) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object value : type.getEnumConstants()) {
                values.add(value.toString());
            }
            return values;
        }
    }

    public static class JsonSchemaProperty
    extends AbstractJsonSchemaProperty<JsonSchemaProperty> {
        private static final TypeInformation<?> STRING_TYPE_INFORMATION = ClassTypeInformation.from(String.class);
        public String description;
        public String type;
        @JsonSerialize(using=ToStringSerializer.class)
        public JsonSchemaFormat format;
        public String pattern;
        public Boolean uniqueItems;
        @JsonProperty(value="$ref")
        public String reference;
        public Map<String, String> items;

        JsonSchemaProperty(String name, String title, String description, boolean required) {
            super(name, title, required);
            this.description = description;
        }

        public JsonSchemaProperty withType(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null");
            return this.with((TypeInformation<?>)ClassTypeInformation.from(type));
        }

        public JsonSchemaProperty with(TypeInformation<?> type) {
            Assert.notNull(type, (String)"Type must not be null");
            this.type = JsonSchema.toJsonSchemaType(type);
            if (JsonSchema.isDate(type)) {
                return this.withFormat(JsonSchemaFormat.DATE_TIME);
            }
            if (type.isCollectionLike()) {
                if (Set.class.equals((Object)type.getType())) {
                    this.uniqueItems = true;
                }
                this.items = Collections.singletonMap("type", JsonSchema.toJsonSchemaType(type.getActualType()));
            }
            return this;
        }

        public JsonSchemaProperty withFormat(JsonSchemaFormat format) {
            Assert.notNull((Object)format, (String)"Format must not be null");
            this.format = format;
            return this.with(STRING_TYPE_INFORMATION);
        }

        public JsonSchemaProperty withRegex(String regex) {
            Assert.hasText((String)regex, (String)"Regular expression must not be null or empty");
            return this.withPattern(Pattern.compile(regex));
        }

        public JsonSchemaProperty withPattern(Pattern pattern) {
            Assert.notNull((Object)pattern, (String)"Pattern must not be null");
            this.pattern = pattern.toString();
            return this.with(STRING_TYPE_INFORMATION);
        }

        public JsonSchemaProperty asAssociation() {
            this.items = null;
            this.uniqueItems = null;
            return this.withFormat(JsonSchemaFormat.URI);
        }

        JsonSchemaProperty with(TypeInformation<?> type, String reference) {
            if (type.isCollectionLike()) {
                if (Set.class.equals((Object)type.getType())) {
                    this.uniqueItems = true;
                }
                this.type = JsonSchema.toJsonSchemaType(type);
                this.items = Collections.singletonMap("$ref", reference);
                return this;
            }
            this.reference = reference;
            return this;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    static abstract class AbstractJsonSchemaProperty<T extends AbstractJsonSchemaProperty<T>> {
        private final String name;
        private final String title;
        private final boolean required;
        private boolean readOnly;

        protected AbstractJsonSchemaProperty(String name, boolean required) {
            this(name, null, required);
        }

        protected AbstractJsonSchemaProperty(String name, String title, boolean required) {
            this.name = name;
            this.title = title;
            this.required = required;
            this.readOnly = false;
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        private boolean isRequired() {
            return this.required;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        protected T withReadOnly() {
            this.readOnly = true;
            return (T)this;
        }
    }

    static class Item {
        private final String type;
        private final PropertiesContainer properties;

        public Item(TypeInformation<?> type, Collection<AbstractJsonSchemaProperty<?>> properties) {
            this.type = JsonSchema.toJsonSchemaType(type.getActualType());
            this.properties = new PropertiesContainer(properties);
        }

        public String getType() {
            return this.type;
        }

        @JsonUnwrapped
        public PropertiesContainer getProperties() {
            return this.properties;
        }
    }
}

