/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.CaseExpression;
import org.springframework.data.relational.core.sql.Literal;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.When;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.TypedSingleConditionRenderSupport;

public class CaseExpressionVisitor
extends TypedSingleConditionRenderSupport<CaseExpression>
implements PartRenderer {
    private final StringBuilder part = new StringBuilder();

    CaseExpressionVisitor(RenderContext context) {
        super(context);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.hasDelegatedRendering()) {
            CharSequence renderedPart = this.consumeRenderedPart();
            if (segment instanceof When) {
                this.part.append(" ");
                this.part.append(renderedPart);
            } else if (segment instanceof Literal) {
                this.part.append(" ELSE ");
                this.part.append(renderedPart);
            }
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(CaseExpression segment) {
        this.part.append("CASE");
        return super.enterMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(CaseExpression segment) {
        this.part.append(" END");
        return super.leaveMatched(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.part;
    }
}

