/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.types;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.util.Assert;

public class Expiration {
    private final long expirationTime;
    private final TimeUnit timeUnit;

    public static Expiration milliseconds(long expirationTime) {
        return new Expiration(expirationTime, TimeUnit.MILLISECONDS);
    }

    public static Expiration seconds(long expirationTime) {
        return new Expiration(expirationTime, TimeUnit.SECONDS);
    }

    public static Expiration unixTimestamp(long unixTimestamp, TimeUnit timeUnit) {
        return new ExpireAt(unixTimestamp, timeUnit);
    }

    public static Expiration from(long expirationTime, @Nullable TimeUnit timeUnit) {
        if (timeUnit == null) {
            return new Expiration(expirationTime, TimeUnit.SECONDS);
        }
        if (TimeUnit.NANOSECONDS.equals((Object)timeUnit) || TimeUnit.MICROSECONDS.equals((Object)timeUnit) || TimeUnit.MILLISECONDS.equals((Object)timeUnit)) {
            return new Expiration(timeUnit.toMillis(expirationTime), TimeUnit.MILLISECONDS);
        }
        return new Expiration(timeUnit.toSeconds(expirationTime), TimeUnit.SECONDS);
    }

    public static Expiration from(Duration duration) {
        Assert.notNull((Object)duration, (String)"Duration must not be null");
        return duration.isZero() ? Expiration.persistent() : (TimeoutUtils.hasMillis(duration) ? new Expiration(duration.toMillis(), TimeUnit.MILLISECONDS) : new Expiration(duration.getSeconds(), TimeUnit.SECONDS));
    }

    public static Expiration keepTtl() {
        return KeepTtl.INSTANCE;
    }

    public static Expiration persistent() {
        return new Expiration(-1L, TimeUnit.SECONDS);
    }

    protected Expiration(long expirationTime, @Nullable TimeUnit timeUnit) {
        this.expirationTime = expirationTime;
        this.timeUnit = timeUnit != null ? timeUnit : TimeUnit.SECONDS;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public long getExpirationTimeInMilliseconds() {
        return this.getConverted(TimeUnit.MILLISECONDS);
    }

    public long getExpirationTimeInSeconds() {
        return this.getConverted(TimeUnit.SECONDS);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getConverted(TimeUnit targetTimeUnit) {
        Assert.notNull((Object)((Object)targetTimeUnit), (String)"TimeUnit must not be null");
        return targetTimeUnit.convert(this.getExpirationTime(), this.getTimeUnit());
    }

    public boolean isPersistent() {
        return this.getExpirationTime() == -1L;
    }

    public boolean isKeepTtl() {
        return false;
    }

    public boolean isUnixTimestamp() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Expiration)) {
            return false;
        }
        Expiration that = (Expiration)obj;
        return this.getTimeUnit().toMillis(this.getExpirationTime()) == that.getTimeUnit().toMillis(that.getExpirationTime());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getExpirationTime(), this.getTimeUnit()});
    }

    private static class ExpireAt
    extends Expiration {
        private ExpireAt(long expirationTime, @Nullable TimeUnit timeUnit) {
            super(expirationTime, timeUnit);
        }

        @Override
        public boolean isUnixTimestamp() {
            return true;
        }
    }

    private static class KeepTtl
    extends Expiration {
        static KeepTtl INSTANCE = new KeepTtl();

        private KeepTtl() {
            super(-2L, null);
        }

        @Override
        public boolean isKeepTtl() {
            return true;
        }
    }
}

