/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.support.collections.AbstractRedisCollection;
import org.springframework.data.redis.support.collections.CollectionUtils;
import org.springframework.data.redis.support.collections.RedisIterator;
import org.springframework.data.redis.support.collections.RedisList;
import org.springframework.lang.Nullable;

public class DefaultRedisList<E>
extends AbstractRedisCollection<E>
implements RedisList<E> {
    private final BoundListOperations<String, E> listOps;
    private volatile int maxSize = 0;
    private volatile boolean capped = false;

    public DefaultRedisList(String key, RedisOperations<String, E> operations) {
        this(operations.boundListOps(key));
    }

    public DefaultRedisList(BoundListOperations<String, E> boundOps) {
        this(boundOps, 0);
    }

    public DefaultRedisList(BoundListOperations<String, E> boundOps, int maxSize) {
        super((String)boundOps.getKey(), boundOps.getOperations());
        this.listOps = boundOps;
        this.setMaxSize(maxSize);
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.capped = maxSize > 0;
    }

    @Override
    public List<E> range(long start, long end) {
        return this.listOps.range(start, end);
    }

    @Override
    public RedisList<E> trim(int start, int end) {
        this.listOps.trim(start, end);
        return this;
    }

    @Override
    public Iterator<E> iterator() {
        List<E> list = this.content();
        this.checkResult(list);
        return new DefaultRedisListIterator(list.iterator());
    }

    @Override
    public int size() {
        Long size = this.listOps.size();
        this.checkResult(size);
        return size.intValue();
    }

    @Override
    public boolean add(E value) {
        this.listOps.rightPush(value);
        this.cap();
        return true;
    }

    @Override
    public void clear() {
        this.listOps.trim(this.size() + 1, 0L);
    }

    @Override
    public boolean remove(Object o) {
        Long result = this.listOps.remove(1L, o);
        return result != null && result > 0L;
    }

    @Override
    public void add(int index, E element) {
        if (index == 0) {
            this.listOps.leftPush(element);
            this.cap();
            return;
        }
        int size = this.size();
        if (index == this.size()) {
            this.listOps.rightPush(element);
            this.cap();
            return;
        }
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        throw new IllegalArgumentException("Redis supports insertion only at the beginning or the end of the list");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (index == 0) {
            Collection<E> reverseC = CollectionUtils.reverse(c);
            for (E e : reverseC) {
                this.listOps.leftPush(e);
                this.cap();
            }
            return true;
        }
        int size = this.size();
        if (index == this.size()) {
            for (E e : c) {
                this.listOps.rightPush(e);
                this.cap();
            }
            return true;
        }
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        throw new IllegalArgumentException("Redis supports insertion only at the beginning or the end of the list");
    }

    @Override
    public E get(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.listOps.index(index);
    }

    @Override
    public int indexOf(Object o) {
        Long index = this.listOps.indexOf(o);
        return index != null ? index.intValue() : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        Long index = this.listOps.lastIndexOf(o);
        return index != null ? index.intValue() : -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E e) {
        E object = this.get(index);
        this.listOps.set(index, e);
        return object;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E element() {
        E value = this.peek();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public boolean offer(E e) {
        this.listOps.rightPush(e);
        this.cap();
        return true;
    }

    @Override
    @Nullable
    public E peek() {
        return this.listOps.index(0L);
    }

    @Override
    @Nullable
    public E poll() {
        return this.listOps.leftPop();
    }

    @Override
    public E remove() {
        E value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public void addFirst(E e) {
        this.listOps.leftPush(e);
        this.cap();
    }

    @Override
    public void addLast(E e) {
        this.add(e);
    }

    @Override
    public Iterator<E> descendingIterator() {
        List<E> content = this.content();
        Collections.reverse(content);
        return new DefaultRedisListIterator(content.iterator());
    }

    @Override
    public E getFirst() {
        return this.element();
    }

    @Override
    public E getLast() {
        E e = this.peekLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    @Nullable
    public E peekFirst() {
        return this.peek();
    }

    @Override
    @Nullable
    public E peekLast() {
        return this.listOps.index(-1L);
    }

    @Override
    @Nullable
    public E pollFirst() {
        return this.poll();
    }

    @Override
    @Nullable
    public E pollLast() {
        return this.listOps.rightPop();
    }

    @Override
    public E pop() {
        E e = this.poll();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E removeFirst() {
        return this.pop();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        Long result = this.listOps.remove(-1L, o);
        return result != null && result > 0L;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (this.equals(c)) {
            throw new IllegalArgumentException("Cannot drain a queue to itself");
        }
        int size = this.size();
        int loop = size >= maxElements ? maxElements : size;
        for (int index = 0; index < loop; ++index) {
            c.add(this.poll());
        }
        return loop;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, this.size());
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    @Nullable
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.listOps.leftPop(timeout, unit);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.offer(e);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Nullable
    public E take() throws InterruptedException {
        return this.poll(0L, TimeUnit.SECONDS);
    }

    @Override
    public boolean offerFirst(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerFirst(e);
    }

    @Override
    public boolean offerLast(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerLast(e);
    }

    @Override
    @Nullable
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        return this.poll(timeout, unit);
    }

    @Override
    @Nullable
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        return this.listOps.rightPop(timeout, unit);
    }

    @Override
    public void putFirst(E e) throws InterruptedException {
        this.add(e);
    }

    @Override
    public void putLast(E e) throws InterruptedException {
        this.put(e);
    }

    @Override
    @Nullable
    public E takeFirst() throws InterruptedException {
        return this.take();
    }

    @Override
    @Nullable
    public E takeLast() throws InterruptedException {
        return this.pollLast(0L, TimeUnit.SECONDS);
    }

    @Override
    public DataType getType() {
        return DataType.LIST;
    }

    private List<E> content() {
        return this.listOps.range(0L, -1L);
    }

    private void cap() {
        if (this.capped) {
            this.listOps.trim(0L, this.maxSize - 1);
        }
    }

    private class DefaultRedisListIterator
    extends RedisIterator<E> {
        public DefaultRedisListIterator(Iterator<E> delegate) {
            super(delegate);
        }

        @Override
        protected void removeFromRedisStorage(E item) {
            DefaultRedisList.this.remove(item);
        }
    }
}

