/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.util.ByteArraySet;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

class JedisClusterSetCommands
implements RedisSetCommands {
    private final JedisClusterConnection connection;

    JedisClusterSetCommands(JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        try {
            return this.connection.getCluster().sadd(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        try {
            return this.connection.getCluster().srem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().spop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sPop(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return new ArrayList<byte[]>(this.connection.getCluster().spop(key, count));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, destKey)) {
            try {
                return JedisConverters.toBoolean(this.connection.getCluster().smove(srcKey, destKey, value));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        if (this.connection.keyCommands().exists(srcKey).booleanValue() && this.sRem(srcKey, new byte[][]{value}) > 0L && !this.sIsMember(destKey, value).booleanValue()) {
            return JedisConverters.toBoolean(this.sAdd(destKey, new byte[][]{value}));
        }
        return Boolean.FALSE;
    }

    @Override
    public Long sCard(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().scard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return this.connection.getCluster().sismember(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().sinter(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        List resultList = this.connection.getClusterCommandExecutor().executeMultiKeyCommand((client, key) -> client.smembers(key), Arrays.asList(keys)).resultsAsList();
        ByteArraySet result = null;
        for (Set value : resultList) {
            ByteArraySet tmp = new ByteArraySet(value);
            if (result == null) {
                result = tmp;
                continue;
            }
            result.retainAll(tmp);
            if (!result.isEmpty()) continue;
            break;
        }
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result.asRawSet();
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)keys, (String)"Source keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements!");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().sinterstore(destKey, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        Set<byte[]> result = this.sInter(keys);
        if (result.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])result.toArray((T[])new byte[result.size()][]));
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().sunion(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        List resultList = this.connection.getClusterCommandExecutor().executeMultiKeyCommand((client, key) -> client.smembers(key), Arrays.asList(keys)).resultsAsList();
        ByteArraySet result = new ByteArraySet();
        for (Set entry : resultList) {
            result.addAll(entry);
        }
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result.asRawSet();
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)keys, (String)"Source keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements!");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().sunionstore(destKey, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        Set<byte[]> result = this.sUnion(keys);
        if (result.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])result.toArray((T[])new byte[result.size()][]));
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().sdiff(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] source = keys[0];
        byte[][] others = (byte[][])Arrays.copyOfRange(keys, 1, keys.length);
        ByteArraySet values = new ByteArraySet(this.sMembers(source));
        List resultList = this.connection.getClusterCommandExecutor().executeMultiKeyCommand((client, key) -> client.smembers(key), Arrays.asList(others)).resultsAsList();
        if (values.isEmpty()) {
            return Collections.emptySet();
        }
        for (Set singleNodeValue : resultList) {
            values.removeAll(singleNodeValue);
        }
        return values.asRawSet();
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)keys, (String)"Source keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements!");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().sdiffstore(destKey, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        Set<byte[]> diff = this.sDiff(keys);
        if (diff.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])diff.toArray((T[])new byte[diff.size()][]));
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().smembers(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().srandmember(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.connection.getCluster().srandmember(key, Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<byte[]> sScan(final byte[] key, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new ScanCursor<byte[]>(options){

            @Override
            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisClusterSetCommands.this.connection.getCluster().sscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<byte[]>(Long.valueOf(result.getCursor()), result.getResult());
            }
        }.open();
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

