/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;

class CachingExpressionParser
implements ExpressionParser {
    private final ExpressionParser delegate;
    private final Map<String, Expression> cache = new ConcurrentHashMap<String, Expression>();

    CachingExpressionParser(ExpressionParser delegate) {
        this.delegate = delegate;
    }

    public Expression parseExpression(String expressionString) throws ParseException {
        return this.cache.computeIfAbsent(expressionString, arg_0 -> ((ExpressionParser)this.delegate).parseExpression(arg_0));
    }

    public Expression parseExpression(String expressionString, ParserContext context) throws ParseException {
        throw new UnsupportedOperationException("Parsing using ParserContext is not supported");
    }
}

