/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

class R2dbcParameterAccessor
extends RelationalParametersParameterAccessor {
    private final Object[] values;
    private final List<MonoProcessor<?>> subscriptions;

    public R2dbcParameterAccessor(R2dbcQueryMethod method, Object ... values) {
        super((QueryMethod)method, values);
        this.values = values;
        this.subscriptions = new ArrayList(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value == null || !ReactiveWrappers.supports(value.getClass())) {
                this.subscriptions.add(null);
                continue;
            }
            if (ReactiveWrappers.isSingleValueType(value.getClass())) {
                this.subscriptions.add(((Mono)ReactiveWrapperConverters.toWrapper((Object)value, Mono.class)).toProcessor());
                continue;
            }
            this.subscriptions.add(((Flux)ReactiveWrapperConverters.toWrapper((Object)value, Flux.class)).collectList().toProcessor());
        }
    }

    protected <T> T getValue(int index) {
        if (this.subscriptions.get(index) != null) {
            return (T)this.subscriptions.get(index).block();
        }
        return (T)super.getValue(index);
    }

    public Object[] getValues() {
        Object[] result = new Object[this.values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getValue(i);
        }
        return result;
    }

    public Object getBindableValue(int index) {
        return this.getValue(this.getParameters().getBindableParameter(index).getIndex());
    }
}

