/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Deprecated
public class Criteria
implements CriteriaDefinition {
    private static final Criteria EMPTY = new Criteria(SqlIdentifier.EMPTY, CriteriaDefinition.Comparator.INITIAL, null);
    @Nullable
    private final Criteria previous;
    private final CriteriaDefinition.Combinator combinator;
    private final List<CriteriaDefinition> group;
    @Nullable
    private final SqlIdentifier column;
    @Nullable
    private final CriteriaDefinition.Comparator comparator;
    @Nullable
    private final Object value;
    private final boolean ignoreCase;

    private Criteria(SqlIdentifier column, CriteriaDefinition.Comparator comparator, @Nullable Object value) {
        this(null, CriteriaDefinition.Combinator.INITIAL, Collections.emptyList(), column, comparator, value, false);
    }

    private Criteria(@Nullable Criteria previous, CriteriaDefinition.Combinator combinator, List<CriteriaDefinition> group, @Nullable SqlIdentifier column, @Nullable CriteriaDefinition.Comparator comparator, @Nullable Object value) {
        this(previous, combinator, group, column, comparator, value, false);
    }

    private Criteria(@Nullable Criteria previous, CriteriaDefinition.Combinator combinator, List<CriteriaDefinition> group, @Nullable SqlIdentifier column, @Nullable CriteriaDefinition.Comparator comparator, @Nullable Object value, boolean ignoreCase) {
        this.previous = previous;
        this.combinator = previous != null && previous.isEmpty() ? CriteriaDefinition.Combinator.INITIAL : combinator;
        this.group = group;
        this.column = column;
        this.comparator = comparator;
        this.value = value;
        this.ignoreCase = ignoreCase;
    }

    private Criteria(@Nullable Criteria previous, CriteriaDefinition.Combinator combinator, List<CriteriaDefinition> group) {
        this.previous = previous;
        this.combinator = previous != null && previous.isEmpty() ? CriteriaDefinition.Combinator.INITIAL : combinator;
        this.group = group;
        this.column = null;
        this.comparator = null;
        this.value = null;
        this.ignoreCase = false;
    }

    public static Criteria empty() {
        return EMPTY;
    }

    public static Criteria from(Criteria ... criteria) {
        Assert.notNull((Object)criteria, (String)"Criteria must not be null");
        Assert.noNullElements((Object[])criteria, (String)"Criteria must not contain null elements");
        return Criteria.from(Arrays.asList(criteria));
    }

    public static Criteria from(List<Criteria> criteria) {
        Assert.notNull(criteria, (String)"Criteria must not be null");
        Assert.noNullElements(criteria, (String)"Criteria must not contain null elements");
        if (criteria.isEmpty()) {
            return EMPTY;
        }
        if (criteria.size() == 1) {
            return criteria.get(0);
        }
        return EMPTY.and(criteria);
    }

    public static CriteriaStep where(String column) {
        Assert.hasText((String)column, (String)"Column name must not be null or empty!");
        return new DefaultCriteriaStep(SqlIdentifier.unquoted((String)column));
    }

    public CriteriaStep and(String column) {
        Assert.hasText((String)column, (String)"Column name must not be null or empty!");
        final SqlIdentifier identifier = SqlIdentifier.unquoted((String)column);
        return new DefaultCriteriaStep(identifier){

            @Override
            protected Criteria createCriteria(CriteriaDefinition.Comparator comparator, Object value) {
                return new Criteria(Criteria.this, CriteriaDefinition.Combinator.AND, Collections.emptyList(), identifier, comparator, value);
            }
        };
    }

    public Criteria and(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"Criteria must not be null!");
        return this.and(Collections.singletonList(criteria));
    }

    public Criteria and(List<Criteria> criteria) {
        Assert.notNull(criteria, (String)"Criteria must not be null!");
        return new Criteria(this, CriteriaDefinition.Combinator.AND, criteria);
    }

    public CriteriaStep or(String column) {
        Assert.hasText((String)column, (String)"Column name must not be null or empty!");
        final SqlIdentifier identifier = SqlIdentifier.unquoted((String)column);
        return new DefaultCriteriaStep(identifier){

            @Override
            protected Criteria createCriteria(CriteriaDefinition.Comparator comparator, Object value) {
                return new Criteria(Criteria.this, CriteriaDefinition.Combinator.OR, Collections.emptyList(), identifier, comparator, value);
            }
        };
    }

    public Criteria or(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"Criteria must not be null!");
        return this.or(Collections.singletonList(criteria));
    }

    public Criteria or(List<Criteria> criteria) {
        Assert.notNull(criteria, (String)"Criteria must not be null!");
        return new Criteria(this, CriteriaDefinition.Combinator.OR, criteria);
    }

    public Criteria ignoreCase(boolean ignoreCase) {
        if (this.ignoreCase != ignoreCase) {
            return new Criteria(this.previous, this.combinator, this.group, this.column, this.comparator, this.value, ignoreCase);
        }
        return this;
    }

    @Nullable
    public Criteria getPrevious() {
        return this.previous;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public boolean isEmpty() {
        if (!this.doIsEmpty()) {
            return false;
        }
        Criteria parent = this.previous;
        while (parent != null) {
            if (!parent.doIsEmpty()) {
                return false;
            }
            parent = parent.previous;
        }
        return true;
    }

    private boolean doIsEmpty() {
        if (this.comparator == CriteriaDefinition.Comparator.INITIAL) {
            return true;
        }
        if (this.column != null) {
            return false;
        }
        for (CriteriaDefinition criteria : this.group) {
            if (criteria.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isGroup() {
        return !this.group.isEmpty();
    }

    public CriteriaDefinition.Combinator getCombinator() {
        return this.combinator;
    }

    public List<CriteriaDefinition> getGroup() {
        return this.group;
    }

    @Nullable
    public SqlIdentifier getColumn() {
        return this.column;
    }

    @Nullable
    public CriteriaDefinition.Comparator getComparator() {
        return this.comparator;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    static class DefaultCriteriaStep
    implements CriteriaStep {
        private final SqlIdentifier property;

        DefaultCriteriaStep(SqlIdentifier property) {
            this.property = property;
        }

        @Override
        public Criteria is(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(CriteriaDefinition.Comparator.EQ, value);
        }

        @Override
        public Criteria not(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(CriteriaDefinition.Comparator.NEQ, value);
        }

        @Override
        public Criteria in(Object ... values) {
            Assert.notNull((Object)values, (String)"Values must not be null!");
            Assert.noNullElements((Object[])values, (String)"Values must not contain a null value!");
            if (values.length > 1 && values[1] instanceof Collection) {
                throw new InvalidDataAccessApiUsageException("You can only pass in one argument of type " + values[1].getClass().getName());
            }
            return this.createCriteria(CriteriaDefinition.Comparator.IN, Arrays.asList(values));
        }

        @Override
        public Criteria in(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null!");
            Assert.noNullElements((Object[])values.toArray(), (String)"Values must not contain a null value!");
            return this.createCriteria(CriteriaDefinition.Comparator.IN, values);
        }

        @Override
        public Criteria notIn(Object ... values) {
            Assert.notNull((Object)values, (String)"Values must not be null!");
            Assert.noNullElements((Object[])values, (String)"Values must not contain a null value!");
            if (values.length > 1 && values[1] instanceof Collection) {
                throw new InvalidDataAccessApiUsageException("You can only pass in one argument of type " + values[1].getClass().getName());
            }
            return this.createCriteria(CriteriaDefinition.Comparator.NOT_IN, Arrays.asList(values));
        }

        @Override
        public Criteria notIn(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null!");
            Assert.noNullElements((Object[])values.toArray(), (String)"Values must not contain a null value!");
            return this.createCriteria(CriteriaDefinition.Comparator.NOT_IN, values);
        }

        @Override
        public Criteria lessThan(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(CriteriaDefinition.Comparator.LT, value);
        }

        @Override
        public Criteria lessThanOrEquals(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(CriteriaDefinition.Comparator.LTE, value);
        }

        @Override
        public Criteria greaterThan(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(CriteriaDefinition.Comparator.GT, value);
        }

        @Override
        public Criteria greaterThanOrEquals(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(CriteriaDefinition.Comparator.GTE, value);
        }

        @Override
        public Criteria like(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(CriteriaDefinition.Comparator.LIKE, value);
        }

        @Override
        public Criteria notLike(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(CriteriaDefinition.Comparator.NOT_LIKE, value);
        }

        @Override
        public Criteria isNull() {
            return this.createCriteria(CriteriaDefinition.Comparator.IS_NULL, null);
        }

        @Override
        public Criteria isNotNull() {
            return this.createCriteria(CriteriaDefinition.Comparator.IS_NOT_NULL, null);
        }

        @Override
        public Criteria isTrue() {
            return this.createCriteria(CriteriaDefinition.Comparator.IS_TRUE, null);
        }

        @Override
        public Criteria isFalse() {
            return this.createCriteria(CriteriaDefinition.Comparator.IS_FALSE, null);
        }

        protected Criteria createCriteria(CriteriaDefinition.Comparator comparator, Object value) {
            return new Criteria(this.property, comparator, value);
        }
    }

    public static interface CriteriaStep {
        public Criteria is(Object var1);

        public Criteria not(Object var1);

        public Criteria in(Object ... var1);

        public Criteria in(Collection<?> var1);

        public Criteria notIn(Object ... var1);

        public Criteria notIn(Collection<?> var1);

        public Criteria lessThan(Object var1);

        public Criteria lessThanOrEquals(Object var1);

        public Criteria greaterThan(Object var1);

        public Criteria greaterThanOrEquals(Object var1);

        public Criteria like(Object var1);

        public Criteria notLike(Object var1);

        public Criteria isNull();

        public Criteria isNotNull();

        public Criteria isTrue();

        public Criteria isFalse();
    }
}

