/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mongodb.core.AggregationUtil;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.aggregation.AggregationUpdate;
import org.springframework.data.mongodb.core.aggregation.FieldLookupPolicy;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.util.Assert;

abstract class BulkOperationsSupport {
    private final String collectionName;

    BulkOperationsSupport(String collectionName) {
        Assert.hasText((String)collectionName, (String)"CollectionName must not be null nor empty");
        this.collectionName = collectionName;
    }

    void maybeEmitBeforeSaveEvent(SourceAwareWriteModelHolder holder) {
        if (holder.model() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)holder.model()).getDocument();
            this.maybeEmitEvent(new BeforeSaveEvent<Object>(holder.source(), target, this.collectionName));
        } else if (holder.model() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)holder.model()).getReplacement();
            this.maybeEmitEvent(new BeforeSaveEvent<Object>(holder.source(), target, this.collectionName));
        }
    }

    void maybeEmitAfterSaveEvent(SourceAwareWriteModelHolder holder) {
        if (holder.model() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)holder.model()).getDocument();
            this.maybeEmitEvent(new AfterSaveEvent<Object>(holder.source(), target, this.collectionName));
        } else if (holder.model() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)holder.model()).getReplacement();
            this.maybeEmitEvent(new AfterSaveEvent<Object>(holder.source(), target, this.collectionName));
        }
    }

    WriteModel<Document> mapWriteModel(Object source, WriteModel<Document> writeModel) {
        if (writeModel instanceof UpdateOneModel) {
            UpdateOneModel model = (UpdateOneModel)writeModel;
            Bson sort = model.getOptions().getSort();
            if (sort instanceof Document) {
                Document sortDocument = (Document)sort;
                model.getOptions().sort((Bson)this.updateMapper().getMappedSort(sortDocument, this.entity().orElse(null)));
            }
            if (source instanceof AggregationUpdate) {
                AggregationUpdate aggregationUpdate = (AggregationUpdate)source;
                List<Document> pipeline = this.mapUpdatePipeline(aggregationUpdate);
                return new UpdateOneModel(this.getMappedQuery(model.getFilter()), pipeline, model.getOptions());
            }
            return new UpdateOneModel(this.getMappedQuery(model.getFilter()), this.getMappedUpdate(model.getUpdate()), model.getOptions());
        }
        if (writeModel instanceof UpdateManyModel) {
            UpdateManyModel model = (UpdateManyModel)writeModel;
            if (source instanceof AggregationUpdate) {
                AggregationUpdate aggregationUpdate = (AggregationUpdate)source;
                List<Document> pipeline = this.mapUpdatePipeline(aggregationUpdate);
                return new UpdateManyModel(this.getMappedQuery(model.getFilter()), pipeline, model.getOptions());
            }
            return new UpdateManyModel(this.getMappedQuery(model.getFilter()), this.getMappedUpdate(model.getUpdate()), model.getOptions());
        }
        if (writeModel instanceof DeleteOneModel) {
            DeleteOneModel model = (DeleteOneModel)writeModel;
            return new DeleteOneModel(this.getMappedQuery(model.getFilter()), model.getOptions());
        }
        if (writeModel instanceof DeleteManyModel) {
            DeleteManyModel model = (DeleteManyModel)writeModel;
            return new DeleteManyModel(this.getMappedQuery(model.getFilter()), model.getOptions());
        }
        if (writeModel instanceof ReplaceOneModel) {
            ReplaceOneModel model = (ReplaceOneModel)writeModel;
            Bson sort = model.getReplaceOptions().getSort();
            if (sort instanceof Document) {
                Document sortDocument = (Document)sort;
                model.getReplaceOptions().sort((Bson)this.updateMapper().getMappedSort(sortDocument, this.entity().orElse(null)));
            }
            return new ReplaceOneModel(this.getMappedQuery(model.getFilter()), (Object)((Document)model.getReplacement()), model.getReplaceOptions());
        }
        return writeModel;
    }

    private List<Document> mapUpdatePipeline(AggregationUpdate source) {
        Class type = this.entity().isPresent() ? this.entity().map(PersistentEntity::getType).get() : Object.class;
        TypeBasedAggregationOperationContext context = new TypeBasedAggregationOperationContext(type, this.updateMapper().getMappingContext(), this.queryMapper(), FieldLookupPolicy.relaxed());
        return new AggregationUtil(this.queryMapper(), this.queryMapper().getMappingContext()).createPipeline(source, context);
    }

    protected abstract void maybeEmitEvent(ApplicationEvent var1);

    protected abstract UpdateMapper updateMapper();

    protected abstract QueryMapper queryMapper();

    protected abstract Optional<? extends MongoPersistentEntity<?>> entity();

    protected Bson getMappedUpdate(Bson update) {
        return ((QueryMapper)this.updateMapper()).getMappedObject(update, this.entity());
    }

    protected Bson getMappedQuery(Bson query) {
        return this.queryMapper().getMappedObject(query, this.entity());
    }

    protected static BulkWriteOptions getBulkWriteOptions(BulkOperations.BulkMode bulkMode) {
        BulkWriteOptions options = new BulkWriteOptions();
        return switch (bulkMode) {
            default -> throw new IncompatibleClassChangeError();
            case BulkOperations.BulkMode.ORDERED -> options.ordered(true);
            case BulkOperations.BulkMode.UNORDERED -> options.ordered(false);
        };
    }

    protected UpdateOptions computeUpdateOptions(Query filterQuery, UpdateDefinition update, boolean upsert, boolean multi) {
        UpdateOptions options = new UpdateOptions();
        options.upsert(upsert);
        if (update.hasArrayFilters()) {
            ArrayList<Document> list = new ArrayList<Document>(update.getArrayFilters().size());
            for (UpdateDefinition.ArrayFilter arrayFilter : update.getArrayFilters()) {
                list.add(arrayFilter.asDocument());
            }
            options.arrayFilters(list);
        }
        if (!multi && filterQuery.isSorted()) {
            options.sort((Bson)filterQuery.getSortObject());
        }
        filterQuery.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((UpdateOptions)options).collation(arg_0));
        return options;
    }

    record SourceAwareWriteModelHolder(Object source, WriteModel<Document> model) {
    }
}

