/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.json;

import java.util.Collections;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.util.json.ValueProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class EvaluationContextExpressionEvaluator
implements ValueExpressionEvaluator {
    final ValueProvider valueProvider;
    final ExpressionParser expressionParser;

    EvaluationContextExpressionEvaluator(ValueProvider valueProvider, ExpressionParser expressionParser) {
        this.valueProvider = valueProvider;
        this.expressionParser = expressionParser;
    }

    public <T> @Nullable T evaluate(String expression) {
        return this.evaluateExpression(expression, Collections.emptyMap());
    }

    EvaluationContext getEvaluationContext(String expressionString) {
        return new StandardEvaluationContext();
    }

    Expression getParsedExpression(String expressionString) {
        return this.expressionParser.parseExpression(expressionString);
    }

    <T> @Nullable T evaluateExpression(String expressionString, Map<String, Object> variables) {
        Expression expression = this.getParsedExpression(expressionString);
        EvaluationContext ctx = this.getEvaluationContext(expressionString);
        variables.forEach((arg_0, arg_1) -> ((EvaluationContext)ctx).setVariable(arg_0, arg_1));
        Object result = expression.getValue(ctx, Object.class);
        return (T)result;
    }
}

