/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import com.mongodb.ConnectionString;
import com.mongodb.RequestContext;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.micrometer.observation.transport.Kind;
import io.micrometer.observation.transport.SenderContext;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.jspecify.annotations.Nullable;

public class MongoHandlerContext
extends SenderContext<Object> {
    private static final Set<String> COMMANDS_WITH_COLLECTION_NAME = new LinkedHashSet<String>(Arrays.asList("aggregate", "count", "distinct", "mapReduce", "geoSearch", "delete", "find", "findAndModify", "insert", "update", "collMod", "compact", "convertToCapped", "create", "createIndexes", "drop", "dropIndexes", "killCursors", "listIndexes", "reIndex"));
    private final @Nullable ConnectionString connectionString;
    private final @Nullable CommandStartedEvent commandStartedEvent;
    private final @Nullable RequestContext requestContext;
    private final @Nullable String collectionName;
    private @Nullable CommandSucceededEvent commandSucceededEvent;
    private @Nullable CommandFailedEvent commandFailedEvent;

    public MongoHandlerContext(@Nullable ConnectionString connectionString, CommandStartedEvent commandStartedEvent, RequestContext requestContext) {
        super((carrier, key, value) -> {}, Kind.CLIENT);
        this.connectionString = connectionString;
        this.commandStartedEvent = commandStartedEvent;
        this.requestContext = requestContext;
        this.collectionName = MongoHandlerContext.getCollectionName(commandStartedEvent);
    }

    public @Nullable CommandStartedEvent getCommandStartedEvent() {
        return this.commandStartedEvent;
    }

    public @Nullable RequestContext getRequestContext() {
        return this.requestContext;
    }

    public String getDatabaseName() {
        return this.commandStartedEvent != null ? this.commandStartedEvent.getDatabaseName() : "n/a";
    }

    public @Nullable String getCollectionName() {
        return this.collectionName;
    }

    public String getCommandName() {
        return this.commandStartedEvent != null ? this.commandStartedEvent.getCommandName() : "n/a";
    }

    public @Nullable ConnectionString getConnectionString() {
        return this.connectionString;
    }

    void setCommandSucceededEvent(CommandSucceededEvent commandSucceededEvent) {
        this.commandSucceededEvent = commandSucceededEvent;
    }

    void setCommandFailedEvent(CommandFailedEvent commandFailedEvent) {
        this.commandFailedEvent = commandFailedEvent;
    }

    private static @Nullable String getCollectionName(CommandStartedEvent event) {
        String collectionName;
        String commandName = event.getCommandName();
        BsonDocument command = event.getCommand();
        if (COMMANDS_WITH_COLLECTION_NAME.contains(commandName) && (collectionName = MongoHandlerContext.getNonEmptyBsonString(command.get((Object)commandName))) != null) {
            return collectionName;
        }
        return command == null ? "" : MongoHandlerContext.getNonEmptyBsonString(command.get((Object)"collection"));
    }

    private static @Nullable String getNonEmptyBsonString(@Nullable BsonValue bsonValue) {
        if (bsonValue == null || !bsonValue.isString()) {
            return null;
        }
        String stringValue = bsonValue.asString().getValue().trim();
        return stringValue.isEmpty() ? null : stringValue;
    }
}

