/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import java.util.Arrays;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.geo.CustomMetric;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.ReadConcernAware;
import org.springframework.data.mongodb.core.ReadPreferenceAware;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.MetricConversion;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class NearQuery
implements ReadConcernAware,
ReadPreferenceAware {
    private final Point point;
    private @Nullable Query query;
    private @Nullable Distance maxDistance;
    private @Nullable Distance minDistance;
    private Metric metric;
    private boolean spherical;
    private @Nullable Long limit;
    private @Nullable Long skip;
    private @Nullable ReadConcern readConcern;
    private @Nullable ReadPreference readPreference;

    private NearQuery(Point point, Metric metric) {
        Assert.notNull((Object)point, (String)"Point must not be null");
        Assert.notNull((Object)metric, (String)"Metric must not be null");
        this.point = point;
        this.spherical = false;
        this.metric = metric;
    }

    public static NearQuery near(double x, double y) {
        return NearQuery.near(x, y, (Metric)Metrics.NEUTRAL);
    }

    public static NearQuery near(double x, double y, Metric metric) {
        return NearQuery.near(new Point(x, y), metric);
    }

    public static NearQuery near(Point point) {
        return NearQuery.near(point, (Metric)Metrics.NEUTRAL);
    }

    public static NearQuery near(Point point, Metric metric) {
        return new NearQuery(point, metric);
    }

    public Metric getMetric() {
        return this.metric;
    }

    @Contract(value="_ -> this")
    public NearQuery limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Contract(value="_ -> this")
    public NearQuery skip(long skip) {
        this.skip = skip;
        return this;
    }

    @Contract(value="_ -> this")
    public NearQuery with(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be 'null'");
        if (pageable.isPaged()) {
            this.skip = pageable.getOffset();
            this.limit = pageable.getPageSize();
        }
        return this;
    }

    @Contract(value="_ -> this")
    public NearQuery maxDistance(double maxDistance) {
        return this.maxDistance(Distance.of((double)maxDistance, (Metric)this.getMetric()));
    }

    @Contract(value="_, _ -> this")
    public NearQuery maxDistance(double maxDistance, Metric metric) {
        Assert.notNull((Object)metric, (String)"Metric must not be null");
        return this.maxDistance(Distance.of((double)maxDistance, (Metric)metric));
    }

    @Contract(value="_ -> this")
    public NearQuery maxDistance(Distance distance) {
        Assert.notNull((Object)distance, (String)"Distance must not be null");
        if (distance.getMetric() != Metrics.NEUTRAL) {
            this.spherical(true);
        }
        if (ObjectUtils.nullSafeEquals((Object)Metrics.NEUTRAL, (Object)this.metric)) {
            this.in(distance.getMetric());
        }
        this.maxDistance = distance;
        return this;
    }

    @Contract(value="_ -> this")
    public NearQuery minDistance(double minDistance) {
        return this.minDistance(Distance.of((double)minDistance, (Metric)this.getMetric()));
    }

    @Contract(value="_, _ -> this")
    public NearQuery minDistance(double minDistance, Metric metric) {
        Assert.notNull((Object)metric, (String)"Metric must not be null");
        return this.minDistance(Distance.of((double)minDistance, (Metric)metric));
    }

    @Contract(value="_ -> this")
    public NearQuery minDistance(Distance distance) {
        Assert.notNull((Object)distance, (String)"Distance must not be null");
        if (distance.getMetric() != Metrics.NEUTRAL) {
            this.spherical(true);
        }
        if (this.metric == null) {
            this.in(distance.getMetric());
        }
        this.minDistance = distance;
        return this;
    }

    public @Nullable Distance getMaxDistance() {
        return this.maxDistance;
    }

    public @Nullable Distance getMinDistance() {
        return this.minDistance;
    }

    @Contract(value="_ -> this")
    public NearQuery distanceMultiplier(double distanceMultiplier) {
        this.metric = new CustomMetric(distanceMultiplier);
        return this;
    }

    @Contract(value="_ -> this")
    public NearQuery spherical(boolean spherical) {
        this.spherical = spherical;
        return this;
    }

    public boolean isSpherical() {
        return this.spherical;
    }

    @Contract(value="-> this")
    public NearQuery inKilometers() {
        return this.adaptMetric((Metric)Metrics.KILOMETERS);
    }

    @Contract(value="-> this")
    public NearQuery inMiles() {
        return this.adaptMetric((Metric)Metrics.MILES);
    }

    @Contract(value="_ -> this")
    public NearQuery in(@Nullable Metric metric) {
        return this.adaptMetric((Metric)(metric == null ? Metrics.NEUTRAL : metric));
    }

    @Contract(value="_ -> this")
    private NearQuery adaptMetric(Metric metric) {
        if (metric != Metrics.NEUTRAL) {
            this.spherical(true);
        }
        this.metric = metric;
        return this;
    }

    @Contract(value="_ -> this")
    public NearQuery query(Query query) {
        Assert.notNull((Object)query, (String)"Cannot apply 'null' query on NearQuery");
        this.query = query;
        this.skip = query.getSkip();
        if (query.getLimit() != 0) {
            this.limit = query.getLimit();
        }
        return this;
    }

    public @Nullable Long getSkip() {
        return this.skip;
    }

    public @Nullable Collation getCollation() {
        return this.query != null ? (Collation)this.query.getCollation().orElse(null) : null;
    }

    @Contract(value="_ -> this")
    public NearQuery withReadConcern(ReadConcern readConcern) {
        Assert.notNull((Object)readConcern, (String)"ReadConcern must not be null");
        this.readConcern = readConcern;
        return this;
    }

    @Contract(value="_ -> this")
    public NearQuery withReadPreference(ReadPreference readPreference) {
        Assert.notNull((Object)readPreference, (String)"ReadPreference must not be null");
        this.readPreference = readPreference;
        return this;
    }

    @Override
    public @Nullable ReadConcern getReadConcern() {
        if (this.query != null && this.query.hasReadConcern()) {
            return this.query.getReadConcern();
        }
        return this.readConcern;
    }

    @Override
    public @Nullable ReadPreference getReadPreference() {
        if (this.query != null && this.query.hasReadPreference()) {
            return this.query.getReadPreference();
        }
        return this.readPreference;
    }

    public Document toDocument() {
        Document document = new Document();
        if (this.query != null) {
            document.put("query", (Object)this.query.getQueryObject());
            this.query.getCollation().ifPresent(collation -> document.append("collation", (Object)collation.toDocument()));
        }
        if (this.maxDistance != null) {
            document.put("maxDistance", (Object)this.getDistanceValueInRadiantsOrMeters(this.maxDistance));
        }
        if (this.minDistance != null) {
            document.put("minDistance", (Object)this.getDistanceValueInRadiantsOrMeters(this.minDistance));
        }
        if (this.metric != null) {
            document.put("distanceMultiplier", (Object)this.getDistanceMultiplier());
        }
        if (this.limit != null && this.limit > 0L) {
            document.put("num", (Object)this.limit);
        }
        if (this.usesGeoJson()) {
            document.put("near", (Object)this.point);
        } else {
            document.put("near", Arrays.asList(this.point.getX(), this.point.getY()));
        }
        document.put("spherical", (Object)(this.spherical ? this.spherical : this.usesGeoJson()));
        return document;
    }

    private double getDistanceMultiplier() {
        return this.usesMetricSystem() ? MetricConversion.getMetersToMetricMultiplier(this.metric) : this.metric.getMultiplier();
    }

    private double getDistanceValueInRadiantsOrMeters(Distance distance) {
        return this.usesMetricSystem() ? MetricConversion.getDistanceInMeters(distance) : distance.getNormalizedValue();
    }

    private boolean usesMetricSystem() {
        return this.usesGeoJson();
    }

    private boolean usesGeoJson() {
        return this.point instanceof GeoJsonPoint;
    }
}

