/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.types.ObjectId;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.annotation.Reference;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.PropertyValueConversions;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.CachingValueExpressionEvaluatorFactory;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mapping.model.ValueExpressionParameterValueProvider;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.AbstractMongoConverter;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultDbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.DocumentAccessor;
import org.springframework.data.mongodb.core.convert.DocumentPointerFactory;
import org.springframework.data.mongodb.core.convert.DocumentPropertyAccessor;
import org.springframework.data.mongodb.core.convert.DocumentReferenceSource;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.convert.MongoConversionContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.ReferenceLookupDelegate;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.DocumentPointer;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.PersistentPropertyTranslator;
import org.springframework.data.mongodb.core.mapping.Unwrapped;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.util.Predicates;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware,
EnvironmentCapable {
    private static final String INCOMPATIBLE_TYPES = "Cannot convert %1$s of type %2$s into an instance of %3$s; Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions; Parent object was: %4$s";
    private static final String INVALID_TYPE_TO_READ = "Expected to read Document %s into type %s but didn't find a PersistentEntity for the latter";
    private static final BiPredicate<MongoPersistentEntity<?>, MongoPersistentProperty> PROPERTY_FILTER = (e, property) -> {
        if (e.isIdProperty(property)) {
            return false;
        }
        if (e.isCreatorArgument(property)) {
            return false;
        }
        return property.isReadable();
    };
    public static final TypeInformation<Bson> BSON = TypeInformation.of(Bson.class);
    protected static final Log LOGGER = LogFactory.getLog(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final QueryMapper idMapper;
    protected final DbRefResolver dbRefResolver;
    protected final DefaultDbRefProxyHandler dbRefProxyHandler;
    protected final ReferenceLookupDelegate referenceLookupDelegate;
    protected @Nullable ApplicationContext applicationContext;
    protected @Nullable Environment environment;
    protected @Nullable MongoTypeMapper typeMapper;
    protected @Nullable String mapKeyDotReplacement = null;
    protected @Nullable CodecRegistryProvider codecRegistryProvider;
    private MongoTypeMapper defaultTypeMapper;
    private SpELContext spELContext;
    private @Nullable EntityCallbacks entityCallbacks;
    private final SpelExpressionParser expressionParser = new SpelExpressionParser();
    private final DocumentPointerFactory documentPointerFactory;
    private final SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory((ExpressionParser)this.expressionParser);
    private final CachingValueExpressionEvaluatorFactory expressionEvaluatorFactory = new CachingValueExpressionEvaluatorFactory((ExpressionParser)this.expressionParser, (EnvironmentCapable)this, o -> this.spELContext.getEvaluationContext(o));

    public MappingMongoConverter(DbRefResolver dbRefResolver, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super((GenericConversionService)new DefaultConversionService());
        Assert.notNull((Object)dbRefResolver, (String)"DbRefResolver must not be null");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        this.dbRefResolver = dbRefResolver;
        this.mappingContext = mappingContext;
        this.defaultTypeMapper = new DefaultMongoTypeMapper("_class", mappingContext, this::getWriteTarget);
        this.idMapper = new QueryMapper(this);
        this.spELContext = new SpELContext((PropertyAccessor)DocumentPropertyAccessor.INSTANCE);
        this.dbRefProxyHandler = new DefaultDbRefProxyHandler(mappingContext, (prop, bson, evaluator, path) -> {
            ConversionContext context = this.getConversionContext(path);
            return this.getValueInternal(context, prop, bson, evaluator);
        }, arg_0 -> ((CachingValueExpressionEvaluatorFactory)this.expressionEvaluatorFactory).create(arg_0));
        this.referenceLookupDelegate = new ReferenceLookupDelegate(mappingContext, this.spELContext);
        this.documentPointerFactory = new DocumentPointerFactory((ConversionService)this.conversionService, mappingContext);
    }

    protected ConversionContext getConversionContext(ObjectPath path) {
        Assert.notNull((Object)path, (String)"ObjectPath must not be null");
        return new DefaultConversionContext(this, this.conversions, path, this::readDocument, this::readCollectionOrArray, this::readMap, this::readDBRef, this::getPotentiallyConvertedSimpleRead);
    }

    @Deprecated
    public MappingMongoConverter(MongoDatabaseFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this(new DefaultDbRefResolver(mongoDbFactory), mappingContext);
        this.setCodecRegistryProvider(mongoDbFactory);
    }

    public void setTypeMapper(@Nullable MongoTypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    @Override
    public MongoTypeMapper getTypeMapper() {
        return this.typeMapper == null ? this.defaultTypeMapper : this.typeMapper;
    }

    @Override
    public ProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    @Override
    public CustomConversions getCustomConversions() {
        return this.conversions;
    }

    public void setMapKeyDotReplacement(@Nullable String mapKeyDotReplacement) {
        this.mapKeyDotReplacement = mapKeyDotReplacement;
    }

    public void preserveMapKeys(boolean preserve) {
        this.setMapKeyDotReplacement(preserve ? "." : null);
    }

    public void setCodecRegistryProvider(@Nullable CodecRegistryProvider codecRegistryProvider) {
        this.codecRegistryProvider = codecRegistryProvider;
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.environment = applicationContext.getEnvironment();
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
        this.projectionFactory.setBeanFactory((BeanFactory)applicationContext);
        if (applicationContext.getClassLoader() != null) {
            this.projectionFactory.setBeanClassLoader(applicationContext.getClassLoader());
        }
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
        ClassLoader classLoader = applicationContext.getClassLoader();
        MongoTypeMapper mongoTypeMapper = this.defaultTypeMapper;
        if (mongoTypeMapper instanceof BeanClassLoaderAware) {
            BeanClassLoaderAware beanClassLoaderAware = (BeanClassLoaderAware)mongoTypeMapper;
            if (classLoader != null) {
                beanClassLoaderAware.setBeanClassLoader(classLoader);
            }
        }
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new StandardEnvironment();
        }
        return this.environment;
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null");
        this.entityCallbacks = entityCallbacks;
    }

    @Override
    public <R> R project(EntityProjection<R, ?> projection, Bson bson) {
        if (!projection.isProjection()) {
            TypeInformation typeToRead = projection.getMappedType().getType().isInterface() ? projection.getDomainType() : projection.getMappedType();
            return (R)this.read(typeToRead, bson);
        }
        ProjectingConversionContext context = new ProjectingConversionContext(this, this.conversions, ObjectPath.ROOT, this::readCollectionOrArray, this::readMap, this::readDBRef, this::getPotentiallyConvertedSimpleRead, projection);
        return this.doReadProjection(context, bson, projection);
    }

    private <R> R doReadProjection(ConversionContext context, Bson bson, EntityProjection<R, ?> projection) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(projection.getActualDomainType());
        TypeInformation mappedType = projection.getActualMappedType();
        MongoPersistentEntity mappedEntity = (MongoPersistentEntity)this.getMappingContext().getPersistentEntity(mappedType);
        ValueExpressionEvaluator evaluator = this.expressionEvaluatorFactory.create((Object)bson);
        boolean isInterfaceProjection = mappedType.getType().isInterface();
        if (isInterfaceProjection) {
            PersistentPropertyTranslator propertyTranslator = PersistentPropertyTranslator.create(mappedEntity);
            DocumentAccessor documentAccessor = new DocumentAccessor(bson);
            MapPersistentPropertyAccessor accessor = new MapPersistentPropertyAccessor();
            PersistentPropertyAccessor convertingAccessor = PropertyTranslatingPropertyAccessor.create(new ConvertingPropertyAccessor((PersistentPropertyAccessor)accessor, (ConversionService)this.conversionService), propertyTranslator);
            MongoDbPropertyValueProvider valueProvider = new MongoDbPropertyValueProvider(context, documentAccessor, evaluator, this.spELContext);
            this.readProperties(context, entity, convertingAccessor, documentAccessor, valueProvider, evaluator, (mongoPersistentProperties, mongoPersistentProperty) -> true);
            return (R)this.projectionFactory.createProjection(mappedType.getType(), accessor.getBean());
        }
        if (mappedEntity == null) {
            throw new MappingException(String.format("No mapping metadata found for %s", mappedType.getType().getName()));
        }
        final PersistentPropertyTranslator propertyTranslator = PersistentPropertyTranslator.create(entity, Predicates.negate(MongoPersistentProperty::hasExplicitFieldName));
        DocumentAccessor documentAccessor = new DocumentAccessor(this, bson){
            final /* synthetic */ MappingMongoConverter this$0;
            {
                this.this$0 = this$0;
                super(document);
            }

            @Override
            FieldName getFieldName(MongoPersistentProperty prop) {
                return propertyTranslator.translate(prop).getMongoField().getName();
            }
        };
        InstanceCreatorMetadata instanceCreatorMetadata = mappedEntity.getInstanceCreatorMetadata();
        ParameterValueProvider<MongoPersistentProperty> provider = instanceCreatorMetadata != null && instanceCreatorMetadata.hasParameters() ? this.getParameterProvider(context, mappedEntity, documentAccessor, evaluator) : NoOpParameterValueProvider.INSTANCE;
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor((PersistentEntity)mappedEntity);
        Object instance = instantiator.createInstance((PersistentEntity)mappedEntity, provider);
        PersistentPropertyAccessor accessor = mappedEntity.getPropertyAccessor(instance);
        this.populateProperties(context, mappedEntity, documentAccessor, evaluator, instance);
        return (R)accessor.getBean();
    }

    private Object doReadOrProject(ConversionContext context, @Nullable Bson source, TypeInformation<?> typeHint, EntityProjection<?, ?> typeDescriptor) {
        if (typeDescriptor.isProjection()) {
            return this.doReadProjection(context, (Bson)BsonUtils.asDocument(source), typeDescriptor);
        }
        return this.readDocument(context, source, typeHint);
    }

    public <S> S read(Class<S> clazz, Bson bson) {
        return this.read(TypeInformation.of(clazz), bson);
    }

    protected <S> S read(TypeInformation<S> type, Bson bson) {
        return this.readDocument(this.getConversionContext(ObjectPath.ROOT), bson, type);
    }

    protected <S> S readDocument(ConversionContext context, @Nullable Bson bson, TypeInformation<? extends S> typeHint) {
        Document document;
        if (bson == null) {
            bson = new Document();
        }
        if (bson instanceof BasicDBObject) {
            BasicDBObject dbObject = (BasicDBObject)bson;
            document = new Document((Map)dbObject);
        } else {
            document = (Document)bson;
        }
        Document document2 = document;
        TypeInformation typeToRead = this.getTypeMapper().readType(document2, typeHint);
        Class rawType = typeToRead.getType();
        if (this.conversions.hasCustomReadTarget(bson.getClass(), rawType)) {
            return (S)this.doConvert(bson, rawType, typeHint.getType());
        }
        if (Document.class.isAssignableFrom(rawType)) {
            return (S)bson;
        }
        if (DBObject.class.isAssignableFrom(rawType)) {
            if (bson instanceof DBObject) {
                return (S)bson;
            }
            if (bson instanceof Document) {
                Document doc = (Document)bson;
                return (S)new BasicDBObject((Map)doc);
            }
            return (S)bson;
        }
        if (typeToRead.isMap()) {
            return context.convert(bson, typeToRead);
        }
        if (BSON.isAssignableFrom(typeHint)) {
            return (S)bson;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeToRead);
        if (entity == null) {
            Optional codec;
            if (this.codecRegistryProvider != null && (codec = this.codecRegistryProvider.getCodecFor(rawType)).isPresent()) {
                return (S)codec.get().decode((BsonReader)new JsonReader(document2.toJson()), DecoderContext.builder().build());
            }
            throw new MappingException(String.format(INVALID_TYPE_TO_READ, document2, rawType));
        }
        return this.read(context, entity, document2);
    }

    private ParameterValueProvider<MongoPersistentProperty> getParameterProvider(ConversionContext context, MongoPersistentEntity<?> entity, DocumentAccessor source, ValueExpressionEvaluator evaluator) {
        AssociationAwareMongoDbPropertyValueProvider provider = new AssociationAwareMongoDbPropertyValueProvider(context, source, evaluator);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, context.getPath().getCurrentObject());
        return new ConverterAwareValueExpressionParameterValueProvider(context, evaluator, (ConversionService)this.conversionService, (ParameterValueProvider<MongoPersistentProperty>)parameterProvider);
    }

    private <S> S read(ConversionContext context, MongoPersistentEntity<S> entity, Document bson) {
        S existing = context.findContextualEntity(entity, bson);
        if (existing != null) {
            return existing;
        }
        EvaluatingDocumentAccessor documentAccessor = new EvaluatingDocumentAccessor((Bson)bson);
        InstanceCreatorMetadata instanceCreatorMetadata = entity.getInstanceCreatorMetadata();
        ParameterValueProvider<MongoPersistentProperty> provider = instanceCreatorMetadata != null && instanceCreatorMetadata.hasParameters() ? this.getParameterProvider(context, entity, documentAccessor, documentAccessor) : NoOpParameterValueProvider.INSTANCE;
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, provider);
        return (S)this.populateProperties(context, entity, documentAccessor, documentAccessor, instance);
    }

    private <S> S populateProperties(ConversionContext context, MongoPersistentEntity<S> entity, DocumentAccessor documentAccessor, ValueExpressionEvaluator evaluator, S instance) {
        if (!entity.requiresPropertyPopulation()) {
            return instance;
        }
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
        Object rawId = this.readAndPopulateIdentifier(context, (PersistentPropertyAccessor<?>)accessor, documentAccessor, entity, evaluator);
        ObjectPath currentPath = context.getPath().push(accessor.getBean(), entity, rawId);
        ConversionContext contextToUse = context.withPath(currentPath);
        MongoDbPropertyValueProvider valueProvider = new MongoDbPropertyValueProvider(contextToUse, documentAccessor, evaluator, this.spELContext);
        this.readProperties(contextToUse, entity, (PersistentPropertyAccessor<?>)accessor, documentAccessor, valueProvider, evaluator, PROPERTY_FILTER);
        return (S)accessor.getBean();
    }

    private @Nullable Object readAndPopulateIdentifier(ConversionContext context, PersistentPropertyAccessor<?> accessor, DocumentAccessor document, MongoPersistentEntity<?> entity, ValueExpressionEvaluator evaluator) {
        Object rawId = document.getRawId(entity);
        if (!entity.hasIdProperty() || rawId == null) {
            return rawId;
        }
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getRequiredIdProperty();
        if (idProperty.isImmutable() && entity.isCreatorArgument(idProperty)) {
            return rawId;
        }
        accessor.setProperty((PersistentProperty)idProperty, this.readIdValue(context, evaluator, idProperty, rawId));
        return rawId;
    }

    private @Nullable Object readIdValue(ConversionContext context, ValueExpressionEvaluator evaluator, MongoPersistentProperty idProperty, Object rawId) {
        String expression = idProperty.getSpelExpression();
        Object resolvedValue = expression != null ? evaluator.evaluate(expression) : rawId;
        return resolvedValue != null ? this.readValue(context.forProperty(idProperty), resolvedValue, idProperty.getTypeInformation()) : null;
    }

    private void readProperties(ConversionContext context, MongoPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, DocumentAccessor documentAccessor, MongoDbPropertyValueProvider valueProvider, ValueExpressionEvaluator evaluator, BiPredicate<MongoPersistentEntity<?>, MongoPersistentProperty> propertyFilter) {
        DbRefResolverCallback callback = null;
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty prop = (MongoPersistentProperty)iterator.next();
            if (!propertyFilter.test(entity, prop)) continue;
            ConversionContext propertyContext = context.forProperty(prop);
            if (prop.isAssociation()) {
                Object value;
                if (callback == null) {
                    callback = this.getDbRefResolverCallback(propertyContext, documentAccessor, evaluator);
                }
                if ((value = this.readAssociation((Association<MongoPersistentProperty>)prop.getRequiredAssociation(), documentAccessor, this.dbRefProxyHandler, callback, propertyContext)) == null) continue;
                accessor.setProperty((PersistentProperty)prop, value);
                continue;
            }
            if (prop.isUnwrapped()) {
                accessor.setProperty((PersistentProperty)prop, this.readUnwrapped(propertyContext, documentAccessor, prop, (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)prop)));
                continue;
            }
            if (!documentAccessor.hasValue(prop)) continue;
            accessor.setProperty((PersistentProperty)prop, valueProvider.getPropertyValue(prop));
        }
    }

    private DbRefResolverCallback getDbRefResolverCallback(ConversionContext context, DocumentAccessor documentAccessor, ValueExpressionEvaluator evaluator) {
        return new DefaultDbRefResolverCallback(documentAccessor.getDocument(), context.getPath(), evaluator, (prop, bson, e, path) -> this.getValueInternal(context, prop, bson, e));
    }

    private @Nullable Object readAssociation(Association<MongoPersistentProperty> association, DocumentAccessor documentAccessor, DbRefProxyHandler handler, DbRefResolverCallback callback, ConversionContext context) {
        Collection collection;
        MongoPersistentProperty property = (MongoPersistentProperty)association.getInverse();
        Object value = documentAccessor.get(property);
        if (property.isDocumentReference() || !property.isDbReference() && property.findAnnotation(Reference.class) != null) {
            if (this.conversionService.canConvert(DocumentPointer.class, property.getActualType())) {
                if (value == null) {
                    return null;
                }
                DocumentPointer<Object> pointer = () -> value;
                return this.conversionService.convert(pointer, property.getActualType());
            }
            return this.dbRefResolver.resolveReference(property, new DocumentReferenceSource(documentAccessor.getDocument(), documentAccessor.get(property)), this.referenceLookupDelegate, context.forProperty(property)::convert);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof com.mongodb.DBRef) {
            com.mongodb.DBRef dbref = (com.mongodb.DBRef)value;
            return this.dbRefResolver.resolveDbRef(property, dbref, callback, handler);
        }
        if (value instanceof Document) {
            Document document = (Document)value;
            if (property.isMap()) {
                if (document.isEmpty() || MappingMongoConverter.peek(document.values()) instanceof com.mongodb.DBRef) {
                    return this.dbRefResolver.resolveDbRef(property, null, callback, handler);
                }
                return this.readMap(context, (Bson)document, property.getTypeInformation());
            }
            return this.read(property.getActualType(), (Bson)document);
        }
        if (value instanceof Collection && !(collection = (Collection)value).isEmpty() && MappingMongoConverter.peek(collection) instanceof Document) {
            return this.readCollectionOrArray(context, collection, property.getTypeInformation());
        }
        return this.dbRefResolver.resolveDbRef(property, null, callback, handler);
    }

    private @Nullable Object readUnwrapped(ConversionContext context, DocumentAccessor documentAccessor, MongoPersistentProperty prop, MongoPersistentEntity<?> unwrappedEntity) {
        if (((Unwrapped)prop.findAnnotation(Unwrapped.class)).onEmpty().equals((Object)Unwrapped.OnEmpty.USE_EMPTY)) {
            return this.read(context, unwrappedEntity, (Document)documentAccessor.getDocument());
        }
        Iterator iterator = unwrappedEntity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty persistentProperty = (MongoPersistentProperty)iterator.next();
            if (!documentAccessor.hasValue(persistentProperty)) continue;
            return this.read(context, unwrappedEntity, (Document)documentAccessor.getDocument());
        }
        return null;
    }

    @Override
    public com.mongodb.DBRef toDBRef(Object object, @Nullable MongoPersistentProperty referringProperty) {
        if (referringProperty != null) {
            DBRef annotation = referringProperty.getDBRef();
            Assert.notNull((Object)annotation, (String)"The referenced property has to be mapped with @DBRef");
        }
        if (object instanceof LazyLoadingProxy) {
            LazyLoadingProxy proxy = (LazyLoadingProxy)object;
            return proxy.toDBRef();
        }
        return this.createDBRef(object, referringProperty);
    }

    @Override
    public DocumentPointer toDocumentPointer(Object source, @Nullable MongoPersistentProperty referringProperty) {
        if (source instanceof LazyLoadingProxy) {
            LazyLoadingProxy proxy = (LazyLoadingProxy)source;
            return proxy::getSource;
        }
        Assert.notNull((Object)referringProperty, (String)"Cannot create DocumentReference; The referringProperty must not be null");
        if (referringProperty.isDbReference()) {
            return () -> this.toDBRef(source, referringProperty);
        }
        if (referringProperty.isDocumentReference() || referringProperty.findAnnotation(Reference.class) != null) {
            return this.createDocumentPointer(source, referringProperty);
        }
        throw new IllegalArgumentException("The referringProperty is neither a DBRef nor a document reference");
    }

    DocumentPointer<?> createDocumentPointer(Object source, @Nullable MongoPersistentProperty referringProperty) {
        if (referringProperty == null) {
            return () -> source;
        }
        if (source instanceof DocumentPointer) {
            DocumentPointer pointer = (DocumentPointer)source;
            return pointer;
        }
        if (ClassUtils.isAssignableValue((Class)referringProperty.getType(), (Object)source) && this.conversionService.canConvert(referringProperty.getType(), DocumentPointer.class)) {
            return (DocumentPointer)this.conversionService.convert(source, DocumentPointer.class);
        }
        if (ClassUtils.isAssignableValue((Class)referringProperty.getAssociationTargetType(), (Object)source)) {
            return this.documentPointerFactory.computePointer(this.mappingContext, referringProperty, source, referringProperty.getActualType());
        }
        return () -> source;
    }

    public void write(Object obj, Bson bson) {
        Object object;
        if (null == obj) {
            return;
        }
        Class entityType = ClassUtils.getUserClass(obj.getClass());
        TypeInformation type = TypeInformation.of((Class)entityType);
        if (obj instanceof LazyLoadingProxy) {
            LazyLoadingProxy proxy = (LazyLoadingProxy)obj;
            object = proxy.getTarget();
        } else {
            object = obj;
        }
        Object target = object;
        this.writeInternal(target, bson, type);
        BsonUtils.removeNullId(bson);
        if (this.requiresTypeHint(entityType)) {
            this.getTypeMapper().writeType(type, bson);
        }
    }

    private boolean requiresTypeHint(Class<?> type) {
        return !this.conversions.isSimpleType(type) && !ClassUtils.isAssignable(Collection.class, type) && !this.conversions.hasCustomWriteTarget(type, Document.class);
    }

    protected void writeInternal(@Nullable Object obj, Bson bson, @Nullable TypeInformation<?> typeHint) {
        if (null == obj) {
            return;
        }
        Class<?> entityType = obj.getClass();
        Optional customTarget = this.conversions.getCustomWriteTarget(entityType, Document.class);
        if (customTarget.isPresent()) {
            Document result = this.doConvert(obj, Document.class);
            BsonUtils.addAllToMap(bson, result);
            return;
        }
        if (Map.class.isAssignableFrom(entityType)) {
            this.writeMapInternal((Map)obj, bson, TypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(entityType)) {
            this.writeCollectionInternal((Collection)obj, TypeInformation.LIST, (Collection)bson);
            return;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType);
        this.writeInternal(obj, bson, entity);
        this.addCustomTypeKeyIfNecessary(typeHint, obj, bson);
    }

    protected void writeInternal(@Nullable Object obj, Bson bson, @Nullable MongoPersistentEntity<?> entity) {
        Object value;
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(obj);
        DocumentAccessor dbObjectAccessor = new DocumentAccessor(bson);
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (idProperty != null && !dbObjectAccessor.hasValue(idProperty) && (value = this.idMapper.convertId(accessor.getProperty((PersistentProperty)idProperty), idProperty.getFieldType())) != null) {
            dbObjectAccessor.put(idProperty, value);
        }
        this.writeProperties(bson, entity, accessor, dbObjectAccessor, idProperty);
    }

    private void writeProperties(Bson bson, MongoPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, DocumentAccessor dbObjectAccessor, @Nullable MongoPersistentProperty idProperty) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty prop = (MongoPersistentProperty)iterator.next();
            if (prop.equals(idProperty) || !prop.isWritable()) continue;
            if (prop.isAssociation()) {
                this.writeAssociation((Association<MongoPersistentProperty>)prop.getRequiredAssociation(), accessor, dbObjectAccessor);
                continue;
            }
            Object value = accessor.getProperty((PersistentProperty)prop);
            if (value == null) {
                if (this.conversions.hasValueConverter((PersistentProperty)prop)) {
                    dbObjectAccessor.put(prop, this.applyPropertyConversion(null, prop, accessor));
                    continue;
                }
                dbObjectAccessor.put(prop, null);
                continue;
            }
            if (!this.conversions.isSimpleType(value.getClass())) {
                this.writePropertyInternal(value, dbObjectAccessor, prop, accessor);
                continue;
            }
            this.writeSimpleInternal(value, bson, prop, accessor);
        }
    }

    private void writeAssociation(Association<MongoPersistentProperty> association, PersistentPropertyAccessor<?> accessor, DocumentAccessor dbObjectAccessor) {
        MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
        Object value = accessor.getProperty((PersistentProperty)inverseProp);
        if (value == null && !inverseProp.isUnwrapped() && inverseProp.writeNullValues()) {
            dbObjectAccessor.put(inverseProp, null);
            return;
        }
        this.writePropertyInternal(value, dbObjectAccessor, inverseProp, accessor);
    }

    void writePropertyInternal(@Nullable Object obj, DocumentAccessor accessor, MongoPersistentProperty prop, PersistentPropertyAccessor<?> persistentPropertyAccessor) {
        Document existingDocument;
        Optional basicTargetType;
        if (obj == null) {
            return;
        }
        TypeInformation valueType = TypeInformation.of(obj.getClass());
        TypeInformation type = prop.getTypeInformation();
        if (this.conversions.hasValueConverter((PersistentProperty)prop)) {
            accessor.put(prop, this.applyPropertyConversion(obj, prop, persistentPropertyAccessor));
            return;
        }
        if (prop.isUnwrapped()) {
            Document target = new Document();
            this.writeInternal(obj, (Bson)target, (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)prop));
            accessor.putAll(target);
            return;
        }
        if (valueType.isCollectionLike()) {
            List<Object> collectionInternal = this.createCollection(BsonUtils.asCollection(obj), prop);
            accessor.put(prop, collectionInternal);
            return;
        }
        if (valueType.isMap()) {
            Bson mapDbObj = this.createMap((Map)obj, prop);
            accessor.put(prop, mapDbObj);
            return;
        }
        if (prop.isDbReference()) {
            com.mongodb.DBRef dbRefObj = null;
            if (obj instanceof LazyLoadingProxy) {
                LazyLoadingProxy proxy = (LazyLoadingProxy)obj;
                dbRefObj = proxy.toDBRef();
            }
            if (obj != null && this.conversions.hasCustomWriteTarget(obj.getClass())) {
                accessor.put(prop, this.doConvert(obj, (Class)this.conversions.getCustomWriteTarget(obj.getClass()).get()));
                return;
            }
            dbRefObj = dbRefObj != null ? dbRefObj : this.createDBRef(obj, prop);
            accessor.put(prop, dbRefObj);
            return;
        }
        if (prop.isAssociation() && prop.isAnnotationPresent(Reference.class)) {
            accessor.put(prop, new DocumentPointerFactory((ConversionService)this.conversionService, this.mappingContext).computePointer(this.mappingContext, prop, obj, valueType.getType()).getPointer());
            return;
        }
        if (obj instanceof LazyLoadingProxy) {
            LazyLoadingProxy proxy = (LazyLoadingProxy)obj;
            obj = proxy.getTarget();
        }
        if ((basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass())).isPresent()) {
            accessor.put(prop, this.doConvert(obj, (Class)basicTargetType.get()));
            return;
        }
        MongoPersistentEntity entity = valueType.isSubTypeOf(prop.getType()) ? (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(obj.getClass()) : (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        Object existingValue = accessor.get(prop);
        Document document = existingValue instanceof Document ? (existingDocument = (Document)existingValue) : new Document();
        this.writeInternal(obj, (Bson)document, entity);
        this.addCustomTypeKeyIfNecessary(TypeInformation.of((Class)prop.getRawType()), obj, (Bson)document);
        accessor.put(prop, document);
    }

    protected List<Object> createCollection(Collection<?> collection, MongoPersistentProperty property) {
        if (!property.isDbReference()) {
            if (property.isAssociation()) {
                List targetCollection = collection.stream().map(it -> this.documentPointerFactory.computePointer(this.mappingContext, property, it, property.getActualType()).getPointer()).collect(Collectors.toList());
                return this.writeCollectionInternal(targetCollection, TypeInformation.of(DocumentPointer.class), new ArrayList(targetCollection.size()));
            }
            if (property.hasExplicitWriteTarget()) {
                return this.writeCollectionInternal(collection, new FieldTypeInformation(property), new ArrayList(collection.size()));
            }
            return this.writeCollectionInternal(collection, property.getTypeInformation(), new ArrayList(collection.size()));
        }
        ArrayList<Object> dbList = new ArrayList<Object>(collection.size());
        for (Object element : collection) {
            if (element == null) continue;
            com.mongodb.DBRef dbRef = this.createDBRef(element, property);
            dbList.add(dbRef);
        }
        return dbList;
    }

    protected Bson createMap(Map<Object, Object> map, MongoPersistentProperty property) {
        Assert.notNull(map, (String)"Given map must not be null");
        Assert.notNull((Object)property, (String)"PersistentProperty must not be null");
        if (!property.isAssociation()) {
            return this.writeMapInternal(map, (Bson)new Document(), property.getTypeInformation());
        }
        Document document = new Document();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.prepareMapKey(key.toString());
                if (property.isDbReference()) {
                    document.put(simpleKey, value != null ? this.createDBRef(value, property) : null);
                    continue;
                }
                document.put(simpleKey, this.documentPointerFactory.computePointer(this.mappingContext, property, value, property.getActualType()).getPointer());
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value");
        }
        return document;
    }

    private List<Object> writeCollectionInternal(Collection<?> source, @Nullable TypeInformation<?> type, Collection<?> sink) {
        List<Object> collection;
        TypeInformation componentType = null;
        List<Object> list = collection = sink instanceof List ? (List<Object>)sink : new ArrayList(sink);
        if (type != null) {
            componentType = type.getComponentType();
        }
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                collection.add(this.getPotentiallyConvertedSimpleWrite(element, componentType != null ? componentType.getType() : Object.class));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                Collection<?> objects = BsonUtils.asCollection(element);
                collection.add(this.writeCollectionInternal(objects, componentType, new ArrayList(objects.size())));
                continue;
            }
            Document document = new Document();
            this.writeInternal(element, (Bson)document, componentType);
            collection.add(document);
        }
        return collection;
    }

    protected Bson writeMapInternal(Map<Object, Object> obj, Bson bson, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.prepareMapKey(key);
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, bson, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    BsonUtils.addToMap(bson, simpleKey, this.writeCollectionInternal(BsonUtils.asCollection(val), propertyType.getMapValueType(), new ArrayList()));
                    continue;
                }
                Document document = new Document();
                TypeInformation valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : TypeInformation.OBJECT;
                this.writeInternal(val, (Bson)document, valueTypeInfo);
                BsonUtils.addToMap(bson, simpleKey, document);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value");
        }
        return bson;
    }

    private String prepareMapKey(Object key) {
        Assert.notNull((Object)key, (String)"Map key must not be null");
        String convertedKey = this.potentiallyConvertMapKey(key);
        return this.potentiallyEscapeMapKey(convertedKey);
    }

    protected String potentiallyEscapeMapKey(String source) {
        if (!source.contains(".")) {
            return source;
        }
        if (this.mapKeyDotReplacement == null) {
            throw new MappingException(String.format("Map key %s contains dots but no replacement was configured; Make sure map keys don't contain dots in the first place or configure an appropriate replacement", source));
        }
        return StringUtils.replace((String)source, (String)".", (String)this.mapKeyDotReplacement);
    }

    private String potentiallyConvertMapKey(Object key) {
        if (key instanceof String) {
            String stringValue = (String)key;
            return stringValue;
        }
        return this.conversions.hasCustomWriteTarget(key.getClass(), String.class) ? (String)this.getPotentiallyConvertedSimpleWrite(key, Object.class) : key.toString();
    }

    protected String potentiallyUnescapeMapKey(String source) {
        return this.mapKeyDotReplacement == null ? source : StringUtils.replace((String)source, (String)this.mapKeyDotReplacement, (String)".");
    }

    protected void addCustomTypeKeyIfNecessary(@Nullable TypeInformation<?> type, Object value, Bson bson) {
        boolean notTheSameClass;
        Class reference = type != null ? type.getRequiredActualType().getType() : Object.class;
        Class valueType = ClassUtils.getUserClass(value.getClass());
        boolean bl = notTheSameClass = !valueType.equals(reference);
        if (notTheSameClass) {
            this.getTypeMapper().writeType(valueType, bson);
        }
    }

    private void writeSimpleInternal(@Nullable Object value, Bson bson, String key) {
        BsonUtils.addToMap(bson, key, this.getPotentiallyConvertedSimpleWrite(value, Object.class));
    }

    private void writeSimpleInternal(@Nullable Object value, Bson bson, MongoPersistentProperty property, PersistentPropertyAccessor<?> persistentPropertyAccessor) {
        DocumentAccessor accessor = new DocumentAccessor(bson);
        if (this.conversions.hasValueConverter((PersistentProperty)property)) {
            accessor.put(property, this.applyPropertyConversion(value, property, persistentPropertyAccessor));
            return;
        }
        accessor.put(property, this.getPotentiallyConvertedSimpleWrite(value, property.hasExplicitWriteTarget() ? property.getFieldType() : Object.class));
    }

    private @Nullable Object applyPropertyConversion(@Nullable Object value, MongoPersistentProperty property, final PersistentPropertyAccessor<?> persistentPropertyAccessor) {
        MongoConversionContext context = new MongoConversionContext(new PropertyValueProvider<MongoPersistentProperty>(this){
            final /* synthetic */ MappingMongoConverter this$0;
            {
                this.this$0 = this$0;
            }

            public <T> @Nullable T getPropertyValue(MongoPersistentProperty property) {
                return (T)persistentPropertyAccessor.getProperty((PersistentProperty)property);
            }
        }, property, (MongoConverter)this, this.spELContext);
        PropertyValueConversions propertyValueConversions = this.conversions.getPropertyValueConversions();
        if (propertyValueConversions == null) {
            return value;
        }
        PropertyValueConverter valueConverter = propertyValueConversions.getValueConverter((PersistentProperty)property);
        return value != null ? valueConverter.write(value, (ValueConversionContext)context) : valueConverter.writeNull((ValueConversionContext)context);
    }

    @Contract(value="null, _-> null")
    private @Nullable Object getPotentiallyConvertedSimpleWrite(@Nullable Object value, @Nullable Class<?> typeHint) {
        Optional customTarget;
        if (value == null) {
            return null;
        }
        if (typeHint != null && Object.class != typeHint && this.conversionService.canConvert(value.getClass(), typeHint)) {
            value = this.doConvert(value, typeHint);
        }
        if ((customTarget = this.conversions.getCustomWriteTarget(value.getClass())).isPresent()) {
            return this.doConvert(value, (Class)customTarget.get());
        }
        if (ObjectUtils.isArray((Object)value)) {
            if (value instanceof byte[]) {
                return value;
            }
            return BsonUtils.asCollection(value);
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    protected @Nullable Object getPotentiallyConvertedSimpleRead(@Nullable Object value, TypeInformation<?> target) {
        return this.getPotentiallyConvertedSimpleRead(value, target.getType());
    }

    @Contract(value="null, _ -> null; _, null -> param1")
    private @Nullable Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (target == null || value == null) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.doConvert(value, target);
        }
        if (ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.doConvert(value, target);
    }

    protected com.mongodb.DBRef createDBRef(Object target, @Nullable MongoPersistentProperty property) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        if (target instanceof com.mongodb.DBRef) {
            com.mongodb.DBRef dbRef = (com.mongodb.DBRef)target;
            return dbRef;
        }
        MongoPersistentEntity targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(target.getClass());
        MongoPersistentEntity mongoPersistentEntity = targetEntity = targetEntity != null ? targetEntity : (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property);
        if (null == targetEntity) {
            throw new MappingException("No mapping metadata found for " + String.valueOf(target.getClass()));
        }
        MongoPersistentEntity entity = targetEntity;
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            Object id;
            Object object = id = target.getClass().equals(idProperty.getType()) ? target : entity.getPropertyAccessor(target).getProperty((PersistentProperty)idProperty);
            if (null == id) {
                throw new MappingException("Cannot create a reference to an object with a NULL id");
            }
            return this.dbRefResolver.createDbRef(property == null ? null : property.getDBRef(), entity, this.idMapper.convertId(id, idProperty != null ? idProperty.getFieldType() : ObjectId.class));
        }
        throw new MappingException("No id property found on class " + String.valueOf(entity.getType()));
    }

    private @Nullable Object getValueInternal(ConversionContext context, MongoPersistentProperty prop, Bson bson, ValueExpressionEvaluator evaluator) {
        return new MongoDbPropertyValueProvider(context, bson, evaluator).getPropertyValue(prop);
    }

    protected @Nullable Object readCollectionOrArray(ConversionContext context, @Nullable Collection<?> source, TypeInformation<?> targetType) {
        Collection<?> items;
        Assert.notNull(targetType, (String)"Target type must not be null");
        Assert.notNull(source, (String)"Source must not be null");
        Class collectionType = targetType.isSubTypeOf(Collection.class) ? targetType.getType() : List.class;
        TypeInformation componentType = targetType.getComponentType() != null ? targetType.getComponentType() : TypeInformation.OBJECT;
        Class rawComponentType = componentType.getType();
        Collection collection = items = targetType.getType().isArray() ? new ArrayList(source.size()) : CollectionFactory.createCollection((Class)collectionType, (Class)rawComponentType, (int)source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
        }
        if (!com.mongodb.DBRef.class.equals((Object)rawComponentType) && MappingMongoConverter.isCollectionOfDbRefWhereBulkFetchIsPossible(source)) {
            List objects = this.bulkReadAndConvertDBRefs(context, (List)source, componentType);
            return this.getPotentiallyConvertedSimpleRead(objects, targetType.getType());
        }
        for (Object element : source) {
            items.add(element != null ? context.convert(element, componentType) : element);
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    protected @Nullable Map<Object, Object> readMap(ConversionContext context, @Nullable Bson bson, TypeInformation<?> targetType) {
        Assert.notNull((Object)bson, (String)"Document must not be null");
        Assert.notNull(targetType, (String)"TypeInformation must not be null");
        Class mapType = this.getTypeMapper().readType(bson, targetType).getType();
        TypeInformation keyType = targetType.getComponentType();
        TypeInformation valueType = targetType.getMapValueType() == null ? TypeInformation.OBJECT : targetType.getRequiredMapValueType();
        Class rawKeyType = keyType != null ? keyType.getType() : Object.class;
        Class rawValueType = valueType.getType();
        Map<String, Object> sourceMap = BsonUtils.asMap(bson);
        Map map = CollectionFactory.createMap((Class)mapType, (Class)rawKeyType, (int)sourceMap.keySet().size());
        if (!com.mongodb.DBRef.class.equals((Object)rawValueType) && MappingMongoConverter.isCollectionOfDbRefWhereBulkFetchIsPossible(sourceMap.values())) {
            this.bulkReadAndConvertDBRefMapIntoTarget(context, valueType, sourceMap, map);
            return map;
        }
        sourceMap.forEach((k, v) -> {
            if (this.getTypeMapper().isTypeKey((String)k)) {
                return;
            }
            String key = this.potentiallyUnescapeMapKey((String)k);
            if (!rawKeyType.isAssignableFrom(key.getClass())) {
                key = this.doConvert(key, rawKeyType);
            }
            map.put(key, v == null ? v : context.convert(v, valueType));
        });
        return map;
    }

    @Override
    public @Nullable Object convertToMongoType(@Nullable Object obj, @Nullable TypeInformation<?> typeInformation) {
        if (obj == null) {
            return null;
        }
        Optional target = this.conversions.getCustomWriteTarget(obj.getClass());
        if (target.isPresent()) {
            return this.doConvert(obj, (Class)target.get());
        }
        if (this.conversions.isSimpleType(obj.getClass())) {
            Class conversionTargetType = typeInformation != null && this.conversions.isSimpleType(typeInformation.getType()) ? typeInformation.getType() : Object.class;
            return this.getPotentiallyConvertedSimpleWrite(obj, conversionTargetType);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return this.maybeConvertList(list, typeInformation);
        }
        if (obj instanceof Document) {
            Document document = (Document)obj;
            Document newValueDocument = new Document();
            for (String vk : document.keySet()) {
                Object o = document.get((Object)vk);
                newValueDocument.put(vk, this.convertToMongoType(o, typeInformation));
            }
            return newValueDocument;
        }
        if (obj instanceof DBObject) {
            DBObject dbObject = (DBObject)obj;
            Document newValueDbo = new Document();
            for (String vk : dbObject.keySet()) {
                Object o = dbObject.get(vk);
                newValueDbo.put(vk, this.convertToMongoType(o, typeInformation));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            Document result = new Document();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.put(entry.getKey().toString(), this.convertToMongoType(entry.getValue(), typeInformation));
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertList(Arrays.asList((Object[])obj), typeInformation);
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            return this.maybeConvertList(collection, typeInformation);
        }
        Document newDocument = new Document();
        this.write(obj, (Bson)newDocument);
        if (typeInformation == null) {
            return this.removeTypeInfo(newDocument, true);
        }
        if (typeInformation.getType().equals(NestedDocument.class)) {
            return this.removeTypeInfo(newDocument, false);
        }
        return !obj.getClass().equals(typeInformation.getType()) ? newDocument : this.removeTypeInfo(newDocument, true);
    }

    @Override
    public Object convertToMongoType(@Nullable Object obj, MongoPersistentEntity<?> entity) {
        Document newDocument = new Document();
        this.writeInternal(obj, (Bson)newDocument, entity);
        return newDocument;
    }

    public List<Object> maybeConvertList(Iterable<?> source, @Nullable TypeInformation<?> typeInformation) {
        ArrayList<Object> newDbl = new ArrayList<Object>();
        for (Object element : source) {
            newDbl.add(this.convertToMongoType(element, typeInformation));
        }
        return newDbl;
    }

    private Object removeTypeInfo(Object object, boolean recursively) {
        if (!(object instanceof Document)) {
            return object;
        }
        Document document = (Document)object;
        String keyToRemove = null;
        for (String key : document.keySet()) {
            if (recursively) {
                Object value = document.get((Object)key);
                if (value instanceof BasicDBList) {
                    for (Object element : (BasicDBList)value) {
                        this.removeTypeInfo(element, recursively);
                    }
                } else if (value instanceof List) {
                    for (Object element : (List)value) {
                        this.removeTypeInfo(element, recursively);
                    }
                } else {
                    this.removeTypeInfo(value, recursively);
                }
            }
            if (!this.getTypeMapper().isTypeKey(key)) continue;
            keyToRemove = key;
            if (recursively) continue;
            break;
        }
        if (keyToRemove != null) {
            document.remove(keyToRemove);
        }
        return document;
    }

    <T> @Nullable T readValue(ConversionContext context, @Nullable Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        Assert.notNull(type, (String)"TypeInformation must not be null");
        Class rawType = type.getType();
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            return this.doConvert(value, rawType);
        }
        if (value instanceof com.mongodb.DBRef) {
            com.mongodb.DBRef dbRef = (com.mongodb.DBRef)value;
            return (T)this.readDBRef(context, dbRef, type);
        }
        return (T)context.convert(value, type);
    }

    private @Nullable Object readDBRef(ConversionContext context, @Nullable com.mongodb.DBRef dbref, TypeInformation<?> type) {
        Object object;
        if (type.getType().equals(com.mongodb.DBRef.class)) {
            return dbref;
        }
        ObjectPath path = context.getPath();
        Object v0 = object = dbref == null ? null : path.getPathItem(dbref.getId(), dbref.getCollectionName(), type.getType());
        if (object != null) {
            return object;
        }
        List result = this.bulkReadAndConvertDBRefs(context, Collections.singletonList(dbref), type);
        return CollectionUtils.isEmpty(result) ? null : MappingMongoConverter.peek(result);
    }

    private void bulkReadAndConvertDBRefMapIntoTarget(ConversionContext context, TypeInformation<?> valueType, Map<String, Object> sourceMap, Map<Object, Object> targetMap) {
        LinkedHashMap<String, Object> referenceMap = new LinkedHashMap<String, Object>(sourceMap);
        List convertedObjects = this.bulkReadAndConvertDBRefs(context.withPath(ObjectPath.ROOT), new ArrayList<Object>(referenceMap.values()), valueType);
        int index = 0;
        for (String key : referenceMap.keySet()) {
            targetMap.put(key, convertedObjects.get(index));
            ++index;
        }
    }

    private <T> List<T> bulkReadAndConvertDBRefs(ConversionContext context, List<com.mongodb.DBRef> dbrefs, TypeInformation<?> type) {
        if (CollectionUtils.isEmpty(dbrefs)) {
            return Collections.emptyList();
        }
        List<Document> referencedRawDocuments = dbrefs.size() == 1 ? Collections.singletonList(this.readRef(MappingMongoConverter.peek(dbrefs))) : this.bulkReadRefs(dbrefs);
        String collectionName = MappingMongoConverter.peek(dbrefs).getCollectionName();
        ArrayList<Object> targetList = new ArrayList<Object>(dbrefs.size());
        for (Document document : referencedRawDocuments) {
            Object target = null;
            if (document != null) {
                this.maybeEmitEvent(new AfterLoadEvent(document, type.getType(), collectionName));
                target = this.readDocument(context, (Bson)document, type);
            }
            if (target != null) {
                this.maybeEmitEvent(new AfterConvertEvent<Object>(document, target, collectionName));
                target = this.maybeCallAfterConvert(target, document, collectionName);
            }
            targetList.add(target);
        }
        return targetList;
    }

    private void maybeEmitEvent(MongoMappingEvent<?> event) {
        if (this.canPublishEvent()) {
            this.applicationContext.publishEvent(event);
        }
    }

    private boolean canPublishEvent() {
        return this.applicationContext != null;
    }

    protected <T> T maybeCallAfterConvert(T object, Document document, String collection) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(AfterConvertCallback.class, object, new Object[]{document, collection});
        }
        return object;
    }

    @Nullable Document readRef(com.mongodb.DBRef ref) {
        return this.dbRefResolver.fetch(ref);
    }

    List<Document> bulkReadRefs(List<com.mongodb.DBRef> references) {
        return this.dbRefResolver.bulkFetch(references);
    }

    public Class<?> getWriteTarget(Class<?> source) {
        return this.conversions.getCustomWriteTarget(source).orElse(source);
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistryProvider != null ? this.codecRegistryProvider.getCodecRegistry() : super.getCodecRegistry();
    }

    public MappingMongoConverter with(MongoDatabaseFactory dbFactory) {
        MappingMongoConverter target = new MappingMongoConverter(new DefaultDbRefResolver(dbFactory), this.mappingContext);
        target.applicationContext = this.applicationContext;
        target.conversions = this.conversions;
        target.spELContext = this.spELContext;
        target.setInstantiators(this.instantiators);
        target.defaultTypeMapper = this.defaultTypeMapper;
        target.typeMapper = this.typeMapper;
        target.setCodecRegistryProvider(dbFactory);
        target.afterPropertiesSet();
        return target;
    }

    private <T> @Nullable T doConvert(Object value, Class<? extends T> target) {
        return this.doConvert(value, target, null);
    }

    private <T> @Nullable T doConvert(Object value, Class<? extends T> target, @Nullable Class<? extends T> fallback) {
        if (this.conversionService.canConvert(value.getClass(), target) || fallback == null) {
            return (T)this.conversionService.convert(value, target);
        }
        return (T)this.conversionService.convert(value, fallback);
    }

    private static boolean isCollectionOfDbRefWhereBulkFetchIsPossible(Iterable<?> source) {
        Assert.notNull(source, (String)"Iterable of DBRefs must not be null");
        HashSet<String> collectionsFound = new HashSet<String>();
        for (Object dbObjItem : source) {
            if (!(dbObjItem instanceof com.mongodb.DBRef)) {
                return false;
            }
            com.mongodb.DBRef dbRef = (com.mongodb.DBRef)dbObjItem;
            collectionsFound.add(dbRef.getCollectionName());
            if (collectionsFound.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private static <T> T peek(Iterable<T> result) {
        return result.iterator().next();
    }

    protected static class DefaultConversionContext
    implements ConversionContext {
        final MongoConverter sourceConverter;
        final CustomConversions conversions;
        final ObjectPath path;
        final ContainerValueConverter<Bson> documentConverter;
        final ContainerValueConverter<Collection<?>> collectionConverter;
        final ContainerValueConverter<@Nullable Bson> mapConverter;
        final ContainerValueConverter<@Nullable com.mongodb.DBRef> dbRefConverter;
        final ValueConverter<@Nullable Object> elementConverter;

        DefaultConversionContext(MongoConverter sourceConverter, CustomConversions customConversions, ObjectPath path, ContainerValueConverter<@Nullable Bson> documentConverter, ContainerValueConverter<@Nullable Collection<?>> collectionConverter, ContainerValueConverter<@Nullable Bson> mapConverter, ContainerValueConverter<@Nullable com.mongodb.DBRef> dbRefConverter, ValueConverter<@Nullable Object> elementConverter) {
            this.sourceConverter = sourceConverter;
            this.conversions = customConversions;
            this.path = path;
            this.documentConverter = documentConverter;
            this.collectionConverter = collectionConverter;
            this.mapConverter = mapConverter;
            this.dbRefConverter = dbRefConverter;
            this.elementConverter = elementConverter;
        }

        @Override
        public <S> S convert(Object source, TypeInformation<? extends S> typeHint, ConversionContext context) {
            if (this.conversions.hasCustomReadTarget(source.getClass(), typeHint.getType())) {
                return (S)this.elementConverter.convert(source, typeHint);
            }
            if (source instanceof Collection) {
                Collection collection = (Collection)source;
                Class rawType = typeHint.getType();
                if (!(Object.class.equals((Object)rawType) || String.class.equals((Object)rawType) || rawType.isArray() || ClassUtils.isAssignable(Iterable.class, (Class)rawType))) {
                    throw new MappingException(String.format(MappingMongoConverter.INCOMPATIBLE_TYPES, source, source.getClass(), rawType, this.getPath()));
                }
                if (typeHint.isCollectionLike() || typeHint.getType().isAssignableFrom(Collection.class)) {
                    return (S)this.collectionConverter.convert(context, collection, typeHint);
                }
            }
            if (typeHint.isMap()) {
                if (ClassUtils.isAssignable(Document.class, (Class)typeHint.getType())) {
                    return (S)this.documentConverter.convert(context, BsonUtils.asBson(source), typeHint);
                }
                if (BsonUtils.supportsBson(source)) {
                    return (S)this.mapConverter.convert(context, BsonUtils.asBson(source), typeHint);
                }
                throw new IllegalArgumentException(String.format("Expected map like structure but found %s", source.getClass()));
            }
            if (source instanceof com.mongodb.DBRef) {
                com.mongodb.DBRef dbRef = (com.mongodb.DBRef)source;
                return (S)this.dbRefConverter.convert(context, dbRef, typeHint);
            }
            if (BsonUtils.supportsBson(source)) {
                return (S)this.documentConverter.convert(context, BsonUtils.asBson(source), typeHint);
            }
            return (S)this.elementConverter.convert(source, typeHint);
        }

        @Override
        public CustomConversions getCustomConversions() {
            return this.conversions;
        }

        @Override
        public MongoConverter getSourceConverter() {
            return this.sourceConverter;
        }

        @Override
        public ConversionContext withPath(ObjectPath currentPath) {
            Assert.notNull((Object)currentPath, (String)"ObjectPath must not be null");
            return new DefaultConversionContext(this.sourceConverter, this.conversions, currentPath, this.documentConverter, this.collectionConverter, this.mapConverter, this.dbRefConverter, this.elementConverter);
        }

        @Override
        public ObjectPath getPath() {
            return this.path;
        }

        static interface ContainerValueConverter<T> {
            public @Nullable Object convert(ConversionContext var1, @Nullable T var2, TypeInformation<?> var3);
        }

        static interface ValueConverter<T> {
            public @Nullable Object convert(@Nullable T var1, TypeInformation<?> var2);
        }
    }

    class ProjectingConversionContext
    extends DefaultConversionContext {
        private final EntityProjection<?, ?> returnedTypeDescriptor;

        ProjectingConversionContext(MongoConverter sourceConverter, CustomConversions customConversions, ObjectPath path, DefaultConversionContext.ContainerValueConverter<Collection<?>> collectionConverter, DefaultConversionContext.ContainerValueConverter<@Nullable Bson> mapConverter, DefaultConversionContext.ContainerValueConverter<@Nullable com.mongodb.DBRef> dbRefConverter, DefaultConversionContext.ValueConverter<Object> elementConverter, EntityProjection<?, ?> projection) {
            super(sourceConverter, customConversions, path, (context, source, typeHint) -> MappingMongoConverter.this.doReadOrProject(context, (Bson)source, (TypeInformation<?>)typeHint, projection), collectionConverter, mapConverter, dbRefConverter, elementConverter);
            this.returnedTypeDescriptor = projection;
        }

        @Override
        public ConversionContext forProperty(String name) {
            EntityProjection property = this.returnedTypeDescriptor.findProperty(name);
            if (property == null) {
                return new DefaultConversionContext(this.sourceConverter, this.conversions, this.path, MappingMongoConverter.this::readDocument, this.collectionConverter, this.mapConverter, this.dbRefConverter, this.elementConverter);
            }
            return new ProjectingConversionContext(this.sourceConverter, this.conversions, this.path, this.collectionConverter, this.mapConverter, this.dbRefConverter, this.elementConverter, property);
        }

        @Override
        public ConversionContext withPath(ObjectPath currentPath) {
            return new ProjectingConversionContext(this.sourceConverter, this.conversions, currentPath, this.collectionConverter, this.mapConverter, this.dbRefConverter, this.elementConverter, this.returnedTypeDescriptor);
        }
    }

    protected static interface ConversionContext {
        default public <S> S convert(Object source, TypeInformation<? extends S> typeHint) {
            return this.convert(source, typeHint, this);
        }

        public <S> S convert(Object var1, TypeInformation<? extends S> var2, ConversionContext var3);

        public ConversionContext withPath(ObjectPath var1);

        default public ConversionContext forProperty(String name) {
            return this;
        }

        default public ConversionContext forProperty(MongoPersistentProperty property) {
            return property.isAssociation() ? new AssociationConversionContext(this.forProperty(property.getName())) : this.forProperty(property.getName());
        }

        default public <S> @Nullable S findContextualEntity(MongoPersistentEntity<S> entity, Document document) {
            return null;
        }

        public ObjectPath getPath();

        public CustomConversions getCustomConversions();

        public MongoConverter getSourceConverter();
    }

    static class MapPersistentPropertyAccessor
    implements PersistentPropertyAccessor<Map<String, Object>> {
        Map<String, Object> map = new LinkedHashMap<String, Object>();

        MapPersistentPropertyAccessor() {
        }

        public void setProperty(PersistentProperty<?> persistentProperty, @Nullable Object o) {
            this.map.put(persistentProperty.getName(), o);
        }

        public @Nullable Object getProperty(PersistentProperty<?> persistentProperty) {
            return this.map.get(persistentProperty.getName());
        }

        public Map<String, Object> getBean() {
            return this.map;
        }
    }

    private static class PropertyTranslatingPropertyAccessor<T>
    implements PersistentPropertyAccessor<T> {
        private final PersistentPropertyAccessor<T> delegate;
        private final PersistentPropertyTranslator propertyTranslator;

        private PropertyTranslatingPropertyAccessor(PersistentPropertyAccessor<T> delegate, PersistentPropertyTranslator propertyTranslator) {
            this.delegate = delegate;
            this.propertyTranslator = propertyTranslator;
        }

        static <T> PersistentPropertyAccessor<T> create(PersistentPropertyAccessor<T> delegate, PersistentPropertyTranslator propertyTranslator) {
            return new PropertyTranslatingPropertyAccessor<T>(delegate, propertyTranslator);
        }

        public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
            this.delegate.setProperty((PersistentProperty)this.translate(property), value);
        }

        public @Nullable Object getProperty(PersistentProperty<?> property) {
            return this.delegate.getProperty((PersistentProperty)this.translate(property));
        }

        public T getBean() {
            return (T)this.delegate.getBean();
        }

        private MongoPersistentProperty translate(PersistentProperty<?> property) {
            return this.propertyTranslator.translate((MongoPersistentProperty)property);
        }
    }

    static class MongoDbPropertyValueProvider
    implements PropertyValueProvider<MongoPersistentProperty> {
        final ConversionContext context;
        final DocumentAccessor accessor;
        final ValueExpressionEvaluator evaluator;
        final @Nullable SpELContext spELContext;

        MongoDbPropertyValueProvider(ConversionContext context, Bson source, ValueExpressionEvaluator evaluator) {
            this(context, new DocumentAccessor(source), evaluator, null);
        }

        MongoDbPropertyValueProvider(ConversionContext context, DocumentAccessor accessor, ValueExpressionEvaluator evaluator, @Nullable SpELContext spELContext) {
            this.context = context;
            this.accessor = accessor;
            this.evaluator = evaluator;
            this.spELContext = spELContext;
        }

        public <T> @Nullable T getPropertyValue(MongoPersistentProperty property) {
            String expression = property.getSpelExpression();
            Object value = expression != null ? this.evaluator.evaluate(expression) : this.accessor.get(property);
            CustomConversions conversions = this.context.getCustomConversions();
            if (conversions.hasValueConverter((PersistentProperty)property)) {
                MongoConversionContext conversionContext = new MongoConversionContext((PropertyValueProvider<MongoPersistentProperty>)this, property, this.context.getSourceConverter(), this.spELContext);
                PropertyValueConverter valueConverter = conversions.getPropertyValueConversions().getValueConverter((PersistentProperty)property);
                return (T)(value != null ? valueConverter.read(value, (ValueConversionContext)conversionContext) : valueConverter.readNull((ValueConversionContext)conversionContext));
            }
            if (value == null) {
                return null;
            }
            ConversionContext contextToUse = this.context.forProperty(property);
            return (T)contextToUse.convert(value, property.getTypeInformation());
        }

        public MongoDbPropertyValueProvider withContext(ConversionContext context) {
            return context == this.context ? this : new MongoDbPropertyValueProvider(context, this.accessor, this.evaluator, this.spELContext);
        }
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<MongoPersistentProperty>
    {
        INSTANCE;


        public <T> @Nullable T getParameterValue(Parameter<T, MongoPersistentProperty> parameter) {
            return null;
        }
    }

    class AssociationAwareMongoDbPropertyValueProvider
    extends MongoDbPropertyValueProvider {
        AssociationAwareMongoDbPropertyValueProvider(ConversionContext context, DocumentAccessor source, ValueExpressionEvaluator evaluator) {
            super(context, source, evaluator, MappingMongoConverter.this.spELContext);
        }

        @Override
        public <T> @Nullable T getPropertyValue(MongoPersistentProperty property) {
            ConversionContext propertyContext = this.context.forProperty(property);
            if (property.isAssociation()) {
                DefaultDbRefResolverCallback callback = new DefaultDbRefResolverCallback(this.accessor.getDocument(), this.context.getPath(), this.evaluator, (prop, bson, evaluator, path) -> MappingMongoConverter.this.getValueInternal(this.context, prop, bson, evaluator));
                return (T)MappingMongoConverter.this.readAssociation((Association<MongoPersistentProperty>)property.getRequiredAssociation(), this.accessor, MappingMongoConverter.this.dbRefProxyHandler, callback, propertyContext);
            }
            if (property.isUnwrapped()) {
                return (T)MappingMongoConverter.this.readUnwrapped(propertyContext, this.accessor, property, (MongoPersistentEntity)MappingMongoConverter.this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property));
            }
            if (!this.accessor.hasValue(property)) {
                return null;
            }
            return super.getPropertyValue(property);
        }
    }

    private static class ConverterAwareValueExpressionParameterValueProvider
    extends ValueExpressionParameterValueProvider<MongoPersistentProperty> {
        private final ConversionContext context;

        public ConverterAwareValueExpressionParameterValueProvider(ConversionContext context, ValueExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<MongoPersistentProperty> delegate) {
            super(evaluator, conversionService, delegate);
            Assert.notNull((Object)context, (String)"ConversionContext must no be null");
            this.context = context;
        }

        protected <T> T potentiallyConvertExpressionValue(Object object, Parameter<T, MongoPersistentProperty> parameter) {
            return (T)this.context.convert(object, parameter.getType());
        }
    }

    class EvaluatingDocumentAccessor
    extends DocumentAccessor
    implements ValueExpressionEvaluator {
        public EvaluatingDocumentAccessor(Bson document) {
            super(document);
        }

        public <T> @Nullable T evaluate(String expression) {
            return (T)MappingMongoConverter.this.expressionEvaluatorFactory.create((Object)this.getDocument()).evaluate(expression);
        }
    }

    private static class FieldTypeInformation<S>
    implements TypeInformation<S> {
        private final MongoPersistentProperty persistentProperty;
        private final TypeInformation<S> delegate;

        public FieldTypeInformation(MongoPersistentProperty property) {
            this.persistentProperty = property;
            this.delegate = property.getTypeInformation();
        }

        public List<TypeInformation<?>> getParameterTypes(Constructor constructor) {
            return this.persistentProperty.getTypeInformation().getParameterTypes(constructor);
        }

        public @Nullable TypeInformation<?> getProperty(String property) {
            return this.delegate.getProperty(property);
        }

        public boolean isCollectionLike() {
            return this.delegate.isCollectionLike();
        }

        public TypeInformation<?> getComponentType() {
            return TypeInformation.of(this.persistentProperty.getFieldType());
        }

        public boolean isMap() {
            return this.delegate.isMap();
        }

        public TypeInformation<?> getMapValueType() {
            return TypeInformation.of(this.persistentProperty.getFieldType());
        }

        public Class<S> getType() {
            return this.delegate.getType();
        }

        public TypeInformation<?> getRawTypeInformation() {
            return this.delegate.getRawTypeInformation();
        }

        public @Nullable TypeInformation<?> getActualType() {
            return this.delegate.getActualType();
        }

        public TypeInformation<?> getReturnType(Method method) {
            return this.delegate.getReturnType(method);
        }

        public List<TypeInformation<?>> getParameterTypes(Method method) {
            return this.delegate.getParameterTypes(method);
        }

        public @Nullable TypeInformation<?> getSuperTypeInformation(Class superType) {
            return this.delegate.getSuperTypeInformation(superType);
        }

        public boolean isAssignableFrom(TypeInformation target) {
            return this.delegate.isAssignableFrom(target);
        }

        public List<TypeInformation<?>> getTypeArguments() {
            return this.delegate.getTypeArguments();
        }

        public TypeInformation<? extends S> specialize(TypeInformation<?> type) {
            return this.delegate.specialize(type);
        }

        public TypeDescriptor toTypeDescriptor() {
            return this.delegate.toTypeDescriptor();
        }

        public ResolvableType toResolvableType() {
            return this.delegate.toResolvableType();
        }
    }

    static class NestedDocument {
        NestedDocument() {
        }
    }

    static class AssociationConversionContext
    implements ConversionContext {
        private final ConversionContext delegate;

        public AssociationConversionContext(ConversionContext delegate) {
            this.delegate = delegate;
        }

        @Override
        public <S> S convert(Object source, TypeInformation<? extends S> typeHint, ConversionContext context) {
            return this.delegate.convert(source, typeHint, context);
        }

        @Override
        public ConversionContext withPath(ObjectPath currentPath) {
            return new AssociationConversionContext(this.delegate.withPath(currentPath));
        }

        @Override
        public <S> @Nullable S findContextualEntity(MongoPersistentEntity<S> entity, Document document) {
            Object identifier = document.get((Object)BasicMongoPersistentProperty.ID_FIELD_NAME);
            return identifier != null ? (S)this.getPath().getPathItem(identifier, entity.getCollection(), entity.getType()) : null;
        }

        @Override
        public ObjectPath getPath() {
            return this.delegate.getPath();
        }

        @Override
        public CustomConversions getCustomConversions() {
            return this.delegate.getCustomConversions();
        }

        @Override
        public MongoConverter getSourceConverter() {
            return this.delegate.getSourceConverter();
        }
    }
}

