/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.listener;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqAttributesFactory;
import org.apache.geode.cache.query.CqListener;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.listener.ContinuousQueryListener;
import org.springframework.data.gemfire.listener.adapter.ContinuousQueryListenerAdapter;
import org.springframework.data.gemfire.listener.annotation.ContinuousQuery;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ContinuousQueryDefinition
implements InitializingBean {
    private final boolean durable;
    private final ContinuousQueryListener listener;
    private final String name;
    private final String query;

    public static ContinuousQueryDefinition from(Object delegate, Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        ContinuousQuery continuousQuery = method.getAnnotation(ContinuousQuery.class);
        Assert.notNull((Object)continuousQuery, () -> String.format("Method [%1$s] must be annotated with [%2$s]", method, ContinuousQuery.class.getName()));
        String name = Optional.of(continuousQuery.name()).filter(StringUtils::hasText).orElseGet(() -> String.format("%1$s.%2$s", method.getDeclaringClass().getName(), method.getName()));
        String query = continuousQuery.query();
        ContinuousQueryListenerAdapter listener = new ContinuousQueryListenerAdapter(delegate);
        listener.setDefaultListenerMethod(method.getName());
        boolean durable = continuousQuery.durable();
        return new ContinuousQueryDefinition(name, query, listener, durable);
    }

    public ContinuousQueryDefinition(String query, ContinuousQueryListener listener) {
        this(query, listener, false);
    }

    public ContinuousQueryDefinition(String query, ContinuousQueryListener listener, boolean durable) {
        this(null, query, listener, durable);
    }

    public ContinuousQueryDefinition(String name, String query, ContinuousQueryListener listener) {
        this(name, query, listener, false);
    }

    public ContinuousQueryDefinition(String name, String query, ContinuousQueryListener listener, boolean durable) {
        this.name = name;
        this.query = query;
        this.listener = listener;
        this.durable = durable;
        this.afterPropertiesSet();
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isNamed() {
        return StringUtils.hasText((String)this.getName());
    }

    public ContinuousQueryListener getListener() {
        return this.listener;
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return this.query;
    }

    public void afterPropertiesSet() {
        Assert.hasText((String)this.query, (String)"Query is required");
        Assert.notNull((Object)this.listener, (String)"Listener is required");
    }

    public CqAttributes toCqAttributes(Function<ContinuousQueryListener, CqListener> listenerFunction) {
        CqAttributesFactory attributesFactory = new CqAttributesFactory();
        attributesFactory.addCqListener(listenerFunction.apply(this.getListener()));
        return attributesFactory.create();
    }
}

