/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;

@Configuration
public class BeanFactoryLocatorConfiguration {
    @Bean
    public BeanPostProcessor useBeanFactoryLocatorBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof CacheFactoryBean) {
                    ((CacheFactoryBean)bean).setUseBeanFactoryLocator(true);
                }
                return bean;
            }
        };
    }

    @Bean
    public ClientCacheConfigurer useBeanFactoryLocatorClientCacheConfigurer() {
        return (beanName, bean) -> bean.setUseBeanFactoryLocator(true);
    }

    @Bean
    public PeerCacheConfigurer useBeanFactoryLocatorPeerCacheConfigurer() {
        return (beanName, bean) -> bean.setUseBeanFactoryLocator(true);
    }
}

