/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.compression.Compressor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.ConfigurableRegionFactoryBean;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionShortcutToDataPolicyConverter;
import org.springframework.data.gemfire.RegionShortcutWrapper;
import org.springframework.data.gemfire.eviction.EvictingRegionFactoryBean;
import org.springframework.data.gemfire.expiration.ExpiringRegionFactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RegionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class PeerRegionFactoryBean<K, V>
extends ConfigurableRegionFactoryBean<K, V>
implements DisposableBean,
EvictingRegionFactoryBean,
ExpiringRegionFactoryBean<K, V>,
SmartLifecycle {
    private boolean close = false;
    private boolean destroy = false;
    private boolean running = false;
    private Boolean offHeap;
    private Boolean persistent;
    private Boolean statisticsEnabled;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private Class<K> keyConstraint;
    private Class<V> valueConstraint;
    private Compressor compressor;
    private CustomExpiry<K, V> customEntryIdleTimeout;
    private CustomExpiry<K, V> customEntryTimeToLive;
    private DataPolicy dataPolicy;
    private EvictionAttributes evictionAttributes;
    private ExpirationAttributes entryIdleTimeout;
    private ExpirationAttributes entryTimeToLive;
    private ExpirationAttributes regionIdleTimeout;
    private ExpirationAttributes regionTimeToLive;
    private final List<AsyncEventQueue> asyncEventQueues = new ArrayList<AsyncEventQueue>();
    private final List<GatewaySender> gatewaySenders = new ArrayList<GatewaySender>();
    private final List<String> asyncEventQueueIds = new ArrayList<String>();
    private final List<String> gatewaySenderIds = new ArrayList<String>();
    private RegionAttributes<K, V> attributes;
    private RegionShortcut shortcut;
    private Resource snapshot;
    private Scope scope;
    private String diskStoreName;

    @Override
    protected Region<K, V> createRegion(GemFireCache gemfireCache, String regionName) {
        this.verifyLockGrantorEligibility(this.getAttributes(), this.getScope());
        Cache cache = this.resolveCache(gemfireCache);
        RegionFactory<K, V> regionFactory = this.postProcess(this.configure(this.createRegionFactory(cache)));
        Region<K, V> region = this.newRegion(regionFactory, this.getParent(), regionName);
        region = this.becomeLockGrantor(region);
        return region;
    }

    private Region<K, V> becomeLockGrantor(Region<K, V> region) {
        if (this.isLockGrantor(region)) {
            region.becomeLockGrantor();
        }
        return region;
    }

    private boolean isLockGrantor(@Nullable Region<K, V> region) {
        return region != null && region.getAttributes() != null && region.getAttributes().isLockGrantor();
    }

    private Region<K, V> newRegion(RegionFactory<K, V> regionFactory, Region<?, ?> parentRegion, String regionName) {
        if (parentRegion != null) {
            this.logInfo("Creating Subregion [%1$s] with parent Region [%2$s]", regionName, parentRegion.getName());
            return regionFactory.createSubregion(parentRegion, regionName);
        }
        this.logInfo("Created Region [%s]", regionName);
        return regionFactory.create(regionName);
    }

    private Cache resolveCache(GemFireCache gemfireCache) {
        return Optional.ofNullable(gemfireCache).filter(Cache.class::isInstance).map(Cache.class::cast).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Peer Cache is required", new Object[0]));
    }

    private RegionAttributes<K, V> verifyLockGrantorEligibility(RegionAttributes<K, V> regionAttributes, Scope scope) {
        Optional.ofNullable(regionAttributes).ifPresent(attributes -> Assert.state((!attributes.isLockGrantor() || this.verifyScope(scope) ? 1 : 0) != 0, (String)"Lock Grantor only applies to GLOBAL Scoped Regions"));
        return regionAttributes;
    }

    private boolean verifyScope(Scope scope) {
        return scope == null || Scope.GLOBAL.equals(scope);
    }

    protected RegionFactory<K, V> createRegionFactory(Cache cache) {
        if (this.shortcut != null) {
            RegionFactory<K, V> regionFactory = this.mergeRegionAttributes(cache.createRegionFactory(this.shortcut), this.attributes);
            this.setDataPolicy(this.getDataPolicy(regionFactory, this.shortcut));
            return regionFactory;
        }
        if (this.attributes != null) {
            return cache.createRegionFactory(this.attributes);
        }
        return cache.createRegionFactory();
    }

    protected RegionFactory<K, V> configure(RegionFactory<K, V> regionFactory) {
        regionFactory.setStatisticsEnabled(this.resolveStatisticsEnabled());
        this.getConfiguredAsyncEventQueueIds().forEach(arg_0 -> regionFactory.addAsyncEventQueueId(arg_0));
        Arrays.stream(ArrayUtils.nullSafeArray(this.cacheListeners, CacheListener.class)).forEach(arg_0 -> regionFactory.addCacheListener(arg_0));
        Optional.ofNullable(this.cacheLoader).ifPresent(arg_0 -> regionFactory.setCacheLoader(arg_0));
        Optional.ofNullable(this.cacheWriter).ifPresent(arg_0 -> regionFactory.setCacheWriter(arg_0));
        Optional.ofNullable(this.compressor).ifPresent(arg_0 -> regionFactory.setCompressor(arg_0));
        Optional.ofNullable(this.customEntryIdleTimeout).ifPresent(arg_0 -> regionFactory.setCustomEntryIdleTimeout(arg_0));
        Optional.ofNullable(this.customEntryTimeToLive).ifPresent(arg_0 -> regionFactory.setCustomEntryTimeToLive(arg_0));
        this.resolveDataPolicy(regionFactory, this.persistent, this.dataPolicy);
        Optional.ofNullable(this.diskStoreName).filter(name -> this.isDiskStoreConfigurationAllowed()).ifPresent(arg_0 -> regionFactory.setDiskStoreName(arg_0));
        Optional.ofNullable(this.entryIdleTimeout).ifPresent(arg_0 -> regionFactory.setEntryIdleTimeout(arg_0));
        Optional.ofNullable(this.entryTimeToLive).ifPresent(arg_0 -> regionFactory.setEntryTimeToLive(arg_0));
        Optional.ofNullable(this.evictionAttributes).ifPresent(arg_0 -> regionFactory.setEvictionAttributes(arg_0));
        this.getConfiguredGatewaySenderIds().forEach(arg_0 -> regionFactory.addGatewaySenderId(arg_0));
        Optional.ofNullable(this.keyConstraint).ifPresent(arg_0 -> regionFactory.setKeyConstraint(arg_0));
        Optional.ofNullable(this.offHeap).ifPresent(arg_0 -> regionFactory.setOffHeap(arg_0));
        Optional.ofNullable(this.regionIdleTimeout).ifPresent(arg_0 -> regionFactory.setRegionIdleTimeout(arg_0));
        Optional.ofNullable(this.regionTimeToLive).ifPresent(arg_0 -> regionFactory.setRegionTimeToLive(arg_0));
        Optional.ofNullable(this.getScope()).ifPresent(arg_0 -> regionFactory.setScope(arg_0));
        Optional.ofNullable(this.valueConstraint).ifPresent(arg_0 -> regionFactory.setValueConstraint(arg_0));
        return regionFactory;
    }

    @Override
    protected RegionFactory<K, V> postProcess(RegionFactory<K, V> regionFactory) {
        return regionFactory;
    }

    private Set<String> getConfiguredAsyncEventQueueIds() {
        HashSet<String> asyncEventQueueIds = new HashSet<String>();
        CollectionUtils.nullSafeList(this.asyncEventQueues).stream().filter(Objects::nonNull).map(AsyncEventQueue::getId).collect(Collectors.toCollection(() -> asyncEventQueueIds));
        CollectionUtils.nullSafeList(this.asyncEventQueueIds).stream().filter(StringUtils::hasText).map(String::trim).collect(Collectors.toCollection(() -> asyncEventQueueIds));
        return asyncEventQueueIds;
    }

    private Set<String> getConfiguredGatewaySenderIds() {
        HashSet<String> gatewaySenderIds = new HashSet<String>();
        CollectionUtils.nullSafeList(this.gatewaySenders).stream().filter(Objects::nonNull).map(GatewaySender::getId).collect(Collectors.toCollection(() -> gatewaySenderIds));
        CollectionUtils.nullSafeList(this.gatewaySenderIds).stream().filter(StringUtils::hasText).map(String::trim).collect(Collectors.toCollection(() -> gatewaySenderIds));
        return gatewaySenderIds;
    }

    DataPolicy getDataPolicy(RegionFactory regionFactory, RegionShortcut regionShortcut) {
        return this.getFieldValue(regionFactory, "attrsFactory", AttributesFactory.class).flatMap(attributesFactory -> this.getFieldValue(attributesFactory, "regionAttributes", null)).map(regionAttributes -> ((RegionAttributes)regionAttributes).getDataPolicy()).orElseGet(() -> RegionShortcutToDataPolicyConverter.INSTANCE.convert(regionShortcut));
    }

    private <T> Optional<T> getFieldValue(Object source, String fieldName, Class<T> targetType) {
        return Optional.ofNullable(source).map(Object::getClass).map(type -> ReflectionUtils.findField((Class)type, (String)fieldName, (Class)targetType)).map(field -> {
            ReflectionUtils.makeAccessible((Field)field);
            return field;
        }).map(field -> ReflectionUtils.getField((Field)field, (Object)source));
    }

    protected <K, V> RegionFactory<K, V> mergeRegionAttributes(RegionFactory<K, V> regionFactory, RegionAttributes<K, V> regionAttributes) {
        if (regionAttributes != null) {
            this.validateRegionAttributes(regionAttributes);
            CollectionUtils.nullSafeSet(regionAttributes.getAsyncEventQueueIds()).stream().filter(StringUtils::hasText).forEach(arg_0 -> regionFactory.addAsyncEventQueueId(arg_0));
            regionFactory.setCloningEnabled(regionAttributes.getCloningEnabled());
            regionFactory.setCompressor(regionAttributes.getCompressor());
            regionFactory.setConcurrencyChecksEnabled(regionAttributes.getConcurrencyChecksEnabled());
            regionFactory.setConcurrencyLevel(regionAttributes.getConcurrencyLevel());
            regionFactory.setCustomEntryIdleTimeout(regionAttributes.getCustomEntryIdleTimeout());
            regionFactory.setCustomEntryTimeToLive(regionAttributes.getCustomEntryTimeToLive());
            regionFactory.setDiskSynchronous(regionAttributes.isDiskSynchronous());
            regionFactory.setEnableAsyncConflation(regionAttributes.getEnableAsyncConflation());
            regionFactory.setEnableSubscriptionConflation(regionAttributes.getEnableSubscriptionConflation());
            regionFactory.setEntryIdleTimeout(regionAttributes.getEntryIdleTimeout());
            regionFactory.setEntryTimeToLive(regionAttributes.getEntryTimeToLive());
            if (this.isUserSpecifiedEvictionAttributes(regionAttributes)) {
                regionFactory.setEvictionAttributes(regionAttributes.getEvictionAttributes());
            }
            CollectionUtils.nullSafeSet(regionAttributes.getGatewaySenderIds()).stream().filter(StringUtils::hasText).forEach(arg_0 -> regionFactory.addGatewaySenderId(arg_0));
            regionFactory.setIgnoreJTA(regionAttributes.getIgnoreJTA());
            regionFactory.setIndexMaintenanceSynchronous(regionAttributes.getIndexMaintenanceSynchronous());
            regionFactory.setInitialCapacity(regionAttributes.getInitialCapacity());
            regionFactory.setKeyConstraint(regionAttributes.getKeyConstraint());
            regionFactory.setLoadFactor(regionAttributes.getLoadFactor());
            regionFactory.setLockGrantor(regionAttributes.isLockGrantor());
            regionFactory.setMembershipAttributes(regionAttributes.getMembershipAttributes());
            regionFactory.setMulticastEnabled(regionAttributes.getMulticastEnabled());
            regionFactory.setOffHeap(regionAttributes.getOffHeap());
            this.mergePartitionAttributes(regionFactory, regionAttributes);
            regionFactory.setPoolName(regionAttributes.getPoolName());
            regionFactory.setRegionIdleTimeout(regionAttributes.getRegionIdleTimeout());
            regionFactory.setRegionTimeToLive(regionAttributes.getRegionTimeToLive());
            regionFactory.setStatisticsEnabled(regionAttributes.getStatisticsEnabled());
            regionFactory.setSubscriptionAttributes(regionAttributes.getSubscriptionAttributes());
            regionFactory.setValueConstraint(regionAttributes.getValueConstraint());
        }
        return regionFactory;
    }

    protected <K, V> void mergePartitionAttributes(RegionFactory<K, V> regionFactory, RegionAttributes<K, V> regionAttributes) {
        if (regionAttributes.getPartitionAttributes() != null) {
            PartitionAttributes partitionAttributes = regionAttributes.getPartitionAttributes();
            PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory(partitionAttributes);
            RegionShortcutWrapper shortcutWrapper = RegionShortcutWrapper.valueOf(this.shortcut);
            if (shortcutWrapper.isRedundant() && partitionAttributes.getRedundantCopies() == 0) {
                partitionAttributesFactory.setRedundantCopies(1);
            }
            if (shortcutWrapper.isProxy()) {
                partitionAttributesFactory.setLocalMaxMemory(0);
            }
            regionFactory.setPartitionAttributes(partitionAttributesFactory.create());
        }
    }

    private boolean isDiskStoreConfigurationAllowed() {
        boolean allow = StringUtils.hasText((String)this.diskStoreName);
        return allow &= this.getDataPolicy().withPersistence() || this.getAttributes() != null && this.getAttributes().getEvictionAttributes() != null && EvictionAction.OVERFLOW_TO_DISK.equals(this.attributes.getEvictionAttributes().getAction());
    }

    boolean isUserSpecifiedEvictionAttributes(RegionAttributes<?, ?> regionAttributes) {
        SpringUtils.ValueReturningThrowableOperation<Boolean> hasEvictionAttributes = () -> Optional.ofNullable(regionAttributes).map(Object::getClass).map(type -> ReflectionUtils.findMethod((Class)type, (String)"hasEvictionAttributes")).map(method -> ReflectionUtils.invokeMethod((Method)method, (Object)regionAttributes)).map(Boolean.TRUE::equals).orElse(false);
        return SpringUtils.safeGetValue(hasEvictionAttributes, false);
    }

    void validateRegionAttributes(RegionAttributes regionAttributes) {
        AttributesFactory.validateAttributes((RegionAttributes)regionAttributes);
    }

    protected boolean isNotPersistent() {
        return Boolean.FALSE.equals(this.persistent);
    }

    protected boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, DataPolicy dataPolicy) {
        if (dataPolicy != null) {
            RegionUtils.assertDataPolicyAndPersistentAttributeAreCompatible(dataPolicy, this.persistent);
            regionFactory.setDataPolicy(dataPolicy);
            this.setDataPolicy(dataPolicy);
        } else {
            this.resolveDataPolicy(regionFactory, persistent, (String)null);
        }
    }

    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        if (dataPolicy != null) {
            DataPolicy resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy [%s] is invalid", dataPolicy));
            RegionUtils.assertDataPolicyAndPersistentAttributeAreCompatible(resolvedDataPolicy, this.persistent);
            regionFactory.setDataPolicy(resolvedDataPolicy);
            this.setDataPolicy(resolvedDataPolicy);
        } else {
            DataPolicy regionAttributesDataPolicy = this.getDataPolicy(this.getAttributes(), DataPolicy.DEFAULT);
            DataPolicy resolvedDataPolicy = this.isPersistent() && DataPolicy.DEFAULT.equals(regionAttributesDataPolicy) ? DataPolicy.PERSISTENT_REPLICATE : regionAttributesDataPolicy;
            RegionUtils.assertDataPolicyAndPersistentAttributeAreCompatible(resolvedDataPolicy, this.persistent);
            regionFactory.setDataPolicy(resolvedDataPolicy);
            this.setDataPolicy(resolvedDataPolicy);
        }
    }

    private DataPolicy getDataPolicy(RegionAttributes regionAttributes, DataPolicy defaultDataPolicy) {
        return Optional.ofNullable(regionAttributes).map(RegionAttributes::getDataPolicy).orElse(defaultDataPolicy);
    }

    public void destroy() throws Exception {
        Optional.ofNullable(this.getObject()).ifPresent(region -> {
            if (this.close && RegionUtils.isCloseable(region)) {
                RegionUtils.close(region);
            }
            if (this.destroy) {
                region.destroyRegion();
            }
        });
    }

    public void setAsyncEventQueues(@NonNull AsyncEventQueue[] asyncEventQueues) {
        this.asyncEventQueues.clear();
        this.addAsyncEventQueues(asyncEventQueues);
    }

    public void setAsyncEventQueueIds(@NonNull String[] asyncEventQueueIds) {
        this.asyncEventQueueIds.clear();
        this.addAsyncEventQueueIds(asyncEventQueueIds);
    }

    public void addAsyncEventQueues(@NonNull AsyncEventQueue[] asyncEventQueues) {
        Arrays.stream(ArrayUtils.nullSafeArray(asyncEventQueues, AsyncEventQueue.class)).filter(Objects::nonNull).forEach(this.asyncEventQueues::add);
    }

    public void addAsyncEventQueueIds(@NonNull String[] asyncEventQueueIds) {
        Arrays.stream(ArrayUtils.nullSafeArray(asyncEventQueueIds, String.class)).filter(StringUtils::hasText).forEach(this.asyncEventQueueIds::add);
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }

    public RegionAttributes<K, V> getAttributes() {
        return Optional.ofNullable(this.getRegion()).map(Region::getAttributes).orElse(this.attributes);
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    @Override
    public void setCustomEntryIdleTimeout(CustomExpiry<K, V> customEntryIdleTimeout) {
        this.customEntryIdleTimeout = customEntryIdleTimeout;
    }

    @Override
    public void setCustomEntryTimeToLive(CustomExpiry<K, V> customEntryTimeToLive) {
        this.customEntryTimeToLive = customEntryTimeToLive;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    public DataPolicy getDataPolicy() {
        Assert.state((this.dataPolicy != null ? 1 : 0) != 0, (String)"Data Policy has not been properly resolved yet");
        return this.dataPolicy;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    @Override
    public void setEntryIdleTimeout(ExpirationAttributes entryIdleTimeout) {
        this.entryIdleTimeout = entryIdleTimeout;
    }

    @Override
    public void setEntryTimeToLive(ExpirationAttributes entryTimeToLive) {
        this.entryTimeToLive = entryTimeToLive;
    }

    @Override
    public void setEvictionAttributes(EvictionAttributes evictionAttributes) {
        this.evictionAttributes = evictionAttributes;
    }

    public void setGatewaySenders(@NonNull GatewaySender[] gatewaySenders) {
        this.gatewaySenders.clear();
        this.addGatewaySenders(gatewaySenders);
    }

    public void setGatewaySenderIds(@NonNull String[] gatewaySenderIds) {
        this.gatewaySenderIds.clear();
        this.addGatewaySendersIds(gatewaySenderIds);
    }

    public void addGatewaySenders(@NonNull GatewaySender[] gatewaySenders) {
        Arrays.stream(ArrayUtils.nullSafeArray(gatewaySenders, GatewaySender.class)).filter(Objects::nonNull).forEach(this.gatewaySenders::add);
    }

    public void addGatewaySendersIds(@NonNull String[] gatewaySenderIds) {
        Arrays.stream(ArrayUtils.nullSafeArray(gatewaySenderIds, String.class)).filter(StringUtils::hasText).forEach(this.gatewaySenderIds::add);
    }

    public void setOffHeap(Boolean offHeap) {
        this.offHeap = offHeap;
    }

    public Boolean getOffHeap() {
        return this.offHeap;
    }

    public boolean isOffHeap() {
        return Boolean.TRUE.equals(this.getOffHeap());
    }

    public void setKeyConstraint(Class<K> keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public void setRegionIdleTimeout(ExpirationAttributes regionIdleTimeout) {
        this.regionIdleTimeout = regionIdleTimeout;
    }

    @Override
    public void setRegionTimeToLive(ExpirationAttributes regionTimeToLive) {
        this.regionTimeToLive = regionTimeToLive;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setShortcut(RegionShortcut shortcut) {
        this.shortcut = shortcut;
    }

    public RegionShortcut getShortcut() {
        return this.shortcut;
    }

    public void setStatisticsEnabled(Boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public Boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public boolean isStatisticsEnabled() {
        return Boolean.TRUE.equals(this.getStatisticsEnabled());
    }

    protected boolean resolveStatisticsEnabled() {
        return this.isStatisticsEnabled() || this.customEntryIdleTimeout != null || this.customEntryTimeToLive != null || this.entryIdleTimeout != null || this.entryTimeToLive != null || this.regionIdleTimeout != null || this.regionTimeToLive != null || Optional.ofNullable(this.getAttributes()).map(RegionAttributes::getStatisticsEnabled).orElse(false) != false;
    }

    public void setValueConstraint(Class<V> valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.gatewaySenders.isEmpty()) {
            List<GatewaySender> list = this.gatewaySenders;
            synchronized (list) {
                this.gatewaySenders.stream().filter(Objects::nonNull).filter(gatewaySender -> !gatewaySender.isManualStart()).filter(gatewaySender -> !gatewaySender.isRunning()).forEach(GatewaySender::start);
            }
        }
        this.running = true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.gatewaySenders.isEmpty()) {
            List<GatewaySender> list = this.gatewaySenders;
            synchronized (list) {
                this.gatewaySenders.forEach(GatewaySender::stop);
            }
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return true;
    }
}

