/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.tests.util.IOUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public abstract class ZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(Resource zipResource, File directory) throws IOException {
        Assert.notNull((Object)zipResource, (String)"ZIP Resource is required");
        Assert.isTrue((directory != null && directory.isDirectory() ? 1 : 0) != 0, (String)String.format("The file system pathname (%1$s) is not a valid directory!", directory));
        ZipFile zipFile = new ZipFile(zipResource.getFile(), 1);
        for (ZipEntry entry : CollectionUtils.iterable(zipFile.entries())) {
            if (entry.isDirectory()) {
                new File(directory, entry.getName()).mkdirs();
                continue;
            }
            DataInputStream entryInputStream = new DataInputStream(zipFile.getInputStream(entry));
            DataOutputStream entryOutputStream = new DataOutputStream(new FileOutputStream(new File(directory, entry.getName())));
            try {
                FileCopyUtils.copy((InputStream)entryInputStream, (OutputStream)entryOutputStream);
            }
            finally {
                IOUtils.close(entryInputStream);
                IOUtils.close(entryOutputStream);
            }
        }
    }
}

