/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.NonNull;

public abstract class ThreadUtils {
    public static boolean sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
            return true;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static boolean timedWait(@NonNull Duration duration) {
        return ThreadUtils.timedWait(duration.toMillis());
    }

    public static boolean timedWait(long duration) {
        return ThreadUtils.timedWait(duration, duration);
    }

    public static boolean timedWait(@NonNull Duration duration, long interval) {
        return ThreadUtils.timedWait(duration.toMillis(), interval);
    }

    public static boolean timedWait(long duration, long interval) {
        return ThreadUtils.timedWait(duration, interval, () -> true);
    }

    public static boolean timedWait(@NonNull Duration duration, long interval, @NonNull Condition condition) {
        return ThreadUtils.timedWait(duration.toMillis(), interval, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean timedWait(long duration, long interval, @NonNull Condition condition) {
        long timeout = System.currentTimeMillis() + duration;
        interval = Math.min(interval, duration);
        try {
            while (!condition.evaluate() && System.currentTimeMillis() < timeout) {
                Condition condition2 = condition;
                synchronized (condition2) {
                    TimeUnit.MILLISECONDS.timedWait(condition, interval);
                }
            }
            return condition.evaluate();
        }
        catch (InterruptedException cause) {
            Thread.currentThread().interrupt();
        }
        return condition.evaluate();
    }

    @Deprecated
    public static interface WaitCondition
    extends Condition {
        default public boolean waiting() {
            return this.evaluate();
        }
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean evaluate();
    }
}

