/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.util.Optional;
import java.util.function.Function;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;

public abstract class SpringUtils
extends org.springframework.data.gemfire.util.SpringUtils {
    public static final Function<ConfigurableApplicationContext, Boolean> APPLICATION_CONTEXT_CLOSING_FUNCTION = applicationContext -> {
        if (applicationContext != null) {
            applicationContext.close();
            return true;
        }
        return false;
    };

    public static boolean isApplicationContextActive(@Nullable ApplicationContext applicationContext) {
        return Optional.ofNullable(applicationContext).filter(ConfigurableApplicationContext.class::isInstance).map(ConfigurableApplicationContext.class::cast).map(ConfigurableApplicationContext::isActive).orElse(false);
    }

    public static boolean closeApplicationContext(@Nullable ApplicationContext applicationContext) {
        return Optional.ofNullable(applicationContext).filter(ConfigurableApplicationContext.class::isInstance).map(ConfigurableApplicationContext.class::cast).map(APPLICATION_CONTEXT_CLOSING_FUNCTION).orElse(false);
    }
}

