/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class ReflectionUtils
extends org.springframework.util.ReflectionUtils {
    public static <T> T getFieldValue(Object target, String fieldName) throws NoSuchFieldException {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Assert.hasText((String)fieldName, (String)String.format("Field name [%s] must be specified", fieldName));
        Field field = ReflectionUtils.findField(target.getClass(), (String)fieldName);
        return (T)Optional.ofNullable(field).map(ReflectionUtils::makeAccessibleReturnField).map(it -> ReflectionUtils.getField((Field)it, (Object)target)).orElseThrow(() -> new NoSuchFieldException(String.format("Field with name [%s] was not found on Object of type [%s]", fieldName, target.getClass().getName())));
    }

    public static Constructor makeAccessibleReturnConstructor(Constructor constructor) {
        ReflectionUtils.makeAccessible((Constructor)constructor);
        return constructor;
    }

    public static Field makeAccessibleReturnField(Field field) {
        ReflectionUtils.makeAccessible((Field)field);
        return field;
    }

    public static Method makeAccessibleReturnMethod(Method method) {
        ReflectionUtils.makeAccessible((Method)method);
        return method;
    }

    public static <T> T setField(T target, String fieldName, Object value) throws NoSuchFieldException {
        Assert.notNull(target, (String)"Target object must not be null");
        Assert.hasText((String)fieldName, (String)String.format("Field name [%s] must be specified", fieldName));
        Field field = ReflectionUtils.findField(target.getClass(), (String)fieldName);
        if (field != null) {
            Class<?> fieldType = field.getType();
            Assert.isTrue((value == null || fieldType.isInstance(value) ? 1 : 0) != 0, (String)String.format("The value type [%1$s] is not assignment compatible with the field type [%2$s]", ObjectUtils.nullSafeClassName((Object)value), fieldType.getName()));
            ReflectionUtils.makeAccessibleReturnField(field);
            ReflectionUtils.setField((Field)field, target, (Object)value);
            return target;
        }
        throw new NoSuchFieldException(String.format("Field [%s] was not found on Object of type [%s]", fieldName, target.getClass().getName()));
    }
}

