/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

public abstract class ObjectUtils {
    public static <T> T doOperationSafely(ExceptionThrowingOperation<T> operation) {
        return ObjectUtils.doOperationSafely(operation, null);
    }

    public static <T> T doOperationSafely(ExceptionThrowingOperation<T> operation, T defaultValue) {
        try {
            return operation.doExceptionThrowingOperation();
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }

    public static <T> T rethrowAsRuntimeException(ExceptionThrowingOperation<T> operation) {
        try {
            return operation.doExceptionThrowingOperation();
        }
        catch (RuntimeException cause) {
            throw cause;
        }
        catch (Throwable cause) {
            throw new RuntimeException(cause);
        }
    }

    @FunctionalInterface
    public static interface ExceptionThrowingOperation<T> {
        public T doExceptionThrowingOperation() throws Exception;
    }
}

