/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.data.gemfire.tests.util.FileUtils;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class FileSystemUtils
extends FileUtils {
    public static final File JAVA_HOME = new File(System.getProperty("java.home"));
    public static final File JAVA_EXE = new File(new File(JAVA_HOME, "bin"), "java");
    public static final File TEMPORARY_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    public static final File USER_HOME = new File(System.getProperty("user.home"));
    public static final File WORKING_DIRECTORY = new File(System.getProperty("user.dir"));
    public static final File[] NO_FILES = new File[0];

    public static boolean deleteRecursive(File path) {
        return FileSystemUtils.deleteRecursive(path, AllFilesFilter.INSTANCE);
    }

    public static boolean deleteRecursive(File path, FileFilter fileFilter) {
        boolean success = true;
        if (FileSystemUtils.isDirectory(path)) {
            for (File file : FileSystemUtils.safeListFiles(path, fileFilter)) {
                success &= FileSystemUtils.deleteRecursive(file);
            }
        }
        return (!FileSystemUtils.exists(path) || path.delete()) && success;
    }

    public static boolean exists(@Nullable File path) {
        return path != null && path.exists();
    }

    @Nullable
    public static File getRootRelativeToWorkingDirectoryOrPath(@Nullable File path) {
        File localPath = path;
        if (FileSystemUtils.isDirectory(localPath)) {
            while (localPath != null && !WORKING_DIRECTORY.equals(localPath.getParentFile())) {
                localPath = localPath.getParentFile();
            }
        }
        return localPath != null ? localPath : path;
    }

    public static boolean isEmpty(File path) {
        return FileSystemUtils.isDirectory(path) ? ArrayUtils.isEmpty((Object[])path.listFiles()) : FileSystemUtils.nullSafeLength(path) == 0L;
    }

    @NonNull
    public static File[] listFiles(@NonNull File directory, @NonNull FileFilter fileFilter) {
        Assert.isTrue((boolean)FileSystemUtils.isDirectory(directory), (String)String.format("File [%s] does not refer to a valid directory", directory));
        ArrayList<File> results = new ArrayList<File>();
        for (File file : FileSystemUtils.safeListFiles(directory, fileFilter)) {
            if (FileSystemUtils.isDirectory(file)) {
                results.addAll(Arrays.asList(FileSystemUtils.listFiles(file, fileFilter)));
                continue;
            }
            results.add(file);
        }
        return results.toArray(new File[0]);
    }

    @NonNull
    public static File[] safeListFiles(@Nullable File directory) {
        return FileSystemUtils.safeListFiles(directory, AllFilesFilter.INSTANCE);
    }

    @NonNull
    public static File[] safeListFiles(@Nullable File directory, @Nullable FileFilter fileFilter) {
        FileFilter resolvedFileFilter = fileFilter != null ? fileFilter : AllFilesFilter.INSTANCE;
        File[] files = FileSystemUtils.isDirectory(directory) ? directory.listFiles(resolvedFileFilter) : null;
        return files != null ? files : NO_FILES;
    }

    public static class NegatingFileFilter
    implements FileFilter {
        private final FileFilter delegate;

        public static NegatingFileFilter newNegatingFileFilter(FileFilter delegate) {
            return new NegatingFileFilter(delegate);
        }

        public NegatingFileFilter(FileFilter delegate) {
            Assert.notNull((Object)delegate, (String)"FileFilter must not be null");
            this.delegate = delegate;
        }

        @Override
        public boolean accept(File pathname) {
            return !this.delegate.accept(pathname);
        }
    }

    public static class FileOnlyFilter
    implements FileFilter {
        public static final FileOnlyFilter INSTANCE = new FileOnlyFilter();

        @Override
        public boolean accept(File pathname) {
            return FileUtils.isFile(pathname);
        }
    }

    public static final class FileExtensionFilter
    extends FileOnlyFilter {
        private final String fileExtension;

        public static FileExtensionFilter newFileExtensionFilter(String fileExtension) {
            return new FileExtensionFilter(fileExtension);
        }

        public FileExtensionFilter(String fileExtension) {
            Assert.hasText((String)fileExtension, (String)String.format("File extension [%s] must be specified", fileExtension));
            this.fileExtension = fileExtension;
        }

        @Override
        public boolean accept(File pathname) {
            return super.accept(pathname) && pathname.getAbsolutePath().toLowerCase().endsWith(this.fileExtension);
        }
    }

    public static class DirectoryOnlyFilter
    implements FileFilter {
        public static final DirectoryOnlyFilter INSTANCE = new DirectoryOnlyFilter();

        @Override
        public boolean accept(File pathname) {
            return FileUtils.isDirectory(pathname);
        }
    }

    public static class CompositeFileFilter
    implements FileFilter {
        private final FileFilter fileFilterOne;
        private final FileFilter fileFilterTwo;
        private final LogicalOperator logicalOperator;

        private CompositeFileFilter(FileFilter fileFilterOne, LogicalOperator operator, FileFilter fileFilterTwo) {
            this.fileFilterOne = fileFilterOne;
            this.logicalOperator = operator;
            this.fileFilterTwo = fileFilterTwo;
        }

        protected static FileFilter compose(FileFilter fileFilterOne, LogicalOperator operator, FileFilter fileFilterTwo) {
            return fileFilterOne == null ? fileFilterTwo : (fileFilterTwo == null ? fileFilterOne : new CompositeFileFilter(fileFilterOne, operator, fileFilterTwo));
        }

        public static FileFilter and(FileFilter ... fileFilters) {
            return CompositeFileFilter.and(Arrays.asList(ArrayUtils.nullSafeArray((Object[])fileFilters, FileFilter.class)));
        }

        public static FileFilter and(Iterable<FileFilter> fileFilters) {
            FileFilter current = null;
            for (FileFilter fileFilter : CollectionUtils.nullSafeIterable(fileFilters)) {
                current = CompositeFileFilter.compose(current, LogicalOperator.AND, fileFilter);
            }
            return current;
        }

        public static FileFilter or(FileFilter ... fileFilters) {
            return CompositeFileFilter.or(Arrays.asList(ArrayUtils.nullSafeArray((Object[])fileFilters, FileFilter.class)));
        }

        public static FileFilter or(Iterable<FileFilter> fileFilters) {
            FileFilter current = null;
            for (FileFilter fileFilter : CollectionUtils.nullSafeIterable(fileFilters)) {
                current = CompositeFileFilter.compose(current, LogicalOperator.OR, fileFilter);
            }
            return current;
        }

        @Override
        public boolean accept(File pathname) {
            switch (this.logicalOperator) {
                case AND: {
                    return this.fileFilterOne.accept(pathname) && this.fileFilterTwo.accept(pathname);
                }
                case OR: {
                    return this.fileFilterOne.accept(pathname) || this.fileFilterTwo.accept(pathname);
                }
            }
            throw new UnsupportedOperationException(String.format("Logical operator [%s] is unsupported", new Object[]{this.logicalOperator}));
        }

        static enum LogicalOperator {
            AND,
            OR;

        }
    }

    public static class AllFilesFilter
    implements FileFilter {
        public static final AllFilesFilter INSTANCE = new AllFilesFilter();

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    }
}

