/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.gemfire.tests.util.FileSystemUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ProcessConfiguration {
    private final boolean redirectingErrorStream;
    private final File workingDirectory;
    private final List<String> command;
    private final Map<String, String> environment;

    public static ProcessConfiguration create(ProcessBuilder processBuilder) {
        Assert.notNull((Object)processBuilder, (String)"The ProcessBuilder used to configure and start the Process must not be null");
        return new ProcessConfiguration(processBuilder.command(), processBuilder.directory(), processBuilder.environment(), processBuilder.redirectErrorStream());
    }

    public ProcessConfiguration(List<String> command, File workingDirectory, Map<String, String> environment, boolean redirectErrorStream) {
        Assert.notEmpty(command, (String)"Process command is required");
        Assert.isTrue((boolean)FileSystemUtils.isDirectory(workingDirectory), (String)String.format("Process working directory [%s] is not valid", workingDirectory));
        this.command = Collections.unmodifiableList(new ArrayList<String>(command));
        this.workingDirectory = workingDirectory;
        this.redirectingErrorStream = redirectErrorStream;
        this.environment = environment != null ? Collections.unmodifiableMap(new HashMap<String, String>(environment)) : Collections.emptyMap();
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommandString() {
        return StringUtils.arrayToDelimitedString((Object[])this.getCommand().toArray(), (String)" ");
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public boolean isRedirectingErrorStream() {
        return this.redirectingErrorStream;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String toString() {
        return "{ command = ".concat(this.getCommandString()).concat(", workingDirectory = ".concat(this.getWorkingDirectory().getAbsolutePath())).concat(", environment = ".concat(String.valueOf(this.getEnvironment()))).concat(", redirectingErrorStream = ".concat(String.valueOf(this.isRedirectingErrorStream()))).concat(" }");
    }
}

