/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.objects.geode.cache;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.geode.cache.Region;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class RegionDataInitializingPostProcessor<T> {
    private Function<T, Object> entityIdentifierFunction;
    private final Map<Object, T> regionData = new ConcurrentHashMap<Object, T>();
    private final String regionBeanName;

    public static <T> EntityIdentifierBuilder<T> withRegion(@NonNull String regionBeanName) {
        return new EntityIdentifierBuilder(new RegionDataInitializingPostProcessor<T>(regionBeanName));
    }

    protected RegionDataInitializingPostProcessor(@NonNull String regionBeanName) {
        Assert.hasText((String)regionBeanName, (String)String.format("Region bean name [%s] must be specified", regionBeanName));
        this.regionBeanName = regionBeanName;
    }

    @NonNull
    public String getRegionBeanName() {
        return this.regionBeanName;
    }

    @NonNull
    protected Function<T, Object> getEntityIdentifierFunction() {
        return this.entityIdentifierFunction;
    }

    @NonNull
    public Map<Object, T> getRegionData() {
        return this.regionData;
    }

    protected boolean isTargetRegion(Object bean, String beanName) {
        return bean instanceof Region && this.getRegionBeanName().equals(beanName);
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void initializeTargetRegionWithData(@NonNull ContextRefreshedEvent event) {
        this.resolveTargetRegion(event).ifPresent(resolvedTargetRegion -> resolvedTargetRegion.putAll(this.getRegionData()));
    }

    protected Optional<ApplicationContext> resolveApplicationContext(@NonNull ContextRefreshedEvent event) {
        return Optional.ofNullable(event).map(ApplicationContextEvent::getApplicationContext).map(Optional::of).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"Failed to resolve ApplicationContext from ContextRefreshedEvent [%s]", (Object[])new Object[]{event}));
    }

    protected Optional<Region<Object, T>> resolveTargetRegion(@NonNull ContextRefreshedEvent event) {
        Region resolvedTargetRegion = this.resolveApplicationContext(event).map(applicationContext -> (Region)applicationContext.getBean(this.getRegionBeanName(), Region.class)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"Failed to resolve Region bean [%s] from ApplicationContext", (Object[])new Object[]{this.getRegionBeanName()}));
        return Optional.of(resolvedTargetRegion);
    }

    public RegionDataInitializingPostProcessor<T> store(T entity) {
        this.getRegionData().put(this.getEntityIdentifierFunction().apply(entity), entity);
        return this;
    }

    protected RegionDataInitializingPostProcessor<T> useEntityIdentifierFunction(@NonNull Function<T, Object> entityIdentifierFunction) {
        Assert.notNull(entityIdentifierFunction, (String)"The Function used to resolve the entity's identify (identifier) must not be null");
        this.entityIdentifierFunction = entityIdentifierFunction;
        return this;
    }

    public static class EntityIdentifierBuilder<T> {
        private final RegionDataInitializingPostProcessor<T> postProcessor;

        private EntityIdentifierBuilder(@NonNull RegionDataInitializingPostProcessor<T> postProcessor) {
            Assert.notNull(postProcessor, (String)"RegionDataInitializingPostProcess must not be null");
            this.postProcessor = postProcessor;
        }

        public RegionDataInitializingPostProcessor<T> useAsEntityIdentifier(@NonNull Function<T, Object> entityIdentifierFunction) {
            return this.postProcessor.useEntityIdentifierFunction(entityIdentifierFunction);
        }
    }
}

