/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock.test.context;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.data.gemfire.tests.extensions.spring.test.context.event.TestContextEventType;
import org.springframework.data.gemfire.tests.mock.GemFireMockObjectsSupport;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;

public class DestroyGemFireMockObjectsTestExecutionListener
implements TestExecutionListener {
    private static final AtomicReference<DestroyGemFireMockObjectsTestExecutionListener> instance = new AtomicReference<Object>(null);
    private final Set<TestContextEventType> destroyOnEventTypes = Collections.synchronizedSet(new HashSet(TestContextEventType.values().length));

    public static Optional<DestroyGemFireMockObjectsTestExecutionListener> getInstance() {
        return Optional.ofNullable(instance.get());
    }

    public DestroyGemFireMockObjectsTestExecutionListener() {
        instance.set(this);
        this.enableDestroyOnEventType(TestContextEventType.AFTER_TEST_CLASS);
    }

    public boolean disableDestroyOnEventType(@Nullable TestContextEventType eventType) {
        return eventType != null && (this.destroyOnEventTypes.remove((Object)eventType) || !this.destroyOnEventTypes.contains((Object)eventType));
    }

    public boolean enableDestroyOnEventType(@Nullable TestContextEventType eventType) {
        return eventType != null && (this.destroyOnEventTypes.add(eventType) || this.destroyOnEventTypes.contains((Object)eventType));
    }

    protected boolean isDestroyOnEventTypeEnabled(@Nullable TestContextEventType eventType) {
        return this.destroyOnEventTypes.contains((Object)eventType);
    }

    public void beforeTestClass(@NonNull TestContext testContext) {
        if (this.isDestroyOnEventTypeEnabled(TestContextEventType.BEFORE_TEST_CLASS)) {
            this.destroyGemFireMockObjects();
        }
    }

    public void prepareTestInstance(@NonNull TestContext testContext) {
        if (this.isDestroyOnEventTypeEnabled(TestContextEventType.PREPARE_TEST_INSTANCE)) {
            this.destroyGemFireMockObjects();
        }
    }

    public void beforeTestMethod(@NonNull TestContext testContext) {
        if (this.isDestroyOnEventTypeEnabled(TestContextEventType.BEFORE_TEST_METHOD)) {
            this.destroyGemFireMockObjects();
        }
    }

    public void beforeTestExecution(@NonNull TestContext testContext) {
        if (this.isDestroyOnEventTypeEnabled(TestContextEventType.BEFORE_TEST_EXECUTION)) {
            this.destroyGemFireMockObjects();
        }
    }

    public void afterTestExecution(@NonNull TestContext testContext) {
        if (this.isDestroyOnEventTypeEnabled(TestContextEventType.AFTER_TEST_EXECUTION)) {
            this.destroyGemFireMockObjects();
        }
    }

    public void afterTestMethod(@NonNull TestContext testContext) {
        if (this.isDestroyOnEventTypeEnabled(TestContextEventType.AFTER_TEST_METHOD)) {
            this.destroyGemFireMockObjects();
        }
    }

    public void afterTestClass(@NonNull TestContext testContext) {
        if (this.isDestroyOnEventTypeEnabled(TestContextEventType.AFTER_TEST_CLASS)) {
            this.destroyGemFireMockObjects();
        }
    }

    protected void destroyGemFireMockObjects() {
        GemFireMockObjectsSupport.destroy();
    }
}

