/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock.context.event;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.data.gemfire.tests.mock.GemFireMockObjectsSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class DestroyGemFireMockObjectsApplicationListener
implements ApplicationListener<ApplicationEvent> {
    private final Set<Class<? extends ApplicationEvent>> configuredDestroyEventTypes;

    public static DestroyGemFireMockObjectsApplicationListener newInstance(Class<? extends ApplicationEvent> ... destroyEventTypes) {
        return DestroyGemFireMockObjectsApplicationListener.newInstance(Arrays.asList(ArrayUtils.nullSafeArray((Object[])destroyEventTypes, Class.class)));
    }

    public static DestroyGemFireMockObjectsApplicationListener newInstance(@Nullable Iterable<Class<? extends ApplicationEvent>> destroyEventTypes) {
        return new DestroyGemFireMockObjectsApplicationListener(destroyEventTypes);
    }

    public DestroyGemFireMockObjectsApplicationListener(@Nullable Iterable<Class<? extends ApplicationEvent>> destroyEventTypes) {
        Set resolvedDestroyEventTypes = StreamSupport.stream(CollectionUtils.nullSafeIterable(destroyEventTypes).spliterator(), false).filter(Objects::nonNull).collect(Collectors.toSet());
        this.configuredDestroyEventTypes = Collections.unmodifiableSet(resolvedDestroyEventTypes);
    }

    @NonNull
    protected Set<Class<? extends ApplicationEvent>> getConfiguredDestroyEventTypes() {
        return this.configuredDestroyEventTypes;
    }

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (this.isDestroyEvent(event)) {
            this.destroyGemFireMockObjects();
        }
    }

    protected boolean isDestroyEvent(@Nullable ApplicationEvent event) {
        for (Class<? extends ApplicationEvent> configuredDestroyEventType : this.getConfiguredDestroyEventTypes()) {
            if (!configuredDestroyEventType.isInstance(event)) continue;
            return true;
        }
        return false;
    }

    protected void destroyGemFireMockObjects() {
        GemFireMockObjectsSupport.destroy();
    }
}

