/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock.beans.factory.config;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.Region;
import org.mockito.Mockito;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class RegionSpyingBeanPostProcessor
implements BeanPostProcessor {
    private final Set<String> regionBeanNames;

    public RegionSpyingBeanPostProcessor(String ... regionBeanNames) {
        this(Arrays.asList(ArrayUtils.nullSafeArray((Object[])regionBeanNames, String.class)));
    }

    public RegionSpyingBeanPostProcessor(@NonNull Iterable<String> regionBeanNames) {
        this.regionBeanNames = StreamSupport.stream(CollectionUtils.nullSafeIterable(regionBeanNames).spliterator(), false).filter(StringUtils::hasText).collect(Collectors.toSet());
    }

    protected boolean isRegion(@Nullable Object target) {
        return target instanceof Region;
    }

    protected boolean isRegionBeanNameMatch(@NonNull String beanName) {
        return this.regionBeanNames.isEmpty() || StringUtils.hasText((String)beanName) && this.regionBeanNames.contains(beanName);
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        return this.isRegion(bean) && this.isRegionBeanNameMatch(beanName) ? this.doSpy(bean) : bean;
    }

    @Nullable
    protected <T> T doSpy(@Nullable T target) {
        return (T)(target != null ? Mockito.spy(target) : target);
    }
}

