/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock.beans.factory.config;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.distributed.DistributedSystem;
import org.mockito.Mockito;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.data.gemfire.AbstractBasicCacheFactoryBean;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.tests.mock.GemFireMockObjectsSupport;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class GemFireMockObjectsBeanPostProcessor
implements BeanPostProcessor {
    protected static final boolean DEFAULT_USE_SINGLETON_CACHE = false;
    protected static final String GEMFIRE_PROPERTIES_BEAN_NAME = "gemfireProperties";
    private volatile boolean useSingletonCache;
    private final AtomicReference<Properties> gemfireProperties = new AtomicReference<Properties>(new Properties());

    @NonNull
    public static GemFireMockObjectsBeanPostProcessor newInstance() {
        return GemFireMockObjectsBeanPostProcessor.newInstance(false);
    }

    @NonNull
    public static GemFireMockObjectsBeanPostProcessor newInstance(boolean useSingletonCache) {
        GemFireMockObjectsBeanPostProcessor beanPostProcessor = new GemFireMockObjectsBeanPostProcessor();
        beanPostProcessor.useSingletonCache = useSingletonCache;
        return beanPostProcessor;
    }

    @Nullable
    public Object postProcessBeforeInitialization(@Nullable Object bean, @NonNull String beanName) throws BeansException {
        return this.isGemFireProperties(bean, beanName) ? this.set((Properties)bean) : (this.isCacheFactoryBean(bean) ? this.spyOnCacheFactoryBean((CacheFactoryBean)bean, this.isUsingSingletonCache()) : (this.isPoolFactoryBean(bean) ? this.mockPoolFactoryBean((PoolFactoryBean)bean) : bean));
    }

    @Nullable
    public Object postProcessAfterInitialization(@Nullable Object bean, @NonNull String beanName) throws BeansException {
        if (bean instanceof GemFireCache) {
            GemFireCache gemfireCache = (GemFireCache)bean;
            DistributedSystem distributedSystem = gemfireCache.getDistributedSystem();
            Properties distributedSystemProperties = distributedSystem.getProperties();
            if (distributedSystemProperties != null) {
                distributedSystemProperties.putAll((Map<?, ?>)this.getGemFireProperties());
            } else {
                ((DistributedSystem)Mockito.doReturn((Object)this.getGemFireProperties()).when((Object)distributedSystem)).getProperties();
            }
        }
        return bean;
    }

    private boolean isCacheFactoryBean(@Nullable Object bean) {
        return bean instanceof CacheFactoryBean;
    }

    private boolean isGemFireProperties(@Nullable Object bean, @Nullable String beanName) {
        return bean instanceof Properties && GEMFIRE_PROPERTIES_BEAN_NAME.equals(beanName);
    }

    private boolean isPoolFactoryBean(@Nullable Object bean) {
        return bean instanceof PoolFactoryBean;
    }

    protected boolean isUsingSingletonCache() {
        return this.useSingletonCache;
    }

    @Nullable
    private Object set(@Nullable Properties gemfireProperties) {
        this.gemfireProperties.set(gemfireProperties);
        return gemfireProperties;
    }

    @Nullable
    protected Properties getGemFireProperties() {
        return this.gemfireProperties.get();
    }

    @NonNull
    private Object spyOnCacheFactoryBean(@NonNull CacheFactoryBean bean, boolean useSingletonCache) {
        return bean instanceof ClientCacheFactoryBean ? SpyingClientCacheFactoryInitializer.spyOn((ClientCacheFactoryBean)bean, useSingletonCache) : SpyingCacheFactoryInitializer.spyOn(bean, useSingletonCache);
    }

    @NonNull
    private Object mockPoolFactoryBean(@NonNull PoolFactoryBean bean) {
        return MockingPoolFactoryInitializer.mock(bean);
    }

    protected static class MockingPoolFactoryInitializer
    implements PoolFactoryBean.PoolFactoryInitializer {
        protected MockingPoolFactoryInitializer() {
        }

        protected static PoolFactoryBean mock(PoolFactoryBean poolFactoryBean) {
            poolFactoryBean.setPoolFactoryInitializer((PoolFactoryBean.PoolFactoryInitializer)new MockingPoolFactoryInitializer());
            return poolFactoryBean;
        }

        public PoolFactory initialize(PoolFactory poolFactory) {
            return GemFireMockObjectsSupport.mockPoolFactory();
        }
    }

    protected static class SpyingClientCacheFactoryInitializer
    implements AbstractBasicCacheFactoryBean.CacheFactoryInitializer<ClientCacheFactory> {
        private final boolean useSingletonCache;

        protected static ClientCacheFactoryBean spyOn(ClientCacheFactoryBean clientCacheFactoryBean, boolean useSingletonCache) {
            clientCacheFactoryBean.setCacheFactoryInitializer((AbstractBasicCacheFactoryBean.CacheFactoryInitializer)new SpyingClientCacheFactoryInitializer(useSingletonCache));
            return clientCacheFactoryBean;
        }

        protected SpyingClientCacheFactoryInitializer(boolean useSingletonCache) {
            this.useSingletonCache = useSingletonCache;
        }

        protected boolean isUsingSingletonCache() {
            return this.useSingletonCache;
        }

        public ClientCacheFactory initialize(ClientCacheFactory clientCacheFactory) {
            return GemFireMockObjectsSupport.spyOn(clientCacheFactory, this.isUsingSingletonCache());
        }
    }

    protected static class SpyingCacheFactoryInitializer
    implements AbstractBasicCacheFactoryBean.CacheFactoryInitializer<CacheFactory> {
        private final boolean useSingletonCache;

        protected static CacheFactoryBean spyOn(CacheFactoryBean cacheFactoryBean, boolean useSingletonCache) {
            cacheFactoryBean.setCacheFactoryInitializer((AbstractBasicCacheFactoryBean.CacheFactoryInitializer)new SpyingCacheFactoryInitializer(useSingletonCache));
            return cacheFactoryBean;
        }

        protected SpyingCacheFactoryInitializer(boolean useSingletonCache) {
            this.useSingletonCache = useSingletonCache;
        }

        protected boolean isUsingSingletonCache() {
            return this.useSingletonCache;
        }

        public CacheFactory initialize(CacheFactory cacheFactory) {
            return GemFireMockObjectsSupport.spyOn(cacheFactory, this.isUsingSingletonCache());
        }
    }
}

