/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.geode.cache.Region;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.repository.GemfireRepository;
import org.springframework.data.gemfire.repository.support.SimpleGemfireRepository;
import org.springframework.data.gemfire.tests.mock.annotation.EnableGemFireMockObjects;
import org.springframework.data.gemfire.tests.mock.beans.factory.config.GemFireMockObjectsBeanPostProcessor;
import org.springframework.data.gemfire.tests.mock.context.event.DestroyGemFireMockObjectsApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.test.context.event.AfterTestClassEvent;
import org.springframework.util.Assert;

@Configuration
public class GemFireMockObjectsConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    public static final boolean DEFAULT_USE_SINGLETON_CACHE = false;
    private boolean useSingletonCache = false;
    private Class<? extends ApplicationEvent>[] destroyEventTypes = new Class[]{AfterTestClassEvent.class};

    public void setImportMetadata(@NonNull AnnotationMetadata importingClassMetadata) {
        Optional.of(importingClassMetadata).filter(arg_0 -> ((GemFireMockObjectsConfiguration)this).isAnnotationPresent(arg_0)).map(arg_0 -> ((GemFireMockObjectsConfiguration)this).getAnnotationAttributes(arg_0)).ifPresent(enableGemFireMockObjectsAttributes -> {
            this.destroyEventTypes = enableGemFireMockObjectsAttributes.getClassArray("destroyOnEvents");
            this.useSingletonCache = enableGemFireMockObjectsAttributes.getBoolean("useSingletonCache");
        });
    }

    @NonNull
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableGemFireMockObjects.class;
    }

    @NonNull
    protected Class<? extends ApplicationEvent>[] getConfiguredDestroyEventTypes() {
        return this.destroyEventTypes;
    }

    protected boolean isUseSingletonCacheConfigured() {
        return this.useSingletonCache;
    }

    @Bean
    @NonNull
    public ApplicationListener<ApplicationEvent> destroyGemFireMockObjectsApplicationListener() {
        return DestroyGemFireMockObjectsApplicationListener.newInstance(this.getConfiguredDestroyEventTypes());
    }

    @Bean
    @NonNull
    public BeanPostProcessor gemfireMockObjectsBeanPostProcessor() {
        return GemFireMockObjectsBeanPostProcessor.newInstance(this.isUseSingletonCacheConfigured());
    }

    @Bean
    @NonNull
    public BeanPostProcessor gemfireRepositoryBeanPostProcessor() {
        return new BeanPostProcessor(){

            @Nullable
            public Object postProcessAfterInitialization(@Nullable Object bean, @NonNull String beanName) throws BeansException {
                if (bean instanceof GemfireRepository) {
                    this.getRegion(bean).ifPresent(region -> {
                        if (bean instanceof Advised) {
                            Advised advisedBean = (Advised)bean;
                            advisedBean.addAdvice(0, (Advice)new CountMethodInterceptor((Region)region));
                        }
                    });
                }
                return bean;
            }

            private Optional<Region<?, ?>> getRegion(@Nullable Object bean) {
                return Optional.ofNullable(bean).map(AopProxyUtils::getSingletonTarget).filter(SimpleGemfireRepository.class::isInstance).map(SimpleGemfireRepository.class::cast).map(SimpleGemfireRepository::getRegion);
            }
        };
    }

    private static class CountMethodInterceptor
    implements MethodInterceptor {
        private static final String COUNT_METHOD_NAME = "count";
        private final Region region;

        private CountMethodInterceptor(@NonNull Region region) {
            Assert.notNull((Object)region, (String)"Region must not be null");
            this.region = region;
        }

        @NonNull
        private Region<?, ?> getRegion() {
            return this.region;
        }

        @Nullable
        public Object invoke(@NonNull MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            return this.isCountMethod(method) ? Long.valueOf(this.getRegion().size()) : invocation.proceed();
        }

        private boolean isCountMethod(@NonNull Method method) {
            return method != null && COUNT_METHOD_NAME.equals(method.getName());
        }
    }
}

