/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheCallback;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.EvictionAttributesMutator;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.SocketFactory;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneIndexFactory;
import org.apache.geode.cache.lucene.LuceneQuery;
import org.apache.geode.cache.lucene.LuceneQueryFactory;
import org.apache.geode.cache.lucene.LuceneQueryProvider;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.QueryStatistics;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ClientSubscriptionConfig;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.compression.Compressor;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.lucene.analysis.Analyzer;
import org.assertj.core.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.RegionShortcutWrapper;
import org.springframework.data.gemfire.client.ClientRegionShortcutWrapper;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicy;
import org.springframework.data.gemfire.tests.mock.MockObjectsSupport;
import org.springframework.data.gemfire.tests.mock.support.MockObjectInvocationException;
import org.springframework.data.gemfire.tests.util.FileSystemUtils;
import org.springframework.data.gemfire.tests.util.IOUtils;
import org.springframework.data.gemfire.tests.util.ObjectUtils;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class GemFireMockObjectsSupport
extends MockObjectsSupport {
    private static final boolean DEFAULT_USE_SINGLETON_CACHE = false;
    private static final AtomicReference<GemFireCache> cacheReference = new AtomicReference<Object>(null);
    private static final AtomicReference<GemFireCache> singletonCache = new AtomicReference<Object>(null);
    private static final AtomicReference<Properties> gemfireProperties = new AtomicReference<Properties>(new Properties());
    private static final List<Object> cachedGemFireObjects = Collections.synchronizedList(new ArrayList());
    private static final Map<String, AsyncEventQueue> asyncEventQueues = new ConcurrentHashMap<String, AsyncEventQueue>();
    private static final Map<String, DiskStore> diskStores = new ConcurrentHashMap<String, DiskStore>();
    private static final Map<String, GatewaySender> gatewaySenders = new ConcurrentHashMap<String, GatewaySender>();
    private static final Map<String, Region<Object, Object>> regions = new ConcurrentHashMap<String, Region<Object, Object>>();
    private static final Map<String, RegionAttributes<Object, Object>> regionAttributes = new ConcurrentHashMap<String, RegionAttributes<Object, Object>>();
    private static final Set<GatewayReceiver> gatewayReceivers = Collections.synchronizedSet(new HashSet());
    private static final Set<String> registeredPoolNames = new ConcurrentSkipListSet<String>();
    private static final String CACHE_FACTORY_DS_PROPS_FIELD_NAME = "dsProps";
    private static final String CACHE_FACTORY_INTERNAL_CACHE_BUILDER_FIELD_NAME = "internalCacheBuilder";
    private static final String CLIENT_CACHE_FACTORY_DS_PROPS_FIELD_NAME = "dsProps";
    private static final String INTERNAL_CACHE_BUILDER_CONFIG_PROPERTIES_FIELD_NAME = "configProperties";
    private static final String GEMFIRE_SYSTEM_PROPERTY_PREFIX = "gemfire.";
    private static final String FROM_KEYWORD = "FROM";
    private static final String REPEATING_REGION_SEPARATOR = "/{2,}";
    private static final String USE_SINGLETON_CACHE_PROPERTY = "spring.data.gemfire.test.cache.singleton";
    private static final String WHERE_KEYWORD = "WHERE";
    private static final String[] GEMFIRE_OBJECT_BASED_PROPERTIES = new String[]{"security-client-auth-init", "security-manager", "security-post-processor"};
    private static final String[] SPRING_DATA_GEODE_TEST_PROPERTIES = new String[]{"spring.data.gemfire.test.cache.singleton"};

    public static void destroy() {
        cacheReference.set(null);
        singletonCache.set(null);
        gemfireProperties.set(new Properties());
        asyncEventQueues.clear();
        diskStores.clear();
        gatewayReceivers.clear();
        gatewaySenders.clear();
        regions.clear();
        regionAttributes.clear();
        GemFireMockObjectsSupport.unregisterFunctions();
        GemFireMockObjectsSupport.unregisterManagedPools();
        GemFireMockObjectsSupport.closePools();
        GemFireMockObjectsSupport.destroyGemFireObjects();
        GemFireMockObjectsSupport.clearSpringDataGeodeTestProperties();
    }

    static void clearSpringDataGeodeTestProperties() {
        Arrays.stream(ArrayUtils.nullSafeArray((Object[])SPRING_DATA_GEODE_TEST_PROPERTIES, String.class)).forEach(System::clearProperty);
    }

    static void closePools() {
        ObjectUtils.doOperationSafely(() -> {
            PoolManager.close();
            return null;
        }, null);
    }

    static synchronized void destroyGemFireObjects() {
        cachedGemFireObjects.stream().filter(gemfireObject -> gemfireObject instanceof DisposableBean).map(gemfireObject -> (DisposableBean)gemfireObject).forEach(disposableBean -> ObjectUtils.doOperationSafely(() -> {
            disposableBean.destroy();
            return null;
        }));
        cachedGemFireObjects.clear();
    }

    static synchronized void unregisterFunctions() {
        CollectionUtils.nullSafeMap((Map)FunctionService.getRegisteredFunctions()).forEach((functionId, function) -> FunctionService.unregisterFunction((String)functionId));
    }

    static synchronized void unregisterManagedPools() {
        CollectionUtils.nullSafeMap((Map)PoolManager.getAll()).values().stream().filter(Objects::nonNull).filter(pool -> registeredPoolNames.contains(pool.getName())).forEach(GemFireMockObjectsSupport::unregister);
        registeredPoolNames.clear();
    }

    private static synchronized void cacheGemFireObject(Object gemfireObject) {
        Optional.ofNullable(gemfireObject).ifPresent(cachedGemFireObjects::add);
    }

    private static <T extends GemFireCache> T constructGemFireObjects(T gemfireCache) {
        Properties localGemfireProperties = gemfireProperties.get();
        Arrays.stream(GEMFIRE_OBJECT_BASED_PROPERTIES).map(localGemfireProperties::getProperty).filter(StringUtils::hasText).filter(className -> ClassUtils.isPresent((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader())).forEach(className -> GemFireMockObjectsSupport.cacheGemFireObject(ReflectionUtils.createInstanceIfPresent((String)className, null)));
        return gemfireCache;
    }

    private static DataPolicy convert(ClientRegionShortcut clientRegionShortcut) {
        return Optional.ofNullable(clientRegionShortcut).map(shortcut -> {
            switch (shortcut) {
                case CACHING_PROXY: 
                case CACHING_PROXY_HEAP_LRU: 
                case CACHING_PROXY_OVERFLOW: 
                case LOCAL: 
                case LOCAL_HEAP_LRU: 
                case LOCAL_OVERFLOW: {
                    return DataPolicy.NORMAL;
                }
                case LOCAL_PERSISTENT: 
                case LOCAL_PERSISTENT_OVERFLOW: {
                    return DataPolicy.PERSISTENT_REPLICATE;
                }
                case PROXY: {
                    return DataPolicy.EMPTY;
                }
            }
            return null;
        }).orElse(DataPolicy.DEFAULT);
    }

    private static DataPolicy convert(RegionShortcut regionShortcut) {
        return Optional.ofNullable(regionShortcut).map(shortcut -> {
            switch (shortcut) {
                case LOCAL: 
                case LOCAL_HEAP_LRU: 
                case LOCAL_OVERFLOW: {
                    return DataPolicy.NORMAL;
                }
                case PARTITION: 
                case PARTITION_HEAP_LRU: 
                case PARTITION_OVERFLOW: 
                case PARTITION_PROXY: 
                case PARTITION_PROXY_REDUNDANT: 
                case PARTITION_REDUNDANT: 
                case PARTITION_REDUNDANT_HEAP_LRU: 
                case PARTITION_REDUNDANT_OVERFLOW: {
                    return DataPolicy.PARTITION;
                }
                case PARTITION_PERSISTENT: 
                case PARTITION_PERSISTENT_OVERFLOW: 
                case PARTITION_REDUNDANT_PERSISTENT: 
                case PARTITION_REDUNDANT_PERSISTENT_OVERFLOW: {
                    return DataPolicy.PERSISTENT_PARTITION;
                }
                case REPLICATE: 
                case REPLICATE_HEAP_LRU: 
                case REPLICATE_OVERFLOW: {
                    return DataPolicy.REPLICATE;
                }
                case LOCAL_PERSISTENT: 
                case LOCAL_PERSISTENT_OVERFLOW: 
                case REPLICATE_PERSISTENT: 
                case REPLICATE_PERSISTENT_OVERFLOW: {
                    return DataPolicy.PERSISTENT_REPLICATE;
                }
                case REPLICATE_PROXY: {
                    return DataPolicy.EMPTY;
                }
            }
            return null;
        }).orElse(DataPolicy.DEFAULT);
    }

    private static boolean isRootRegion(Region<?, ?> region) {
        return GemFireMockObjectsSupport.isRootRegion(region.getFullPath());
    }

    private static boolean isRootRegion(String regionPath) {
        return regionPath.lastIndexOf("/") <= 0;
    }

    private static String normalizeGemFirePropertyName(String propertyName) {
        return Optional.ofNullable(propertyName).filter(StringUtils::hasText).filter(it -> it.startsWith(GEMFIRE_SYSTEM_PROPERTY_PREFIX)).map(it -> it.substring(GEMFIRE_SYSTEM_PROPERTY_PREFIX.length())).orElse(propertyName);
    }

    private static String normalizeRegionPath(String regionPath) {
        regionPath = (regionPath = regionPath.replaceAll(REPEATING_REGION_SEPARATOR, "/")).endsWith("/") ? regionPath.substring(0, regionPath.length() - 1) : regionPath;
        return regionPath;
    }

    @Nullable
    private static <T extends GemFireCache> T referTo(@Nullable T gemfireCache) {
        return (T)cacheReference.updateAndGet(currentCacheReference -> gemfireCache);
    }

    private static <T extends GemFireCache> T rememberMockedGemFireCache(T mockedGemFireCache, boolean useSingletonCache) {
        return (T)Optional.ofNullable(mockedGemFireCache).map(it -> {
            if (useSingletonCache) {
                singletonCache.compareAndSet((GemFireCache)null, (GemFireCache)it);
            }
            return it;
        }).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"GemFireCache is required", (Object[])new Object[0]));
    }

    private static <K, V> Region<K, V> rememberMockedRegion(Region<K, V> mockRegion) {
        String mockRegionPath = Optional.ofNullable(mockRegion).map(Region::getFullPath).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"Region is required", (Object[])new Object[0]));
        if (regions.putIfAbsent(mockRegionPath, mockRegion) != null) {
            throw new RegionExistsException(mockRegion);
        }
        Assertions.assertThat(regions).containsValue(mockRegion);
        return mockRegion;
    }

    private static <T extends GemFireCache> Optional<T> resolveAnyGemFireCache() {
        return Optional.ofNullable(cacheReference.get());
    }

    private static <T extends GemFireCache> Optional<T> resolveMockedGemFireCache(boolean useSingletonCache) {
        return Optional.ofNullable(singletonCache.get()).filter(it -> useSingletonCache);
    }

    @NonNull
    private static <K, V> RegionAttributes<K, V> resolveRegionAttributes(String regionAttributesId) {
        return Optional.ofNullable(regionAttributes.get(regionAttributesId)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"RegionAttributes with ID [%s] cannot be found", (Object[])new Object[]{regionAttributesId}));
    }

    private static <K, V> RegionAttributes<K, V> resolveRegionAttributesFromClientRegionShortcut(@Nullable ClientRegionShortcut clientRegionShortcut) {
        RegionAttributes mockRegionAttributes = null;
        if (clientRegionShortcut != null) {
            ClientRegionShortcutWrapper clientRegionShortcutWrapper = ClientRegionShortcutWrapper.valueOf((ClientRegionShortcut)clientRegionShortcut);
            mockRegionAttributes = (RegionAttributes)Mockito.mock(RegionAttributes.class, (MockSettings)Mockito.withSettings().lenient());
            ((RegionAttributes)Mockito.doReturn((Object)GemFireMockObjectsSupport.convert(clientRegionShortcut)).when((Object)mockRegionAttributes)).getDataPolicy();
            if (clientRegionShortcutWrapper.isHeapLru()) {
                ((RegionAttributes)Mockito.doReturn((Object)EvictionAttributes.createLRUHeapAttributes()).when((Object)mockRegionAttributes)).getEvictionAttributes();
            } else if (clientRegionShortcutWrapper.isOverflow()) {
                ((RegionAttributes)Mockito.doReturn((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK)).when((Object)mockRegionAttributes)).getEvictionAttributes();
            }
        }
        return mockRegionAttributes;
    }

    @Nullable
    private static <K, V> RegionAttributes<K, V> resolveRegionAttributesFromRegionShortcut(@Nullable RegionShortcut regionShortcut) {
        RegionAttributes mockRegionAttributes = null;
        if (regionShortcut != null) {
            RegionShortcutWrapper regionShortcutWrapper = RegionShortcutWrapper.valueOf((RegionShortcut)regionShortcut);
            mockRegionAttributes = (RegionAttributes)Mockito.mock(RegionAttributes.class, (MockSettings)Mockito.withSettings().lenient());
            ((RegionAttributes)Mockito.doReturn((Object)GemFireMockObjectsSupport.convert(regionShortcut)).when((Object)mockRegionAttributes)).getDataPolicy();
            if (regionShortcutWrapper.isHeapLru()) {
                ((RegionAttributes)Mockito.doReturn((Object)EvictionAttributes.createLRUHeapAttributes()).when((Object)mockRegionAttributes)).getEvictionAttributes();
            } else if (regionShortcutWrapper.isOverflow()) {
                ((RegionAttributes)Mockito.doReturn((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK)).when((Object)mockRegionAttributes)).getEvictionAttributes();
            }
            if (regionShortcutWrapper.isLocal()) {
                ((RegionAttributes)Mockito.doReturn((Object)Scope.LOCAL).when((Object)mockRegionAttributes)).getScope();
            }
            if (regionShortcutWrapper.isPartition()) {
                PartitionAttributes mockPartitionAttributes = (PartitionAttributes)Mockito.mock(PartitionAttributes.class, (MockSettings)Mockito.withSettings().lenient());
                if (regionShortcut.isProxy()) {
                    ((PartitionAttributes)Mockito.doReturn((Object)0).when((Object)mockPartitionAttributes)).getLocalMaxMemory();
                }
                if (regionShortcutWrapper.isRedundant()) {
                    ((PartitionAttributes)Mockito.doReturn((Object)1).when((Object)mockPartitionAttributes)).getRedundantCopies();
                }
                ((RegionAttributes)Mockito.doReturn((Object)mockPartitionAttributes).when((Object)mockRegionAttributes)).getPartitionAttributes();
            }
            if (regionShortcutWrapper.isReplicate()) {
                ((RegionAttributes)Mockito.doReturn((Object)Scope.DISTRIBUTED_ACK).when((Object)mockRegionAttributes)).getScope();
            }
        }
        return mockRegionAttributes;
    }

    private static String toRegionName(String regionName) {
        return Optional.ofNullable(regionName).map(String::trim).map(it -> {
            int lastIndexOfRegionSeparator = it.lastIndexOf("/");
            return lastIndexOfRegionSeparator < 0 ? it : it.substring(lastIndexOfRegionSeparator + 1);
        }).filter(it -> !it.isEmpty()).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"Region name [%s] is required", (Object[])new Object[]{regionName}));
    }

    private static String toRegionPath(String regionPath) {
        return Optional.ofNullable(regionPath).map(String::trim).map(it -> it.startsWith("/") ? it : String.format("%1$s%2$s", "/", it)).map(GemFireMockObjectsSupport::normalizeRegionPath).filter(it -> !it.isEmpty()).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"Region path [%s] is required", (Object[])new Object[]{regionPath}));
    }

    private static <T extends GemFireCache> T mockCacheApi(T mockGemFireCache) {
        AtomicBoolean copyOnRead = new AtomicBoolean(false);
        CacheTransactionManager mockCacheTransactionManager = GemFireMockObjectsSupport.mockCacheTransactionManager();
        DistributedSystem mockDistributedSystem = GemFireMockObjectsSupport.mockDistributedSystem();
        ResourceManager mockResourceManager = GemFireMockObjectsSupport.mockResourceManager();
        ((GemFireCache)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(copyOnRead, null)).when(mockGemFireCache)).setCopyOnRead(ArgumentMatchers.anyBoolean());
        ((GemFireCache)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(regionAttributes, null)).when(mockGemFireCache)).setRegionAttributes(ArgumentMatchers.anyString(), (RegionAttributes)ArgumentMatchers.any(RegionAttributes.class));
        Mockito.when((Object)mockGemFireCache.getCacheTransactionManager()).thenReturn((Object)mockCacheTransactionManager);
        Mockito.when((Object)mockGemFireCache.getCopyOnRead()).thenAnswer(GemFireMockObjectsSupport.newGetter(copyOnRead));
        Mockito.when((Object)mockGemFireCache.getDistributedSystem()).thenReturn((Object)mockDistributedSystem);
        Mockito.when((Object)mockGemFireCache.getName()).thenAnswer(invocation -> Optional.ofNullable(gemfireProperties).map(AtomicReference::get).map(properties -> properties.getProperty("name")).filter(StringUtils::hasText).orElse(null));
        Mockito.when((Object)mockGemFireCache.getRegionAttributes(ArgumentMatchers.anyString())).thenAnswer(invocation -> regionAttributes.get(invocation.getArgument(0)));
        Mockito.when((Object)mockGemFireCache.getResourceManager()).thenReturn((Object)mockResourceManager);
        Mockito.when((Object)mockGemFireCache.createDiskStoreFactory()).thenAnswer(invocation -> GemFireMockObjectsSupport.mockDiskStoreFactory());
        Mockito.when((Object)mockGemFireCache.findDiskStore(ArgumentMatchers.anyString())).thenAnswer(invocation -> diskStores.get(invocation.getArgument(0)));
        Mockito.when((Object)mockGemFireCache.listRegionAttributes()).thenReturn(Collections.unmodifiableMap(regionAttributes));
        ((GemFireCache)Mockito.doThrow((Throwable[])new Throwable[]{RuntimeExceptionFactory.newUnsupportedOperationException((String)"Operation Not Supported", (Object[])new Object[0])}).when(mockGemFireCache)).loadCacheXml((InputStream)ArgumentMatchers.any(InputStream.class));
        return GemFireMockObjectsSupport.mockRegionServiceApi(mockGemFireCache);
    }

    private static <T extends RegionService> T mockRegionServiceApi(T mockRegionService) {
        AtomicBoolean closed = new AtomicBoolean(false);
        ((RegionService)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(closed, true, null)).when(mockRegionService)).close();
        Mockito.when((Object)mockRegionService.isClosed()).thenAnswer(GemFireMockObjectsSupport.newGetter(closed));
        Mockito.when((Object)mockRegionService.getCancelCriterion()).thenThrow(new Throwable[]{RuntimeExceptionFactory.newUnsupportedOperationException((String)"Operation Not Supported", (Object[])new Object[0])});
        Mockito.when((Object)mockRegionService.getRegion(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String regionPath = (String)invocation.getArgument(0);
            String resolvedRegionPath = Optional.ofNullable(regionPath).map(String::trim).filter(it -> !it.isEmpty()).map(GemFireMockObjectsSupport::toRegionPath).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"Region path [%s] is not valid", (Object[])new Object[]{regionPath}));
            return regions.get(resolvedRegionPath);
        });
        Mockito.when((Object)mockRegionService.createPdxEnum(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{RuntimeExceptionFactory.newUnsupportedOperationException((String)"Operation Not Supported", (Object[])new Object[0])});
        Mockito.when((Object)mockRegionService.createPdxInstanceFactory(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{RuntimeExceptionFactory.newUnsupportedOperationException((String)"Operation Not Supported", (Object[])new Object[0])});
        Mockito.when((Object)mockRegionService.rootRegions()).thenAnswer(invocation -> regions.values().stream().filter(GemFireMockObjectsSupport::isRootRegion).collect(Collectors.toSet()));
        return mockRegionService;
    }

    public static ClientCache mockClientCache() {
        ClientCache mockClientCache = (ClientCache)Mockito.mock(ClientCache.class);
        ((ClientCache)Mockito.doAnswer(GemFireMockObjectsSupport.newVoidAnswer(invocation -> mockClientCache.close())).when((Object)mockClientCache)).close(ArgumentMatchers.anyBoolean());
        Mockito.when((Object)mockClientCache.createClientRegionFactory((ClientRegionShortcut)ArgumentMatchers.any(ClientRegionShortcut.class))).thenAnswer(invocation -> GemFireMockObjectsSupport.mockClientRegionFactory(mockClientCache, (ClientRegionShortcut)invocation.getArgument(0)));
        Mockito.when((Object)mockClientCache.createClientRegionFactory(ArgumentMatchers.anyString())).thenAnswer(invocation -> GemFireMockObjectsSupport.mockClientRegionFactory(mockClientCache, (String)invocation.getArgument(0)));
        return (ClientCache)GemFireMockObjectsSupport.referTo((GemFireCache)GemFireMockObjectsSupport.mockQueryService(GemFireMockObjectsSupport.mockCacheApi(mockClientCache)));
    }

    public static GemFireCache mockGemFireCache() {
        GemFireCache mockGemFireCache = (GemFireCache)Mockito.mock(GemFireCache.class);
        return GemFireMockObjectsSupport.referTo(GemFireMockObjectsSupport.mockQueryService(GemFireMockObjectsSupport.mockCacheApi(mockGemFireCache)));
    }

    public static Cache mockPeerCache() {
        Cache mockCache = (Cache)Mockito.mock(Cache.class);
        AtomicInteger lockLease = new AtomicInteger();
        AtomicInteger lockTimeout = new AtomicInteger();
        AtomicInteger messageSyncInterval = new AtomicInteger();
        AtomicInteger searchTimeout = new AtomicInteger();
        AtomicReference gatewayConflictResolver = new AtomicReference();
        ArrayList cacheServers = new ArrayList();
        Mockito.when((Object)mockCache.addCacheServer()).thenAnswer(invocation -> {
            CacheServer mockCacheServer = GemFireMockObjectsSupport.mockCacheServer();
            cacheServers.add(mockCacheServer);
            return mockCacheServer;
        });
        ((Cache)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(gatewayConflictResolver, () -> null)).when((Object)mockCache)).setGatewayConflictResolver((GatewayConflictResolver)ArgumentMatchers.any(GatewayConflictResolver.class));
        ((Cache)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(lockLease, null)).when((Object)mockCache)).setLockLease(ArgumentMatchers.anyInt());
        ((Cache)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(lockTimeout, null)).when((Object)mockCache)).setLockTimeout(ArgumentMatchers.anyInt());
        ((Cache)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(messageSyncInterval, null)).when((Object)mockCache)).setMessageSyncInterval(ArgumentMatchers.anyInt());
        ((Cache)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(searchTimeout, null)).when((Object)mockCache)).setSearchTimeout(ArgumentMatchers.anyInt());
        Mockito.when((Object)mockCache.isServer()).thenReturn((Object)true);
        Mockito.when((Object)mockCache.getAsyncEventQueues()).thenAnswer(invocation -> Collections.unmodifiableSet(new HashSet<AsyncEventQueue>(asyncEventQueues.values())));
        Mockito.when((Object)mockCache.getCacheServers()).thenAnswer(invocation -> Collections.unmodifiableList(cacheServers));
        Mockito.when((Object)mockCache.getGatewayConflictResolver()).thenAnswer(GemFireMockObjectsSupport.newGetter(gatewayConflictResolver));
        Mockito.when((Object)mockCache.getGatewayReceivers()).thenAnswer(invocation -> Collections.unmodifiableSet(gatewayReceivers));
        Mockito.when((Object)mockCache.getGatewaySenders()).thenAnswer(invocation -> Collections.unmodifiableSet(new HashSet<GatewaySender>(gatewaySenders.values())));
        Mockito.when((Object)mockCache.getLockLease()).thenAnswer(GemFireMockObjectsSupport.newGetter(lockLease));
        Mockito.when((Object)mockCache.getLockTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(lockTimeout));
        Mockito.when((Object)mockCache.getMessageSyncInterval()).thenAnswer(GemFireMockObjectsSupport.newGetter(messageSyncInterval));
        Mockito.when((Object)mockCache.getReconnectedCache()).thenAnswer(invocation -> GemFireMockObjectsSupport.mockPeerCache());
        Mockito.when((Object)mockCache.getSearchTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(searchTimeout));
        Mockito.when((Object)mockCache.createRegionFactory()).thenAnswer(invocation -> GemFireMockObjectsSupport.mockRegionFactory(mockCache));
        Mockito.when((Object)mockCache.createRegionFactory((RegionAttributes)ArgumentMatchers.any(RegionAttributes.class))).thenAnswer(invocation -> GemFireMockObjectsSupport.mockRegionFactory(mockCache, (RegionAttributes)invocation.getArgument(0)));
        Mockito.when((Object)mockCache.createRegionFactory((RegionShortcut)ArgumentMatchers.any(RegionShortcut.class))).thenAnswer(invocation -> GemFireMockObjectsSupport.mockRegionFactory(mockCache, (RegionShortcut)invocation.getArgument(0)));
        Mockito.when((Object)mockCache.createRegionFactory(ArgumentMatchers.anyString())).thenAnswer(invocation -> GemFireMockObjectsSupport.mockRegionFactory(mockCache, (String)invocation.getArgument(0)));
        ((Cache)Mockito.doAnswer(invocation -> {
            String asyncEventQueueId = (String)invocation.getArgument(0);
            return asyncEventQueues.get(asyncEventQueueId);
        }).when((Object)mockCache)).getAsyncEventQueue(ArgumentMatchers.anyString());
        ((Cache)Mockito.doAnswer(invocation -> {
            String gatewaySenderId = (String)invocation.getArgument(0);
            return gatewaySenders.get(gatewaySenderId);
        }).when((Object)mockCache)).getGatewaySender(ArgumentMatchers.anyString());
        return (Cache)GemFireMockObjectsSupport.referTo((GemFireCache)GemFireMockObjectsSupport.mockQueryService(GemFireMockObjectsSupport.mockGatewaySenderFactory(GemFireMockObjectsSupport.mockGatewayReceiverFactory(GemFireMockObjectsSupport.mockAsyncEventQueueFactory(GemFireMockObjectsSupport.mockCacheApi(mockCache))))));
    }

    public static Cache mockAsyncEventQueueFactory(Cache mockCache) {
        Mockito.when((Object)mockCache.createAsyncEventQueueFactory()).thenAnswer(invocation -> GemFireMockObjectsSupport.mockAsyncEventQueueFactory());
        return mockCache;
    }

    public static AsyncEventQueueFactory mockAsyncEventQueueFactory() {
        AsyncEventQueueFactory mockAsyncEventQueueFactory = (AsyncEventQueueFactory)Mockito.mock(AsyncEventQueueFactory.class);
        AtomicBoolean batchConflationEnabled = new AtomicBoolean(false);
        AtomicBoolean diskSynchronous = new AtomicBoolean(true);
        AtomicBoolean forwardExpirationDestroy = new AtomicBoolean(false);
        AtomicBoolean parallel = new AtomicBoolean(false);
        AtomicBoolean pauseEventDispatching = new AtomicBoolean(false);
        AtomicBoolean persistent = new AtomicBoolean(false);
        AtomicInteger batchSize = new AtomicInteger(100);
        AtomicInteger batchTimeInterval = new AtomicInteger(5);
        AtomicInteger dispatcherThreads = new AtomicInteger(5);
        AtomicInteger maximumQueueMemory = new AtomicInteger(100);
        AtomicReference<Object> diskStoreName = new AtomicReference<Object>(null);
        AtomicReference<Object> gatewayEventSubstitutionFilter = new AtomicReference<Object>(null);
        AtomicReference<GatewaySender.OrderPolicy> orderPolicy = new AtomicReference<GatewaySender.OrderPolicy>(GatewaySender.OrderPolicy.KEY);
        CopyOnWriteArrayList gatewayEventFilters = new CopyOnWriteArrayList();
        Mockito.when((Object)mockAsyncEventQueueFactory.setBatchConflationEnabled(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(batchConflationEnabled, mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setBatchSize(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(batchSize, mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setBatchTimeInterval(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(batchTimeInterval, mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setDiskStoreName(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newSetter(diskStoreName, () -> mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setDiskSynchronous(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(diskSynchronous, mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setDispatcherThreads(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(dispatcherThreads, mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setForwardExpirationDestroy(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(forwardExpirationDestroy, mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setGatewayEventSubstitutionListener((GatewayEventSubstitutionFilter)ArgumentMatchers.any(GatewayEventSubstitutionFilter.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(gatewayEventSubstitutionFilter, () -> mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setMaximumQueueMemory(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(maximumQueueMemory, mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setOrderPolicy((GatewaySender.OrderPolicy)ArgumentMatchers.any(GatewaySender.OrderPolicy.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(orderPolicy, () -> mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setParallel(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(parallel, mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.setPersistent(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(persistent, mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.addGatewayEventFilter((GatewayEventFilter)ArgumentMatchers.any(GatewayEventFilter.class))).thenAnswer(invocation -> {
            gatewayEventFilters.add(invocation.getArgument(0));
            return mockAsyncEventQueueFactory;
        });
        Mockito.when((Object)mockAsyncEventQueueFactory.pauseEventDispatching()).thenAnswer(GemFireMockObjectsSupport.newSetter(pauseEventDispatching, true, mockAsyncEventQueueFactory));
        Mockito.when((Object)mockAsyncEventQueueFactory.removeGatewayEventFilter((GatewayEventFilter)ArgumentMatchers.any(GatewayEventFilter.class))).thenAnswer(invocation -> {
            gatewayEventFilters.remove(invocation.getArgument(0));
            return mockAsyncEventQueueFactory;
        });
        Mockito.when((Object)mockAsyncEventQueueFactory.create(ArgumentMatchers.anyString(), (AsyncEventListener)ArgumentMatchers.any(AsyncEventListener.class))).thenAnswer(invocation -> {
            String asyncEventQueueId = (String)invocation.getArgument(0);
            AsyncEventListener listener = (AsyncEventListener)invocation.getArgument(1);
            AsyncEventQueue mockAsyncEventQueue = (AsyncEventQueue)Mockito.mock(AsyncEventQueue.class);
            Mockito.when((Object)mockAsyncEventQueue.isBatchConflationEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(batchConflationEnabled));
            Mockito.when((Object)mockAsyncEventQueue.isDiskSynchronous()).thenAnswer(GemFireMockObjectsSupport.newGetter(diskSynchronous));
            Mockito.when((Object)mockAsyncEventQueue.isDispatchingPaused()).thenAnswer(GemFireMockObjectsSupport.newGetter(pauseEventDispatching));
            Mockito.when((Object)mockAsyncEventQueue.isForwardExpirationDestroy()).thenAnswer(GemFireMockObjectsSupport.newGetter(forwardExpirationDestroy));
            Mockito.when((Object)mockAsyncEventQueue.isParallel()).thenAnswer(GemFireMockObjectsSupport.newGetter(parallel));
            Mockito.when((Object)mockAsyncEventQueue.isPersistent()).thenAnswer(GemFireMockObjectsSupport.newGetter(persistent));
            Mockito.when((Object)mockAsyncEventQueue.isPrimary()).thenReturn((Object)false);
            Mockito.when((Object)mockAsyncEventQueue.getAsyncEventListener()).thenReturn((Object)listener);
            Mockito.when((Object)mockAsyncEventQueue.getBatchSize()).thenAnswer(GemFireMockObjectsSupport.newGetter(batchSize));
            Mockito.when((Object)mockAsyncEventQueue.getBatchTimeInterval()).thenAnswer(GemFireMockObjectsSupport.newGetter(batchTimeInterval));
            Mockito.when((Object)mockAsyncEventQueue.getDiskStoreName()).thenAnswer(GemFireMockObjectsSupport.newGetter(diskStoreName));
            Mockito.when((Object)mockAsyncEventQueue.getDispatcherThreads()).thenAnswer(GemFireMockObjectsSupport.newGetter(dispatcherThreads));
            Mockito.when((Object)mockAsyncEventQueue.getGatewayEventFilters()).thenReturn((Object)gatewayEventFilters);
            Mockito.when((Object)mockAsyncEventQueue.getGatewayEventSubstitutionFilter()).thenAnswer(GemFireMockObjectsSupport.newGetter(gatewayEventSubstitutionFilter));
            Mockito.when((Object)mockAsyncEventQueue.getId()).thenReturn((Object)asyncEventQueueId);
            Mockito.when((Object)mockAsyncEventQueue.getMaximumQueueMemory()).thenAnswer(GemFireMockObjectsSupport.newGetter(maximumQueueMemory));
            Mockito.when((Object)mockAsyncEventQueue.getOrderPolicy()).thenAnswer(GemFireMockObjectsSupport.newGetter(orderPolicy));
            ((AsyncEventQueue)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pauseEventDispatching, false, null)).when((Object)mockAsyncEventQueue)).resumeEventDispatching();
            Mockito.when((Object)mockAsyncEventQueue.size()).thenReturn((Object)0);
            asyncEventQueues.put(asyncEventQueueId, mockAsyncEventQueue);
            return mockAsyncEventQueue;
        });
        return mockAsyncEventQueueFactory;
    }

    public static CacheServer mockCacheServer() {
        CacheServer mockCacheServer = (CacheServer)Mockito.mock(CacheServer.class);
        AtomicBoolean running = new AtomicBoolean(false);
        AtomicBoolean tcpNoDelay = new AtomicBoolean(true);
        AtomicInteger maxConnections = new AtomicInteger(800);
        AtomicInteger maxMessageCount = new AtomicInteger(230000);
        AtomicInteger maxThreads = new AtomicInteger(0);
        AtomicInteger maxTimeBetweenPings = new AtomicInteger(60000);
        AtomicInteger messageTimeToLive = new AtomicInteger(180);
        AtomicInteger port = new AtomicInteger(40404);
        AtomicInteger socketBufferSize = new AtomicInteger(32768);
        AtomicLong loadPollInterval = new AtomicLong(5000L);
        AtomicReference<String> bindAddress = new AtomicReference<String>("");
        AtomicReference<String> hostnameForClients = new AtomicReference<String>("");
        AtomicReference<Object> serverLoadProbe = new AtomicReference<Object>(null);
        AtomicReference<String[]> groups = new AtomicReference<String[]>(CacheServer.DEFAULT_GROUPS);
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(bindAddress, () -> null)).when((Object)mockCacheServer)).setBindAddress(ArgumentMatchers.anyString());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(groups, () -> null)).when((Object)mockCacheServer)).setGroups((String[])ArgumentMatchers.any(String[].class));
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(hostnameForClients, () -> null)).when((Object)mockCacheServer)).setHostnameForClients(ArgumentMatchers.anyString());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(loadPollInterval, null)).when((Object)mockCacheServer)).setLoadPollInterval(ArgumentMatchers.anyLong());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(maxConnections, null)).when((Object)mockCacheServer)).setMaxConnections(ArgumentMatchers.anyInt());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(maxMessageCount, null)).when((Object)mockCacheServer)).setMaximumMessageCount(ArgumentMatchers.anyInt());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(maxThreads, null)).when((Object)mockCacheServer)).setMaxThreads(ArgumentMatchers.anyInt());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(maxTimeBetweenPings, null)).when((Object)mockCacheServer)).setMaximumTimeBetweenPings(ArgumentMatchers.anyInt());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(messageTimeToLive, null)).when((Object)mockCacheServer)).setMessageTimeToLive(ArgumentMatchers.anyInt());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(port, null)).when((Object)mockCacheServer)).setPort(ArgumentMatchers.anyInt());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(serverLoadProbe, () -> null)).when((Object)mockCacheServer)).setLoadProbe((ServerLoadProbe)ArgumentMatchers.any(ServerLoadProbe.class));
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(socketBufferSize, null)).when((Object)mockCacheServer)).setSocketBufferSize(ArgumentMatchers.anyInt());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(tcpNoDelay, null)).when((Object)mockCacheServer)).setTcpNoDelay(ArgumentMatchers.anyBoolean());
        Mockito.when((Object)mockCacheServer.isRunning()).thenAnswer(GemFireMockObjectsSupport.newGetter(running));
        Mockito.when((Object)mockCacheServer.getAllClientSessions()).thenReturn(Collections.emptySet());
        Mockito.when((Object)mockCacheServer.getBindAddress()).thenAnswer(GemFireMockObjectsSupport.newGetter(bindAddress));
        Mockito.when((Object)mockCacheServer.getClientSession((DistributedMember)ArgumentMatchers.any(DistributedMember.class))).thenThrow(new Throwable[]{RuntimeExceptionFactory.newUnsupportedOperationException((String)"Operation Not Supported", (Object[])new Object[0])});
        Mockito.when((Object)mockCacheServer.getClientSession(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{RuntimeExceptionFactory.newUnsupportedOperationException((String)"Operation Not Supported", (Object[])new Object[0])});
        Mockito.when((Object)mockCacheServer.getGroups()).thenAnswer(GemFireMockObjectsSupport.newGetter(groups));
        Mockito.when((Object)mockCacheServer.getHostnameForClients()).thenAnswer(GemFireMockObjectsSupport.newGetter(hostnameForClients));
        Mockito.when((Object)mockCacheServer.getInterestRegistrationListeners()).thenReturn(Collections.emptySet());
        Mockito.when((Object)mockCacheServer.getLoadPollInterval()).thenAnswer(GemFireMockObjectsSupport.newGetter(loadPollInterval));
        Mockito.when((Object)mockCacheServer.getLoadProbe()).thenAnswer(GemFireMockObjectsSupport.newGetter(serverLoadProbe));
        Mockito.when((Object)mockCacheServer.getMaxConnections()).thenAnswer(GemFireMockObjectsSupport.newGetter(maxConnections));
        Mockito.when((Object)mockCacheServer.getMaximumMessageCount()).thenAnswer(GemFireMockObjectsSupport.newGetter(maxMessageCount));
        Mockito.when((Object)mockCacheServer.getMaximumTimeBetweenPings()).thenAnswer(GemFireMockObjectsSupport.newGetter(maxTimeBetweenPings));
        Mockito.when((Object)mockCacheServer.getMaxThreads()).thenAnswer(GemFireMockObjectsSupport.newGetter(maxThreads));
        Mockito.when((Object)mockCacheServer.getMessageTimeToLive()).thenAnswer(GemFireMockObjectsSupport.newGetter(messageTimeToLive));
        Mockito.when((Object)mockCacheServer.getPort()).thenAnswer(GemFireMockObjectsSupport.newGetter(port));
        Mockito.when((Object)mockCacheServer.getSocketBufferSize()).thenAnswer(GemFireMockObjectsSupport.newGetter(socketBufferSize));
        Mockito.when((Object)mockCacheServer.getTcpNoDelay()).thenAnswer(GemFireMockObjectsSupport.newGetter(tcpNoDelay));
        ClientSubscriptionConfig mockClientSubscriptionConfig = GemFireMockObjectsSupport.mockClientSubscriptionConfig();
        Mockito.when((Object)mockCacheServer.getClientSubscriptionConfig()).thenReturn((Object)mockClientSubscriptionConfig);
        IOUtils.doSafeIo(() -> ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(running, true, null)).when((Object)mockCacheServer)).start());
        ((CacheServer)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(running, false, null)).when((Object)mockCacheServer)).stop();
        return mockCacheServer;
    }

    public static CacheTransactionManager mockCacheTransactionManager() {
        CacheTransactionManager mockCacheTransactionManager = (CacheTransactionManager)Mockito.mock(CacheTransactionManager.class);
        AtomicBoolean distributed = new AtomicBoolean(false);
        AtomicReference<Object> transactionWriter = new AtomicReference<Object>(null);
        CopyOnWriteArrayList transactionListeners = new CopyOnWriteArrayList();
        ((CacheTransactionManager)Mockito.doReturn((Object)false).when((Object)mockCacheTransactionManager)).exists();
        ((CacheTransactionManager)Mockito.doReturn((Object)false).when((Object)mockCacheTransactionManager)).exists((TransactionId)ArgumentMatchers.any(TransactionId.class));
        ((CacheTransactionManager)Mockito.doAnswer(GemFireMockObjectsSupport.newGetter(distributed)).when((Object)mockCacheTransactionManager)).isDistributed();
        ((CacheTransactionManager)Mockito.doReturn((Object)false).when((Object)mockCacheTransactionManager)).isSuspended((TransactionId)ArgumentMatchers.any(TransactionId.class));
        ((CacheTransactionManager)Mockito.doAnswer(invocation -> transactionListeners.add(invocation.getArgument(0))).when((Object)mockCacheTransactionManager)).addListener((TransactionListener)ArgumentMatchers.any(TransactionListener.class));
        ((CacheTransactionManager)Mockito.doAnswer(invocation -> transactionListeners.toArray(new TransactionListener[0])).when((Object)mockCacheTransactionManager)).getListeners();
        ((CacheTransactionManager)Mockito.doAnswer(GemFireMockObjectsSupport.newGetter(transactionWriter)).when((Object)mockCacheTransactionManager)).getWriter();
        ((CacheTransactionManager)Mockito.doAnswer(invocation -> {
            TransactionListener[] newTransactionListeners = (TransactionListener[])invocation.getArgument(0);
            transactionListeners.forEach(CacheCallback::close);
            transactionListeners.clear();
            Collections.addAll(transactionListeners, newTransactionListeners);
            return null;
        }).when((Object)mockCacheTransactionManager)).initListeners((TransactionListener[])ArgumentMatchers.any(TransactionListener[].class));
        ((CacheTransactionManager)Mockito.doAnswer(invocation -> transactionListeners.remove(invocation.getArgument(0))).when((Object)mockCacheTransactionManager)).removeListener((TransactionListener)ArgumentMatchers.any(TransactionListener.class));
        ((CacheTransactionManager)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(distributed, null)).when((Object)mockCacheTransactionManager)).setDistributed(ArgumentMatchers.anyBoolean());
        ((CacheTransactionManager)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(transactionWriter)).when((Object)mockCacheTransactionManager)).setWriter((TransactionWriter)ArgumentMatchers.any(TransactionWriter.class));
        return mockCacheTransactionManager;
    }

    public static <K, V> ClientRegionFactory<K, V> mockClientRegionFactory(ClientCache mockClientCache, ClientRegionShortcut clientRegionShortcut) {
        return GemFireMockObjectsSupport.mockClientRegionFactory(mockClientCache, GemFireMockObjectsSupport.resolveRegionAttributesFromClientRegionShortcut(clientRegionShortcut), clientRegionShortcut);
    }

    public static <K, V> ClientRegionFactory<K, V> mockClientRegionFactory(ClientCache mockClientCache, String regionAttributesId) {
        return GemFireMockObjectsSupport.mockClientRegionFactory(mockClientCache, GemFireMockObjectsSupport.resolveRegionAttributes(regionAttributesId), null);
    }

    public static <K, V> ClientRegionFactory<K, V> mockClientRegionFactory(ClientCache mockClientCache, RegionAttributes<K, V> regionAttributes, ClientRegionShortcut clientRegionShortcut) {
        ClientRegionFactory mockClientRegionFactory = (ClientRegionFactory)Mockito.mock(ClientRegionFactory.class, (String)GemFireMockObjectsSupport.mockObjectIdentifier("MockClientRegionFactory"));
        ExpirationAttributes DEFAULT_EXPIRATION_ATTRIBUTES = new ExpirationAttributes(0, ExpirationAction.INVALIDATE);
        Optional<RegionAttributes<K, V>> optionalRegionAttributes = Optional.ofNullable(regionAttributes);
        AtomicBoolean cloningEnabled = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getCloningEnabled).orElse(false));
        AtomicBoolean concurrencyChecksEnabled = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getConcurrencyChecksEnabled).orElse(false));
        AtomicBoolean diskSynchronous = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::isDiskSynchronous).orElse(true));
        AtomicBoolean statisticsEnabled = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getStatisticsEnabled).orElse(false));
        AtomicInteger concurrencyLevel = new AtomicInteger(optionalRegionAttributes.map(RegionAttributes::getConcurrencyLevel).orElse(16));
        AtomicInteger initialCapacity = new AtomicInteger(optionalRegionAttributes.map(RegionAttributes::getInitialCapacity).orElse(16));
        AtomicReference<Object> compressor = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getCompressor).orElse(null));
        AtomicReference<Object> customEntryIdleTimeout = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getCustomEntryIdleTimeout).orElse(null));
        AtomicReference<Object> customEntryTimeToLive = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getCustomEntryTimeToLive).orElse(null));
        AtomicReference<DataPolicy> dataPolicy = new AtomicReference<DataPolicy>(optionalRegionAttributes.map(RegionAttributes::getDataPolicy).orElseGet(() -> GemFireMockObjectsSupport.convert(clientRegionShortcut)));
        AtomicReference<Object> diskStoreName = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getDiskStoreName).orElse(null));
        AtomicReference<ExpirationAttributes> entryIdleTimeout = new AtomicReference<ExpirationAttributes>(optionalRegionAttributes.map(RegionAttributes::getEntryIdleTimeout).orElse(DEFAULT_EXPIRATION_ATTRIBUTES));
        AtomicReference<ExpirationAttributes> entryTimeToLive = new AtomicReference<ExpirationAttributes>(optionalRegionAttributes.map(RegionAttributes::getEntryTimeToLive).orElse(DEFAULT_EXPIRATION_ATTRIBUTES));
        AtomicReference<EvictionAttributes> evictionAttributes = new AtomicReference<EvictionAttributes>(optionalRegionAttributes.map(RegionAttributes::getEvictionAttributes).orElseGet(EvictionAttributes::createLRUEntryAttributes));
        AtomicReference<Object> keyConstraint = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getKeyConstraint).orElse(null));
        AtomicReference<Float> loadFactor = new AtomicReference<Float>(optionalRegionAttributes.map(RegionAttributes::getLoadFactor).orElse(Float.valueOf(0.75f)));
        AtomicReference<Object> poolName = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getPoolName).orElse(null));
        AtomicReference<ExpirationAttributes> regionIdleTimeout = new AtomicReference<ExpirationAttributes>(optionalRegionAttributes.map(RegionAttributes::getRegionIdleTimeout).orElse(DEFAULT_EXPIRATION_ATTRIBUTES));
        AtomicReference<ExpirationAttributes> regionTimeToLive = new AtomicReference<ExpirationAttributes>(optionalRegionAttributes.map(RegionAttributes::getRegionTimeToLive).orElse(DEFAULT_EXPIRATION_ATTRIBUTES));
        AtomicReference<Object> valueConstraint = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getValueConstraint).orElse(null));
        ArrayList<Object> cacheListeners = new ArrayList<Object>(Arrays.asList(ArrayUtils.nullSafeArray((Object[])optionalRegionAttributes.map(RegionAttributes::getCacheListeners).orElse(null), CacheListener.class)));
        Mockito.when((Object)mockClientRegionFactory.addCacheListener((CacheListener)ArgumentMatchers.any(CacheListener.class))).thenAnswer(GemFireMockObjectsSupport.newAdder(cacheListeners, mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.initCacheListeners((CacheListener[])ArgumentMatchers.any(CacheListener[].class))).thenAnswer(invocation -> {
            cacheListeners.clear();
            Collections.addAll(cacheListeners, (Object[])invocation.getArgument(0));
            return mockClientRegionFactory;
        });
        Mockito.when((Object)mockClientRegionFactory.setCloningEnabled(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(cloningEnabled, mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setCompressor((Compressor)ArgumentMatchers.any(Compressor.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(compressor, () -> mockClientRegionFactory));
        ((ClientRegionFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(concurrencyChecksEnabled, mockClientRegionFactory)).when((Object)mockClientRegionFactory)).setConcurrencyChecksEnabled(ArgumentMatchers.anyBoolean());
        Mockito.when((Object)mockClientRegionFactory.setConcurrencyLevel(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(concurrencyLevel, mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setCustomEntryIdleTimeout((CustomExpiry)ArgumentMatchers.any(CustomExpiry.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(customEntryIdleTimeout, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setCustomEntryTimeToLive((CustomExpiry)ArgumentMatchers.any(CustomExpiry.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(customEntryTimeToLive, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setDiskStoreName(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newSetter(diskStoreName, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setDiskSynchronous(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(diskSynchronous, mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setEntryIdleTimeout((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(entryIdleTimeout, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setEntryTimeToLive((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(entryTimeToLive, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setEvictionAttributes((EvictionAttributes)ArgumentMatchers.any(EvictionAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(evictionAttributes, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setInitialCapacity(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(initialCapacity, mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setKeyConstraint((Class)ArgumentMatchers.any(Class.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(keyConstraint, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setLoadFactor(ArgumentMatchers.anyFloat())).thenAnswer(GemFireMockObjectsSupport.newSetter(loadFactor, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setPoolName(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newSetter(poolName, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setRegionIdleTimeout((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(regionIdleTimeout, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setRegionTimeToLive((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(regionTimeToLive, () -> mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setStatisticsEnabled(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(statisticsEnabled, mockClientRegionFactory));
        Mockito.when((Object)mockClientRegionFactory.setValueConstraint((Class)ArgumentMatchers.any(Class.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(valueConstraint, () -> mockClientRegionFactory));
        RegionAttributes mockRegionAttributes = (RegionAttributes)Mockito.mock(RegionAttributes.class, (String)GemFireMockObjectsSupport.mockObjectIdentifier("MockRegionAttributes"));
        Mockito.when((Object)mockRegionAttributes.getCacheListeners()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> cacheListeners.toArray(new CacheListener[cacheListeners.size()])));
        Mockito.when((Object)mockRegionAttributes.getCloningEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(cloningEnabled));
        Mockito.when((Object)mockRegionAttributes.getCompressor()).thenAnswer(GemFireMockObjectsSupport.newGetter(compressor));
        Mockito.when((Object)mockRegionAttributes.getConcurrencyChecksEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(concurrencyChecksEnabled));
        Mockito.when((Object)mockRegionAttributes.getConcurrencyLevel()).thenAnswer(GemFireMockObjectsSupport.newGetter(concurrencyLevel));
        Mockito.when((Object)mockRegionAttributes.getCustomEntryIdleTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(customEntryIdleTimeout));
        Mockito.when((Object)mockRegionAttributes.getCustomEntryTimeToLive()).thenAnswer(GemFireMockObjectsSupport.newGetter(customEntryTimeToLive));
        Mockito.when((Object)mockRegionAttributes.getDataPolicy()).thenAnswer(GemFireMockObjectsSupport.newGetter(dataPolicy));
        Mockito.when((Object)mockRegionAttributes.getDiskStoreName()).thenAnswer(GemFireMockObjectsSupport.newGetter(diskStoreName));
        Mockito.when((Object)mockRegionAttributes.isDiskSynchronous()).thenAnswer(GemFireMockObjectsSupport.newGetter(diskSynchronous));
        Mockito.when((Object)mockRegionAttributes.getEntryIdleTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(entryIdleTimeout));
        Mockito.when((Object)mockRegionAttributes.getEntryTimeToLive()).thenAnswer(GemFireMockObjectsSupport.newGetter(entryTimeToLive));
        Mockito.when((Object)mockRegionAttributes.getEvictionAttributes()).thenAnswer(GemFireMockObjectsSupport.newGetter(evictionAttributes));
        Mockito.when((Object)mockRegionAttributes.getInitialCapacity()).thenAnswer(GemFireMockObjectsSupport.newGetter(initialCapacity));
        Mockito.when((Object)mockRegionAttributes.getKeyConstraint()).thenAnswer(GemFireMockObjectsSupport.newGetter(keyConstraint));
        Mockito.when((Object)Float.valueOf(mockRegionAttributes.getLoadFactor())).thenAnswer(GemFireMockObjectsSupport.newGetter(loadFactor));
        Mockito.when((Object)mockRegionAttributes.getPoolName()).thenAnswer(GemFireMockObjectsSupport.newGetter(poolName));
        Mockito.when((Object)mockRegionAttributes.getRegionIdleTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(regionIdleTimeout));
        Mockito.when((Object)mockRegionAttributes.getRegionTimeToLive()).thenAnswer(GemFireMockObjectsSupport.newGetter(regionTimeToLive));
        Mockito.when((Object)mockRegionAttributes.getStatisticsEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(statisticsEnabled));
        Mockito.when((Object)mockRegionAttributes.getValueConstraint()).thenAnswer(GemFireMockObjectsSupport.newGetter(valueConstraint));
        Mockito.when((Object)mockClientRegionFactory.create(ArgumentMatchers.anyString())).thenAnswer(invocation -> GemFireMockObjectsSupport.mockRegion((RegionService)mockClientCache, (String)invocation.getArgument(0), mockRegionAttributes));
        Mockito.when((Object)mockClientRegionFactory.createSubregion((Region)ArgumentMatchers.any(Region.class), ArgumentMatchers.anyString())).thenAnswer(invocation -> GemFireMockObjectsSupport.mockSubRegion((Region)invocation.getArgument(0), (String)invocation.getArgument(1), mockRegionAttributes));
        return mockClientRegionFactory;
    }

    public static ClientSubscriptionConfig mockClientSubscriptionConfig() {
        ClientSubscriptionConfig mockClientSubscriptionConfig = (ClientSubscriptionConfig)Mockito.mock(ClientSubscriptionConfig.class);
        AtomicInteger subscriptionCapacity = new AtomicInteger(1);
        AtomicReference<String> subscriptionDiskStoreName = new AtomicReference<String>("");
        AtomicReference<SubscriptionEvictionPolicy> subscriptionEvictionPolicy = new AtomicReference<SubscriptionEvictionPolicy>(SubscriptionEvictionPolicy.DEFAULT);
        Function<String, SubscriptionEvictionPolicy> stringToSubscriptionEvictionPolicyConverter = arg -> SubscriptionEvictionPolicy.valueOfIgnoreCase((String)String.valueOf(arg));
        Function<SubscriptionEvictionPolicy, String> subscriptionEvictionPolicyToStringConverter = arg -> Optional.ofNullable(arg).map(Object::toString).map(String::toLowerCase).orElse(null);
        ((ClientSubscriptionConfig)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(subscriptionCapacity, null)).when((Object)mockClientSubscriptionConfig)).setCapacity(ArgumentMatchers.anyInt());
        ((ClientSubscriptionConfig)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(subscriptionDiskStoreName, () -> null)).when((Object)mockClientSubscriptionConfig)).setDiskStoreName(ArgumentMatchers.anyString());
        ((ClientSubscriptionConfig)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(subscriptionEvictionPolicy, stringToSubscriptionEvictionPolicyConverter, () -> null)).when((Object)mockClientSubscriptionConfig)).setEvictionPolicy(ArgumentMatchers.anyString());
        Mockito.when((Object)mockClientSubscriptionConfig.getCapacity()).thenAnswer(GemFireMockObjectsSupport.newGetter(subscriptionCapacity));
        Mockito.when((Object)mockClientSubscriptionConfig.getDiskStoreName()).thenAnswer(GemFireMockObjectsSupport.newGetter(subscriptionDiskStoreName));
        Mockito.when((Object)mockClientSubscriptionConfig.getEvictionPolicy()).thenAnswer(GemFireMockObjectsSupport.newGetter(subscriptionEvictionPolicy, subscriptionEvictionPolicyToStringConverter));
        return mockClientSubscriptionConfig;
    }

    public static DiskStoreFactory mockDiskStoreFactory() {
        DiskStoreFactory mockDiskStoreFactory = (DiskStoreFactory)Mockito.mock(DiskStoreFactory.class);
        AtomicBoolean allowForceCompaction = new AtomicBoolean(false);
        AtomicBoolean autoCompact = new AtomicBoolean(true);
        AtomicInteger compactionThreshold = new AtomicInteger(50);
        AtomicInteger queueSize = new AtomicInteger(0);
        AtomicInteger writeBufferSize = new AtomicInteger(32768);
        AtomicLong maxOplogSize = new AtomicLong(DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE);
        AtomicLong timeInterval = new AtomicLong(1000L);
        AtomicReference<File[]> diskDirectories = new AtomicReference<File[]>(new File[]{FileSystemUtils.WORKING_DIRECTORY});
        AtomicReference<int[]> diskDiretorySizes = new AtomicReference<int[]>(new int[0]);
        AtomicReference<Float> diskUsageCriticalPercentage = new AtomicReference<Float>(Float.valueOf(99.0f));
        AtomicReference<Float> diskUsageWarningPercentage = new AtomicReference<Float>(Float.valueOf(90.0f));
        Mockito.when((Object)mockDiskStoreFactory.setAllowForceCompaction(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(allowForceCompaction, mockDiskStoreFactory));
        Mockito.when((Object)mockDiskStoreFactory.setAutoCompact(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(autoCompact, mockDiskStoreFactory));
        Mockito.when((Object)mockDiskStoreFactory.setCompactionThreshold(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(compactionThreshold, mockDiskStoreFactory));
        Mockito.when((Object)mockDiskStoreFactory.setDiskDirs((File[])ArgumentMatchers.any(File[].class))).thenAnswer(invocation -> {
            File[] resolveDiskDirectories = (File[])ArrayUtils.nullSafeArray((Object[])((Object[])invocation.getArgument(0)), File.class);
            int[] resolvedDiskDirectorySizes = new int[resolveDiskDirectories.length];
            Arrays.fill(resolvedDiskDirectorySizes, Integer.MAX_VALUE);
            diskDirectories.set(resolveDiskDirectories);
            diskDiretorySizes.set(resolvedDiskDirectorySizes);
            return mockDiskStoreFactory;
        });
        Mockito.when((Object)mockDiskStoreFactory.setDiskDirsAndSizes((File[])ArgumentMatchers.any(File[].class), (int[])ArgumentMatchers.any(int[].class))).thenAnswer(invocation -> {
            diskDirectories.set((File[])invocation.getArgument(0));
            diskDiretorySizes.set((int[])invocation.getArgument(1));
            return mockDiskStoreFactory;
        });
        Mockito.when((Object)mockDiskStoreFactory.setDiskUsageCriticalPercentage(ArgumentMatchers.anyFloat())).thenAnswer(GemFireMockObjectsSupport.newSetter(diskUsageCriticalPercentage, () -> mockDiskStoreFactory));
        Mockito.when((Object)mockDiskStoreFactory.setDiskUsageWarningPercentage(ArgumentMatchers.anyFloat())).thenAnswer(GemFireMockObjectsSupport.newSetter(diskUsageWarningPercentage, () -> mockDiskStoreFactory));
        Mockito.when((Object)mockDiskStoreFactory.setMaxOplogSize(ArgumentMatchers.anyLong())).thenAnswer(GemFireMockObjectsSupport.newSetter(maxOplogSize, mockDiskStoreFactory));
        Mockito.when((Object)mockDiskStoreFactory.setQueueSize(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(queueSize, mockDiskStoreFactory));
        Mockito.when((Object)mockDiskStoreFactory.setTimeInterval(ArgumentMatchers.anyLong())).thenAnswer(GemFireMockObjectsSupport.newSetter(timeInterval, mockDiskStoreFactory));
        Mockito.when((Object)mockDiskStoreFactory.setWriteBufferSize(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(writeBufferSize, mockDiskStoreFactory));
        Mockito.when((Object)mockDiskStoreFactory.create(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String name = (String)invocation.getArgument(0);
            DiskStore mockDiskStore = (DiskStore)Mockito.mock(DiskStore.class, (String)name);
            Mockito.when((Object)mockDiskStore.getAllowForceCompaction()).thenReturn((Object)allowForceCompaction.get());
            Mockito.when((Object)mockDiskStore.getAutoCompact()).thenReturn((Object)autoCompact.get());
            Mockito.when((Object)mockDiskStore.getCompactionThreshold()).thenReturn((Object)compactionThreshold.get());
            Mockito.when((Object)mockDiskStore.getDiskDirs()).thenReturn(diskDirectories.get());
            Mockito.when((Object)mockDiskStore.getDiskDirSizes()).thenReturn(diskDiretorySizes.get());
            Mockito.when((Object)Float.valueOf(mockDiskStore.getDiskUsageCriticalPercentage())).thenReturn(diskUsageCriticalPercentage.get());
            Mockito.when((Object)Float.valueOf(mockDiskStore.getDiskUsageWarningPercentage())).thenReturn(diskUsageWarningPercentage.get());
            Mockito.when((Object)mockDiskStore.getDiskStoreUUID()).thenReturn((Object)UUID.randomUUID());
            Mockito.when((Object)mockDiskStore.getMaxOplogSize()).thenReturn((Object)maxOplogSize.get());
            Mockito.when((Object)mockDiskStore.getName()).thenReturn((Object)name);
            Mockito.when((Object)mockDiskStore.getQueueSize()).thenReturn((Object)queueSize.get());
            Mockito.when((Object)mockDiskStore.getTimeInterval()).thenReturn((Object)timeInterval.get());
            Mockito.when((Object)mockDiskStore.getWriteBufferSize()).thenReturn((Object)writeBufferSize.get());
            diskStores.put(name, mockDiskStore);
            return mockDiskStore;
        });
        return mockDiskStoreFactory;
    }

    public static DistributedMember mockDistributedMember() {
        DistributedMember mockDistributedMember = (DistributedMember)Mockito.mock(DistributedMember.class);
        Mockito.when((Object)mockDistributedMember.getGroups()).thenAnswer(invocation -> new ArrayList(StringUtils.commaDelimitedListToSet((String)gemfireProperties.get().getProperty("groups"))));
        Mockito.when((Object)mockDistributedMember.getHost()).thenReturn(ObjectUtils.doOperationSafely(() -> InetAddress.getLocalHost().getHostName(), null));
        Mockito.when((Object)mockDistributedMember.getName()).thenAnswer(invocation -> gemfireProperties.get().getProperty("name"));
        return mockDistributedMember;
    }

    public static DistributedSystem mockDistributedSystem() {
        DistributedMember mockDistributedMember = GemFireMockObjectsSupport.mockDistributedMember();
        DistributedSystem mockDistributedSystem = (DistributedSystem)Mockito.mock(DistributedSystem.class);
        ((DistributedSystem)Mockito.doAnswer(invocation -> gemfireProperties.get().getProperty("name")).when((Object)mockDistributedSystem)).getName();
        Mockito.when((Object)mockDistributedSystem.getDistributedMember()).thenReturn((Object)mockDistributedMember);
        Mockito.when((Object)mockDistributedSystem.getProperties()).thenAnswer(invocation -> gemfireProperties.get());
        Mockito.when((Object)mockDistributedSystem.getReconnectedSystem()).thenAnswer(invocation -> GemFireMockObjectsSupport.mockDistributedSystem());
        return mockDistributedSystem;
    }

    public static Cache mockGatewayReceiverFactory(Cache mockCache) {
        Mockito.when((Object)mockCache.createGatewayReceiverFactory()).thenAnswer(invocation -> GemFireMockObjectsSupport.mockGatewayReceiverFactory());
        return mockCache;
    }

    public static GatewayReceiverFactory mockGatewayReceiverFactory() {
        GatewayReceiverFactory mockGatewayReceiverFactory = (GatewayReceiverFactory)Mockito.mock(GatewayReceiverFactory.class);
        AtomicBoolean manualStart = new AtomicBoolean(false);
        AtomicInteger endPort = new AtomicInteger(5500);
        AtomicInteger maximumTimeBetweenPings = new AtomicInteger(60000);
        AtomicInteger socketBufferSize = new AtomicInteger(524288);
        AtomicInteger startPort = new AtomicInteger(5000);
        AtomicReference<String> bindAddress = new AtomicReference<String>("");
        AtomicReference<String> hostnameForSenders = new AtomicReference<String>("");
        CopyOnWriteArrayList gatewayTransportFilters = new CopyOnWriteArrayList();
        Mockito.when((Object)mockGatewayReceiverFactory.setBindAddress(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newSetter(bindAddress, () -> mockGatewayReceiverFactory));
        Mockito.when((Object)mockGatewayReceiverFactory.setEndPort(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(endPort, mockGatewayReceiverFactory));
        Mockito.when((Object)mockGatewayReceiverFactory.setHostnameForSenders(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newSetter(hostnameForSenders, () -> mockGatewayReceiverFactory));
        Mockito.when((Object)mockGatewayReceiverFactory.setManualStart(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(manualStart, mockGatewayReceiverFactory));
        Mockito.when((Object)mockGatewayReceiverFactory.setMaximumTimeBetweenPings(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(maximumTimeBetweenPings, mockGatewayReceiverFactory));
        Mockito.when((Object)mockGatewayReceiverFactory.setSocketBufferSize(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(socketBufferSize, mockGatewayReceiverFactory));
        Mockito.when((Object)mockGatewayReceiverFactory.setStartPort(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(startPort, mockGatewayReceiverFactory));
        Mockito.when((Object)mockGatewayReceiverFactory.addGatewayTransportFilter((GatewayTransportFilter)ArgumentMatchers.any(GatewayTransportFilter.class))).thenAnswer(invocation -> {
            gatewayTransportFilters.add(invocation.getArgument(0));
            return mockGatewayReceiverFactory;
        });
        Mockito.when((Object)mockGatewayReceiverFactory.removeGatewayTransportFilter((GatewayTransportFilter)ArgumentMatchers.any(GatewayTransportFilter.class))).thenAnswer(invocation -> {
            gatewayTransportFilters.remove(invocation.getArgument(0));
            return mockGatewayReceiverFactory;
        });
        Mockito.when((Object)mockGatewayReceiverFactory.create()).thenAnswer(invocation -> {
            AtomicBoolean running = new AtomicBoolean(!manualStart.get());
            GatewayReceiver mockGatewayReceiver = (GatewayReceiver)Mockito.mock(GatewayReceiver.class);
            Mockito.when((Object)mockGatewayReceiver.isManualStart()).thenAnswer(GemFireMockObjectsSupport.newGetter(manualStart));
            Mockito.when((Object)mockGatewayReceiver.isRunning()).thenAnswer(GemFireMockObjectsSupport.newGetter(running));
            Mockito.when((Object)mockGatewayReceiver.getBindAddress()).thenAnswer(GemFireMockObjectsSupport.newGetter(bindAddress));
            Mockito.when((Object)mockGatewayReceiver.getEndPort()).thenAnswer(GemFireMockObjectsSupport.newGetter(endPort));
            Mockito.when((Object)mockGatewayReceiver.getGatewayTransportFilters()).thenReturn((Object)gatewayTransportFilters);
            Mockito.when((Object)mockGatewayReceiver.getHost()).thenAnswer(GemFireMockObjectsSupport.newGetter(hostnameForSenders));
            Mockito.when((Object)mockGatewayReceiver.getHostnameForSenders()).thenAnswer(GemFireMockObjectsSupport.newGetter(hostnameForSenders));
            Mockito.when((Object)mockGatewayReceiver.getMaximumTimeBetweenPings()).thenAnswer(GemFireMockObjectsSupport.newGetter(maximumTimeBetweenPings));
            Mockito.when((Object)mockGatewayReceiver.getPort()).thenAnswer(portInvocation -> {
                Random randomPort = new Random(System.currentTimeMillis());
                int port = startPort.get() + randomPort.nextInt(endPort.get() - startPort.get());
                return port;
            });
            Mockito.when((Object)mockGatewayReceiver.getSocketBufferSize()).thenAnswer(GemFireMockObjectsSupport.newGetter(socketBufferSize));
            Mockito.when((Object)mockGatewayReceiver.getStartPort()).thenAnswer(GemFireMockObjectsSupport.newGetter(startPort));
            ((GatewayReceiver)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(running, true, null)).when((Object)mockGatewayReceiver)).start();
            ((GatewayReceiver)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(running, false, null)).when((Object)mockGatewayReceiver)).stop();
            gatewayReceivers.add(mockGatewayReceiver);
            return mockGatewayReceiver;
        });
        return mockGatewayReceiverFactory;
    }

    public static Cache mockGatewaySenderFactory(Cache mockCache) {
        Mockito.when((Object)mockCache.createGatewaySenderFactory()).thenAnswer(invocation -> GemFireMockObjectsSupport.mockGatewaySenderFactory());
        return mockCache;
    }

    public static GatewaySenderFactory mockGatewaySenderFactory() {
        GatewaySenderFactory mockGatewaySenderFactory = (GatewaySenderFactory)Mockito.mock(GatewaySenderFactory.class);
        AtomicBoolean batchConflationEnabled = new AtomicBoolean(false);
        AtomicBoolean diskSynchronous = new AtomicBoolean(true);
        AtomicBoolean parallel = new AtomicBoolean(false);
        AtomicBoolean persistenceEnabled = new AtomicBoolean(false);
        AtomicInteger alertThreshold = new AtomicInteger(0);
        AtomicInteger batchSize = new AtomicInteger(100);
        AtomicInteger batchTimeInterval = new AtomicInteger(1000);
        AtomicInteger dispatcherThreads = new AtomicInteger(5);
        AtomicInteger maximumQueueMemory = new AtomicInteger(100);
        AtomicInteger parallelFactorForReplicatedRegion = new AtomicInteger(GatewaySender.DEFAULT_PARALLELISM_REPLICATED_REGION);
        AtomicInteger socketBufferSize = new AtomicInteger(524288);
        AtomicInteger socketReadTimeout = new AtomicInteger(GatewaySender.DEFAULT_SOCKET_READ_TIMEOUT);
        AtomicReference<Object> diskStoreName = new AtomicReference<Object>(null);
        AtomicReference<Object> gatewayEventSubstitutionFilter = new AtomicReference<Object>(null);
        AtomicReference<GatewaySender.OrderPolicy> orderPolicy = new AtomicReference<GatewaySender.OrderPolicy>(GatewaySender.DEFAULT_ORDER_POLICY);
        CopyOnWriteArrayList gatewayEventFilters = new CopyOnWriteArrayList();
        CopyOnWriteArrayList gatewayTransportFilters = new CopyOnWriteArrayList();
        Mockito.when((Object)mockGatewaySenderFactory.setAlertThreshold(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(alertThreshold, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setBatchConflationEnabled(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(batchConflationEnabled, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setBatchSize(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(batchSize, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setBatchTimeInterval(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(batchTimeInterval, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setDiskStoreName(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newSetter(diskStoreName, () -> mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setDiskSynchronous(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(diskSynchronous, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setDispatcherThreads(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(dispatcherThreads, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setGatewayEventSubstitutionFilter((GatewayEventSubstitutionFilter)ArgumentMatchers.any(GatewayEventSubstitutionFilter.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(gatewayEventSubstitutionFilter, () -> mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setMaximumQueueMemory(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(maximumQueueMemory, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setOrderPolicy((GatewaySender.OrderPolicy)ArgumentMatchers.any(GatewaySender.OrderPolicy.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(orderPolicy, () -> mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setParallel(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(parallel, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setParallelFactorForReplicatedRegion(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(parallelFactorForReplicatedRegion, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setPersistenceEnabled(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(persistenceEnabled, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setSocketBufferSize(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(socketBufferSize, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.setSocketReadTimeout(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(socketReadTimeout, mockGatewaySenderFactory));
        Mockito.when((Object)mockGatewaySenderFactory.addGatewayEventFilter((GatewayEventFilter)ArgumentMatchers.any(GatewayEventFilter.class))).thenAnswer(invocation -> {
            gatewayEventFilters.add(invocation.getArgument(0));
            return mockGatewaySenderFactory;
        });
        Mockito.when((Object)mockGatewaySenderFactory.addGatewayTransportFilter((GatewayTransportFilter)ArgumentMatchers.any(GatewayTransportFilter.class))).thenAnswer(invocation -> {
            gatewayTransportFilters.add(invocation.getArgument(0));
            return mockGatewaySenderFactory;
        });
        Mockito.when((Object)mockGatewaySenderFactory.removeGatewayEventFilter((GatewayEventFilter)ArgumentMatchers.any(GatewayEventFilter.class))).thenAnswer(invocation -> {
            gatewayEventFilters.remove(invocation.getArgument(0));
            return mockGatewaySenderFactory;
        });
        Mockito.when((Object)mockGatewaySenderFactory.removeGatewayTransportFilter((GatewayTransportFilter)ArgumentMatchers.any(GatewayTransportFilter.class))).thenAnswer(invocation -> {
            gatewayTransportFilters.remove(invocation.getArgument(0));
            return mockGatewaySenderFactory;
        });
        Mockito.when((Object)mockGatewaySenderFactory.create(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt())).thenAnswer(invocation -> {
            GatewaySender mockGatewaySender = (GatewaySender)Mockito.mock(GatewaySender.class);
            AtomicBoolean destroyed = new AtomicBoolean(false);
            AtomicBoolean running = new AtomicBoolean(false);
            Integer remoteDistributedSystemId = (Integer)invocation.getArgument(1);
            String gatewaySenderId = (String)invocation.getArgument(0);
            Mockito.when((Object)mockGatewaySender.isBatchConflationEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(batchConflationEnabled));
            Mockito.when((Object)mockGatewaySender.isDiskSynchronous()).thenAnswer(GemFireMockObjectsSupport.newGetter(diskSynchronous));
            Mockito.when((Object)mockGatewaySender.isParallel()).thenAnswer(GemFireMockObjectsSupport.newGetter(parallel));
            Mockito.when((Object)mockGatewaySender.isPaused()).thenAnswer(GemFireMockObjectsSupport.newGetter(running));
            Mockito.when((Object)mockGatewaySender.isPersistenceEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(persistenceEnabled));
            Mockito.when((Object)mockGatewaySender.isRunning()).thenAnswer(GemFireMockObjectsSupport.newGetter(running));
            Mockito.when((Object)mockGatewaySender.getAlertThreshold()).thenAnswer(GemFireMockObjectsSupport.newGetter(alertThreshold));
            Mockito.when((Object)mockGatewaySender.getBatchSize()).thenAnswer(GemFireMockObjectsSupport.newGetter(batchSize));
            Mockito.when((Object)mockGatewaySender.getBatchTimeInterval()).thenAnswer(GemFireMockObjectsSupport.newGetter(batchTimeInterval));
            Mockito.when((Object)mockGatewaySender.getDiskStoreName()).thenAnswer(GemFireMockObjectsSupport.newGetter(diskStoreName));
            Mockito.when((Object)mockGatewaySender.getDispatcherThreads()).thenAnswer(GemFireMockObjectsSupport.newGetter(dispatcherThreads));
            Mockito.when((Object)mockGatewaySender.getGatewayEventFilters()).thenReturn((Object)gatewayEventFilters);
            Mockito.when((Object)mockGatewaySender.getGatewayEventSubstitutionFilter()).thenAnswer(GemFireMockObjectsSupport.newGetter(gatewayEventSubstitutionFilter));
            Mockito.when((Object)mockGatewaySender.getGatewayTransportFilters()).thenReturn((Object)gatewayTransportFilters);
            Mockito.when((Object)mockGatewaySender.getId()).thenReturn((Object)gatewaySenderId);
            Mockito.when((Object)mockGatewaySender.getMaximumQueueMemory()).thenAnswer(GemFireMockObjectsSupport.newGetter(maximumQueueMemory));
            Mockito.when((Object)mockGatewaySender.getMaxParallelismForReplicatedRegion()).thenAnswer(GemFireMockObjectsSupport.newGetter(parallelFactorForReplicatedRegion));
            Mockito.when((Object)mockGatewaySender.getOrderPolicy()).thenAnswer(GemFireMockObjectsSupport.newGetter(orderPolicy));
            Mockito.when((Object)mockGatewaySender.getRemoteDSId()).thenReturn((Object)remoteDistributedSystemId);
            Mockito.when((Object)mockGatewaySender.getSocketBufferSize()).thenAnswer(GemFireMockObjectsSupport.newGetter(socketBufferSize));
            Mockito.when((Object)mockGatewaySender.getSocketReadTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(socketReadTimeout));
            ((GatewaySender)Mockito.doAnswer(it -> {
                gatewayEventFilters.add(it.getArgument(0));
                return null;
            }).when((Object)mockGatewaySender)).addGatewayEventFilter((GatewayEventFilter)ArgumentMatchers.any(GatewayEventFilter.class));
            ((GatewaySender)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(destroyed, null)).when((Object)mockGatewaySender)).destroy();
            ((GatewaySender)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(running, false, null)).when((Object)mockGatewaySender)).pause();
            ((GatewaySender)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(running, true, null)).when((Object)mockGatewaySender)).resume();
            ((GatewaySender)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(running, true, null)).when((Object)mockGatewaySender)).start();
            ((GatewaySender)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(running, false, null)).when((Object)mockGatewaySender)).stop();
            ((GatewaySender)Mockito.doAnswer(it -> {
                gatewayEventFilters.remove(it.getArgument(0));
                return null;
            }).when((Object)mockGatewaySender)).removeGatewayEventFilter((GatewayEventFilter)ArgumentMatchers.any(GatewayEventFilter.class));
            gatewaySenders.put(gatewaySenderId, mockGatewaySender);
            return mockGatewaySender;
        });
        return mockGatewaySenderFactory;
    }

    public static PoolFactory mockPoolFactory() {
        PoolFactory mockPoolFactory = (PoolFactory)Mockito.mock(PoolFactory.class);
        AtomicBoolean multiuserAuthentication = new AtomicBoolean(false);
        AtomicBoolean prSingleHopEnabled = new AtomicBoolean(true);
        AtomicBoolean subscriptionEnabled = new AtomicBoolean(false);
        AtomicBoolean threadLocalConnections = new AtomicBoolean(false);
        AtomicInteger freeConnectionTimeout = new AtomicInteger(10000);
        AtomicInteger loadConditioningInterval = new AtomicInteger(300000);
        AtomicInteger maxConnections = new AtomicInteger(-1);
        AtomicInteger minConnections = new AtomicInteger(1);
        AtomicInteger readTimeout = new AtomicInteger(10000);
        AtomicInteger retryAttempts = new AtomicInteger(-1);
        AtomicInteger serverConnectionTimeout = new AtomicInteger(0);
        AtomicInteger socketBufferSize = new AtomicInteger(32768);
        AtomicInteger socketConnectTimeout = new AtomicInteger(59000);
        AtomicInteger statisticInterval = new AtomicInteger(-1);
        AtomicInteger subscriptionAckInterval = new AtomicInteger(100);
        AtomicInteger subscriptionMessageTrackingTimeout = new AtomicInteger(900000);
        AtomicInteger subscriptionRedundancy = new AtomicInteger(0);
        AtomicLong idleTimeout = new AtomicLong(5000L);
        AtomicLong pingInterval = new AtomicLong(10000L);
        AtomicReference<SocketFactory> socketFactory = new AtomicReference<SocketFactory>(PoolFactory.DEFAULT_SOCKET_FACTORY);
        AtomicReference<String> serverGroup = new AtomicReference<String>("");
        ArrayList locators = new ArrayList();
        ArrayList servers = new ArrayList();
        Mockito.when((Object)mockPoolFactory.addLocator(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt())).thenAnswer(invocation -> {
            locators.add(new InetSocketAddress((String)invocation.getArgument(0), (int)((Integer)invocation.getArgument(1))));
            return mockPoolFactory;
        });
        Mockito.when((Object)mockPoolFactory.addServer(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt())).thenAnswer(invocation -> {
            servers.add(new InetSocketAddress((String)invocation.getArgument(0), (int)((Integer)invocation.getArgument(1))));
            return mockPoolFactory;
        });
        Mockito.when((Object)mockPoolFactory.setFreeConnectionTimeout(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(freeConnectionTimeout, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setIdleTimeout(ArgumentMatchers.anyLong())).thenAnswer(GemFireMockObjectsSupport.newSetter(idleTimeout, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setLoadConditioningInterval(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(loadConditioningInterval, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setMaxConnections(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(maxConnections, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setMinConnections(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(minConnections, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setMultiuserAuthentication(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(multiuserAuthentication, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setPingInterval(ArgumentMatchers.anyLong())).thenAnswer(GemFireMockObjectsSupport.newSetter(pingInterval, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setPRSingleHopEnabled(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(prSingleHopEnabled, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setReadTimeout(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(readTimeout, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setRetryAttempts(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(retryAttempts, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setServerConnectionTimeout(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(serverConnectionTimeout, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setServerGroup(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newSetter(serverGroup, () -> mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setSocketBufferSize(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(socketBufferSize, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setSocketConnectTimeout(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(socketConnectTimeout, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setSocketFactory((SocketFactory)ArgumentMatchers.any(SocketFactory.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(socketFactory, () -> mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setStatisticInterval(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(statisticInterval, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setSubscriptionAckInterval(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(subscriptionAckInterval, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setSubscriptionEnabled(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(subscriptionEnabled, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setSubscriptionMessageTrackingTimeout(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(subscriptionMessageTrackingTimeout, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setSubscriptionRedundancy(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(subscriptionRedundancy, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.setThreadLocalConnections(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(threadLocalConnections, mockPoolFactory));
        Mockito.when((Object)mockPoolFactory.create(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String name = (String)invocation.getArgument(0);
            Pool mockPool = (Pool)Mockito.mock(Pool.class, (String)name);
            AtomicReference<Object> queryService = new AtomicReference<Object>(null);
            AtomicBoolean destroyed = new AtomicBoolean(false);
            ((Pool)Mockito.doAnswer(invocationOnMock -> {
                destroyed.set(true);
                return null;
            }).when((Object)mockPool)).destroy();
            ((Pool)Mockito.doAnswer(invocationOnMock -> {
                destroyed.set(true);
                return null;
            }).when((Object)mockPool)).destroy(ArgumentMatchers.anyBoolean());
            Mockito.when((Object)mockPool.isDestroyed()).thenAnswer(GemFireMockObjectsSupport.newGetter(destroyed));
            Mockito.when((Object)mockPool.getFreeConnectionTimeout()).thenReturn((Object)freeConnectionTimeout.get());
            Mockito.when((Object)mockPool.getIdleTimeout()).thenReturn((Object)idleTimeout.get());
            Mockito.when((Object)mockPool.getLoadConditioningInterval()).thenReturn((Object)loadConditioningInterval.get());
            Mockito.when((Object)mockPool.getLocators()).thenReturn((Object)locators);
            Mockito.when((Object)mockPool.getMaxConnections()).thenReturn((Object)maxConnections.get());
            Mockito.when((Object)mockPool.getMinConnections()).thenReturn((Object)minConnections.get());
            Mockito.when((Object)mockPool.getMultiuserAuthentication()).thenReturn((Object)multiuserAuthentication.get());
            Mockito.when((Object)mockPool.getName()).thenReturn((Object)name);
            Mockito.when((Object)mockPool.getPingInterval()).thenReturn((Object)pingInterval.get());
            Mockito.when((Object)mockPool.getPRSingleHopEnabled()).thenReturn((Object)prSingleHopEnabled.get());
            Mockito.when((Object)mockPool.getReadTimeout()).thenReturn((Object)readTimeout.get());
            Mockito.when((Object)mockPool.getRetryAttempts()).thenReturn((Object)retryAttempts.get());
            Mockito.when((Object)mockPool.getServerConnectionTimeout()).thenReturn((Object)serverConnectionTimeout.get());
            Mockito.when((Object)mockPool.getServerGroup()).thenReturn(serverGroup.get());
            Mockito.when((Object)mockPool.getServers()).thenReturn((Object)servers);
            Mockito.when((Object)mockPool.getSocketBufferSize()).thenReturn((Object)socketBufferSize.get());
            Mockito.when((Object)mockPool.getSocketConnectTimeout()).thenReturn((Object)socketConnectTimeout.get());
            Mockito.when((Object)mockPool.getSocketFactory()).thenReturn(socketFactory.get());
            Mockito.when((Object)mockPool.getStatisticInterval()).thenReturn((Object)statisticInterval.get());
            Mockito.when((Object)mockPool.getSubscriptionAckInterval()).thenReturn((Object)subscriptionAckInterval.get());
            Mockito.when((Object)mockPool.getSubscriptionEnabled()).thenReturn((Object)subscriptionEnabled.get());
            Mockito.when((Object)mockPool.getSubscriptionMessageTrackingTimeout()).thenReturn((Object)subscriptionMessageTrackingTimeout.get());
            Mockito.when((Object)mockPool.getSubscriptionRedundancy()).thenReturn((Object)subscriptionRedundancy.get());
            Mockito.when((Object)mockPool.getThreadLocalConnections()).thenReturn((Object)threadLocalConnections.get());
            ((Pool)Mockito.doAnswer(getQueryServiceInvocation -> GemFireMockObjectsSupport.resolveAnyGemFireCache().map(RegionService::getQueryService).orElseGet(() -> (QueryService)queryService.updateAndGet(it -> it != null ? it : GemFireMockObjectsSupport.mockQueryService()))).when((Object)mockPool)).getQueryService();
            GemFireMockObjectsSupport.register(mockPool);
            return mockPool;
        });
        return mockPoolFactory;
    }

    private static Pool register(Pool pool) {
        if (registeredPoolNames.add(pool.getName())) {
            PoolManagerImpl.getPMI().register(pool);
        }
        return pool;
    }

    private static Pool unregister(Pool pool) {
        PoolManagerImpl.getPMI().unregister(pool);
        return pool;
    }

    public static Pool mockQueryService(Pool pool) {
        QueryService mockQueryService = GemFireMockObjectsSupport.mockQueryService();
        Mockito.when((Object)pool.getQueryService()).thenReturn((Object)mockQueryService);
        return pool;
    }

    public static <T extends RegionService> T mockQueryService(T regionService) {
        QueryService mockQueryService = GemFireMockObjectsSupport.mockQueryService();
        ((RegionService)Mockito.doReturn((Object)mockQueryService).when(regionService)).getQueryService();
        if (regionService instanceof ClientCache) {
            ((ClientCache)Mockito.doReturn((Object)mockQueryService).when((Object)((ClientCache)regionService))).getLocalQueryService();
            ((ClientCache)Mockito.doReturn((Object)mockQueryService).when((Object)((ClientCache)regionService))).getQueryService(ArgumentMatchers.anyString());
        }
        return regionService;
    }

    public static QueryService mockQueryService() {
        QueryService mockQueryService = (QueryService)Mockito.mock(QueryService.class);
        Set cqQueries = Collections.synchronizedSet(new HashSet());
        Set<Index> indexes = Collections.synchronizedSet(new HashSet());
        try {
            Mockito.when((Object)mockQueryService.getCq(ArgumentMatchers.anyString())).thenAnswer(invocation -> cqQueries.stream().filter(cqQuery -> invocation.getArgument(0).equals(cqQuery.getName())).findFirst().orElse(null));
            Mockito.when((Object)mockQueryService.getCqs()).thenAnswer(invocation -> cqQueries.toArray(new CqQuery[cqQueries.size()]));
            Mockito.when((Object)mockQueryService.getCqs(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
                List<CqQuery> cqQueriesByRegion = cqQueries.stream().filter(cqQuery -> {
                    String queryString = cqQuery.getQueryString();
                    int indexOfFromClause = queryString.indexOf(FROM_KEYWORD);
                    int indexOfWhereClause = queryString.indexOf(WHERE_KEYWORD);
                    queryString = indexOfFromClause > -1 ? queryString.substring(indexOfFromClause + FROM_KEYWORD.length()) : queryString;
                    queryString = indexOfWhereClause > 0 ? queryString.substring(0, indexOfWhereClause) : queryString;
                    queryString = queryString.startsWith("/") ? queryString.substring(1) : queryString;
                    return invocation.getArgument(0).equals(queryString.trim());
                }).collect(Collectors.toList());
                return cqQueriesByRegion.toArray(new CqQuery[cqQueriesByRegion.size()]);
            });
            Mockito.when((Object)mockQueryService.getIndex((Region)ArgumentMatchers.any(Region.class), ArgumentMatchers.anyString())).thenAnswer(invocation -> {
                Region region = (Region)invocation.getArgument(0);
                String indexName = (String)invocation.getArgument(1);
                Collection indexesForRegion = mockQueryService.getIndexes(region);
                return indexesForRegion.stream().filter(index -> index.getName().equals(indexName)).findFirst().orElse(null);
            });
            Mockito.when((Object)mockQueryService.getIndexes()).thenReturn(indexes);
            Mockito.when((Object)mockQueryService.getIndexes((Region)ArgumentMatchers.any(Region.class))).thenAnswer(invocation -> {
                Region region = (Region)invocation.getArgument(0);
                return indexes.stream().filter(index -> index.getRegion().equals((Object)region)).collect(Collectors.toList());
            });
            Mockito.when((Object)mockQueryService.createIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.createIndexAnswer(indexes, IndexType.FUNCTIONAL));
            Mockito.when((Object)mockQueryService.createIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.createIndexAnswer(indexes, IndexType.FUNCTIONAL));
            Mockito.when((Object)mockQueryService.createHashIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.createIndexAnswer(indexes, IndexType.HASH));
            Mockito.when((Object)mockQueryService.createHashIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.createIndexAnswer(indexes, IndexType.HASH));
            Mockito.when((Object)mockQueryService.createKeyIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.createIndexAnswer(indexes, IndexType.KEY));
            Mockito.when((Object)mockQueryService.newCq(ArgumentMatchers.anyString(), (CqAttributes)ArgumentMatchers.any(CqAttributes.class))).thenAnswer(invocation -> GemFireMockObjectsSupport.add(cqQueries, GemFireMockObjectsSupport.mockCqQuery(null, (String)invocation.getArgument(0), (CqAttributes)invocation.getArgument(1), false)));
            Mockito.when((Object)mockQueryService.newCq(ArgumentMatchers.anyString(), (CqAttributes)ArgumentMatchers.any(CqAttributes.class), ArgumentMatchers.anyBoolean())).thenAnswer(invocation -> GemFireMockObjectsSupport.add(cqQueries, GemFireMockObjectsSupport.mockCqQuery(null, (String)invocation.getArgument(0), (CqAttributes)invocation.getArgument(1), (Boolean)invocation.getArgument(2))));
            Mockito.when((Object)mockQueryService.newCq(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (CqAttributes)ArgumentMatchers.any(CqAttributes.class))).thenAnswer(invocation -> GemFireMockObjectsSupport.add(cqQueries, GemFireMockObjectsSupport.mockCqQuery((String)invocation.getArgument(0), (String)invocation.getArgument(1), (CqAttributes)invocation.getArgument(2), false)));
            Mockito.when((Object)mockQueryService.newCq(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (CqAttributes)ArgumentMatchers.any(CqAttributes.class), ArgumentMatchers.anyBoolean())).thenAnswer(invocation -> GemFireMockObjectsSupport.add(cqQueries, GemFireMockObjectsSupport.mockCqQuery((String)invocation.getArgument(0), (String)invocation.getArgument(1), (CqAttributes)invocation.getArgument(2), (Boolean)invocation.getArgument(3))));
            Mockito.when((Object)mockQueryService.newQuery(ArgumentMatchers.anyString())).thenAnswer(invocation -> GemFireMockObjectsSupport.mockQuery((String)invocation.getArgument(0)));
        }
        catch (Exception cause) {
            throw new MockObjectInvocationException(cause);
        }
        return mockQueryService;
    }

    private static CqQuery add(Collection<CqQuery> cqQueries, CqQuery cqQuery) {
        cqQueries.add(cqQuery);
        return cqQuery;
    }

    private static Index add(Collection<Index> indexes, Index index) {
        indexes.add(index);
        return index;
    }

    private static Answer<Index> createIndexAnswer(Collection<Index> indexes, IndexType indexType) {
        return invocation -> {
            String indexName = (String)invocation.getArgument(0);
            String indexedExpression = (String)invocation.getArgument(1);
            String regionPath = (String)invocation.getArgument(2);
            return GemFireMockObjectsSupport.add(indexes, GemFireMockObjectsSupport.mockIndex(indexName, indexedExpression, regionPath, indexType));
        };
    }

    private static CqQuery mockCqQuery(String name, String queryString, CqAttributes cqAttributes, boolean durable) {
        CqQuery mockCqQuery = (CqQuery)Mockito.mock(CqQuery.class);
        Query mockQuery = GemFireMockObjectsSupport.mockQuery(queryString);
        AtomicBoolean closed = new AtomicBoolean(false);
        AtomicBoolean running = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(true);
        Mockito.when((Object)mockCqQuery.getCqAttributes()).thenReturn((Object)cqAttributes);
        Mockito.when((Object)mockCqQuery.getName()).thenReturn((Object)name);
        Mockito.when((Object)mockCqQuery.getQuery()).thenReturn((Object)mockQuery);
        Mockito.when((Object)mockCqQuery.getQueryString()).thenReturn((Object)queryString);
        try {
            ((CqQuery)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(closed, true, null)).when((Object)mockCqQuery)).close();
            ((CqQuery)Mockito.doAnswer(invocation -> {
                running.set(true);
                stopped.set(false);
                return null;
            }).when((Object)mockCqQuery)).execute();
            ((CqQuery)Mockito.doAnswer(invocation -> {
                running.set(false);
                stopped.set(true);
                return null;
            }).when((Object)mockCqQuery)).stop();
        }
        catch (Exception cause) {
            throw new MockObjectInvocationException(cause);
        }
        Mockito.when((Object)mockCqQuery.isClosed()).thenAnswer(GemFireMockObjectsSupport.newGetter(closed));
        Mockito.when((Object)mockCqQuery.isDurable()).thenReturn((Object)durable);
        Mockito.when((Object)mockCqQuery.isRunning()).thenAnswer(GemFireMockObjectsSupport.newGetter(running));
        Mockito.when((Object)mockCqQuery.isStopped()).thenAnswer(GemFireMockObjectsSupport.newGetter(stopped));
        return mockCqQuery;
    }

    private static Query mockQuery(String queryString) {
        Query mockQuery = (Query)Mockito.mock(Query.class);
        QueryStatistics mockQueryStatistics = GemFireMockObjectsSupport.mockQueryStatistics(mockQuery);
        SelectResults mockSelectResults = GemFireMockObjectsSupport.mockSelectResults();
        ((Query)Mockito.doReturn((Object)queryString).when((Object)mockQuery)).getQueryString();
        ((Query)Mockito.doReturn((Object)mockQueryStatistics).when((Object)mockQuery)).getStatistics();
        try {
            ((Query)Mockito.doReturn(mockSelectResults).when((Object)mockQuery)).execute();
            ((Query)Mockito.doReturn(mockSelectResults).when((Object)mockQuery)).execute(new Object[]{ArgumentMatchers.any(Object.class)});
            ((Query)Mockito.doReturn(mockSelectResults).when((Object)mockQuery)).execute((RegionFunctionContext)ArgumentMatchers.any(RegionFunctionContext.class));
            ((Query)Mockito.doReturn(mockSelectResults).when((Object)mockQuery)).execute((RegionFunctionContext)ArgumentMatchers.any(RegionFunctionContext.class), (Object[])ArgumentMatchers.any());
        }
        catch (Throwable cause) {
            throw new MockObjectInvocationException(cause);
        }
        return mockQuery;
    }

    private static QueryStatistics mockQueryStatistics(Query query) {
        QueryStatistics mockQueryStatistics = (QueryStatistics)Mockito.mock(QueryStatistics.class);
        AtomicLong numberOfExecutions = new AtomicLong(0L);
        Answer executeAnswer = invocation -> {
            numberOfExecutions.incrementAndGet();
            return null;
        };
        try {
            Mockito.when((Object)query.execute()).thenAnswer(executeAnswer);
            Mockito.when((Object)query.execute((Object[])ArgumentMatchers.any(Object[].class))).thenAnswer(executeAnswer);
            Mockito.when((Object)query.execute((RegionFunctionContext)ArgumentMatchers.any(RegionFunctionContext.class))).thenAnswer(executeAnswer);
            Mockito.when((Object)query.execute((RegionFunctionContext)ArgumentMatchers.any(RegionFunctionContext.class), (Object[])ArgumentMatchers.any(Object[].class))).thenAnswer(executeAnswer);
        }
        catch (Exception cause) {
            throw new MockObjectInvocationException(cause);
        }
        Mockito.when((Object)mockQueryStatistics.getNumExecutions()).thenAnswer(GemFireMockObjectsSupport.newGetter(numberOfExecutions));
        Mockito.when((Object)mockQueryStatistics.getTotalExecutionTime()).thenReturn((Object)0L);
        return mockQueryStatistics;
    }

    private static <T> SelectResults<T> mockSelectResults() {
        ObjectType mockObjectType = (ObjectType)Mockito.mock(ObjectType.class, (MockSettings)Mockito.withSettings().lenient());
        ((ObjectType)Mockito.doReturn((Object)Object.class.getSimpleName()).when((Object)mockObjectType)).getSimpleClassName();
        ((ObjectType)Mockito.doReturn((Object)false).when((Object)mockObjectType)).isCollectionType();
        ((ObjectType)Mockito.doReturn((Object)false).when((Object)mockObjectType)).isMapType();
        ((ObjectType)Mockito.doReturn((Object)false).when((Object)mockObjectType)).isStructType();
        ((ObjectType)Mockito.doReturn(Object.class).when((Object)mockObjectType)).resolveClass();
        CollectionType mockCollectionType = (CollectionType)Mockito.mock(CollectionType.class, (MockSettings)Mockito.withSettings().lenient());
        ((CollectionType)Mockito.doReturn((Object)false).when((Object)mockCollectionType)).allowsDuplicates();
        ((CollectionType)Mockito.doReturn((Object)mockObjectType).when((Object)mockCollectionType)).getElementType();
        ((CollectionType)Mockito.doReturn((Object)false).when((Object)mockCollectionType)).isOrdered();
        SelectResults mockSelectResults = (SelectResults)Mockito.mock(SelectResults.class, (MockSettings)Mockito.withSettings().lenient());
        ((SelectResults)Mockito.doReturn(Collections.emptyList()).when((Object)mockSelectResults)).asList();
        ((SelectResults)Mockito.doReturn(Collections.emptySet()).when((Object)mockSelectResults)).asSet();
        ((SelectResults)Mockito.doReturn((Object)mockCollectionType).when((Object)mockSelectResults)).getCollectionType();
        ((SelectResults)Mockito.doReturn((Object)false).when((Object)mockSelectResults)).isModifiable();
        ((SelectResults)Mockito.doReturn(Collections.emptyIterator()).when((Object)mockSelectResults)).iterator();
        ((SelectResults)Mockito.doReturn((Object)0).when((Object)mockSelectResults)).occurrences(ArgumentMatchers.any());
        ((SelectResults)Mockito.doNothing().when((Object)mockSelectResults)).setElementType((ObjectType)ArgumentMatchers.any(ObjectType.class));
        return mockSelectResults;
    }

    public static Index mockIndex(String name, String expression, String fromClause, IndexType indexType) {
        Index mockIndex = (Index)Mockito.mock(Index.class, (String)name);
        IndexStatistics mockIndexStaticts = GemFireMockObjectsSupport.mockIndexStatistics(name);
        Mockito.when((Object)mockIndex.getName()).thenReturn((Object)name);
        Mockito.when((Object)mockIndex.getCanonicalizedFromClause()).thenReturn((Object)fromClause);
        Mockito.when((Object)mockIndex.getCanonicalizedIndexedExpression()).thenReturn((Object)expression);
        Mockito.when((Object)mockIndex.getCanonicalizedProjectionAttributes()).thenReturn((Object)expression);
        Mockito.when((Object)mockIndex.getFromClause()).thenReturn((Object)fromClause);
        Mockito.when((Object)mockIndex.getIndexedExpression()).thenReturn((Object)expression);
        Mockito.when((Object)mockIndex.getProjectionAttributes()).thenReturn((Object)expression);
        Mockito.when((Object)mockIndex.getStatistics()).thenReturn((Object)mockIndexStaticts);
        Mockito.when((Object)mockIndex.getType()).thenReturn((Object)indexType.getGemfireIndexType());
        ((Index)Mockito.doAnswer(invocation -> {
            String regionName = GemFireMockObjectsSupport.fromClauseToRegionPath(fromClause);
            return regions.get(regionName);
        }).when((Object)mockIndex)).getRegion();
        return mockIndex;
    }

    private static String fromClauseToRegionPath(String fromClause) {
        String regionName = String.valueOf(fromClause);
        int indexOfDot = regionName.indexOf(".");
        int indexOfSpace = regionName.indexOf(" ");
        regionName = regionName.startsWith("/") ? regionName : GemfireUtils.toRegionPath((String)regionName);
        regionName = indexOfSpace > -1 ? regionName.substring(0, indexOfSpace) : regionName;
        regionName = indexOfDot > -1 ? regionName.substring(0, indexOfDot) : regionName;
        return regionName;
    }

    private static IndexStatistics mockIndexStatistics(String name) {
        return (IndexStatistics)Mockito.mock(IndexStatistics.class, (String)GemFireMockObjectsSupport.mockObjectIdentifier(name));
    }

    public static LuceneIndexFactory mockLuceneIndexFactory() {
        return GemFireMockObjectsSupport.mockLuceneIndexFactory(null);
    }

    private static LuceneIndexFactory mockLuceneIndexFactory(Map<LuceneIndexKey, LuceneIndex> luceneIndexes) {
        LuceneIndexFactory mockLuceneIndexFactory = (LuceneIndexFactory)Mockito.mock(LuceneIndexFactory.class);
        AtomicReference<Object> luceneSerializer = new AtomicReference<Object>(null);
        ConcurrentHashMap fieldAnalyzers = new ConcurrentHashMap();
        CopyOnWriteArraySet fields = new CopyOnWriteArraySet();
        Mockito.when((Object)mockLuceneIndexFactory.addField(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String fieldName = (String)invocation.getArgument(0);
            fields.add(fieldName);
            return mockLuceneIndexFactory;
        });
        Mockito.when((Object)mockLuceneIndexFactory.addField(ArgumentMatchers.anyString(), (Analyzer)ArgumentMatchers.any(Analyzer.class))).thenAnswer(invocation -> {
            String fieldName = (String)invocation.getArgument(0);
            Analyzer analyzer = (Analyzer)invocation.getArgument(1);
            fieldAnalyzers.put(fieldName, analyzer);
            return mockLuceneIndexFactory;
        });
        Mockito.when((Object)mockLuceneIndexFactory.setFields((String[])ArgumentMatchers.any())).thenAnswer(invocation -> {
            Object[] fieldsArgument = invocation.getArguments();
            String[] fieldNames = (String[])Arrays.stream(ArrayUtils.nullSafeArray((Object[])fieldsArgument, Object.class)).filter(Objects::nonNull).map(String::valueOf).toArray(String[]::new);
            fields.clear();
            Collections.addAll(fields, fieldNames);
            return mockLuceneIndexFactory;
        });
        Mockito.when((Object)mockLuceneIndexFactory.setFields(ArgumentMatchers.anyMap())).thenAnswer(invocation -> {
            Map fieldAnalyzersArgument = (Map)invocation.getArgument(0);
            fieldAnalyzers.clear();
            fieldAnalyzers.putAll(CollectionUtils.nullSafeMap((Map)fieldAnalyzersArgument));
            return mockLuceneIndexFactory;
        });
        Mockito.when((Object)mockLuceneIndexFactory.setLuceneSerializer((LuceneSerializer)ArgumentMatchers.any(LuceneSerializer.class))).thenAnswer(invocation -> {
            LuceneSerializer luceneSerializerArgument = (LuceneSerializer)invocation.getArgument(0);
            luceneSerializer.set(luceneSerializerArgument);
            return mockLuceneIndexFactory;
        });
        ((LuceneIndexFactory)Mockito.doAnswer(invocation -> {
            String indexName = (String)invocation.getArgument(0);
            String regionPath = (String)invocation.getArgument(1);
            LuceneIndexKey key = LuceneIndexKey.of(indexName, regionPath);
            LuceneIndex mockLuceneIndex = (LuceneIndex)Mockito.mock(LuceneIndex.class, (String)key.toString());
            Mockito.when((Object)mockLuceneIndex.getFieldAnalyzers()).thenReturn(Collections.unmodifiableMap(fieldAnalyzers));
            Mockito.when((Object)mockLuceneIndex.getFieldNames()).thenAnswer(in -> fields.toArray(new String[fields.size()]));
            Mockito.when((Object)mockLuceneIndex.getLuceneSerializer()).thenAnswer(in -> (LuceneSerializer)luceneSerializer.get());
            Mockito.when((Object)mockLuceneIndex.getName()).thenReturn((Object)indexName);
            Mockito.when((Object)mockLuceneIndex.getRegionPath()).thenReturn((Object)regionPath);
            Optional.ofNullable(luceneIndexes).ifPresent(it -> it.put(key, mockLuceneIndex));
            return null;
        }).when((Object)mockLuceneIndexFactory)).create(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        return mockLuceneIndexFactory;
    }

    public static LuceneQueryFactory mockLuceneQueryFactory() {
        LuceneQueryFactory mockLuceneQueryFactory = (LuceneQueryFactory)Mockito.mock(LuceneQueryFactory.class);
        AtomicInteger limit = new AtomicInteger(100);
        AtomicInteger pageSize = new AtomicInteger(0);
        Mockito.when((Object)mockLuceneQueryFactory.setLimit(ArgumentMatchers.anyInt())).thenAnswer(invocation -> {
            limit.set((Integer)invocation.getArgument(0));
            return mockLuceneQueryFactory;
        });
        Mockito.when((Object)mockLuceneQueryFactory.setPageSize(ArgumentMatchers.anyInt())).thenAnswer(invocation -> {
            pageSize.set((Integer)invocation.getArgument(0));
            return mockLuceneQueryFactory;
        });
        Mockito.when((Object)mockLuceneQueryFactory.create(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (LuceneQueryProvider)ArgumentMatchers.any(LuceneQueryProvider.class))).thenAnswer(invocation -> GemFireMockObjectsSupport.mockLuceneQuery(limit.get(), pageSize.get()));
        Mockito.when((Object)mockLuceneQueryFactory.create(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(invocation -> GemFireMockObjectsSupport.mockLuceneQuery(limit.get(), pageSize.get()));
        return mockLuceneQueryFactory;
    }

    private static LuceneQuery mockLuceneQuery(int limit, int pageSize) {
        LuceneQuery mockLuceneQuery = (LuceneQuery)Mockito.mock(LuceneQuery.class);
        Mockito.when((Object)mockLuceneQuery.getLimit()).thenReturn((Object)limit);
        Mockito.when((Object)mockLuceneQuery.getPageSize()).thenReturn((Object)pageSize);
        ObjectUtils.doOperationSafely(() -> Mockito.when((Object)mockLuceneQuery.findKeys()).thenReturn(Collections.emptySet()), Collections.emptySet());
        ObjectUtils.rethrowAsRuntimeException(() -> Mockito.when((Object)mockLuceneQuery.findPages()).thenThrow(new Throwable[]{RuntimeExceptionFactory.newUnsupportedOperationException((String)"Operation Not Supported!", (Object[])new Object[0])}));
        ObjectUtils.doOperationSafely(() -> Mockito.when((Object)mockLuceneQuery.findResults()).thenReturn(Collections.emptyList()), Collections.emptyList());
        ObjectUtils.doOperationSafely(() -> Mockito.when((Object)mockLuceneQuery.findValues()).thenReturn(Collections.emptyList()), Collections.emptyList());
        return mockLuceneQuery;
    }

    public static LuceneService mockLuceneService(Cache mockCache) {
        LuceneService mockLuceneService = (LuceneService)Mockito.mock(LuceneService.class);
        ConcurrentHashMap luceneIndexes = new ConcurrentHashMap();
        Mockito.when((Object)mockLuceneService.createIndexFactory()).thenAnswer(invocation -> GemFireMockObjectsSupport.mockLuceneIndexFactory(luceneIndexes));
        Mockito.when((Object)mockLuceneService.createLuceneQueryFactory()).thenAnswer(invocation -> GemFireMockObjectsSupport.mockLuceneQueryFactory());
        ((LuceneService)Mockito.doAnswer(invocation -> {
            String indexName = (String)invocation.getArgument(0);
            String regionName = (String)invocation.getArgument(1);
            luceneIndexes.remove(LuceneIndexKey.of(indexName, regionName));
            return null;
        }).when((Object)mockLuceneService)).destroyIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((LuceneService)Mockito.doAnswer(invocation -> {
            String regionPath = (String)invocation.getArgument(0);
            luceneIndexes.keySet().stream().filter(key -> key.getRegionPath().equals(regionPath)).collect(Collectors.toSet()).forEach(key -> {
                LuceneIndex cfr_ignored_0 = (LuceneIndex)luceneIndexes.remove(key);
            });
            return null;
        }).when((Object)mockLuceneService)).destroyIndexes(ArgumentMatchers.anyString());
        Mockito.when((Object)mockLuceneService.getAllIndexes()).thenAnswer(invocation -> Collections.unmodifiableCollection(luceneIndexes.values()));
        Mockito.when((Object)mockLuceneService.getCache()).thenReturn((Object)mockCache);
        Mockito.when((Object)mockLuceneService.getIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String indexName = (String)invocation.getArgument(0);
            String regionPath = (String)invocation.getArgument(1);
            return luceneIndexes.get(LuceneIndexKey.of(indexName, regionPath));
        });
        ObjectUtils.doOperationSafely(() -> Mockito.when((Object)mockLuceneService.waitUntilFlushed(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.any(TimeUnit.class))))).thenReturn((Object)true));
        return mockLuceneService;
    }

    public static <K, V> Region<K, V> mockRegion(RegionService regionService, String name, RegionAttributes<K, V> regionAttributes) {
        Region mockRegion = (Region)Mockito.mock(Region.class, (MockSettings)Mockito.withSettings().name(name).lenient());
        RegionAttributes<K, V> mockRegionAttributes = GemFireMockObjectsSupport.mockRegionAttributes(mockRegion, regionAttributes);
        CopyOnWriteArraySet subRegions = new CopyOnWriteArraySet();
        Mockito.when((Object)mockRegion.getFullPath()).thenReturn((Object)GemFireMockObjectsSupport.toRegionPath(name));
        Mockito.when((Object)mockRegion.getName()).thenReturn((Object)GemFireMockObjectsSupport.toRegionName(name));
        Mockito.when((Object)mockRegion.getRegionService()).thenReturn((Object)regionService);
        GemFireMockObjectsSupport.mockRegionDataAccessOperations(mockRegion, mockRegionAttributes);
        ((Region)Mockito.doAnswer(invocation -> {
            String subRegionPath = GemFireMockObjectsSupport.toRegionPath((String)invocation.getArgument(0));
            String subRegionFullPath = String.format("%1$s%2$s", mockRegion.getFullPath(), subRegionPath);
            return regions.get(subRegionFullPath);
        }).when((Object)mockRegion)).getSubregion(ArgumentMatchers.anyString());
        ((Region)Mockito.doAnswer(invocation -> {
            boolean recursive = (Boolean)invocation.getArgument(0);
            return recursive ? subRegions.stream().flatMap(subRegion -> subRegion.subregions(true).stream()).collect(Collectors.toSet()) : subRegions;
        }).when((Object)mockRegion)).subregions(ArgumentMatchers.anyBoolean());
        return GemFireMockObjectsSupport.rememberMockedRegion(mockRegion);
    }

    private static <K, V> RegionAttributes<K, V> mockRegionAttributes(Region<K, V> mockRegion, RegionAttributes<K, V> baseRegionAttributes) {
        AttributesMutator mockAttributesMutator = (AttributesMutator)Mockito.mock(AttributesMutator.class, (MockSettings)Mockito.withSettings().lenient());
        EvictionAttributesMutator mockEvictionAttributesMutator = (EvictionAttributesMutator)Mockito.mock(EvictionAttributesMutator.class, (MockSettings)Mockito.withSettings().lenient());
        RegionAttributes mockRegionAttributes = (RegionAttributes)Mockito.mock(RegionAttributes.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)mockRegion.getAttributes()).thenReturn((Object)mockRegionAttributes);
        Mockito.when((Object)mockRegion.getAttributesMutator()).thenReturn((Object)mockAttributesMutator);
        Mockito.when((Object)mockAttributesMutator.getEvictionAttributesMutator()).thenReturn((Object)mockEvictionAttributesMutator);
        Mockito.when((Object)mockAttributesMutator.getRegion()).thenReturn(mockRegion);
        AtomicBoolean cloningEnabled = new AtomicBoolean(baseRegionAttributes.getCloningEnabled());
        AtomicInteger evictionMaximum = new AtomicInteger(Optional.ofNullable(baseRegionAttributes.getEvictionAttributes()).map(EvictionAttributes::getMaximum).orElse(900));
        AtomicReference<CacheLoader> cacheLoader = new AtomicReference<CacheLoader>(baseRegionAttributes.getCacheLoader());
        AtomicReference<CacheWriter> cacheWriter = new AtomicReference<CacheWriter>(baseRegionAttributes.getCacheWriter());
        AtomicReference<CustomExpiry> customEntryIdleTimeout = new AtomicReference<CustomExpiry>(baseRegionAttributes.getCustomEntryIdleTimeout());
        AtomicReference<CustomExpiry> customEntryTimeToLive = new AtomicReference<CustomExpiry>(baseRegionAttributes.getCustomEntryTimeToLive());
        AtomicReference<ExpirationAttributes> entryIdleTimeout = new AtomicReference<ExpirationAttributes>(baseRegionAttributes.getEntryIdleTimeout());
        AtomicReference<ExpirationAttributes> entryTimeToLive = new AtomicReference<ExpirationAttributes>(baseRegionAttributes.getEntryTimeToLive());
        AtomicReference<ExpirationAttributes> regionIdleTimeout = new AtomicReference<ExpirationAttributes>(baseRegionAttributes.getRegionIdleTimeout());
        AtomicReference<ExpirationAttributes> regionTimeToLive = new AtomicReference<ExpirationAttributes>(baseRegionAttributes.getRegionTimeToLive());
        CopyOnWriteArrayList asyncEventQueueIds = new CopyOnWriteArrayList(CollectionUtils.nullSafeSet((Set)baseRegionAttributes.getAsyncEventQueueIds()));
        CopyOnWriteArrayList<Object> cacheListeners = new CopyOnWriteArrayList<Object>(ArrayUtils.nullSafeArray((Object[])baseRegionAttributes.getCacheListeners(), CacheListener.class));
        CopyOnWriteArrayList gatewaySenderIds = new CopyOnWriteArrayList(CollectionUtils.nullSafeSet((Set)baseRegionAttributes.getGatewaySenderIds()));
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newAdder(asyncEventQueueIds, null)).when((Object)mockAttributesMutator)).addAsyncEventQueueId(ArgumentMatchers.anyString());
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newAdder(cacheListeners, null)).when((Object)mockAttributesMutator)).addCacheListener((CacheListener)ArgumentMatchers.any(CacheListener.class));
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newAdder(gatewaySenderIds, null)).when((Object)mockAttributesMutator)).addGatewaySenderId(ArgumentMatchers.anyString());
        Mockito.when((Object)mockAttributesMutator.getCloningEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(cloningEnabled::get));
        ((AttributesMutator)Mockito.doAnswer(invocation -> {
            CacheListener[] cacheListenersArgument = (CacheListener[])ArrayUtils.nullSafeArray((Object[])((Object[])invocation.getArgument(0)), CacheListener.class);
            Arrays.stream(cacheListenersArgument).forEach(it -> Assert.notNull((Object)it, (String)"The CacheListener[] must not contain null elements"));
            cacheListeners.forEach(CacheCallback::close);
            cacheListeners.addAll(Arrays.asList(cacheListenersArgument));
            return null;
        }).when((Object)mockAttributesMutator)).initCacheListeners((CacheListener[])ArgumentMatchers.any(CacheListener[].class));
        ((AttributesMutator)Mockito.doAnswer(invocation -> asyncEventQueueIds.remove(invocation.getArgument(0))).when((Object)mockAttributesMutator)).removeAsyncEventQueueId(ArgumentMatchers.anyString());
        ((AttributesMutator)Mockito.doAnswer(invocation -> cacheListeners.remove(invocation.getArgument(0))).when((Object)mockAttributesMutator)).removeCacheListener((CacheListener)ArgumentMatchers.any(CacheListener.class));
        ((AttributesMutator)Mockito.doAnswer(invocation -> gatewaySenderIds.remove(invocation.getArgument(0))).when((Object)mockAttributesMutator)).removeGatewaySenderId(ArgumentMatchers.anyString());
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(cacheLoader)).when((Object)mockAttributesMutator)).setCacheLoader((CacheLoader)ArgumentMatchers.any(CacheLoader.class));
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(cacheWriter)).when((Object)mockAttributesMutator)).setCacheWriter((CacheWriter)ArgumentMatchers.any(CacheWriter.class));
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(cloningEnabled, null)).when((Object)mockAttributesMutator)).setCloningEnabled(ArgumentMatchers.anyBoolean());
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(customEntryIdleTimeout)).when((Object)mockAttributesMutator)).setCustomEntryIdleTimeout((CustomExpiry)ArgumentMatchers.any(CustomExpiry.class));
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(customEntryTimeToLive)).when((Object)mockAttributesMutator)).setCustomEntryTimeToLive((CustomExpiry)ArgumentMatchers.any(CustomExpiry.class));
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(entryIdleTimeout)).when((Object)mockAttributesMutator)).setEntryIdleTimeout((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class));
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(entryTimeToLive)).when((Object)mockAttributesMutator)).setEntryTimeToLive((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class));
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(regionIdleTimeout)).when((Object)mockAttributesMutator)).setRegionIdleTimeout((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class));
        ((AttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(regionTimeToLive)).when((Object)mockAttributesMutator)).setRegionTimeToLive((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class));
        ((EvictionAttributesMutator)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(evictionMaximum, null)).when((Object)mockEvictionAttributesMutator)).setMaximum(ArgumentMatchers.anyInt());
        Mockito.when((Object)mockRegionAttributes.getAsyncEventQueueIds()).thenAnswer(invocation -> CollectionUtils.asSet((Object[])asyncEventQueueIds.toArray(new String[asyncEventQueueIds.size()])));
        Mockito.when((Object)mockRegionAttributes.getCacheListeners()).thenAnswer(invocation -> cacheListeners.toArray(new CacheListener[cacheListeners.size()]));
        Mockito.when((Object)mockRegionAttributes.getCacheLoader()).thenAnswer(GemFireMockObjectsSupport.newGetter(cacheLoader::get));
        Mockito.when((Object)mockRegionAttributes.getCacheWriter()).thenAnswer(GemFireMockObjectsSupport.newGetter(cacheWriter::get));
        Mockito.when((Object)mockRegionAttributes.getCloningEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(cloningEnabled::get));
        Mockito.when((Object)mockRegionAttributes.getCompressor()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getCompressor()));
        Mockito.when((Object)mockRegionAttributes.getConcurrencyChecksEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getConcurrencyChecksEnabled()));
        Mockito.when((Object)mockRegionAttributes.getConcurrencyLevel()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getConcurrencyLevel()));
        Mockito.when((Object)mockRegionAttributes.getCustomEntryIdleTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(customEntryIdleTimeout::get));
        Mockito.when((Object)mockRegionAttributes.getCustomEntryTimeToLive()).thenAnswer(GemFireMockObjectsSupport.newGetter(customEntryTimeToLive::get));
        Mockito.when((Object)mockRegionAttributes.getDataPolicy()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getDataPolicy()));
        Mockito.when((Object)mockRegionAttributes.getDiskStoreName()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getDiskStoreName()));
        Mockito.when((Object)mockRegionAttributes.getEnableAsyncConflation()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getEnableAsyncConflation()));
        Mockito.when((Object)mockRegionAttributes.getEnableSubscriptionConflation()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getEnableSubscriptionConflation()));
        Mockito.when((Object)mockRegionAttributes.getEntryIdleTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(entryIdleTimeout::get));
        Mockito.when((Object)mockRegionAttributes.getEntryTimeToLive()).thenAnswer(GemFireMockObjectsSupport.newGetter(entryTimeToLive::get));
        Mockito.when((Object)mockRegionAttributes.getEvictionAttributes()).thenAnswer(invocation -> {
            EvictionAttributes mockEvictionAttibutes = (EvictionAttributes)Mockito.mock(EvictionAttributes.class);
            EvictionAttributes regionEvictionAttributes = baseRegionAttributes.getEvictionAttributes();
            Mockito.when((Object)mockEvictionAttibutes.getAction()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> ((EvictionAttributes)regionEvictionAttributes).getAction()));
            Mockito.when((Object)mockEvictionAttibutes.getAlgorithm()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> ((EvictionAttributes)regionEvictionAttributes).getAlgorithm()));
            Mockito.when((Object)mockEvictionAttibutes.getMaximum()).thenAnswer(GemFireMockObjectsSupport.newGetter(evictionMaximum));
            Mockito.when((Object)mockEvictionAttibutes.getObjectSizer()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> ((EvictionAttributes)regionEvictionAttributes).getObjectSizer()));
            return mockEvictionAttibutes;
        });
        Mockito.when((Object)mockRegionAttributes.getGatewaySenderIds()).thenAnswer(invocation -> CollectionUtils.asSet((Object[])gatewaySenderIds.toArray(new String[gatewaySenderIds.size()])));
        Mockito.when((Object)mockRegionAttributes.getIgnoreJTA()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getIgnoreJTA()));
        Mockito.when((Object)mockRegionAttributes.getIndexMaintenanceSynchronous()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getIndexMaintenanceSynchronous()));
        Mockito.when((Object)mockRegionAttributes.getInitialCapacity()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getInitialCapacity()));
        Mockito.when((Object)mockRegionAttributes.getKeyConstraint()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getKeyConstraint()));
        Mockito.when((Object)Float.valueOf(mockRegionAttributes.getLoadFactor())).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getLoadFactor()));
        Mockito.when((Object)mockRegionAttributes.getMembershipAttributes()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getMembershipAttributes()));
        Mockito.when((Object)mockRegionAttributes.getMulticastEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getMulticastEnabled()));
        Mockito.when((Object)mockRegionAttributes.getOffHeap()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getOffHeap()));
        Mockito.when((Object)mockRegionAttributes.getPartitionAttributes()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getPartitionAttributes()));
        Mockito.when((Object)mockRegionAttributes.getPoolName()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getPoolName()));
        Mockito.when((Object)mockRegionAttributes.getRegionIdleTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(regionIdleTimeout::get));
        Mockito.when((Object)mockRegionAttributes.getRegionTimeToLive()).thenAnswer(GemFireMockObjectsSupport.newGetter(regionTimeToLive::get));
        Mockito.when((Object)mockRegionAttributes.getScope()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getScope()));
        Mockito.when((Object)mockRegionAttributes.getStatisticsEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getStatisticsEnabled()));
        Mockito.when((Object)mockRegionAttributes.getSubscriptionAttributes()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getSubscriptionAttributes()));
        Mockito.when((Object)mockRegionAttributes.getValueConstraint()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.getValueConstraint()));
        Mockito.when((Object)mockRegionAttributes.isDiskSynchronous()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.isDiskSynchronous()));
        Mockito.when((Object)mockRegionAttributes.isLockGrantor()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> baseRegionAttributes.isLockGrantor()));
        return mockRegionAttributes;
    }

    private static <K, V> void mockRegionDataAccessOperations(Region<K, V> mockRegion, RegionAttributes<K, V> mockRegionAttributes) {
        ConcurrentHashMap data = new ConcurrentHashMap();
        HashSet invalidatedKeys = new HashSet();
        ((Region)Mockito.doAnswer(invocation -> {
            data.clear();
            return null;
        }).when(mockRegion)).clear();
        ((Region)Mockito.doAnswer(invocation -> data.containsKey(invocation.getArgument(0))).when(mockRegion)).containsKey(ArgumentMatchers.any());
        ((Region)Mockito.doAnswer(invocation -> data.containsValue(invocation.getArgument(0))).when(mockRegion)).containsValue(ArgumentMatchers.any());
        ((Region)Mockito.doAnswer(invocation -> {
            Object key = invocation.getArgument(0);
            return !invalidatedKeys.contains(key) && data.containsKey(key) && Objects.nonNull(data.get(key));
        }).when(mockRegion)).containsValueForKey(ArgumentMatchers.any());
        ((Region)Mockito.doAnswer(invocation -> {
            BiConsumer consumer = (BiConsumer)invocation.getArgument(0);
            data.forEach(consumer);
            return null;
        }).when(mockRegion)).forEach((BiConsumer)ArgumentMatchers.any(BiConsumer.class));
        ((Region)Mockito.doAnswer(invocation -> {
            Object value;
            Object key = invocation.getArgument(0);
            Object v0 = value = invalidatedKeys.contains(key) ? null : data.get(key);
            if (value == null) {
                value = Optional.ofNullable(mockRegionAttributes.getCacheLoader()).map(cacheLoader -> {
                    LoaderHelper mockLoaderHelper = (LoaderHelper)Mockito.mock(LoaderHelper.class, (MockSettings)Mockito.withSettings().lenient());
                    Mockito.when((Object)mockLoaderHelper.getArgument()).thenReturn(null);
                    Mockito.when((Object)mockLoaderHelper.getKey()).thenReturn(key);
                    Mockito.when((Object)mockLoaderHelper.getRegion()).thenReturn((Object)mockRegion);
                    return cacheLoader.load(mockLoaderHelper);
                }).map(loadedValue -> {
                    data.put(key, loadedValue);
                    invalidatedKeys.remove(key);
                    return loadedValue;
                }).orElse(value);
            }
            return value;
        }).when(mockRegion)).get(ArgumentMatchers.any());
        ((Region)Mockito.doAnswer(invocation -> {
            Collection keys = (Collection)invocation.getArgument(0);
            HashMap result = new HashMap(keys.size());
            for (Object key : keys) {
                if (key == null) continue;
                result.put(key, mockRegion.get(key));
            }
            return result;
        }).when(mockRegion)).getAll((Collection)ArgumentMatchers.any(Collection.class));
        Mockito.when((Object)mockRegion.getEntry(ArgumentMatchers.any())).thenAnswer(regionGetEntryInvocation -> data.entrySet().stream().filter(entry -> entry.getKey().equals(regionGetEntryInvocation.getArgument(0))).findFirst().map(entry -> {
            Map.Entry entrySpy = (Map.Entry)Mockito.spy((Object)entry);
            ((Map.Entry)Mockito.doAnswer(entryGetValueInvocation -> invalidatedKeys.contains(entry.getKey()) ? null : entry.getValue()).when((Object)entrySpy)).getValue();
            return entrySpy;
        }).orElse(null));
        ((Region)Mockito.doAnswer(invocation -> {
            Object key = invocation.getArgument(0);
            Object value = data.get(key);
            Object defaultValue = invocation.getArgument(1);
            return value != null ? value : defaultValue;
        }).when(mockRegion)).getOrDefault(ArgumentMatchers.any(), ArgumentMatchers.any());
        ((Region)Mockito.doAnswer(invocation -> {
            Object key = invocation.getArgument(0);
            if (!data.containsKey(key)) {
                throw new EntryNotFoundException(String.format("Entry with key [%s] not found", key));
            }
            if (invalidatedKeys.add(key)) {
                EntryEvent mockEntryEvent = (EntryEvent)Mockito.mock(EntryEvent.class, (MockSettings)Mockito.withSettings().lenient());
                Mockito.when((Object)mockEntryEvent.getKey()).thenReturn(key);
                Mockito.when((Object)mockEntryEvent.getNewValue()).thenReturn(null);
                Mockito.when((Object)mockEntryEvent.getOldValue()).thenReturn(data.get(key));
                Mockito.when((Object)mockEntryEvent.getRegion()).thenReturn((Object)mockRegion);
                Arrays.stream(ArrayUtils.nullSafeArray((Object[])mockRegionAttributes.getCacheListeners(), CacheListener.class)).filter(Objects::nonNull).forEach(cacheListener -> cacheListener.afterInvalidate(mockEntryEvent));
            }
            return null;
        }).when(mockRegion)).invalidate(ArgumentMatchers.any());
        ((Region)Mockito.doAnswer(invocation -> data.isEmpty()).when(mockRegion)).isEmpty();
        ((Region)Mockito.doAnswer(invocation -> Collections.unmodifiableSet(data.keySet())).when(mockRegion)).keySet();
        ((Region)Mockito.doAnswer(invocation -> {
            mockRegion.clear();
            return null;
        }).when(mockRegion)).localClear();
        ((Region)Mockito.doAnswer(invocation -> {
            mockRegion.invalidate(invocation.getArgument(0));
            return null;
        }).when(mockRegion)).localInvalidate(ArgumentMatchers.any());
        ((Region)Mockito.doAnswer(invocation -> {
            Object key = invocation.getArgument(0);
            Object newValue = invocation.getArgument(1);
            Assert.notNull((Object)newValue, (String)"Value is required");
            boolean entryExists = data.containsKey(key);
            EntryEvent mockEntryEvent = (EntryEvent)Mockito.mock(EntryEvent.class, (MockSettings)Mockito.withSettings().lenient());
            Object entryEventValue = invalidatedKeys.contains(key) ? null : data.get(key);
            Mockito.when((Object)mockEntryEvent.getKey()).thenReturn(key);
            Mockito.when((Object)mockEntryEvent.getNewValue()).thenReturn(newValue);
            Mockito.when((Object)mockEntryEvent.getOldValue()).thenReturn(entryEventValue);
            Mockito.when((Object)mockEntryEvent.getRegion()).thenReturn((Object)mockRegion);
            CacheWriter cacheWriter = mockRegionAttributes.getCacheWriter();
            if (cacheWriter != null) {
                try {
                    if (entryExists) {
                        cacheWriter.beforeUpdate(mockEntryEvent);
                    } else {
                        cacheWriter.beforeCreate(mockEntryEvent);
                    }
                }
                catch (Throwable cause) {
                    throw new CacheWriterException("Create/Update Error", cause);
                }
            }
            Object existingValue = data.put(key, newValue);
            Arrays.stream(ArrayUtils.nullSafeArray((Object[])mockRegionAttributes.getCacheListeners(), CacheListener.class)).filter(Objects::nonNull).forEach(cacheListener -> {
                if (entryExists) {
                    cacheListener.afterUpdate(mockEntryEvent);
                } else {
                    cacheListener.afterCreate(mockEntryEvent);
                }
            });
            return invalidatedKeys.remove(key) ? null : existingValue;
        }).when(mockRegion)).put(ArgumentMatchers.any(), ArgumentMatchers.any());
        ((Region)Mockito.doAnswer(invocation -> {
            Map map = (Map)invocation.getArgument(0);
            CollectionUtils.nullSafeMap((Map)map).entrySet().forEach(entry -> mockRegion.put(entry.getKey(), entry.getValue()));
            return null;
        }).when(mockRegion)).putAll((Map)ArgumentMatchers.any(Map.class));
        ((Region)Mockito.doAnswer(invocation -> {
            Object key = invocation.getArgument(0);
            EntryEvent mockEntryEvent = (EntryEvent)Mockito.mock(EntryEvent.class, (MockSettings)Mockito.withSettings().lenient());
            Object entryEventValue = invalidatedKeys.contains(key) ? null : data.get(key);
            Mockito.when((Object)mockEntryEvent.getKey()).thenReturn(key);
            Mockito.when((Object)mockEntryEvent.getNewValue()).thenReturn(null);
            Mockito.when((Object)mockEntryEvent.getOldValue()).thenReturn(entryEventValue);
            Mockito.when((Object)mockEntryEvent.getRegion()).thenReturn((Object)mockRegion);
            CacheWriter cacheWriter = mockRegionAttributes.getCacheWriter();
            if (cacheWriter != null) {
                try {
                    cacheWriter.beforeDestroy(mockEntryEvent);
                }
                catch (Throwable cause) {
                    throw new CacheWriterException("Destroy Error", cause);
                }
            }
            Object value = data.remove(key);
            Arrays.stream(ArrayUtils.nullSafeArray((Object[])mockRegionAttributes.getCacheListeners(), CacheListener.class)).filter(Objects::nonNull).forEach(cacheListener -> cacheListener.afterDestroy(mockEntryEvent));
            return invalidatedKeys.remove(key) ? null : value;
        }).when(mockRegion)).remove(ArgumentMatchers.any());
        ((Region)Mockito.doAnswer(invocation -> {
            Collection keys = (Collection)invocation.getArgument(0);
            CollectionUtils.nullSafeCollection((Collection)keys).stream().filter(Objects::nonNull).forEach(arg_0 -> ((Region)mockRegion).remove(arg_0));
            return null;
        }).when(mockRegion)).removeAll((Collection)ArgumentMatchers.any(Collection.class));
        ((Region)Mockito.doAnswer(invocation -> data.size()).when(mockRegion)).size();
        ((Region)Mockito.doAnswer(invocation -> Collections.unmodifiableCollection(data.values())).when(mockRegion)).values();
    }

    public static <K, V> Region<K, V> mockSubRegion(Region<K, V> parent, String name, RegionAttributes<K, V> regionAttributes) {
        String subRegionName = String.format("%1$s%2$s", parent.getFullPath(), GemFireMockObjectsSupport.toRegionPath(name));
        Region<K, V> mockSubRegion = GemFireMockObjectsSupport.mockRegion(parent.getRegionService(), subRegionName, regionAttributes);
        ((Region)Mockito.doReturn(parent).when(mockSubRegion)).getParentRegion();
        parent.subregions(false).add(mockSubRegion);
        return mockSubRegion;
    }

    public static <K, V> RegionFactory<K, V> mockRegionFactory(Cache mockCache) {
        return GemFireMockObjectsSupport.mockRegionFactory(mockCache, null, null);
    }

    public static <K, V> RegionFactory<K, V> mockRegionFactory(Cache mockCache, RegionAttributes<K, V> regionAttributes) {
        return GemFireMockObjectsSupport.mockRegionFactory(mockCache, regionAttributes, null);
    }

    public static <K, V> RegionFactory<K, V> mockRegionFactory(Cache mockCache, RegionShortcut regionShortcut) {
        return GemFireMockObjectsSupport.mockRegionFactory(mockCache, GemFireMockObjectsSupport.resolveRegionAttributesFromRegionShortcut(regionShortcut), regionShortcut);
    }

    public static <K, V> RegionFactory<K, V> mockRegionFactory(Cache mockCache, String regionAttributesId) {
        return GemFireMockObjectsSupport.mockRegionFactory(mockCache, GemFireMockObjectsSupport.resolveRegionAttributes(regionAttributesId), null);
    }

    public static <K, V> RegionFactory<K, V> mockRegionFactory(Cache mockCache, RegionAttributes<K, V> regionAttributes, RegionShortcut regionShortcut) {
        RegionFactory mockRegionFactory = (RegionFactory)Mockito.mock(RegionFactory.class, (String)GemFireMockObjectsSupport.mockObjectIdentifier("MockRegionFactory"));
        Optional<RegionAttributes<K, V>> optionalRegionAttributes = Optional.ofNullable(regionAttributes);
        ExpirationAttributes DEFAULT_EXPIRATION_ATTRIBUTES = new ExpirationAttributes(0, ExpirationAction.INVALIDATE);
        AtomicBoolean cloningEnabled = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getCloningEnabled).orElse(false));
        AtomicBoolean concurrencyChecksEnabled = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getConcurrencyChecksEnabled).orElse(true));
        AtomicBoolean diskSynchronous = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::isDiskSynchronous).orElse(true));
        AtomicBoolean enableAsyncConflation = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getEnableAsyncConflation).orElse(false));
        AtomicBoolean enableSubscriptionConflation = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getEnableSubscriptionConflation).orElse(false));
        AtomicBoolean ignoreJta = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getIgnoreJTA).orElse(false));
        AtomicBoolean indexMaintenanceSynchronous = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getIndexMaintenanceSynchronous).orElse(true));
        AtomicBoolean lockGrantor = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::isLockGrantor).orElse(false));
        AtomicBoolean multicastEnabled = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getMulticastEnabled).orElse(false));
        AtomicBoolean offHeap = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getOffHeap).orElse(false));
        AtomicBoolean statisticsEnabled = new AtomicBoolean(optionalRegionAttributes.map(RegionAttributes::getStatisticsEnabled).orElse(false));
        AtomicInteger concurrencyLevel = new AtomicInteger(optionalRegionAttributes.map(RegionAttributes::getConcurrencyLevel).orElse(16));
        AtomicInteger initialCapacity = new AtomicInteger(optionalRegionAttributes.map(RegionAttributes::getInitialCapacity).orElse(16));
        AtomicReference<Object> cacheLoader = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getCacheLoader).orElse(null));
        AtomicReference<Object> cacheWriter = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getCacheWriter).orElse(null));
        AtomicReference<Object> compressor = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getCompressor).orElse(null));
        AtomicReference<Object> customEntryIdleTimeout = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getCustomEntryIdleTimeout).orElse(null));
        AtomicReference<Object> customEntryTimeToLive = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getCustomEntryTimeToLive).orElse(null));
        AtomicReference<DataPolicy> dataPolicy = new AtomicReference<DataPolicy>(optionalRegionAttributes.map(RegionAttributes::getDataPolicy).orElseGet(() -> GemFireMockObjectsSupport.convert(regionShortcut)));
        AtomicReference<Object> diskStoreName = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getDiskStoreName).orElse(null));
        AtomicReference<ExpirationAttributes> entryIdleTimeout = new AtomicReference<ExpirationAttributes>(optionalRegionAttributes.map(RegionAttributes::getEntryIdleTimeout).orElse(DEFAULT_EXPIRATION_ATTRIBUTES));
        AtomicReference<ExpirationAttributes> entryTimeToLive = new AtomicReference<ExpirationAttributes>(optionalRegionAttributes.map(RegionAttributes::getEntryTimeToLive).orElse(DEFAULT_EXPIRATION_ATTRIBUTES));
        AtomicReference<EvictionAttributes> evictionAttributes = new AtomicReference<EvictionAttributes>(optionalRegionAttributes.map(RegionAttributes::getEvictionAttributes).orElseGet(EvictionAttributes::createLRUEntryAttributes));
        AtomicReference<Object> keyConstraint = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getKeyConstraint).orElse(null));
        AtomicReference<Float> loadFactor = new AtomicReference<Float>(optionalRegionAttributes.map(RegionAttributes::getLoadFactor).orElse(Float.valueOf(0.75f)));
        AtomicReference<MembershipAttributes> membershipAttributes = new AtomicReference<MembershipAttributes>(optionalRegionAttributes.map(RegionAttributes::getMembershipAttributes).orElseGet(MembershipAttributes::new));
        AtomicReference<Object> partitionAttributes = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getPartitionAttributes).orElse(null));
        AtomicReference<Object> poolName = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getPoolName).orElse(null));
        AtomicReference<ExpirationAttributes> regionIdleTimeout = new AtomicReference<ExpirationAttributes>(optionalRegionAttributes.map(RegionAttributes::getRegionIdleTimeout).orElse(DEFAULT_EXPIRATION_ATTRIBUTES));
        AtomicReference<ExpirationAttributes> regionTimeToLive = new AtomicReference<ExpirationAttributes>(optionalRegionAttributes.map(RegionAttributes::getRegionTimeToLive).orElse(DEFAULT_EXPIRATION_ATTRIBUTES));
        AtomicReference<Scope> scope = new AtomicReference<Scope>(optionalRegionAttributes.map(RegionAttributes::getScope).orElse(Scope.DISTRIBUTED_NO_ACK));
        AtomicReference<SubscriptionAttributes> subscriptionAttributes = new AtomicReference<SubscriptionAttributes>(optionalRegionAttributes.map(RegionAttributes::getSubscriptionAttributes).orElseGet(SubscriptionAttributes::new));
        AtomicReference<Object> valueConstraint = new AtomicReference<Object>(optionalRegionAttributes.map(RegionAttributes::getValueConstraint).orElse(null));
        ArrayList<Object> cacheListeners = new ArrayList<Object>(Arrays.asList(ArrayUtils.nullSafeArray((Object[])optionalRegionAttributes.map(RegionAttributes::getCacheListeners).orElse(null), CacheListener.class)));
        HashSet asyncEventQueueIds = new HashSet(CollectionUtils.nullSafeSet((Set)optionalRegionAttributes.map(RegionAttributes::getAsyncEventQueueIds).orElse(null)));
        HashSet gatewaySenderIds = new HashSet(CollectionUtils.nullSafeSet((Set)optionalRegionAttributes.map(RegionAttributes::getGatewaySenderIds).orElse(null)));
        Mockito.when((Object)mockRegionFactory.addAsyncEventQueueId(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newAdder(asyncEventQueueIds, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.addCacheListener((CacheListener)ArgumentMatchers.any(CacheListener.class))).thenAnswer(GemFireMockObjectsSupport.newAdder(cacheListeners, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.addGatewaySenderId(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newAdder(gatewaySenderIds, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.initCacheListeners((CacheListener[])ArgumentMatchers.any(CacheListener[].class))).thenAnswer(invocation -> {
            cacheListeners.clear();
            Collections.addAll(cacheListeners, (Object[])invocation.getArgument(0));
            return mockRegionFactory;
        });
        Mockito.when((Object)mockRegionFactory.setCacheLoader((CacheLoader)ArgumentMatchers.any(CacheLoader.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(cacheLoader, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setCacheWriter((CacheWriter)ArgumentMatchers.any(CacheWriter.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(cacheWriter, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setCloningEnabled(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(cloningEnabled, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setCompressor((Compressor)ArgumentMatchers.any(Compressor.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(compressor, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setConcurrencyChecksEnabled(ArgumentMatchers.anyBoolean())).then(GemFireMockObjectsSupport.newSetter(concurrencyChecksEnabled, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setConcurrencyLevel(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(concurrencyLevel, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setCustomEntryIdleTimeout((CustomExpiry)ArgumentMatchers.any(CustomExpiry.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(customEntryIdleTimeout, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setCustomEntryTimeToLive((CustomExpiry)ArgumentMatchers.any(CustomExpiry.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(customEntryTimeToLive, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setDataPolicy((DataPolicy)ArgumentMatchers.any(DataPolicy.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(dataPolicy, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setDiskStoreName(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newSetter(diskStoreName, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setDiskSynchronous(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(diskSynchronous, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setEnableAsyncConflation(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(enableAsyncConflation, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setEnableSubscriptionConflation(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(enableSubscriptionConflation, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setEntryIdleTimeout((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(entryIdleTimeout, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setEntryTimeToLive((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(entryTimeToLive, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setEvictionAttributes((EvictionAttributes)ArgumentMatchers.any(EvictionAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(evictionAttributes, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setIgnoreJTA(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(ignoreJta, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setIndexMaintenanceSynchronous(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(indexMaintenanceSynchronous, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setInitialCapacity(ArgumentMatchers.anyInt())).thenAnswer(GemFireMockObjectsSupport.newSetter(initialCapacity, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setKeyConstraint((Class)ArgumentMatchers.any(Class.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(keyConstraint, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setLoadFactor(ArgumentMatchers.anyFloat())).thenAnswer(GemFireMockObjectsSupport.newSetter(loadFactor, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setLockGrantor(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(lockGrantor, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setMembershipAttributes((MembershipAttributes)ArgumentMatchers.any(MembershipAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(membershipAttributes, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setMulticastEnabled(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(multicastEnabled, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setOffHeap(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(offHeap, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setPartitionAttributes((PartitionAttributes)ArgumentMatchers.any(PartitionAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(partitionAttributes, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setPoolName(ArgumentMatchers.anyString())).thenAnswer(GemFireMockObjectsSupport.newSetter(poolName, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setRegionIdleTimeout((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(regionIdleTimeout, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setRegionTimeToLive((ExpirationAttributes)ArgumentMatchers.any(ExpirationAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(regionTimeToLive, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setScope((Scope)ArgumentMatchers.any(Scope.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(scope, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setStatisticsEnabled(ArgumentMatchers.anyBoolean())).thenAnswer(GemFireMockObjectsSupport.newSetter(statisticsEnabled, mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setSubscriptionAttributes((SubscriptionAttributes)ArgumentMatchers.any(SubscriptionAttributes.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(subscriptionAttributes, () -> mockRegionFactory));
        Mockito.when((Object)mockRegionFactory.setValueConstraint((Class)ArgumentMatchers.any(Class.class))).thenAnswer(GemFireMockObjectsSupport.newSetter(valueConstraint, () -> mockRegionFactory));
        RegionAttributes mockRegionAttributes = (RegionAttributes)Mockito.mock(RegionAttributes.class, (String)GemFireMockObjectsSupport.mockObjectIdentifier("MockRegionAttributes"));
        Mockito.when((Object)mockRegionAttributes.getAsyncEventQueueIds()).thenReturn(asyncEventQueueIds);
        Mockito.when((Object)mockRegionAttributes.getCacheListeners()).thenAnswer(GemFireMockObjectsSupport.newGetter(() -> cacheListeners.toArray(new CacheListener[cacheListeners.size()])));
        Mockito.when((Object)mockRegionAttributes.getCacheLoader()).thenAnswer(GemFireMockObjectsSupport.newGetter(cacheLoader));
        Mockito.when((Object)mockRegionAttributes.getCacheWriter()).thenAnswer(GemFireMockObjectsSupport.newGetter(cacheWriter));
        Mockito.when((Object)mockRegionAttributes.getCloningEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(cloningEnabled));
        Mockito.when((Object)mockRegionAttributes.getCompressor()).thenAnswer(GemFireMockObjectsSupport.newGetter(compressor));
        Mockito.when((Object)mockRegionAttributes.getConcurrencyChecksEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(concurrencyChecksEnabled));
        Mockito.when((Object)mockRegionAttributes.getConcurrencyLevel()).thenAnswer(GemFireMockObjectsSupport.newGetter(concurrencyLevel));
        Mockito.when((Object)mockRegionAttributes.getCustomEntryIdleTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(customEntryIdleTimeout));
        Mockito.when((Object)mockRegionAttributes.getCustomEntryTimeToLive()).thenAnswer(GemFireMockObjectsSupport.newGetter(customEntryTimeToLive));
        Mockito.when((Object)mockRegionAttributes.getDataPolicy()).thenAnswer(GemFireMockObjectsSupport.newGetter(dataPolicy));
        Mockito.when((Object)mockRegionAttributes.getDiskStoreName()).thenAnswer(GemFireMockObjectsSupport.newGetter(diskStoreName));
        Mockito.when((Object)mockRegionAttributes.isDiskSynchronous()).thenAnswer(GemFireMockObjectsSupport.newGetter(diskSynchronous));
        Mockito.when((Object)mockRegionAttributes.getEnableAsyncConflation()).thenAnswer(GemFireMockObjectsSupport.newGetter(enableAsyncConflation));
        Mockito.when((Object)mockRegionAttributes.getEnableSubscriptionConflation()).thenAnswer(GemFireMockObjectsSupport.newGetter(enableSubscriptionConflation));
        Mockito.when((Object)mockRegionAttributes.getEntryIdleTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(entryIdleTimeout));
        Mockito.when((Object)mockRegionAttributes.getEntryTimeToLive()).thenAnswer(GemFireMockObjectsSupport.newGetter(entryTimeToLive));
        Mockito.when((Object)mockRegionAttributes.getEvictionAttributes()).thenAnswer(GemFireMockObjectsSupport.newGetter(evictionAttributes));
        Mockito.when((Object)mockRegionAttributes.getGatewaySenderIds()).thenReturn(gatewaySenderIds);
        Mockito.when((Object)mockRegionAttributes.getIgnoreJTA()).thenAnswer(GemFireMockObjectsSupport.newGetter(ignoreJta));
        Mockito.when((Object)mockRegionAttributes.getIndexMaintenanceSynchronous()).thenAnswer(GemFireMockObjectsSupport.newGetter(indexMaintenanceSynchronous));
        Mockito.when((Object)mockRegionAttributes.getInitialCapacity()).thenAnswer(GemFireMockObjectsSupport.newGetter(initialCapacity));
        Mockito.when((Object)mockRegionAttributes.getKeyConstraint()).thenAnswer(GemFireMockObjectsSupport.newGetter(keyConstraint));
        Mockito.when((Object)Float.valueOf(mockRegionAttributes.getLoadFactor())).thenAnswer(GemFireMockObjectsSupport.newGetter(loadFactor));
        Mockito.when((Object)mockRegionAttributes.isLockGrantor()).thenAnswer(GemFireMockObjectsSupport.newGetter(lockGrantor));
        Mockito.when((Object)mockRegionAttributes.getMembershipAttributes()).thenAnswer(GemFireMockObjectsSupport.newGetter(membershipAttributes));
        Mockito.when((Object)mockRegionAttributes.getMulticastEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(multicastEnabled));
        Mockito.when((Object)mockRegionAttributes.getOffHeap()).thenAnswer(GemFireMockObjectsSupport.newGetter(offHeap));
        Mockito.when((Object)mockRegionAttributes.getPartitionAttributes()).thenAnswer(GemFireMockObjectsSupport.newGetter(partitionAttributes));
        Mockito.when((Object)mockRegionAttributes.getPoolName()).thenAnswer(GemFireMockObjectsSupport.newGetter(poolName));
        Mockito.when((Object)mockRegionAttributes.getRegionIdleTimeout()).thenAnswer(GemFireMockObjectsSupport.newGetter(regionIdleTimeout));
        Mockito.when((Object)mockRegionAttributes.getRegionTimeToLive()).thenAnswer(GemFireMockObjectsSupport.newGetter(regionTimeToLive));
        Mockito.when((Object)mockRegionAttributes.getScope()).thenAnswer(GemFireMockObjectsSupport.newGetter(scope));
        Mockito.when((Object)mockRegionAttributes.getStatisticsEnabled()).thenAnswer(GemFireMockObjectsSupport.newGetter(statisticsEnabled));
        Mockito.when((Object)mockRegionAttributes.getSubscriptionAttributes()).thenAnswer(GemFireMockObjectsSupport.newGetter(subscriptionAttributes));
        Mockito.when((Object)mockRegionAttributes.getValueConstraint()).thenAnswer(GemFireMockObjectsSupport.newGetter(valueConstraint));
        Mockito.when((Object)mockRegionFactory.create(ArgumentMatchers.anyString())).thenAnswer(invocation -> GemFireMockObjectsSupport.mockRegion((RegionService)mockCache, (String)invocation.getArgument(0), mockRegionAttributes));
        Mockito.when((Object)mockRegionFactory.createSubregion((Region)ArgumentMatchers.any(Region.class), ArgumentMatchers.anyString())).thenAnswer(invocation -> GemFireMockObjectsSupport.mockSubRegion((Region)invocation.getArgument(0), (String)invocation.getArgument(1), mockRegionAttributes));
        return mockRegionFactory;
    }

    public static ResourceManager mockResourceManager() {
        ResourceManager mockResourceManager = (ResourceManager)Mockito.mock(ResourceManager.class);
        AtomicReference<Float> criticalHeapPercentage = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> criticalOffHeapPercentage = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> evictionHeapPercentage = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> evictionOffHeapPercentage = new AtomicReference<Float>(Float.valueOf(0.0f));
        ((ResourceManager)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(criticalHeapPercentage, () -> null)).when((Object)mockResourceManager)).setCriticalHeapPercentage(ArgumentMatchers.anyFloat());
        ((ResourceManager)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(criticalOffHeapPercentage, () -> null)).when((Object)mockResourceManager)).setCriticalOffHeapPercentage(ArgumentMatchers.anyFloat());
        ((ResourceManager)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(evictionHeapPercentage, () -> null)).when((Object)mockResourceManager)).setEvictionHeapPercentage(ArgumentMatchers.anyFloat());
        ((ResourceManager)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(evictionOffHeapPercentage, () -> null)).when((Object)mockResourceManager)).setEvictionOffHeapPercentage(ArgumentMatchers.anyFloat());
        Mockito.when((Object)Float.valueOf(mockResourceManager.getCriticalHeapPercentage())).thenAnswer(GemFireMockObjectsSupport.newGetter(criticalHeapPercentage));
        Mockito.when((Object)Float.valueOf(mockResourceManager.getCriticalOffHeapPercentage())).thenAnswer(GemFireMockObjectsSupport.newGetter(criticalOffHeapPercentage));
        Mockito.when((Object)Float.valueOf(mockResourceManager.getEvictionHeapPercentage())).thenAnswer(GemFireMockObjectsSupport.newGetter(evictionHeapPercentage));
        Mockito.when((Object)Float.valueOf(mockResourceManager.getEvictionOffHeapPercentage())).thenAnswer(GemFireMockObjectsSupport.newGetter(evictionOffHeapPercentage));
        Mockito.when((Object)mockResourceManager.getRebalanceOperations()).thenReturn(Collections.emptySet());
        return mockResourceManager;
    }

    public static boolean resolveUseSingletonCache() {
        return Boolean.parseBoolean(System.getProperty(USE_SINGLETON_CACHE_PROPERTY, String.valueOf(false)));
    }

    public static CacheFactory spyOn(CacheFactory cacheFactory) {
        return GemFireMockObjectsSupport.spyOn(cacheFactory, GemFireMockObjectsSupport.resolveUseSingletonCache());
    }

    public static CacheFactory spyOn(CacheFactory cacheFactory, boolean useSingletonCache) {
        AtomicBoolean pdxIgnoreUnreadFields = new AtomicBoolean(false);
        AtomicBoolean pdxPersistent = new AtomicBoolean(false);
        AtomicBoolean pdxReadSerialized = new AtomicBoolean(false);
        AtomicReference<Object> pdxDiskStoreName = new AtomicReference<Object>(null);
        AtomicReference<Object> pdxSerializer = new AtomicReference<Object>(null);
        CacheFactory cacheFactorySpy = (CacheFactory)Mockito.spy((Object)cacheFactory);
        ((CacheFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pdxDiskStoreName, () -> cacheFactorySpy)).when((Object)cacheFactorySpy)).setPdxDiskStore(ArgumentMatchers.anyString());
        ((CacheFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pdxIgnoreUnreadFields, cacheFactorySpy)).when((Object)cacheFactorySpy)).setPdxIgnoreUnreadFields(ArgumentMatchers.anyBoolean());
        ((CacheFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pdxPersistent, cacheFactorySpy)).when((Object)cacheFactorySpy)).setPdxPersistent(ArgumentMatchers.anyBoolean());
        ((CacheFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pdxReadSerialized, cacheFactorySpy)).when((Object)cacheFactorySpy)).setPdxReadSerialized(ArgumentMatchers.anyBoolean());
        ((CacheFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pdxSerializer, () -> cacheFactorySpy)).when((Object)cacheFactorySpy)).setPdxSerializer((PdxSerializer)ArgumentMatchers.any(PdxSerializer.class));
        Supplier<Cache> resolvedMockCache = () -> GemFireMockObjectsSupport.resolveMockedGemFireCache(useSingletonCache).orElseGet(() -> {
            Cache mockCache = GemFireMockObjectsSupport.mockPeerCache();
            Mockito.when((Object)mockCache.getPdxDiskStore()).thenAnswer(GemFireMockObjectsSupport.newGetter(pdxDiskStoreName));
            Mockito.when((Object)mockCache.getPdxIgnoreUnreadFields()).thenAnswer(GemFireMockObjectsSupport.newGetter(pdxIgnoreUnreadFields));
            Mockito.when((Object)mockCache.getPdxPersistent()).thenAnswer(GemFireMockObjectsSupport.newGetter(pdxPersistent));
            Mockito.when((Object)mockCache.getPdxReadSerialized()).thenAnswer(GemFireMockObjectsSupport.newGetter(pdxReadSerialized));
            Mockito.when((Object)mockCache.getPdxSerializer()).thenAnswer(GemFireMockObjectsSupport.newGetter(pdxSerializer));
            return mockCache;
        });
        ((CacheFactory)Mockito.doAnswer(invocation -> {
            GemFireMockObjectsSupport.storeConfiguration(cacheFactory);
            return GemFireMockObjectsSupport.rememberMockedGemFireCache(GemFireMockObjectsSupport.constructGemFireObjects((GemFireCache)resolvedMockCache.get()), useSingletonCache);
        }).when((Object)cacheFactorySpy)).create();
        return cacheFactorySpy;
    }

    public static ClientCacheFactory spyOn(ClientCacheFactory clientCacheFactory) {
        return GemFireMockObjectsSupport.spyOn(clientCacheFactory, GemFireMockObjectsSupport.resolveUseSingletonCache());
    }

    public static ClientCacheFactory spyOn(ClientCacheFactory clientCacheFactory, boolean useSingletonCache) {
        AtomicBoolean pdxIgnoreUnreadFields = new AtomicBoolean(false);
        AtomicBoolean pdxPersistent = new AtomicBoolean(false);
        AtomicBoolean pdxReadSerialized = new AtomicBoolean(false);
        AtomicReference<Object> pdxDiskStoreName = new AtomicReference<Object>(null);
        AtomicReference<Object> pdxSerializer = new AtomicReference<Object>(null);
        ClientCacheFactory clientCacheFactorySpy = (ClientCacheFactory)Mockito.spy((Object)clientCacheFactory);
        ((ClientCacheFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pdxDiskStoreName, () -> clientCacheFactorySpy)).when((Object)clientCacheFactorySpy)).setPdxDiskStore(ArgumentMatchers.anyString());
        ((ClientCacheFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pdxIgnoreUnreadFields, clientCacheFactorySpy)).when((Object)clientCacheFactorySpy)).setPdxIgnoreUnreadFields(ArgumentMatchers.anyBoolean());
        ((ClientCacheFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pdxPersistent, clientCacheFactorySpy)).when((Object)clientCacheFactorySpy)).setPdxPersistent(ArgumentMatchers.anyBoolean());
        ((ClientCacheFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pdxReadSerialized, clientCacheFactorySpy)).when((Object)clientCacheFactorySpy)).setPdxReadSerialized(ArgumentMatchers.anyBoolean());
        ((ClientCacheFactory)Mockito.doAnswer(GemFireMockObjectsSupport.newSetter(pdxSerializer, () -> clientCacheFactorySpy)).when((Object)clientCacheFactorySpy)).setPdxSerializer((PdxSerializer)ArgumentMatchers.any(PdxSerializer.class));
        PoolFactory mockPoolFactory = GemFireMockObjectsSupport.mockPoolFactory();
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.addLocator((String)invocation.getArgument(0), ((Integer)invocation.getArgument(1)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).addPoolLocator(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.addServer((String)invocation.getArgument(0), ((Integer)invocation.getArgument(1)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).addPoolServer(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setFreeConnectionTimeout(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolFreeConnectionTimeout(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setIdleTimeout(((Long)invocation.getArgument(0)).longValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolIdleTimeout(ArgumentMatchers.anyLong());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setLoadConditioningInterval(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolLoadConditioningInterval(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setMaxConnections(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolMaxConnections(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setMinConnections(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolMinConnections(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setMultiuserAuthentication(((Boolean)invocation.getArgument(0)).booleanValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolMultiuserAuthentication(ArgumentMatchers.anyBoolean());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setPingInterval(((Long)invocation.getArgument(0)).longValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolPingInterval(ArgumentMatchers.anyLong());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setPRSingleHopEnabled(((Boolean)invocation.getArgument(0)).booleanValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolPRSingleHopEnabled(ArgumentMatchers.anyBoolean());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setReadTimeout(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolReadTimeout(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setRetryAttempts(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolRetryAttempts(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setServerConnectionTimeout(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolServerConnectionTimeout(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setServerGroup((String)invocation.getArgument(0));
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolServerGroup(ArgumentMatchers.anyString());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setSocketBufferSize(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolSocketBufferSize(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setSocketConnectTimeout(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolSocketConnectTimeout(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setSocketFactory((SocketFactory)invocation.getArgument(0));
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolSocketFactory((SocketFactory)ArgumentMatchers.any(SocketFactory.class));
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setStatisticInterval(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolStatisticInterval(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setSubscriptionAckInterval(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolSubscriptionAckInterval(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setSubscriptionEnabled(((Boolean)invocation.getArgument(0)).booleanValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolSubscriptionEnabled(ArgumentMatchers.anyBoolean());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setSubscriptionMessageTrackingTimeout(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolSubscriptionMessageTrackingTimeout(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setSubscriptionRedundancy(((Integer)invocation.getArgument(0)).intValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolSubscriptionRedundancy(ArgumentMatchers.anyInt());
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            mockPoolFactory.setThreadLocalConnections(((Boolean)invocation.getArgument(0)).booleanValue());
            return clientCacheFactorySpy;
        }).when((Object)clientCacheFactorySpy)).setPoolThreadLocalConnections(ArgumentMatchers.anyBoolean());
        Supplier<ClientCache> resolvedMockedClientCache = () -> GemFireMockObjectsSupport.resolveMockedGemFireCache(useSingletonCache).orElseGet(() -> {
            ClientCache mockClientCache = GemFireMockObjectsSupport.mockClientCache();
            Pool mockDefaultPool = mockPoolFactory.create("DEFAULT");
            ((Pool)Mockito.doAnswer(invocation -> mockClientCache.getQueryService()).when((Object)mockDefaultPool)).getQueryService();
            Mockito.when((Object)mockClientCache.getCurrentServers()).thenAnswer(invocation -> Collections.unmodifiableSet(new HashSet(mockClientCache.getDefaultPool().getServers())));
            Mockito.when((Object)mockClientCache.getDefaultPool()).thenReturn((Object)mockDefaultPool);
            Mockito.when((Object)mockClientCache.getPdxDiskStore()).thenAnswer(GemFireMockObjectsSupport.newGetter(pdxDiskStoreName));
            Mockito.when((Object)mockClientCache.getPdxIgnoreUnreadFields()).thenAnswer(GemFireMockObjectsSupport.newGetter(pdxIgnoreUnreadFields));
            Mockito.when((Object)mockClientCache.getPdxPersistent()).thenAnswer(GemFireMockObjectsSupport.newGetter(pdxPersistent));
            Mockito.when((Object)mockClientCache.getPdxReadSerialized()).thenAnswer(GemFireMockObjectsSupport.newGetter(pdxReadSerialized));
            Mockito.when((Object)mockClientCache.getPdxSerializer()).thenAnswer(GemFireMockObjectsSupport.newGetter(pdxSerializer));
            return mockClientCache;
        });
        ((ClientCacheFactory)Mockito.doAnswer(invocation -> {
            GemFireMockObjectsSupport.storeConfiguration(clientCacheFactory);
            return GemFireMockObjectsSupport.rememberMockedGemFireCache(GemFireMockObjectsSupport.constructGemFireObjects((GemFireCache)resolvedMockedClientCache.get()), useSingletonCache);
        }).when((Object)clientCacheFactorySpy)).create();
        return clientCacheFactorySpy;
    }

    private static void storeConfiguration(CacheFactory cacheFactory) {
        GemFireMockObjectsSupport.storeConfiguration(cacheFactory, "dsProps");
    }

    private static void storeConfiguration(ClientCacheFactory clientCacheFactory) {
        GemFireMockObjectsSupport.storeConfiguration(clientCacheFactory, "dsProps");
    }

    private static void storeConfiguration(Object cacheFactory, String gemfirePropertiesFieldName) {
        Properties localGemFireProperties = gemfireProperties.get();
        localGemFireProperties.putAll((Map<?, ?>)GemFireMockObjectsSupport.withGemFireApiProperties(cacheFactory, gemfirePropertiesFieldName));
        localGemFireProperties.putAll((Map<?, ?>)GemFireMockObjectsSupport.withGemFireSystemProperties());
    }

    private static Properties withGemFireApiProperties(Object cacheFactory, String gemfirePropertiesFieldName) {
        Class<Object> cacheFactoryType = Optional.ofNullable(cacheFactory).map(Object::getClass).orElse(Object.class);
        try {
            Field dsPropsField = cacheFactoryType.getDeclaredField(gemfirePropertiesFieldName);
            dsPropsField.setAccessible(true);
            Properties gemfireApiProperties = (Properties)dsPropsField.get(cacheFactory);
            return gemfireApiProperties;
        }
        catch (Throwable cause) {
            if (cause instanceof NoSuchFieldException && !CACHE_FACTORY_INTERNAL_CACHE_BUILDER_FIELD_NAME.equals(gemfirePropertiesFieldName)) {
                return Arrays.stream(ArrayUtils.nullSafeArray((Object[])cacheFactoryType.getDeclaredFields(), Field.class)).filter(field -> CACHE_FACTORY_INTERNAL_CACHE_BUILDER_FIELD_NAME.equals(field.getName())).findFirst().map(field -> {
                    field.setAccessible(true);
                    Object internalCacheBuilder = ObjectUtils.doOperationSafely(() -> field.get(cacheFactory), null);
                    if (internalCacheBuilder != null) {
                        return GemFireMockObjectsSupport.withGemFireApiProperties(internalCacheBuilder, INTERNAL_CACHE_BUILDER_CONFIG_PROPERTIES_FIELD_NAME);
                    }
                    return null;
                }).orElseGet(Properties::new);
            }
            return new Properties();
        }
    }

    private static Properties withGemFireSystemProperties() {
        Properties gemfireSystemProperties = new Properties();
        List gemfireSystemPropertyNames = System.getProperties().stringPropertyNames().stream().filter(StringUtils::hasText).filter(it -> it.startsWith(GEMFIRE_SYSTEM_PROPERTY_PREFIX)).collect(Collectors.toList());
        gemfireSystemPropertyNames.stream().forEach(propertyName -> gemfireSystemProperties.setProperty(GemFireMockObjectsSupport.normalizeGemFirePropertyName(propertyName), System.getProperty(propertyName)));
        return gemfireSystemProperties;
    }

    public static class LuceneIndexKey {
        private final String indexName;
        private final String regionPath;

        public static LuceneIndexKey of(String indexName, Region<?, ?> region) {
            Assert.notNull(region, (String)"Region is required");
            return LuceneIndexKey.of(indexName, region.getFullPath());
        }

        public static LuceneIndexKey of(String indexName, String regionPath) {
            return new LuceneIndexKey(indexName, regionPath);
        }

        private LuceneIndexKey(String indexName, String regionPath) {
            Assert.hasText((String)indexName, (String)String.format("LuceneIndex name [%s] is required", indexName));
            Assert.hasText((String)regionPath, (String)String.format("Region path [%s] is required", regionPath));
            this.indexName = indexName;
            this.regionPath = regionPath;
        }

        protected String getIndexName() {
            return this.indexName;
        }

        protected String getRegionPath() {
            return this.regionPath;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LuceneIndexKey)) {
                return false;
            }
            LuceneIndexKey that = (LuceneIndexKey)obj;
            return this.getIndexName().equals(that.getIndexName()) && this.getRegionPath().equals(that.getRegionPath());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + this.getIndexName().hashCode();
            hashValue = 37 * hashValue + this.getRegionPath().hashCode();
            return hashValue;
        }

        public String toString() {
            return String.format("%1$s.%2$s", this.getRegionPath(), this.getIndexName());
        }
    }
}

