/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration.context.event;

import java.io.File;
import java.io.FileFilter;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.DiskStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.data.gemfire.tests.util.FileSystemUtils;
import org.springframework.data.gemfire.tests.util.ThreadUtils;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.test.context.event.AfterTestClassEvent;
import org.springframework.util.Assert;

public class GemFireResourceCollectorApplicationListener
implements ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    protected static final int DEFAULT_DELETE_ATTEMPTS = 2;
    protected static final long DEFAULT_DELETE_TIMED_WAIT_INTERVAL = Duration.ofMillis(250L).toMillis();
    protected static final File DEFAULT_SEARCH_DIRECTORY = FileSystemUtils.WORKING_DIRECTORY;
    private boolean tryCleanDiskStoreFilesEnabled = false;
    private ApplicationContext applicationContext;
    private final File searchDirectory;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<Class<? extends ApplicationEvent>> gemfireResourceCollectorEventTypes;

    public static GemFireResourceCollectorApplicationListener create(Class<? extends ApplicationEvent> ... gemfireResourceCollectorEventTypes) {
        return GemFireResourceCollectorApplicationListener.create(DEFAULT_SEARCH_DIRECTORY, Arrays.asList(ArrayUtils.nullSafeArray((Object[])gemfireResourceCollectorEventTypes, Class.class)));
    }

    public static GemFireResourceCollectorApplicationListener create(@Nullable File searchDirectory, Class<? extends ApplicationEvent> ... gemfireResourceCollectorEventTypes) {
        return GemFireResourceCollectorApplicationListener.create(searchDirectory, Arrays.asList(ArrayUtils.nullSafeArray((Object[])gemfireResourceCollectorEventTypes, Class.class)));
    }

    public static GemFireResourceCollectorApplicationListener create(@Nullable Iterable<Class<? extends ApplicationEvent>> gemfireResourceCollectorEventTypes) {
        return new GemFireResourceCollectorApplicationListener(gemfireResourceCollectorEventTypes);
    }

    public static GemFireResourceCollectorApplicationListener create(File searchDirectory, @Nullable Iterable<Class<? extends ApplicationEvent>> gemfireResourceCollectorEventTypes) {
        return new GemFireResourceCollectorApplicationListener(searchDirectory, gemfireResourceCollectorEventTypes);
    }

    public GemFireResourceCollectorApplicationListener(@Nullable Iterable<Class<? extends ApplicationEvent>> gemfireResourceCollectorEventTypes) {
        this(DEFAULT_SEARCH_DIRECTORY, gemfireResourceCollectorEventTypes);
    }

    public GemFireResourceCollectorApplicationListener(@Nullable File searchDirectory, @Nullable Iterable<Class<? extends ApplicationEvent>> gemfireResourceCollectorEventTypes) {
        this.searchDirectory = searchDirectory != null ? searchDirectory : DEFAULT_SEARCH_DIRECTORY;
        Set resolvedGemFireResourceCollectorEventTypes = StreamSupport.stream(CollectionUtils.nullSafeIterable(gemfireResourceCollectorEventTypes).spliterator(), false).filter(Objects::nonNull).collect(Collectors.toSet());
        resolvedGemFireResourceCollectorEventTypes = !resolvedGemFireResourceCollectorEventTypes.isEmpty() ? resolvedGemFireResourceCollectorEventTypes : Collections.singleton(AfterTestClassEvent.class);
        this.gemfireResourceCollectorEventTypes = Collections.unmodifiableSet(resolvedGemFireResourceCollectorEventTypes);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected Optional<ApplicationContext> getApplicationContext() {
        return Optional.ofNullable(this.applicationContext);
    }

    @NonNull
    protected Set<Class<? extends ApplicationEvent>> getConfiguredGemFireResourceCollectorEventTypes() {
        return this.gemfireResourceCollectorEventTypes;
    }

    protected boolean isGemFireResourceCollectorEvent(@Nullable ApplicationEvent event) {
        for (Class<? extends ApplicationEvent> gemfireResourceCollectorEventType : this.getConfiguredGemFireResourceCollectorEventTypes()) {
            if (!gemfireResourceCollectorEventType.isInstance(event)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    protected Logger getLogger() {
        return this.logger;
    }

    @NonNull
    protected File getSearchDirectory() {
        return this.searchDirectory;
    }

    protected boolean isTryCleanDiskStoreFilesEnabled() {
        return this.tryCleanDiskStoreFilesEnabled;
    }

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (this.isGemFireResourceCollectorEvent(event)) {
            this.collectGemFireResources(this.getSearchDirectory());
        }
        if (this.isTryCleanDiskStoreFilesEnabled()) {
            this.collectGemFireDiskStoreFiles();
        }
    }

    protected void collectGemFireResources(@NonNull File directory) {
        Assert.isTrue((boolean)FileSystemUtils.isDirectory(directory), () -> String.format("File [%s] must be a directory", directory));
        for (File file : FileSystemUtils.safeListFiles(directory, GemFireResourceFileFilter.INSTANCE)) {
            if (FileSystemUtils.isDirectory(file)) {
                this.collectGemFireResources(file);
                continue;
            }
            if (this.tryDelete(file)) continue;
            file.deleteOnExit();
        }
        if (FileSystemUtils.isEmpty(directory)) {
            directory.delete();
        }
    }

    protected void collectGemFireDiskStoreFiles() {
        this.getApplicationContext().map(it -> it.getBeansOfType(DiskStore.class)).map(Map::values).ifPresent(diskStores -> diskStores.stream().filter(Objects::nonNull).forEach(diskStore -> {
            for (File directory : (File[])ArrayUtils.nullSafeArray((Object[])diskStore.getDiskDirs(), File.class)) {
                try {
                    FileSystemUtils.deleteRecursive(directory);
                }
                catch (Throwable ignore) {
                    this.getLogger().warn("Unable to delete DiskStore directory [{}]", (Object)directory);
                }
            }
        }));
    }

    public GemFireResourceCollectorApplicationListener tryCleanDiskStoreFiles(boolean enable) {
        this.tryCleanDiskStoreFilesEnabled = enable;
        return this;
    }

    protected boolean tryDelete(@Nullable File file) {
        return this.tryDelete(file, 2, DEFAULT_DELETE_TIMED_WAIT_INTERVAL);
    }

    protected boolean tryDelete(@Nullable File file, int attempts, long waitDurationBetweenAttempts) {
        if (FileSystemUtils.isFile(file)) {
            long interval = waitDurationBetweenAttempts;
            long duration = (long)attempts * interval;
            return ThreadUtils.timedWait(duration, interval, file::delete);
        }
        return false;
    }

    protected static class GemFireResourceFileFilter
    implements FileFilter {
        protected static final GemFireResourceFileFilter INSTANCE = new GemFireResourceFileFilter();
        protected static final FileFilter DIRECTORY_FILE_FILTER = FileSystemUtils.DirectoryOnlyFilter.INSTANCE;
        private static final FileFilter GEMFIRE_FILE_EXTENSION_FILTER = FileSystemUtils.CompositeFileFilter.or(new FileSystemUtils.FileExtensionFilter(".dat"), new FileSystemUtils.FileExtensionFilter(".gfs"), new FileSystemUtils.FileExtensionFilter(".crf"), new FileSystemUtils.FileExtensionFilter(".drf"), new FileSystemUtils.FileExtensionFilter(".if"), new FileSystemUtils.FileExtensionFilter(".krf"), new FileSystemUtils.FileExtensionFilter(".lk"), new FileSystemUtils.FileExtensionFilter(".log"), new FileSystemUtils.FileExtensionFilter(".pid"), new FileSystemUtils.FileExtensionFilter(".properties"), new FileSystemUtils.FileExtensionFilter(".xml"));
        private static final Set<String> GEMFIRE_FILE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("backup", "cache", "configdiskdir", "default", "drlk_if", "gfsecurity", "gemfire", "geode", "locator", "overflow")));
        private static final Predicate<File> GEMFIRE_FILE_NAME_FILTER = file -> {
            if (!Objects.nonNull(file)) return false;
            if (!GEMFIRE_FILE_NAMES.stream().anyMatch(file.getName().toLowerCase()::startsWith)) return false;
            return true;
        };

        protected GemFireResourceFileFilter() {
        }

        protected FileFilter getDirectoryFileFilter() {
            return DIRECTORY_FILE_FILTER;
        }

        protected FileFilter getGemFireFileExtensionFilter() {
            return GEMFIRE_FILE_EXTENSION_FILTER;
        }

        protected Predicate<File> getGemFireFilenameFilter() {
            return GEMFIRE_FILE_NAME_FILTER;
        }

        @Override
        public boolean accept(File pathname) {
            return this.getDirectoryFileFilter().accept(pathname) || this.isGemFireResource(pathname);
        }

        protected boolean isGemFireResource(@Nullable File file) {
            return Objects.nonNull(file) && this.isFileExtensionOrFileNameMatch(file);
        }

        protected boolean isFileExtensionOrFileNameMatch(@NonNull File file) {
            return this.getGemFireFileExtensionFilter().accept(file) || this.getGemFireFilenameFilter().test(file);
        }
    }
}

