/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration.annotation;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.tests.integration.annotation.EnableGemFireResourceCollector;
import org.springframework.data.gemfire.tests.integration.context.event.GemFireResourceCollectorApplicationListener;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.lang.NonNull;
import org.springframework.test.context.event.AfterTestClassEvent;

@Configuration
public class GemFireResourceCollectorConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    public static final boolean DEFAULT_CLEAN_DISK_STORE_FILES = false;
    private boolean tryCleanDiskStoreFiles = false;
    private Class<? extends ApplicationEvent>[] collectorEventTypes = new Class[]{AfterTestClassEvent.class};

    public void setImportMetadata(@NonNull AnnotationMetadata importMetadata) {
        Optional.of(importMetadata).filter(arg_0 -> ((GemFireResourceCollectorConfiguration)this).isAnnotationPresent(arg_0)).map(arg_0 -> ((GemFireResourceCollectorConfiguration)this).getAnnotationAttributes(arg_0)).ifPresent(enableGemFireResourceCollectorAttributes -> {
            this.collectorEventTypes = enableGemFireResourceCollectorAttributes.getClassArray("collectOnEvents");
            this.tryCleanDiskStoreFiles = enableGemFireResourceCollectorAttributes.getBoolean("tryCleanDiskStoreFiles");
        });
    }

    protected Class<? extends Annotation> getAnnotationType() {
        return EnableGemFireResourceCollector.class;
    }

    @NonNull
    protected Class<? extends ApplicationEvent>[] getConfiguredCollectorEventTypes() {
        return (Class[])ArrayUtils.nullSafeArray((Object[])this.collectorEventTypes, Class.class);
    }

    protected boolean isTryCleanDiskStoreFiles() {
        return this.tryCleanDiskStoreFiles;
    }

    @Bean
    ApplicationListener<ApplicationEvent> gemfireResourceCollectorApplicationListener() {
        return GemFireResourceCollectorApplicationListener.create(this.getConfiguredCollectorEventTypes()).tryCleanDiskStoreFiles(this.isTryCleanDiskStoreFiles());
    }
}

