/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration;

import java.util.Map;
import java.util.function.Function;
import org.junit.After;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.data.gemfire.tests.integration.IntegrationTestsSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.lang.NonNull;

public abstract class SpringApplicationContextIntegrationTestsSupport
extends IntegrationTestsSupport
implements ApplicationEventPublisherAware {
    @After
    public void closeApplicationContext() {
        SpringApplicationContextIntegrationTestsSupport.closeApplicationContext(this.getApplicationContext());
    }

    protected ConfigurableApplicationContext newApplicationContext(Class<?> ... annotatedClasses) {
        return this.newApplicationContext(this::processBeforeRefresh, annotatedClasses);
    }

    protected ConfigurableApplicationContext newApplicationContext(Function<ConfigurableApplicationContext, ConfigurableApplicationContext> applicationContextInitializer, Class<?> ... annotatedClasses) {
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();
        applicationContext.register((Class[])ArrayUtils.nullSafeArray((Object[])annotatedClasses, Class.class));
        applicationContext.registerShutdownHook();
        applicationContextInitializer.apply((ConfigurableApplicationContext)applicationContext);
        applicationContext.refresh();
        return this.setApplicationContext(applicationContext);
    }

    @NonNull
    protected ConfigurableApplicationContext processBeforeRefresh(@NonNull ConfigurableApplicationContext applicationContext) {
        this.setApplicationEventPublisher((ApplicationEventPublisher)applicationContext);
        return applicationContext;
    }

    public void setApplicationEventPublisher(@NonNull ApplicationEventPublisher applicationEventPublisher) {
        if (applicationEventPublisher != null) {
            IntegrationTestsSupport.TestContextCacheLifecycleListenerAdapter.getInstance().setApplicationEventPublisher(applicationEventPublisher);
        }
    }

    protected boolean containsBean(String beanName) {
        Object applicationContext = this.requireApplicationContext();
        return applicationContext.containsBean(beanName);
    }

    protected <T> T getBean(Class<T> requiredType) {
        Object applicationContext = this.requireApplicationContext();
        return (T)applicationContext.getBean(requiredType);
    }

    protected <T> T getBean(String beanName, Class<T> requiredType) {
        Object applicationContext = this.requireApplicationContext();
        return (T)applicationContext.getBean(beanName, requiredType);
    }

    protected <T> Map<String, T> getBeansOfType(Class<T> requiredType) {
        Object applicationContext = this.requireApplicationContext();
        return applicationContext.getBeansOfType(requiredType);
    }
}

