/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.Locator;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.CacheLifecycleListener;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.shiro.util.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.support.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.tests.mock.GemFireMockObjectsSupport;
import org.springframework.data.gemfire.tests.util.FileSystemUtils;
import org.springframework.data.gemfire.tests.util.FileUtils;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class IntegrationTestsSupport {
    protected static final boolean DEFAULT_DEBUG_GEMFIRE_QUERIES = false;
    protected static final boolean DEBUG_GEMFIRE_QUERIES = Boolean.getBoolean("spring.data.gemfire.query.debug");
    protected static final long DEFAULT_WAIT_DURATION = TimeUnit.SECONDS.toMillis(30L);
    protected static final long DEFAULT_WAIT_INTERVAL = 500L;
    protected static final String DATE_TIME_PATTERN = "yyyy-MM-dd-hh-mm-ss";
    protected static final String DIRECTORY_DELETE_ON_EXIT_PROPERTY = "spring.data.gemfire.test.directory.delete-on-exit";
    protected static final String DIRECTORY_NAME_FORMAT = "%1$s-%2$s";
    protected static final String GEMFIRE_LOG_FILE = "gemfire-server.log";
    protected static final String GEMFIRE_LOG_FILE_PROPERTY = "spring.data.gemfire.log.file";
    protected static final String GEMFIRE_LOG_LEVEL = "error";
    protected static final String GEMFIRE_LOG_LEVEL_PROPERTY = "spring.data.gemfire.log.level";
    protected static final String GEMFIRE_QUERY_VERBOSE_PROPERTY = "gemfire.Query.VERBOSE";
    protected static final String SYSTEM_PROPERTIES_LOG_FILE = "system-properties.log";
    protected static final String TEST_GEMFIRE_LOG_LEVEL = "error";
    private static final AtomicReference<ConfigurableApplicationContext> applicationContextReference = new AtomicReference<Object>(null);
    private static final Predicate<String> JAVAX_NET_SSL_NAME_PREDICATE = propertyName -> String.valueOf(propertyName).toLowerCase().startsWith("javax.net.ssl");
    private static final Predicate<String> GEMFIRE_DOT_SYSTEM_PROPERTY_NAME_PREDICATE = propertyName -> String.valueOf(propertyName).toLowerCase().startsWith("gemfire");
    private static final Predicate<String> GEODE_DOT_SYSTEM_PROPERTY_NAME_PREDICATE = propertyName -> String.valueOf(propertyName).toLowerCase().startsWith("geode");
    private static final Predicate<String> SPRING_DOT_SYSTEM_PROPERTY_NAME_PREDICATE = propertyName -> String.valueOf(propertyName).toLowerCase().startsWith("spring");
    private static final Predicate<String> ALL_SYSTEM_PROPERTIES_NAME_PREDICATE = JAVAX_NET_SSL_NAME_PREDICATE.or(GEMFIRE_DOT_SYSTEM_PROPERTY_NAME_PREDICATE).or(GEODE_DOT_SYSTEM_PROPERTY_NAME_PREDICATE).or(SPRING_DOT_SYSTEM_PROPERTY_NAME_PREDICATE);
    private static final Predicate<String> SYSTEM_ENVIRONMENT_PROPERTY_SOURCE_NAME = "systemEnvironment"::equals;
    private static final Predicate<String> SYSTEM_PROPERTIES_PROPERTY_SOURCE_NAME = "systemProperties"::equals;
    private static final Predicate<String> RETAINED_PROPERTY_SOURCE_NAMES = SYSTEM_ENVIRONMENT_PROPERTY_SOURCE_NAME.or(SYSTEM_PROPERTIES_PROPERTY_SOURCE_NAME);
    private static final TestContextCacheLifecycleListenerAdapter cacheLifecycleListener = TestContextCacheLifecycleListenerAdapter.getInstance();
    @Autowired(required=false)
    private ConfigurableApplicationContext applicationContext;

    @Nullable
    protected <T extends ConfigurableApplicationContext> T setApplicationContext(@Nullable T applicationContext) {
        this.applicationContext = applicationContext;
        return applicationContext;
    }

    @Nullable
    protected <T extends ConfigurableApplicationContext> T getApplicationContext() {
        return (T)this.applicationContext;
    }

    protected <T extends ConfigurableApplicationContext> Optional<T> getOptionalApplicationContext() {
        return Optional.ofNullable(this.getApplicationContext());
    }

    protected <T extends ConfigurableApplicationContext> T requireApplicationContext() {
        return (T)((ConfigurableApplicationContext)this.getOptionalApplicationContext().orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"An ApplicationContext was not initialized", (Object[])new Object[0])));
    }

    @AfterClass
    public static void clearAllJavaGemFireGeodeAndSpringDotPrefixedSystemProperties() {
        List<String> allSystemPropertyNames = System.getProperties().stringPropertyNames().stream().filter(ALL_SYSTEM_PROPERTIES_NAME_PREDICATE).collect(Collectors.toList());
        allSystemPropertyNames.forEach(System::clearProperty);
    }

    @AfterClass
    public static void clearNonStandardSpringEnvironmentPropertySources() {
        Optional.ofNullable(applicationContextReference.get()).map(ConfigurableApplicationContext::getEnvironment).map(ConfigurableEnvironment::getPropertySources).ifPresent(propertySources -> {
            for (PropertySource propertySource : propertySources) {
                String propertySourceName;
                if (!Objects.nonNull(propertySource) || !StringUtils.hasText((String)(propertySourceName = propertySource.getName())) || RETAINED_PROPERTY_SOURCE_NAMES.test(propertySource.getName())) continue;
                propertySources.remove(propertySourceName);
            }
        });
    }

    @AfterClass
    public static void closeAllBeanFactoryLocators() {
        GemfireBeanFactoryLocator.clear();
    }

    @AfterClass
    public static void closeAnyGemFireCache() {
        IntegrationTestsSupport.closeGemFireCacheWaitOnCacheClosedEvent();
    }

    @AfterClass
    public static void closeAnyGemFireLocator() {
        IntegrationTestsSupport.stopGemFireLocatorWaitOnStopEvent();
    }

    @AfterClass
    public static void closeAnySocketConfiguration() {
        SocketCreatorFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void closeAnySslConfiguration() {
        Class<SSLConfigurationFactory> clazz = SSLConfigurationFactory.class;
        synchronized (SSLConfigurationFactory.class) {
            try {
                Field instance = ReflectionUtils.findField(SSLConfigurationFactory.class, (String)"instance", SSLConfigurationFactory.class);
                Optional.ofNullable(instance).ifPresent(field -> {
                    ReflectionUtils.makeAccessible((Field)field);
                    ReflectionUtils.setField((Field)field, null, null);
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }

    @AfterClass
    public static void deleteAllGemFireProcessIdFiles() {
        FileFilter fileFilter = file -> file != null && file.getName().startsWith("vf.gf") && file.getName().endsWith(".pid");
        FileSystemUtils.deleteRecursive(FileSystemUtils.WORKING_DIRECTORY, fileFilter);
    }

    @AfterClass
    public static void destroyAllGemFireMockObjects() {
        GemFireMockObjectsSupport.destroy();
    }

    @AfterClass
    public static void unregisterAllDataSerializers() {
        Arrays.stream(ArrayUtils.nullSafeArray((Object[])InternalDataSerializer.getSerializers(), DataSerializer.class)).map(DataSerializer::getId).forEach(InternalDataSerializer::unregister);
    }

    @AfterClass
    public static void unregisterFunctions() {
        CollectionUtils.nullSafeMap((Map)FunctionService.getRegisteredFunctions()).forEach((functionId, function) -> FunctionService.unregisterFunction((String)functionId));
    }

    @Before
    public void configureQueryDebugging() {
        if (this.isQueryDebuggingEnabled()) {
            System.setProperty(GEMFIRE_QUERY_VERBOSE_PROPERTY, Boolean.TRUE.toString());
        }
    }

    @Before
    public void referenceApplicationContext() {
        applicationContextReference.set(this.applicationContext);
    }

    public static void closeApplicationContext(@Nullable ApplicationContext applicationContext) {
        Optional.ofNullable(applicationContext).filter(ConfigurableApplicationContext.class::isInstance).map(ConfigurableApplicationContext.class::cast).ifPresent(ConfigurableApplicationContext::close);
    }

    public static void closeGemFireCacheWaitOnCacheClosedEvent() {
        IntegrationTestsSupport.closeGemFireCacheWaitOnCacheClosedEvent(DEFAULT_WAIT_DURATION);
    }

    public static void closeGemFireCacheWaitOnCacheClosedEvent(long duration) {
        IntegrationTestsSupport.closeGemFireCacheWaitOnCacheClosedEvent(CacheUtils::resolveGemFireCache, duration);
    }

    public static void closeGemFireCacheWaitOnCacheClosedEvent(@NonNull Supplier<GemFireCache> cacheSupplier) {
        IntegrationTestsSupport.closeGemFireCacheWaitOnCacheClosedEvent(cacheSupplier, DEFAULT_WAIT_DURATION);
    }

    public static void closeGemFireCacheWaitOnCacheClosedEvent(@NonNull Supplier<GemFireCache> cacheSupplier, @NonNull Function<GemFireCache, GemFireCache> cacheClosingFunction) {
        IntegrationTestsSupport.closeGemFireCacheWaitOnCacheClosedEvent(cacheSupplier, cacheClosingFunction, DEFAULT_WAIT_DURATION);
    }

    public static void closeGemFireCacheWaitOnCacheClosedEvent(@NonNull Supplier<GemFireCache> cacheSupplier, long duration) {
        Function<GemFireCache, GemFireCache> cacheClosingFunction = cacheToClose -> {
            if (GemfireUtils.isClient((GemFireCache)cacheToClose)) {
                ((ClientCache)cacheToClose).close(false);
            } else {
                cacheToClose.close();
            }
            return cacheToClose;
        };
        IntegrationTestsSupport.closeGemFireCacheWaitOnCacheClosedEvent(cacheSupplier, cacheClosingFunction, duration);
    }

    public static void closeGemFireCacheWaitOnCacheClosedEvent(@NonNull Supplier<GemFireCache> cacheSupplier, @NonNull Function<GemFireCache, GemFireCache> cacheClosingFunction, long duration) {
        AtomicBoolean closed = new AtomicBoolean(false);
        IntegrationTestsSupport.waitOn(() -> {
            try {
                return Optional.ofNullable(cacheSupplier.get()).filter(cache -> !closed.get()).map(cacheClosingFunction).map(cacheLifecycleListener::isClosed).orElse(true);
            }
            catch (CacheClosedException ignore) {
                closed.set(true);
                return true;
            }
        }, duration);
    }

    public static void stopGemFireLocatorWaitOnStopEvent() {
        IntegrationTestsSupport.stopGemFireLocatorWaitOnStopEvent(DEFAULT_WAIT_DURATION);
    }

    public static void stopGemFireLocatorWaitOnStopEvent(long duration) {
        AtomicBoolean stopped = new AtomicBoolean(false);
        IntegrationTestsSupport.waitOn(() -> {
            try {
                return Optional.ofNullable(Locator.getLocator()).filter(it -> !stopped.get()).map(IntegrationTestsSupport::stop).map(it -> {
                    stopped.set(!Locator.hasLocator());
                    return stopped.get();
                }).orElse(true);
            }
            catch (Exception ignore) {
                stopped.set(true);
                return true;
            }
        }, duration);
    }

    @Nullable
    private static Locator stop(@Nullable Locator locator) {
        return Optional.ofNullable(locator).map(it -> {
            it.stop();
            return it;
        }).orElse(locator);
    }

    @NonNull
    protected static String asApplicationName(@NonNull Class<?> type) {
        return type.getSimpleName();
    }

    @NonNull
    protected static String asDirectoryName(@NonNull Class<?> type) {
        return String.format(DIRECTORY_NAME_FORMAT, IntegrationTestsSupport.asApplicationName(type), LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN)));
    }

    @NonNull
    protected static File createDirectory(@NonNull String pathname) {
        return IntegrationTestsSupport.createDirectory(new File(pathname));
    }

    @NonNull
    protected static File createDirectory(@NonNull File directory) {
        ((AbstractFileAssert)Assertions.assertThat((File)directory).describedAs("A File reference to the directory to create must not be null", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((directory.isDirectory() || directory.mkdirs() ? 1 : 0) != 0).describedAs(String.format("Failed to create directory [%s]", directory), new Object[0])).isTrue();
        if (IntegrationTestsSupport.isDeleteDirectoryOnExit()) {
            directory.deleteOnExit();
        }
        return directory;
    }

    protected static boolean isDeleteDirectoryOnExit() {
        return !System.getProperties().containsKey(DIRECTORY_DELETE_ON_EXIT_PROPERTY) || Boolean.getBoolean(DIRECTORY_DELETE_ON_EXIT_PROPERTY);
    }

    protected boolean isQueryDebuggingEnabled() {
        return DEBUG_GEMFIRE_QUERIES || this.withQueryDebugging();
    }

    @NonNull
    protected static String getClassNameAsPath(@NonNull Class type) {
        return type.getName().replaceAll("\\.", "/");
    }

    @NonNull
    protected static String getClassNameAsPath(@NonNull Object obj) {
        return IntegrationTestsSupport.getClassNameAsPath(obj.getClass());
    }

    @NonNull
    protected static String getPackageNameAsPath(@NonNull Class type) {
        return type.getPackage().getName().replaceAll("\\.", "/");
    }

    @NonNull
    protected static String getPackageNameAsPath(@NonNull Object obj) {
        return IntegrationTestsSupport.getPackageNameAsPath(obj.getClass());
    }

    @NonNull
    protected static String getContextXmlFileLocation(@NonNull Class type) {
        return IntegrationTestsSupport.getClassNameAsPath(type).concat("-context.xml");
    }

    @NonNull
    protected static String getServerContextXmlFileLocation(@NonNull Class type) {
        return IntegrationTestsSupport.getClassNameAsPath(type).concat("-server-context.xml");
    }

    protected static String logFile() {
        return IntegrationTestsSupport.logFile(GEMFIRE_LOG_FILE);
    }

    protected static String logFile(String defaultLogFilePathname) {
        return System.getProperty(GEMFIRE_LOG_FILE_PROPERTY, defaultLogFilePathname);
    }

    protected static String logLevel() {
        return IntegrationTestsSupport.logLevel("error");
    }

    protected static String logLevel(String defaultLogLevel) {
        return System.getProperty(GEMFIRE_LOG_LEVEL_PROPERTY, defaultLogLevel);
    }

    protected static void logSystemProperties() throws IOException {
        FileUtils.write(new File(SYSTEM_PROPERTIES_LOG_FILE), String.format("%s", CollectionUtils.toString((Map)System.getProperties())));
    }

    protected static boolean waitOn(@NonNull Condition condition) {
        return IntegrationTestsSupport.waitOn(condition, DEFAULT_WAIT_DURATION);
    }

    protected static boolean waitOn(@NonNull Condition condition, long duration) {
        return IntegrationTestsSupport.waitOn(condition, duration, 500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean waitOn(@NonNull Condition condition, long duration, long interval) {
        long resolvedInterval = Math.max(Math.min(interval, duration), 1L);
        long timeout = System.currentTimeMillis() + duration;
        try {
            while (!condition.evaluate() && System.currentTimeMillis() < timeout) {
                Condition condition2 = condition;
                synchronized (condition2) {
                    TimeUnit.MILLISECONDS.timedWait(condition, resolvedInterval);
                }
            }
            return condition.evaluate();
        }
        catch (InterruptedException cause) {
            Thread.currentThread().interrupt();
        }
        return condition.evaluate();
    }

    protected void usingDeleteDirectoryOnExit(boolean delete) {
        System.setProperty(DIRECTORY_DELETE_ON_EXIT_PROPERTY, String.valueOf(delete));
    }

    protected boolean withQueryDebugging() {
        return false;
    }

    public static class CacheClosedEvent
    extends AbstractCacheEvent {
        public CacheClosedEvent(@NonNull GemFireCache cache) {
            super(cache);
        }
    }

    public static class CacheCreatedEvent
    extends AbstractCacheEvent {
        public CacheCreatedEvent(@NonNull GemFireCache cache) {
            super(cache);
        }
    }

    protected static class AbstractCacheEvent
    extends ApplicationEvent {
        protected static <T> T requireNonNull(@NonNull T target, String message) {
            Assert.notNull(target, (String)message);
            return target;
        }

        protected AbstractCacheEvent(@NonNull GemFireCache cache) {
            super((Object)AbstractCacheEvent.requireNonNull(cache, "GemFireCache must not be null"));
        }

        @NonNull
        public GemFireCache getCache() {
            return (GemFireCache)this.getSource();
        }
    }

    public static final class TestContextCacheLifecycleListenerAdapter
    extends AbstractApplicationEventPublisherCacheLifecycleListenerAdapter {
        private static final AtomicReference<TestContextCacheLifecycleListenerAdapter> INSTANCE = new AtomicReference<Object>(null);
        private final Map<GemFireCache, Object> cacheInstances = Collections.synchronizedMap(new WeakHashMap());

        public static TestContextCacheLifecycleListenerAdapter getInstance() {
            return INSTANCE.updateAndGet(instance -> instance != null ? instance : TestContextCacheLifecycleListenerAdapter.newTestContextCacheLifecycleListenerAdapter());
        }

        private static TestContextCacheLifecycleListenerAdapter newTestContextCacheLifecycleListenerAdapter() {
            return TestContextCacheLifecycleListenerAdapter.registerCacheLifecycleListener(new TestContextCacheLifecycleListenerAdapter());
        }

        @NonNull
        private static <T extends CacheLifecycleListener> T registerCacheLifecycleListener(@NonNull T listener) {
            GemFireCacheImpl.addCacheLifecycleListener(listener);
            return listener;
        }

        private TestContextCacheLifecycleListenerAdapter() {
        }

        public boolean isClosed(@Nullable GemFireCache cache) {
            return cache == null || cache.isClosed() && this.isCacheClosed(cache);
        }

        private boolean isCacheClosed(@Nullable GemFireCache cache) {
            return !this.isOpen(cache);
        }

        public boolean isOpen(@Nullable GemFireCache cache) {
            return this.cacheInstances.containsKey(cache);
        }

        @Override
        public void cacheCreated(@NonNull InternalCache cache) {
            if (cache != null) {
                this.cacheInstances.put((GemFireCache)cache, this);
                super.cacheCreated(cache);
            }
        }

        @Override
        public void cacheClosed(@NonNull InternalCache cache) {
            if (cache != null) {
                this.cacheInstances.remove(cache, this);
                super.cacheClosed(cache);
            }
        }
    }

    protected static abstract class AbstractApplicationEventPublisherCacheLifecycleListenerAdapter
    implements ApplicationEventPublisherAware,
    CacheLifecycleListener {
        private ApplicationEventPublisher applicationEventPublisher;

        protected AbstractApplicationEventPublisherCacheLifecycleListenerAdapter() {
        }

        public void setApplicationEventPublisher(@Nullable ApplicationEventPublisher applicationEventPublisher) {
            this.applicationEventPublisher = applicationEventPublisher;
        }

        protected Optional<ApplicationEventPublisher> getApplicationEventPublisher() {
            return Optional.ofNullable(this.applicationEventPublisher);
        }

        public void cacheCreated(InternalCache cache) {
            this.getApplicationEventPublisher().ifPresent(eventPublisher -> eventPublisher.publishEvent((ApplicationEvent)new CacheCreatedEvent((GemFireCache)cache)));
        }

        public void cacheClosed(InternalCache cache) {
            this.getApplicationEventPublisher().ifPresent(eventPublisher -> eventPublisher.publishEvent((ApplicationEvent)new CacheClosedEvent((GemFireCache)cache)));
        }
    }

    @FunctionalInterface
    protected static interface Condition {
        public boolean evaluate();
    }
}

