/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.AfterClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.gemfire.config.annotation.CacheServerApplication;
import org.springframework.data.gemfire.config.annotation.ClientCacheApplication;
import org.springframework.data.gemfire.config.annotation.EnablePdx;
import org.springframework.data.gemfire.tests.integration.ClientServerIntegrationTestsSupport;
import org.springframework.data.gemfire.tests.integration.config.ClientServerIntegrationTestsConfiguration;
import org.springframework.data.gemfire.tests.process.JavaProcessRunner;
import org.springframework.data.gemfire.tests.process.ProcessWrapper;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class ForkingClientServerIntegrationTestsSupport
extends ClientServerIntegrationTestsSupport {
    private static ProcessWrapper gemfireServer;

    @NonNull
    public static ProcessWrapper startGemFireServer(final @NonNull Class<?> gemfireServerMainClass, String ... arguments) throws IOException {
        return ForkingClientServerIntegrationTestsSupport.startGemFireServer(new JavaProcessRunner(){

            @Override
            public Class<?> getMainClass() {
                return gemfireServerMainClass;
            }

            @Override
            public ProcessWrapper run(String ... arguments) throws IOException {
                return ForkingClientServerIntegrationTestsSupport.run(this.getMainClass(), arguments);
            }
        }, arguments);
    }

    @NonNull
    public static ProcessWrapper startGemFireServer(final @NonNull File workingDirectory, final @NonNull Class<?> gemfireServerMainClass, String ... arguments) throws IOException {
        return ForkingClientServerIntegrationTestsSupport.startGemFireServer(new JavaProcessRunner(){

            @Override
            public Class<?> getMainClass() {
                return gemfireServerMainClass;
            }

            @Override
            public File getWorkingDirectory() {
                return workingDirectory;
            }

            @Override
            public ProcessWrapper run(String ... arguments) throws IOException {
                return ForkingClientServerIntegrationTestsSupport.run(this.getWorkingDirectory(), this.getMainClass(), arguments);
            }
        }, arguments);
    }

    @NonNull
    public static ProcessWrapper startGemFireServer(final @NonNull String classpath, final @NonNull Class<?> gemfireServerMainClass, String ... arguments) throws IOException {
        return ForkingClientServerIntegrationTestsSupport.startGemFireServer(new JavaProcessRunner(){

            @Override
            public String getClassPath() {
                return classpath;
            }

            @Override
            public Class<?> getMainClass() {
                return gemfireServerMainClass;
            }

            @Override
            public ProcessWrapper run(String ... arguments) throws IOException {
                return ForkingClientServerIntegrationTestsSupport.run(this.getClassPath(), this.getMainClass(), arguments);
            }
        }, arguments);
    }

    @NonNull
    public static ProcessWrapper startGemFireServer(final @NonNull File workingDirectory, final @NonNull String classpath, final @NonNull Class<?> gemfireServerMainClass, String ... arguments) throws IOException {
        return ForkingClientServerIntegrationTestsSupport.startGemFireServer(new JavaProcessRunner(){

            @Override
            public String getClassPath() {
                return classpath;
            }

            @Override
            public Class<?> getMainClass() {
                return gemfireServerMainClass;
            }

            @Override
            public File getWorkingDirectory() {
                return workingDirectory;
            }

            @Override
            public ProcessWrapper run(String ... arguments) throws IOException {
                return ForkingClientServerIntegrationTestsSupport.run(this.getWorkingDirectory(), this.getClassPath(), this.getMainClass(), arguments);
            }
        }, arguments);
    }

    @NonNull
    private static ProcessWrapper startGemFireServer(@NonNull JavaProcessRunner processRunner, String ... arguments) throws IOException {
        int availablePort = ForkingClientServerIntegrationTestsSupport.setAndGetPoolPortProperty(ForkingClientServerIntegrationTestsSupport.setAndGetCacheServerPortProperty(ForkingClientServerIntegrationTestsSupport.findAndReserveAvailablePort()));
        ArrayList<Object> argumentList = new ArrayList<Object>(Arrays.asList(ArrayUtils.nullSafeArray((Object[])arguments, String.class)));
        argumentList.add(String.format("-D%s=%d", "spring.data.gemfire.cache.server.port", availablePort));
        ProcessWrapper gemfireServerProcessWrapper = processRunner.run(argumentList);
        gemfireServerProcessWrapper = gemfireServerProcessWrapper.runningOn(InetAddress.getLocalHost().getHostAddress()).listeningOn(availablePort);
        ForkingClientServerIntegrationTestsSupport.setGemFireServerProcess(gemfireServerProcessWrapper);
        ForkingClientServerIntegrationTestsSupport.waitForServerToStart("localhost", availablePort);
        return gemfireServerProcessWrapper;
    }

    public static ProcessWrapper startGeodeServer(@NonNull Class<?> geodeServerMainClass, String ... arguments) throws IOException {
        return ForkingClientServerIntegrationTestsSupport.startGemFireServer(geodeServerMainClass, arguments);
    }

    public static ProcessWrapper startGeodeServer(@NonNull File workingDirectory, @NonNull Class<?> geodeServerMainClass, String ... arguments) throws IOException {
        return ForkingClientServerIntegrationTestsSupport.startGemFireServer(workingDirectory, geodeServerMainClass, arguments);
    }

    public static ProcessWrapper startGeodeServer(@NonNull String classpath, @NonNull Class<?> geodeServerMainClass, String ... arguments) throws IOException {
        return ForkingClientServerIntegrationTestsSupport.startGemFireServer(classpath, geodeServerMainClass, arguments);
    }

    public static ProcessWrapper startGeodeServer(@NonNull File workingDirectory, @NonNull String classpath, @NonNull Class<?> geodeServerMainClass, String ... arguments) throws IOException {
        return ForkingClientServerIntegrationTestsSupport.startGemFireServer(workingDirectory, classpath, geodeServerMainClass, arguments);
    }

    protected static int setAndGetCacheServerPortProperty(int port) {
        System.setProperty("spring.data.gemfire.cache.server.port", String.valueOf(port));
        return port;
    }

    protected static int setAndGetPoolPortProperty(int port) {
        System.setProperty("spring.data.gemfire.pool.servers", String.format("localhost[%d]", port));
        return port;
    }

    @AfterClass
    public static void stopGemFireServer() {
        ForkingClientServerIntegrationTestsSupport.getGemFireServerProcess().ifPresent(ClientServerIntegrationTestsSupport::stop);
        ForkingClientServerIntegrationTestsSupport.setGemFireServerProcess(null);
    }

    @AfterClass
    public static void clearCacheServerPortAndPoolPortProperties() {
        System.clearProperty("spring.data.gemfire.cache.server.port");
        System.clearProperty("spring.data.gemfire.pool.servers");
    }

    protected static synchronized void setGemFireServerProcess(@Nullable ProcessWrapper gemfireServerProcess) {
        gemfireServer = gemfireServerProcess;
    }

    protected static synchronized Optional<ProcessWrapper> getGemFireServerProcess() {
        return Optional.ofNullable(gemfireServer);
    }

    public static interface SpringApplicationTerminatorConfigurer {
        public static final SpringApplicationTerminatorConfigurer EMPTY = new SpringApplicationTerminatorConfigurer(){};

        default public boolean isEmpty() {
            return EMPTY.equals(this);
        }

        default public boolean isNotEmpty() {
            return !this.isEmpty();
        }

        default public Duration delay() {
            return Duration.ZERO;
        }
    }

    @Configuration
    public static class SpringApplicationTerminatorConfiguration {
        @Bean
        public SpringApplicationTerminatorConfigurer springApplicationTerminatorConfigurer() {
            return SpringApplicationTerminatorConfigurer.EMPTY;
        }

        @EventListener(classes={ContextRefreshedEvent.class})
        public void configureTerminator(@NonNull ContextRefreshedEvent event) {
            Function<ApplicationContext, SpringApplicationTerminatorConfigurer> safeSpringApplicationTerminatorConfigurerResolver = applicationContext -> (SpringApplicationTerminatorConfigurer)SpringUtils.safeGetValue(() -> (SpringApplicationTerminatorConfigurer)applicationContext.getBean(SpringApplicationTerminatorConfigurer.class), (Object)null);
            Runnable springApplicationTerminatorRunnable = () -> System.exit(-1);
            ThreadFactory springApplicationTerminatorThreadFactory = runnable -> {
                Thread springApplicationTerminatorThread = new Thread(runnable, "Spring Application Terminator Thread");
                springApplicationTerminatorThread.setDaemon(true);
                springApplicationTerminatorThread.setPriority(5);
                return springApplicationTerminatorThread;
            };
            Optional.ofNullable(event).map(ApplicationContextEvent::getApplicationContext).map(safeSpringApplicationTerminatorConfigurerResolver).filter(SpringApplicationTerminatorConfigurer::isNotEmpty).filter(this::delayIsGreaterThanZero).ifPresent(configurer -> Executors.newScheduledThreadPool(1, springApplicationTerminatorThreadFactory).schedule(springApplicationTerminatorRunnable, configurer.delay().toMillis(), TimeUnit.MILLISECONDS));
        }

        private boolean delayIsGreaterThanZero(@NonNull SpringApplicationTerminatorConfigurer configurer) {
            return Optional.ofNullable(configurer).map(SpringApplicationTerminatorConfigurer::delay).map(delay -> Duration.ZERO.compareTo((Duration)delay) > 0).orElse(false);
        }
    }

    @EnablePdx
    @CacheServerApplication(name="ForkingClientServerIntegrationTestsSupport", logLevel="error")
    public static class BaseGemFireServerConfiguration
    extends ClientServerIntegrationTestsConfiguration {
        public static void main(String[] args) {
            AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext(new Class[]{BaseGemFireServerConfiguration.class});
            applicationContext.registerShutdownHook();
        }
    }

    @EnablePdx
    @ClientCacheApplication(logLevel="error")
    public static class BaseGemFireClientConfiguration
    extends ClientServerIntegrationTestsConfiguration {
    }
}

