/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.extensions.spring.test.context.support;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.springframework.core.SpringProperties;
import org.springframework.lang.NonNull;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class CloseApplicationContextAfterTestClassTestExecutionListener
extends AbstractTestExecutionListener {
    protected static final boolean DEFAULT_SPRING_TEST_CONTEXT_CLOSED = false;
    protected static final String SPRING_TEST_CONTEXT_CLOSE_PROPERTY = "spring.test.context.close";
    protected static final DirtiesContext.HierarchyMode DEFAULT_HIERARCHY_MODE = DirtiesContext.HierarchyMode.CURRENT_LEVEL;
    private final AtomicReference<Boolean> springTestContextCloseEnabled = new AtomicReference();

    public int getOrder() {
        return 100000;
    }

    protected boolean isSpringTestContextCloseEnabled() {
        return this.springTestContextCloseEnabled.updateAndGet(closeEnabled -> closeEnabled != null ? closeEnabled : this.getSpringTestContextCloseEnabledResolvingFunction().apply(false));
    }

    protected Function<Boolean, Boolean> getSpringTestContextCloseEnabledResolvingFunction() {
        return defaultCloseEnabled -> {
            String closeEnabledProperty = SpringProperties.getProperty((String)SPRING_TEST_CONTEXT_CLOSE_PROPERTY);
            boolean resolvedCloseEnabled = Boolean.parseBoolean(closeEnabledProperty) || defaultCloseEnabled != false;
            return resolvedCloseEnabled;
        };
    }

    public void afterTestClass(@NonNull TestContext testContext) throws Exception {
        if (this.isSpringTestContextCloseEnabled()) {
            super.afterTestClass(testContext);
            testContext.markApplicationContextDirty(DEFAULT_HIERARCHY_MODE);
        }
    }
}

