/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.extensions.spring.test.context.event;

import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.test.context.event.AfterTestClassEvent;
import org.springframework.test.context.event.AfterTestExecutionEvent;
import org.springframework.test.context.event.AfterTestMethodEvent;
import org.springframework.test.context.event.BeforeTestClassEvent;
import org.springframework.test.context.event.BeforeTestExecutionEvent;
import org.springframework.test.context.event.BeforeTestMethodEvent;
import org.springframework.test.context.event.PrepareTestInstanceEvent;
import org.springframework.test.context.event.TestContextEvent;
import org.springframework.util.Assert;

public enum TestContextEventType {
    BEFORE_TEST_CLASS(BeforeTestClassEvent.class),
    PREPARE_TEST_INSTANCE(PrepareTestInstanceEvent.class),
    BEFORE_TEST_METHOD(BeforeTestMethodEvent.class),
    BEFORE_TEST_EXECUTION(BeforeTestExecutionEvent.class),
    AFTER_TEST_EXECUTION(AfterTestExecutionEvent.class),
    AFTER_TEST_METHOD(AfterTestMethodEvent.class),
    AFTER_TEST_CLASS(AfterTestClassEvent.class);

    private final Class<? extends TestContextEvent> eventType;

    @Nullable
    public static TestContextEventType from(@Nullable TestContextEvent event) {
        for (TestContextEventType eventType : TestContextEventType.values()) {
            if (!eventType.getTestContextEventType().isInstance(event)) continue;
            return eventType;
        }
        return null;
    }

    private TestContextEventType(Class<? extends TestContextEvent> eventType) {
        Assert.notNull(eventType, (String)"The Class type of the TestContextEvent for this enumerated value must not be null");
        this.eventType = eventType;
    }

    @NonNull
    public Class<? extends TestContextEvent> getTestContextEventType() {
        return this.eventType;
    }
}

