/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.extensions.spring.test.context.cache;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringProperties;
import org.springframework.data.gemfire.tests.util.SpringUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.cache.ContextCache;
import org.springframework.test.context.cache.DefaultCacheAwareContextLoaderDelegate;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ConfigurableCacheAwareContextLoaderDelegate
extends DefaultCacheAwareContextLoaderDelegate {
    protected static final boolean DEFAULT_SPRING_TEST_CONTEXT_CACHE_ENABLED = true;
    protected static final String SPRING_TEST_CONTEXT_CACHE_ENABLED_PROPERTY = "spring.test.context.cache.enabled";
    private final AtomicReference<Boolean> springTestContextCacheEnabled = new AtomicReference<Object>(null);
    private final AtomicReference<MergedContextConfigurationAndApplicationContextPair> applicationContextReference = new AtomicReference();

    public ConfigurableCacheAwareContextLoaderDelegate() {
    }

    public ConfigurableCacheAwareContextLoaderDelegate(@NonNull ContextCache contextCache) {
        super(contextCache);
    }

    protected boolean isSpringTestContextCacheEnabled() {
        return this.springTestContextCacheEnabled.updateAndGet(cacheEnabled -> cacheEnabled != null ? cacheEnabled : this.getSpringTestContextCacheEnabledResolvingFunction().apply(true));
    }

    protected Function<Boolean, Boolean> getSpringTestContextCacheEnabledResolvingFunction() {
        return defaultCacheEnabled -> {
            String cacheEnabledProperty = SpringProperties.getProperty((String)SPRING_TEST_CONTEXT_CACHE_ENABLED_PROPERTY);
            boolean resolvedCacheEnabled = (!StringUtils.hasText((String)cacheEnabledProperty) || Boolean.parseBoolean(cacheEnabledProperty)) && defaultCacheEnabled != false;
            return resolvedCacheEnabled;
        };
    }

    protected boolean isApplicationContextActive() {
        return Optional.ofNullable(this.applicationContextReference.get()).filter(MergedContextConfigurationAndApplicationContextPair::isActive).isPresent();
    }

    public boolean isContextLoaded(@NonNull MergedContextConfiguration mergedContextConfiguration) {
        boolean contextLoaded = this.isSpringTestContextCacheEnabled() && super.isContextLoaded(mergedContextConfiguration) || this.isApplicationContextActive();
        return contextLoaded;
    }

    @NonNull
    public ApplicationContext loadContext(@NonNull MergedContextConfiguration mergedContextConfiguration) {
        return this.isSpringTestContextCacheEnabled() ? super.loadContext(mergedContextConfiguration) : this.loadContext(mergedContextConfiguration, this::loadContextInternalWithExceptionHandling);
    }

    @NonNull
    private ApplicationContext loadContext(@NonNull MergedContextConfiguration mergedContextConfiguration, @NonNull Function<MergedContextConfiguration, ApplicationContext> contextLoaderFunction) {
        MergedContextConfigurationAndApplicationContextPair pair = this.applicationContextReference.updateAndGet(ref -> ref != null ? ref.update(mergedContextConfiguration, contextLoaderFunction) : MergedContextConfigurationAndApplicationContextPair.from(mergedContextConfiguration, (ApplicationContext)contextLoaderFunction.apply(mergedContextConfiguration)));
        return pair.getApplicationContext();
    }

    @NonNull
    private ApplicationContext loadContextInternalWithExceptionHandling(@NonNull MergedContextConfiguration mergedContextConfiguration) {
        try {
            return this.loadContextInternal(mergedContextConfiguration);
        }
        catch (Exception cause) {
            throw RuntimeExceptionFactory.newIllegalStateException((Throwable)cause, (String)"Failed to load ApplicationContext for context configuration [%s]", (Object[])new Object[]{mergedContextConfiguration});
        }
    }

    public void closeContext(@NonNull MergedContextConfiguration mergedContextConfiguration, DirtiesContext.HierarchyMode hierarchyMode) {
        if (this.isSpringTestContextCacheEnabled()) {
            super.closeContext(mergedContextConfiguration, hierarchyMode);
        } else {
            this.closeApplicationContext(mergedContextConfiguration);
        }
    }

    private boolean closeApplicationContext(@NonNull MergedContextConfiguration contextConfiguration) {
        return Optional.ofNullable(this.applicationContextReference.get()).map(pair -> pair.closeApplicationContextIfMatch(contextConfiguration)).orElse(false);
    }

    protected static class MergedContextConfigurationAndApplicationContextPair {
        private final ApplicationContext applicationContext;
        private final MergedContextConfiguration mergedContextConfiguration;

        @NonNull
        protected static MergedContextConfigurationAndApplicationContextPair from(@NonNull MergedContextConfiguration contextConfiguration, @NonNull ApplicationContext applicationContext) {
            return new MergedContextConfigurationAndApplicationContextPair(contextConfiguration, applicationContext);
        }

        protected MergedContextConfigurationAndApplicationContextPair(@NonNull MergedContextConfiguration mergedContextConfiguration, @NonNull ApplicationContext applicationContext) {
            Assert.notNull((Object)mergedContextConfiguration, (String)"MergedContextConfiguration must not be null");
            Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
            this.mergedContextConfiguration = mergedContextConfiguration;
            this.applicationContext = applicationContext;
        }

        @NonNull
        protected ApplicationContext getApplicationContext() {
            return this.applicationContext;
        }

        @NonNull
        protected MergedContextConfiguration getMergedContextConfiguration() {
            return this.mergedContextConfiguration;
        }

        protected boolean isActive() {
            return Optional.ofNullable(this.getApplicationContext()).filter(SpringUtils::isApplicationContextActive).isPresent();
        }

        protected boolean isMatch(@Nullable MergedContextConfiguration mergedContextConfiguration) {
            return this.getMergedContextConfiguration().equals((Object)mergedContextConfiguration);
        }

        protected boolean isNotMatch(@Nullable MergedContextConfiguration mergedContextConfiguration) {
            return !this.isMatch(mergedContextConfiguration);
        }

        protected boolean isUpdatable(@Nullable MergedContextConfiguration mergedContextConfiguration) {
            return Objects.nonNull(mergedContextConfiguration) && this.closeApplicationContextIfNotMatch(mergedContextConfiguration) && !this.isActive();
        }

        protected boolean closeApplicationContextIfMatch(@Nullable MergedContextConfiguration mergedContextConfiguration) {
            return this.isMatch(mergedContextConfiguration) && SpringUtils.closeApplicationContext(this.getApplicationContext());
        }

        protected boolean closeApplicationContextIfNotMatch(@Nullable MergedContextConfiguration mergedContextConfiguration) {
            return this.isNotMatch(mergedContextConfiguration) && SpringUtils.closeApplicationContext(this.getApplicationContext());
        }

        @NonNull
        protected MergedContextConfigurationAndApplicationContextPair update(@Nullable MergedContextConfiguration mergedContextConfiguration, @NonNull Function<MergedContextConfiguration, ApplicationContext> contextLoaderFunction) {
            return this.isUpdatable(mergedContextConfiguration) ? MergedContextConfigurationAndApplicationContextPair.from(mergedContextConfiguration, contextLoaderFunction.apply(mergedContextConfiguration)) : this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MergedContextConfigurationAndApplicationContextPair)) {
                return false;
            }
            MergedContextConfigurationAndApplicationContextPair that = (MergedContextConfigurationAndApplicationContextPair)obj;
            return ObjectUtils.nullSafeEquals((Object)this.getMergedContextConfiguration(), (Object)that.getMergedContextConfiguration()) && ObjectUtils.nullSafeEquals((Object)this.getApplicationContext(), (Object)that.getApplicationContext());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getMergedContextConfiguration());
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getApplicationContext());
            return hashValue;
        }

        public String toString() {
            return String.format("MergedContextConfiguration [%1$s] for ApplicationContext [%2$s]", this.getMergedContextConfiguration(), this.getApplicationContext());
        }
    }
}

